/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.modules.editor.structure.formatting.TagBasedFormatter;

public class HTMLFormatter
extends TagBasedFormatter {
    private static final String[] UNFORMATTABLE_TAGS = new String[]{"pre", "script", "code"};

    public HTMLFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HTMLSyntax;
    }

    protected ExtSyntaxSupport getSyntaxSupport(BaseDocument doc) {
        return (HTMLSyntaxSupport)doc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
    }

    protected TokenItem getTagTokenEndingAtPosition(BaseDocument doc, int position) throws BadLocationException {
        HTMLSyntaxSupport sup;
        TokenItem token;
        if (position >= 0 && (token = (sup = (HTMLSyntaxSupport)this.getSyntaxSupport(doc)).getTokenChain(position, position + 1)).getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL && !token.getImage().endsWith("/>")) {
            while ((token = token.getPrevious()) != null) {
                if (!HTMLSyntaxSupport.isTag(token)) continue;
            }
            return token;
        }
        return null;
    }

    protected int getTagEndOffset(TokenItem token) {
        TokenItem t;
        for (t = token.getNext(); t != null && t.getTokenID() != HTMLTokenContext.TAG_CLOSE_SYMBOL; t = t.getNext()) {
        }
        return t == null ? -1 : t.getOffset();
    }

    protected boolean isJustBeforeClosingTag(BaseDocument doc, int pos) throws BadLocationException {
        return super.isJustBeforeClosingTag(doc, pos + "</".length());
    }

    protected boolean isClosingTag(TokenItem token) {
        return token != null && token.getTokenID() == HTMLTokenContext.TAG_CLOSE;
    }

    protected boolean isOpeningTag(TokenItem token) {
        return token != null && token.getTokenID() == HTMLTokenContext.TAG_OPEN;
    }

    protected String extractTagName(TokenItem tknTag) {
        return tknTag.getImage().trim();
    }

    protected boolean areTagNamesEqual(String tagName1, String tagName2) {
        return tagName1.equalsIgnoreCase(tagName2);
    }

    protected int getOpeningSymbolOffset(TokenItem tknTag) {
        TokenItem tkn = tknTag;
        while ((tkn = tkn.getPrevious()) != null && tkn.getTokenID() != HTMLTokenContext.TAG_OPEN_SYMBOL) {
        }
        if (tkn != null) {
            return tkn.getOffset();
        }
        return -1;
    }

    protected boolean isClosingTagRequired(BaseDocument doc, String tagName) {
        HTMLSyntaxSupport htmlsup = (HTMLSyntaxSupport)doc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
        DTD dtd = htmlsup.getDTD();
        if (dtd == null) {
            return false;
        }
        DTD.Element elem = dtd.getElement(tagName.toUpperCase());
        if (elem == null) {
            return true;
        }
        return !elem.isEmpty();
    }

    protected boolean isUnformattableToken(TokenItem token) {
        return token.getTokenID() == HTMLTokenContext.BLOCK_COMMENT;
    }

    protected boolean isUnformattableTag(String tag) {
        for (int i = 0; i < UNFORMATTABLE_TAGS.length; ++i) {
            if (!tag.equalsIgnoreCase(UNFORMATTABLE_TAGS[i])) continue;
            return true;
        }
        return false;
    }
}

