/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.fileupload;

import com.sun.javaee.blueprints.components.ui.fileupload.CustomServletRequestContext;
import com.sun.javaee.blueprints.components.ui.fileupload.FileUploadStatus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.shale.remoting.faces.ResponseFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadHandler {
    private Logger _logger = null;
    private FileUploadStatus fileUploadStatus = null;
    private static final String FILE_UPLOAD_LOGGER = "com.sun.javaee.blueprints.components.ui.fileupload";
    private static final String FILE_UPLOAD_LOG_STRINGS = "com.sun.javaee.blueprints.components.ui.fileupload.LogStrings";
    public static final String FILE_UPLOAD_STATUS = "fileUploadStatus";
    public static final boolean bDebug = false;
    private static ResponseFactory factory = new ResponseFactory();

    public void handleFileStatus() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader("Cache-Control", "no-cache");
        FileUploadStatus status = this.getFileUploadStatus();
        try {
            ResponseWriter writer = factory.getResponseWriter(context, "text/xml");
            writer.startElement("response", null);
            if (status != null) {
                writer.startElement("message", null);
                writer.write(status.getMessage());
                writer.endElement("message");
                writer.startElement("status", null);
                writer.write(status.getStatus());
                writer.endElement("status");
                writer.startElement("current_item", null);
                writer.write(status.getCurrentItem());
                writer.endElement("current_item");
                writer.startElement("percent_complete", null);
                writer.write(String.valueOf(status.getPercentageComplete()));
                writer.endElement("percent_complete");
            } else {
                writer.startElement("message", null);
                writer.write("No Status");
                writer.endElement("message");
                writer.startElement("status", null);
                writer.write("No Status");
                writer.endElement("status");
                writer.startElement("current_item", null);
                writer.write("None");
                writer.endElement("current_item");
                writer.startElement("percent_complete", null);
                writer.write("0");
                writer.endElement("percent_complete");
            }
            writer.endElement("response");
            writer.flush();
        }
        catch (IOException iox) {
            System.out.println("FileUploadPhaseListener error writting AJAX response : " + iox);
            this.getLogger().log(Level.SEVERE, "response.exeception", iox);
        }
    }

    public void handleFileUpload() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader("Cache-Control", "no-cache");
        Object object = context.getExternalContext().getRequest();
        if (!(object instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        FileUploadStatus status = this.getFileUploadStatus();
        status.reset();
        HashMap<String, String> hmUpload = new HashMap<String, String>();
        long totalSizeOfUpload = request.getContentLength();
        status.setTotalUploadSize(totalSizeOfUpload);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                CustomServletRequestContext csrc = new CustomServletRequestContext(request, status);
                List items = upload.parseRequest((RequestContext)csrc);
                status.setReadingComplete();
                Iterator iter = items.iterator();
                FileItem item = null;
                String itemName = null;
                long sizex = 0L;
                while (iter.hasNext()) {
                    item = (FileItem)iter.next();
                    if (!item.isFormField()) continue;
                    itemName = item.getFieldName();
                    sizex = item.getSize();
                    this.updateSessionStatus(itemName, sizex);
                    this.formItemFound(context, item, hmUpload);
                }
                String compName = hmUpload.get("componentName");
                status.setName(compName);
                String serverLocationDir = hmUpload.get(compName + "_" + "serverLocationDir");
                File fileDir = null;
                if (serverLocationDir == null) {
                    serverLocationDir = System.getProperty("com.sun.aas.instanceRoot");
                    if (serverLocationDir != null) {
                        serverLocationDir = serverLocationDir + "/lib/upload";
                        fileDir = new File(serverLocationDir);
                        fileDir.mkdirs();
                    } else {
                        fileDir = (File)context.getExternalContext().getApplicationMap().get("javax.servlet.context.tempdir");
                        serverLocationDir = fileDir.toString();
                    }
                } else {
                    fileDir = new File(serverLocationDir);
                }
                if (fileDir == null || !fileDir.isDirectory() || !fileDir.canWrite()) {
                    status.setUploadError("Directory \"" + fileDir.toString() + "\" doesn't exist!");
                    this.getLogger().log(Level.SEVERE, "directory.inaccessable", fileDir.toString());
                    this.writeUploadResponse(context, hmUpload);
                    return;
                }
                iter = items.iterator();
                Object fileLocation = null;
                while (iter.hasNext()) {
                    item = (FileItem)iter.next();
                    if (item.isFormField()) continue;
                    this.fileItemFound(context, item, hmUpload, serverLocationDir);
                }
                status.setUploadComplete();
            }
            catch (Exception e) {
                status.setUploadError("FileUpload didn't complete successfully.  Exception received:" + e.toString());
                this.getLogger().log(Level.SEVERE, "file.upload.exception", e);
            }
        }
        this.writeUploadResponse(context, hmUpload);
    }

    protected void formItemFound(FacesContext context, FileItem item, HashMap<String, String> hmUpload) {
        String key = item.getFieldName();
        String value = item.getString();
        hmUpload.put(key, value);
    }

    protected void fileItemFound(FacesContext context, FileItem item, HashMap hmUpload, String serverLocationDir) throws Exception {
        String fileName = item.getName();
        if (fileName != null && !fileName.equals("")) {
            int iPos = fileName.lastIndexOf("/");
            if (iPos > -1) {
                fileName = fileName.substring(iPos + 1);
            }
            if ((iPos = fileName.lastIndexOf("\\")) > -1) {
                fileName = fileName.substring(iPos + 1);
            }
            String fileLocation = serverLocationDir + "/" + fileName;
            File uploadedFile = new File(fileLocation);
            this.write(item, uploadedFile);
            String key = "fileLocation_" + fileName;
            hmUpload.put(key, fileLocation);
        }
    }

    public void writeUploadResponse(FacesContext context, HashMap<String, String> hmUpload) {
        try {
            ResponseWriter writer = factory.getResponseWriter(context, "text/xml");
            String compName = hmUpload.get("componentName");
            FileUploadStatus status = this.getFileUploadStatus();
            String postProcessingMethod = hmUpload.get(compName + "_" + "postProcessingMethod");
            if (postProcessingMethod != null) {
                try {
                    Class[] argTypes = new Class[]{FacesContext.class, HashMap.class, FileUploadStatus.class};
                    MethodExpression mex = context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), postProcessingMethod, null, argTypes);
                    Object[] args = new Object[]{context, hmUpload, status};
                    mex.invoke(context.getELContext(), args);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "post.processing.exeception", e);
                }
            }
            if (!status.isCustomReturnEnabled()) {
                writer.startElement("response", null);
                writer.startElement("message", null);
                writer.write(status.getMessage());
                writer.endElement("message");
                writer.startElement("status", null);
                writer.write(status.getStatus());
                writer.endElement("status");
                writer.startElement("duration", null);
                writer.write(String.valueOf(status.getUploadTime()));
                writer.endElement("duration");
                writer.startElement("duration_string", null);
                writer.write(status.getUploadTimeString());
                writer.endElement("duration_string");
                writer.startElement("start_date", null);
                writer.write(status.getStartUploadDate().toString());
                writer.endElement("start_date");
                writer.startElement("end_date", null);
                writer.write(status.getEndUploadDate().toString());
                writer.endElement("end_date");
                writer.startElement("upload_size", null);
                writer.write(String.valueOf(status.getTotalUploadSize()));
                writer.endElement("upload_size");
                writer.endElement("response");
                writer.flush();
            }
        }
        catch (IOException iox) {
            System.out.println("FileUploadPhaseListener error writting AJAX response : " + iox);
            this.getLogger().log(Level.SEVERE, "response.exeception", iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileItem item, File file) throws Exception {
        String itemName = item.getName();
        this.getLogger().log(Level.INFO, "uploaded.item", file.toString());
        this.updateSessionStatus(itemName, 0L);
        if (item.isInMemory()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(item.get());
                this.updateSessionStatus("", item.getSize());
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
        DiskFileItem dfItem = (DiskFileItem)item;
        File outputFile = dfItem.getStoreLocation();
        if (outputFile != null) {
            if (!outputFile.renameTo(file)) {
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(outputFile));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    int byteCnt = 0;
                    byte[] buffer = new byte[4096];
                    while ((byteCnt = in.read(buffer)) != -1) {
                        if (out == null || byteCnt <= 0) continue;
                        ((BufferedOutputStream)out).write(buffer, 0, byteCnt);
                        this.updateSessionStatus(itemName, byteCnt);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        } else {
            throw new FileUploadException("Cannot write uploaded file to disk!");
        }
    }

    public void updateSessionStatus(String itemName, long incrementAmount) {
        FileUploadStatus status = this.getFileUploadStatus();
        status.setCurrentItem(itemName);
        status.incrementCurrentSizeWritten(incrementAmount);
    }

    public void setFileUploadStatus(FileUploadStatus status) {
        this.fileUploadStatus = status;
    }

    public FileUploadStatus getFileUploadStatus() {
        return this.fileUploadStatus;
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger(FILE_UPLOAD_LOGGER, FILE_UPLOAD_LOG_STRINGS);
        }
        return this._logger;
    }
}

