/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.jspel;

import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.syntax.ELTokenContext;
import org.netbeans.modules.web.core.syntax.JSPHyperlinkProvider;
import org.netbeans.modules.web.core.syntax.JspJavaSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.editor.jspel.JSFELExpression;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class JSFJSPHyperlinkProvider
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return false;
        }
        try {
            FileObject fObject;
            WebModule wm;
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return false;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            JspSyntaxSupport jspSup = (JspSyntaxSupport)sup.get(JspSyntaxSupport.class);
            TokenItem token = jspSup.getTokenChain(offset, offset + 1);
            if (token == null) {
                return false;
            }
            TokenID tokenID = token.getTokenID();
            if (tokenID == null) {
                return false;
            }
            if (token.getTokenContextPath().contains(ELTokenContext.contextPath) && (wm = WebModule.getWebModule((FileObject)(fObject = NbEditorUtilities.getFileObject((Document)doc)))) != null) {
                JSFELExpression exp = new JSFELExpression(wm, (JspSyntaxSupport)bdoc.getSyntaxSupport());
                int res = exp.parse(token.getOffset() + token.getImage().length());
                if (res == 1) {
                    res = exp.parse(token.getOffset() + token.getImage().length() + 1);
                }
                return res == 100;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return null;
        }
        try {
            JSFELExpression exp;
            int res;
            FileObject fObject;
            WebModule wm;
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return null;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            JspSyntaxSupport jspSup = (JspSyntaxSupport)sup.get(JspSyntaxSupport.class);
            TokenItem token = jspSup.getTokenChain(offset, offset + 1);
            if (token == null) {
                return null;
            }
            if (token.getTokenContextPath().contains(ELTokenContext.contextPath) && (wm = WebModule.getWebModule((FileObject)(fObject = NbEditorUtilities.getFileObject((Document)doc)))) != null && ((res = (exp = new JSFELExpression(wm, (JspSyntaxSupport)bdoc.getSyntaxSupport())).parse(token.getOffset() + token.getImage().length())) == 100 || res == 1)) {
                return new int[]{token.getOffset(), token.getOffset() + token.getImage().length()};
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    public void performClickAction(Document doc, int offset) {
        TokenItem token = null;
        try {
            FileObject fObject;
            WebModule wm;
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return;
            }
            SyntaxSupport sup = bdoc.getSyntaxSupport();
            JspSyntaxSupport jspSup = (JspSyntaxSupport)sup.get(JspSyntaxSupport.class);
            token = jspSup.getTokenChain(offset, offset + 1);
            if (token == null) {
                return;
            }
            if (token.getTokenContextPath().contains(ELTokenContext.contextPath) && (wm = WebModule.getWebModule((FileObject)(fObject = NbEditorUtilities.getFileObject((Document)doc)))) != null) {
                JSFELExpression exp = new JSFELExpression(wm, (JspSyntaxSupport)bdoc.getSyntaxSupport());
                int res = exp.parse(token.getOffset() + token.getImage().length());
                if (res == 1) {
                    new OpenConfigFile(wm, token.getImage()).run();
                    return;
                }
                if (res == 100) {
                    JavaClass bean = exp.getBean(exp.getExpression());
                    Object item = exp.getPropertyDeclaration(exp.getExpression(), bean);
                    if (item == null) {
                        item = exp.getMethodDeclaration(exp.getExpression(), bean);
                    }
                    if (item != null) {
                        OpenJavaItem run = new OpenJavaItem(item, sup);
                        JavaMetamodel.getManager().invokeAfterScanFinished((Runnable)run, NbBundle.getMessage(JSPHyperlinkProvider.class, (String)"MSG_goto-source"));
                    }
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public static class OpenJavaItem
    implements Runnable {
        private Object item;
        private SyntaxSupport sup;

        OpenJavaItem(Object item, SyntaxSupport sup) {
            this.item = item;
            this.sup = sup;
        }

        public void run() {
            JspJavaSyntaxSupport javaSup = (JspJavaSyntaxSupport)this.sup.get(JspJavaSyntaxSupport.class);
            if (this.item != null && javaSup != null) {
                String itemDesc = null;
                itemDesc = javaSup.openSource(this.item, true);
                if (itemDesc != null) {
                    String msg = NbBundle.getBundle(JSPHyperlinkProvider.class).getString("MSG_source_not_found");
                    StatusDisplayer.getDefault().setStatusText(msg);
                }
            }
        }
    }

    private static class OpenConfigFile
    implements Runnable {
        private String beanName;
        private WebModule wm;

        OpenConfigFile(WebModule wm, String beanName) {
            this.beanName = beanName;
            this.wm = wm;
        }

        public void run() {
            if (this.wm == null) {
                return;
            }
            FileObject config = JSFConfigUtilities.findFacesConfigForManagedBean(this.wm, this.beanName);
            if (config != null) {
                EditorCookie.Observable ec;
                DataObject dobj = null;
                try {
                    dobj = DataObject.find((FileObject)config);
                }
                catch (DataObjectNotFoundException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return;
                }
                if (dobj != null && (ec = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class)) != null) {
                    StatusDisplayer.getDefault().setStatusText("otvirani");
                    Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                        public void run() {
                            JEditorPane[] panes = ec.getOpenedPanes();
                            if (panes != null && panes.length > 0) {
                                OpenConfigFile.this.openPane(panes[0], OpenConfigFile.this.beanName);
                            } else {
                                ec.addPropertyChangeListener(new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if ("openedPanes".equals(evt.getPropertyName())) {
                                            JEditorPane[] panes = ec.getOpenedPanes();
                                            if (panes != null && panes.length > 0) {
                                                OpenConfigFile.this.openPane(panes[0], OpenConfigFile.this.beanName);
                                            }
                                            ec.removePropertyChangeListener((PropertyChangeListener)this);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    ec.open();
                }
            }
        }

        private void openPane(JEditorPane pane, String beanName) {
            Cursor editCursor = pane.getCursor();
            pane.setCursor(Cursor.getPredefinedCursor(3));
            int[] definition = JSFEditorUtilities.getManagedBeanDefinition((BaseDocument)pane.getDocument(), beanName);
            if (definition[0] > -1) {
                pane.setCaretPosition(definition[0]);
            }
            pane.setCursor(editCursor);
            StatusDisplayer.getDefault().setStatusText("");
        }
    }
}

