/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;
import org.netbeans.modules.web.spi.webmodule.FrameworkConfigurationPanel;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class JSFFrameworkProvider
extends WebFrameworkProvider {
    private JSFConfigurationPanel panel;

    public JSFFrameworkProvider() {
        super(NbBundle.getMessage(JSFFrameworkProvider.class, (String)"JSF_Name"), NbBundle.getMessage(JSFFrameworkProvider.class, (String)"JSF_Description"));
    }

    public Set extend(WebModule wm) {
        FileObject fo = wm.getDocumentBase();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        try {
            ProjectClassPathExtender cpExtender;
            Library jsfLibrary;
            FileObject dd = wm.getDeploymentDescriptor();
            WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            if (ddRoot != null && !"2.5".equals(ddRoot.getVersion()) && (jsfLibrary = LibraryManager.getDefault().getLibrary("jsf")) != null && cp.findResource("javax/faces/FacesException.class") == null && (cpExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class)) != null) {
                try {
                    cpExtender.addLibrary(jsfLibrary);
                    Library jstlLibrary = LibraryManager.getDefault().getLibrary("jstl11");
                    if (jstlLibrary != null) {
                        cpExtender.addLibrary(jstlLibrary);
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            boolean isMyFaces = cp.findResource("org/apache/myfaces/webapp/StartupServletContextListener.class") != null;
            FileSystem fs = wm.getWebInf().getFileSystem();
            fs.runAtomicAction((FileSystem.AtomicAction)new CreateFacesConfig(wm, isMyFaces));
        }
        catch (FileNotFoundException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
        return null;
    }

    public static String readResource(InputStream is, String encoding) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public File[] getConfigurationFiles(WebModule wm) {
        FileObject dd = wm.getDeploymentDescriptor();
        if (dd != null) {
            FileObject[] filesFO = JSFConfigUtilities.getConfiFilesFO(dd);
            File[] files = new File[filesFO.length];
            for (int i = 0; i < filesFO.length; ++i) {
                files[i] = FileUtil.toFile((FileObject)filesFO[i]);
            }
            if (files.length > 0) {
                return files;
            }
        }
        return null;
    }

    public FrameworkConfigurationPanel getConfigurationPanel(WebModule wm) {
        boolean defaultValue = wm == null || !this.isInWebModule(wm);
        this.panel = new JSFConfigurationPanel(!defaultValue);
        if (!defaultValue) {
            Servlet servlet = JSFConfigUtilities.getActionServlet(wm.getDeploymentDescriptor());
            this.panel.setServletName(servlet.getServletName());
            this.panel.setURLPattern(JSFConfigUtilities.getActionServletMapping(wm.getDeploymentDescriptor()));
            this.panel.setValidateXML(JSFConfigUtilities.validateXML(wm.getDeploymentDescriptor()));
            this.panel.setVerifyObjects(JSFConfigUtilities.verifyObjects(wm.getDeploymentDescriptor()));
        }
        return this.panel;
    }

    public boolean isInWebModule(WebModule wm) {
        FileObject dd = wm.getDeploymentDescriptor();
        return dd != null && JSFConfigUtilities.getActionServlet(dd) != null;
    }

    public String getServletPath(FileObject file) {
        String url = null;
        if (file == null) {
            return url;
        }
        WebModule wm = WebModule.getWebModule((FileObject)file);
        if (wm != null) {
            String mapping;
            url = FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)file);
            if (url.charAt(0) != '/') {
                url = "/" + url;
            }
            if ((mapping = JSFConfigUtilities.getActionServletMapping(wm.getDeploymentDescriptor())) != null && !"".equals(mapping) && mapping.endsWith("/*")) {
                mapping = mapping.substring(0, mapping.length() - 2);
                url = mapping + url;
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileObject target, String content, String encoding) throws IOException {
        FileLock lock = target.lock();
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(lock), encoding));
            bw.write(content);
            bw.close();
        }
        finally {
            lock.releaseLock();
        }
    }

    private class CreateFacesConfig
    implements FileSystem.AtomicAction {
        WebModule wm;
        boolean isMyFaces;

        public CreateFacesConfig(WebModule wm, boolean isMyFaces) {
            this.wm = wm;
            this.isMyFaces = isMyFaces;
        }

        public void run() throws IOException {
            FileObject dd = this.wm.getDeploymentDescriptor();
            WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
            if (ddRoot != null) {
                try {
                    Servlet servlet = (Servlet)ddRoot.createBean("Servlet");
                    String servletName = JSFFrameworkProvider.this.panel == null ? "Faces Servlet" : JSFFrameworkProvider.this.panel.getServletName();
                    servlet.setServletName(servletName);
                    servlet.setServletClass("javax.faces.webapp.FacesServlet");
                    ddRoot.addServlet(servlet);
                    servlet.setLoadOnStartup(new BigInteger("1"));
                    ServletMapping mapping = (ServletMapping)ddRoot.createBean("ServletMapping");
                    mapping.setServletName(servletName);
                    mapping.setUrlPattern(JSFFrameworkProvider.this.panel == null ? "/faces/*" : JSFFrameworkProvider.this.panel.getURLPattern());
                    ddRoot.addServletMapping(mapping);
                    InitParam contextParam = (InitParam)ddRoot.createBean("InitParam");
                    contextParam.setParamName("com.sun.faces.verifyObjects");
                    if (JSFFrameworkProvider.this.panel != null && JSFFrameworkProvider.this.panel.verifyObjects()) {
                        contextParam.setParamValue("true");
                    } else {
                        contextParam.setParamValue("false");
                    }
                    ddRoot.addContextParam(contextParam);
                    contextParam = (InitParam)ddRoot.createBean("InitParam");
                    contextParam.setParamName("com.sun.faces.validateXml");
                    if (JSFFrameworkProvider.this.panel == null || JSFFrameworkProvider.this.panel.validateXML()) {
                        contextParam.setParamValue("true");
                    } else {
                        contextParam.setParamValue("false");
                    }
                    ddRoot.addContextParam(contextParam);
                    contextParam = (InitParam)ddRoot.createBean("InitParam");
                    contextParam.setParamName("javax.faces.STATE_SAVING_METHOD");
                    contextParam.setParamValue("client");
                    ddRoot.addContextParam(contextParam);
                    if (this.isMyFaces) {
                        Listener facesListener = (Listener)ddRoot.createBean("Listener");
                        facesListener.setListenerClass("org.apache.myfaces.webapp.StartupServletContextListener");
                        ddRoot.addListener(facesListener);
                    }
                    ddRoot.write(dd);
                }
                catch (ClassNotFoundException cnfe) {
                    ErrorManager.getDefault().notify((Throwable)cnfe);
                }
            }
            if (this.canCreateNewFile(this.wm.getWebInf(), "faces-config.xml")) {
                String facesConfigTemplate = "faces-config.xml";
                if (ddRoot != null && "2.5".equals(ddRoot.getVersion())) {
                    facesConfigTemplate = "faces-config_1_2.xml";
                }
                String content = JSFFrameworkProvider.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-jsf/" + facesConfigTemplate).getInputStream(), "UTF-8");
                FileObject target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"faces-config.xml");
                JSFFrameworkProvider.createFile(target, content, "UTF-8");
            }
            if (this.canCreateNewFile(this.wm.getDocumentBase(), "welcomeJSF.jsp")) {
                String content = JSFFrameworkProvider.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-jsf/welcomeJSF.jsp").getInputStream(), "UTF-8");
                FileObject target = FileUtil.createData((FileObject)this.wm.getDocumentBase(), (String)"welcomeJSF.jsp");
                JSFFrameworkProvider.createFile(target, content, "UTF-8");
                FileObject documentBase = this.wm.getDocumentBase();
                FileObject indexjsp = documentBase.getFileObject("index.jsp");
                if (indexjsp != null) {
                    this.changeIndexJSP(indexjsp);
                }
            }
        }

        private boolean canCreateNewFile(FileObject parent, String name) {
            File fileToBe = new File(FileUtil.toFile((FileObject)parent), name);
            boolean create = true;
            if (fileToBe.exists()) {
                DialogDescriptor dialog = new DialogDescriptor((Object)NbBundle.getMessage(JSFFrameworkProvider.class, (String)"MSG_OverwriteFile", (Object)fileToBe.getAbsolutePath()), NbBundle.getMessage(JSFFrameworkProvider.class, (String)"TTL_OverwriteFile"), true, 0, DialogDescriptor.NO_OPTION, null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
                d.setVisible(true);
                create = dialog.getValue() == DialogDescriptor.NO_OPTION;
            }
            return create;
        }

        private void changeIndexJSP(FileObject indexjsp) throws IOException {
            String content = JSFFrameworkProvider.readResource(indexjsp.getInputStream(), "UTF-8");
            String find = "<h1>JSP Page</h1>";
            String endLine = System.getProperty("line.separator");
            if (content.indexOf(find) > 0) {
                StringBuffer replace = new StringBuffer();
                replace.append(find);
                replace.append(endLine);
                replace.append("    <br/>");
                replace.append(endLine);
                replace.append("    <a href=\".");
                replace.append(JSFConfigUtilities.translateURI(JSFFrameworkProvider.this.panel == null ? "/faces/*" : JSFFrameworkProvider.this.panel.getURLPattern(), "/welcomeJSF.jsp"));
                replace.append("\">");
                replace.append(NbBundle.getMessage(JSFFrameworkProvider.class, (String)"LBL_JSF_WELCOME_PAGE"));
                replace.append("</a>");
                content = content.replaceFirst(find, new String(replace.toString().getBytes("UTF8"), "UTF-8"));
                JSFFrameworkProvider.createFile(indexjsp, content, "UTF-8");
            }
        }
    }
}

