/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class SyncFileNode
extends AbstractNode {
    private CvsFileNode node;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_STICKY = "sticky";
    private String htmlDisplayName;
    private String sticky;
    private static final String[] zeros = new String[]{"", "00", "0", ""};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode;

    public SyncFileNode(CvsFileNode node) {
        this(Children.LEAF, node);
    }

    private SyncFileNode(Children children, CvsFileNode node) {
        super(children, Lookups.fixed((Object[])node.getLookupObjects()));
        this.node = node;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public File getFile() {
        return this.node.getFile();
    }

    public FileInformation getFileInformation() {
        return this.node.getInformation();
    }

    public String getName() {
        return this.node.getName();
    }

    public Action getPreferredAction() {
        if (this.node.getInformation().getStatus() == 64) {
            return SystemAction.get((Class)ResolveConflictsAction.class);
        }
        return SystemAction.get((Class)DiffAction.class);
    }

    public Node.Cookie getCookie(Class klass) {
        FileObject fo = FileUtil.toFileObject((File)this.getFile());
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return dobj.getCookie(klass);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(klass);
    }

    private void initProperties() {
        if (this.node.getFile().isDirectory()) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new PathProperty());
        ps.put((Node.Property)new StatusProperty());
        ps.put((Node.Property)new StickyProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        FileInformation info = this.node.getInformation();
        int status = info.getStatus();
        if (status == 128) {
            status = 64;
        }
        this.htmlDisplayName = CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(this.node.getFile().getName(), info, null);
        this.fireDisplayNameChange(this.node.getName(), this.node.getName());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    public String getSticky() {
        if (this.sticky == null) {
            this.sticky = Utils.getSticky(this.node.getFile());
            this.sticky = this.sticky == null ? "" : this.sticky.substring(1);
        }
        return this.sticky == null || this.sticky.length() == 0 ? "" : this.sticky;
    }

    private class StatusProperty
    extends SyncFileProperty {
        public StatusProperty() {
            super(SyncFileNode.COLUMN_NAME_STATUS, class$java$lang$String == null ? (class$java$lang$String = SyncFileNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2007"), NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2008"));
            String shortPath = Utils.getRelativePath(SyncFileNode.this.node.getFile());
            String sortable = Integer.toString(Utils.getComparableStatus(SyncFileNode.this.node.getInformation().getStatus()));
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + shortPath + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.node.getInformation().getStatusText();
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(SyncFileNode.COLUMN_NAME_NAME, class$java$lang$String == null ? (class$java$lang$String = SyncFileNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2005"), NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2006"));
            this.setValue("sortkey", SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;

        public PathProperty() {
            super(SyncFileNode.COLUMN_NAME_PATH, class$java$lang$String == null ? (class$java$lang$String = SyncFileNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2003"), NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2004"));
            this.shortPath = Utils.getRelativePath(SyncFileNode.this.node.getFile());
            this.setValue("sortkey", this.shortPath + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    private class StickyProperty
    extends SyncFileProperty {
        public StickyProperty() {
            super(SyncFileNode.COLUMN_NAME_STICKY, class$java$lang$String == null ? (class$java$lang$String = SyncFileNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2001"), NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode = SyncFileNode.class$("org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$syncview$SyncFileNode), (String)"BK2002"));
        }

        public Object getValue() {
            return SyncFileNode.this.getSticky();
        }
    }

    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly {
        protected SyncFileProperty(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }
    }
}

