/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffResultsView;
import org.netbeans.modules.versioning.system.cvss.ui.history.Divider;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.util.NoContentPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener,
DiffSetupSource {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private Divider divider;
    private Action searchAction;
    private SearchExecutor currentSearch;
    private RequestProcessor.Task currentSearchTask;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List results;
    private List dispResults;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private ExplorerManager explorerManager;
    private static final Comparator revisionsComparator = new ByRemotePathRevisionNumberComparator(){

        public int compare(Object o1, Object o2) {
            return super.compare(((DispRevision)o1).getRevision(), ((DispRevision)o2).getRevision());
        }
    };
    private JButton bNext;
    private JButton bPrev;
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JToolBar jToolBar1;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;

    public SearchHistoryPanel(File[] roots, SearchCriteriaPanel criteria) {
        this.roots = roots;
        this.criteria = criteria;
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.setupComponents();
        this.refreshComponents(true);
    }

    private void setupComponents() {
        this.remove(this.jPanel1);
        this.divider = new Divider(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.divider, gridBagConstraints);
        this.searchCriteriaPanel.add(this.criteria);
        this.searchAction = new AbstractAction(NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel = SearchHistoryPanel.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel), (String)"TT_Search"));
            }

            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.search();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.getActionMap().put("search", this.searchAction);
        this.bSearch.setAction(this.searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension d1 = this.tbSummary.getPreferredSize();
        Dimension d2 = this.tbDiff.getPreferredSize();
        if (d1.width > d2.width) {
            this.tbDiff.setPreferredSize(d1);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 1) {
            this.criteriaVisible = !this.criteriaVisible;
            this.refreshComponents(false);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean refreshResults) {
        if (refreshResults) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add(new NoContentPanel(NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add(new NoContentPanel(NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
            } else if (this.tbSummary.isSelected()) {
                if (this.summaryView == null) {
                    this.summaryView = new SummaryView(this, this.dispResults);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
            } else {
                if (this.diffView == null) {
                    this.diffView = new DiffResultsView(this, this.dispResults);
                }
                this.resultsPanel.add(this.diffView.getComponent());
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
        this.divider.setArrowDirection(this.criteriaVisible ? 1 : 0);
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.bSearch.setVisible(this.criteriaVisible);
        this.revalidate();
        this.repaint();
    }

    public void setResults(List newResults) {
        this.setResults(newResults, false);
    }

    private void setResults(List newResults, boolean searching) {
        this.results = newResults;
        if (this.results != null) {
            this.dispResults = SearchHistoryPanel.createDisplayList(this.results);
        }
        this.searchInProgress = searching;
        this.summaryView = null;
        this.diffView = null;
        this.refreshComponents(true);
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    private synchronized void search() {
        if (this.currentSearchTask != null) {
            this.currentSearchTask.cancel();
        }
        this.setResults(null, true);
        this.currentSearch = new SearchExecutor(this);
        this.currentSearchTask = RequestProcessor.getDefault().create((Runnable)this.currentSearch);
        this.currentSearchTask.schedule(0);
    }

    private static List createDisplayList(List list) {
        ArrayList<ResultsContainer> dispResults = new ArrayList<ResultsContainer>();
        ArrayList<DispRevision> results = new ArrayList<DispRevision>(list);
        Collections.sort(results, new ByRemotePathRevisionNumberComparator());
        int n = results.size();
        if (n == 0) {
            return dispResults;
        }
        for (int i = 0; i < n; ++i) {
            LogInformation.Revision revision = (LogInformation.Revision)results.get(i);
            results.set(i, new DispRevision(revision));
        }
        ResultsContainer currentContainer = null;
        currentContainer = new ResultsContainer(((DispRevision)results.get(0)).getRevision().getLogInfoHeader());
        dispResults.add(currentContainer);
        for (int i = 0; i < n; ++i) {
            DispRevision parent;
            DispRevision revision = (DispRevision)results.get(i);
            if (currentContainer.getHeader() != revision.getRevision().getLogInfoHeader()) {
                if (currentContainer.getRevisions().size() < 1) {
                    dispResults.remove(currentContainer);
                    if (currentContainer.getRevisions().size() == 1) {
                        dispResults.add((ResultsContainer)currentContainer.getRevisions().get(0));
                    }
                }
                currentContainer = new ResultsContainer(revision.getRevision().getLogInfoHeader());
                dispResults.add(currentContainer);
            }
            if ((parent = SearchHistoryPanel.getParentRevision(results, revision)) != null) {
                parent.addRevision(revision);
                continue;
            }
            currentContainer.add(revision);
        }
        if (currentContainer.getRevisions().size() < 1) {
            dispResults.remove(currentContainer);
            if (currentContainer.getRevisions().size() == 1) {
                dispResults.add((ResultsContainer)currentContainer.getRevisions().get(0));
            }
        }
        return dispResults;
    }

    private static DispRevision getParentRevision(List results, DispRevision revision) {
        LogInformation.Revision parentRev;
        int index;
        String number = revision.getRevision().getNumber();
        do {
            int idx;
            if ((idx = number.lastIndexOf(46, number.lastIndexOf(46) - 1)) == -1) {
                return null;
            }
            number = number.substring(0, idx);
            parentRev = new LogInformation.Revision(revision.getRevision().getLogInfoHeader());
            parentRev.setNumber(number);
        } while ((index = Collections.binarySearch(results, new DispRevision(parentRev), revisionsComparator)) < 0);
        return (DispRevision)results.get(index);
    }

    void executeSearch() {
        this.search();
    }

    void showDiff(DispRevision revision) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(revision);
    }

    public void showDiff(ResultsContainer container) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(container);
    }

    public Collection getSetups() {
        if (this.dispResults == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<Setup> setups = new ArrayList<Setup>(this.dispResults.size());
        Iterator it = this.dispResults.iterator();
        while (it.hasNext()) {
            ResultsContainer entry = (ResultsContainer)it.next();
            File file = entry.getHeader().getFile();
            boolean atomicRange = true;
            String prev = null;
            List revisions = entry.getRevisions();
            Iterator revs = revisions.iterator();
            while (revs.hasNext()) {
                DispRevision revision = (DispRevision)revs.next();
                String rev = revision.getRevision().getNumber();
                if (prev != null && !prev.equals(Utils.previousRevision(rev))) {
                    atomicRange = false;
                    break;
                }
                prev = rev;
            }
            if (!atomicRange) {
                return Collections.EMPTY_SET;
            }
            String eldest = entry.getEldestRevision();
            String newest = entry.getNewestRevision();
            Setup setup = new Setup(file, eldest, newest);
            setups.add(setup);
        }
        return setups;
    }

    public String getSetupDisplayName() {
        return null;
    }

    public static int compareRevisions(String r1, String r2) {
        int n2;
        int n1;
        StringTokenizer st1 = new StringTokenizer(r1, ".");
        StringTokenizer st2 = new StringTokenizer(r2, ".");
        do {
            if (!st1.hasMoreTokens()) {
                return st2.hasMoreTokens() ? -1 : 0;
            }
            if (st2.hasMoreTokens()) continue;
            return st1.hasMoreTokens() ? 1 : 0;
        } while ((n1 = Integer.parseInt(st1.nextToken())) == (n2 = Integer.parseInt(st2.nextToken())));
        return n2 - n1;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.bNext = new JButton();
        this.bPrev = new JButton();
        this.resultsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchCriteriaPanel, gridBagConstraints);
        this.bSearch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.bSearch, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_NextDifference"));
        this.bPrev.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_PrevDifference"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.resultsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    private void onViewToggle(ActionEvent evt) {
        this.refreshComponents(true);
    }

    private static class ByRemotePathRevisionNumberComparator
    implements Comparator {
        private ByRemotePathRevisionNumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            LogInformation.Revision r1 = (LogInformation.Revision)o1;
            LogInformation.Revision r2 = (LogInformation.Revision)o2;
            int namec = r1.getLogInfoHeader().getFile().getName().compareToIgnoreCase(r2.getLogInfoHeader().getFile().getName());
            if (namec != 0) {
                return namec;
            }
            namec = r1.getLogInfoHeader().getRepositoryFilename().compareToIgnoreCase(r2.getLogInfoHeader().getRepositoryFilename());
            if (namec != 0) {
                return namec;
            }
            return SearchHistoryPanel.compareRevisions(r1.getNumber(), r2.getNumber());
        }
    }

    static class DispRevision {
        private final LogInformation.Revision revision;
        private String name;
        private List children;
        private String path;
        private int indentation;

        public DispRevision(LogInformation.Revision revision) {
            block2: {
                this.revision = revision;
                File file = revision.getLogInfoHeader().getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception e) {
                    this.name = revision.getLogInfoHeader().getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public LogInformation.Revision getRevision() {
            return this.revision;
        }

        public void addRevision(DispRevision revision) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(revision);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DispRevision)) {
                return false;
            }
            return this.revision.equals(((DispRevision)o).revision);
        }

        public int hashCode() {
            return this.revision.hashCode();
        }

        public int getIndentation() {
            return this.indentation;
        }

        public void setIndentation(int indentation) {
            this.indentation = indentation;
        }

        public String toString() {
            StringBuffer indent = new StringBuffer("  ");
            for (int i = 0; i < this.getIndentation(); ++i) {
                indent.append("  ");
            }
            StringBuffer text = new StringBuffer();
            text.append(indent).append(this.getRevision().getNumber()).append("\t").append(this.getRevision().getDateString()).append(" ").append(this.getRevision().getAuthor());
            text.append("\n");
            text.append(this.getRevision().getMessage());
            return text.toString();
        }
    }

    static class ResultsContainer {
        private List revisions;
        private String name;
        private String path;
        private final LogInformation header;

        public ResultsContainer(LogInformation header) {
            block2: {
                this.revisions = new ArrayList(2);
                this.header = header;
                File file = header.getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception e) {
                    this.name = header.getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
            this.name = this.name.substring(this.path.length() + 1);
        }

        public LogInformation getHeader() {
            return this.header;
        }

        public void add(DispRevision revision) {
            this.revisions.add(this.revisions.size(), revision);
        }

        public String getName() {
            return this.name;
        }

        public List getRevisions() {
            return this.revisions;
        }

        public String getEldestRevision() {
            DispRevision rev = (DispRevision)this.revisions.get(this.revisions.size() - 1);
            return Utils.previousRevision(rev.getRevision().getNumber());
        }

        public String getNewestRevision() {
            return ((DispRevision)this.revisions.get(0)).getRevision().getNumber();
        }

        public String getPath() {
            return this.path;
        }

        public File getFile() {
            return this.header.getFile();
        }

        public String toString() {
            return this.getName() + "    " + this.getPath();
        }
    }
}

