/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.modules.versioning.system.cvss.ui.actions.SystemActionBridge;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.AddToRepositoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.UpdateWithDependenciesAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public final class ProjectCvsMenuItem
extends NodeAction
implements Presenter.Popup {
    private static final String name = NbBundle.getBundle((Class)ProjectCvsMenuItem.class).getString("CTL_MenuItem_CVSCommands_Label");

    public String getName() {
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectCvsMenuItem.class);
    }

    protected void performAction(Node[] nodes) {
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length > 0) {
            int versionedCount = 0;
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                if (!Utils.isVersionedProject(node)) continue;
                ++versionedCount;
            }
            return versionedCount == nodes.length || versionedCount == 0;
        }
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new CvsProjectMenuItems();
    }

    private static Action[] actions() {
        Action[] actions;
        Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        int versionedCount = 0;
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (!Utils.isVersionedProject(node)) continue;
            ++versionedCount;
        }
        if (versionedCount == 0) {
            SystemAction sysAction = SystemAction.get((Class)AddToRepositoryAction.class);
            actions = new Action[]{new SystemActionBridge((Action)sysAction, sysAction.getName())};
        } else {
            ResourceBundle loc = NbBundle.getBundle((Class)ProjectCvsMenuItem.class);
            actions = new Action[]{new SystemActionBridge((Action)SystemAction.get((Class)StatusAction.class), loc.getString("CTL_ProjectMenu_Status")), new SystemActionBridge((Action)SystemAction.get((Class)DiffAction.class), loc.getString("CTL_ProjectMenu_Diff")), new SystemActionBridge((Action)SystemAction.get((Class)UpdateAction.class), loc.getString("CTL_ProjectMenu_Update")), new SystemActionBridge((Action)SystemAction.get((Class)UpdateWithDependenciesAction.class), loc.getString("CTL_ProjectMenu_UpdateWithDeps")), new SystemActionBridge((Action)SystemAction.get((Class)CommitAction.class), loc.getString("CTL_ProjectMenu_Commit")), null, new SystemActionBridge((Action)SystemAction.get((Class)TagAction.class), loc.getString("CTL_ProjectMenu_Tag")), null, new SystemActionBridge((Action)SystemAction.get((Class)BranchAction.class), loc.getString("CTL_ProjectMenu_Branch")), new SystemActionBridge((Action)SystemAction.get((Class)SwitchBranchAction.class), loc.getString("CTL_ProjectMenu_SwitchBranch")), new SystemActionBridge((Action)SystemAction.get((Class)MergeBranchAction.class), loc.getString("CTL_ProjectMenu_MergeFromBranch")), null, new SystemActionBridge((Action)SystemAction.get((Class)SearchHistoryAction.class), loc.getString("CTL_ProjectMenu_SearchHistory")), null, new SystemActionBridge((Action)SystemAction.get((Class)GetCleanAction.class), loc.getString("CTL_ProjectMenu_RevertModifications")), new SystemActionBridge((Action)SystemAction.get((Class)ResolveConflictsAction.class), loc.getString("CTL_ProjectMenu_ResolveConflicts"))};
        }
        return actions;
    }

    private static final class CvsProjectMenuItems
    extends JMenu {
        static final long serialVersionUID = 1L;
        private boolean popupContructed;

        public CvsProjectMenuItems() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)name);
        }

        public void setSelected(boolean selected) {
            if (selected && !this.popupContructed) {
                Action[] actions = ProjectCvsMenuItem.actions();
                for (int i = 0; i < actions.length; ++i) {
                    Action action = actions[i];
                    if (action == null) {
                        this.add(new JSeparator());
                        continue;
                    }
                    JMenuItem item = new JMenuItem(actions[i]);
                    Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                    this.add(item);
                }
                this.popupContructed = true;
            }
            super.setSelected(selected);
        }
    }
}

