/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.VersionsCacheExecutor;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class VersionsCache {
    public static final String REVISION_CURRENT = "";
    public static final String REVISION_BASE = "*";
    public static final String REVISION_HEAD = "HEAD";
    private static final String CACHE_DIR = "CVS/RevisionCache/";
    private static VersionsCache instance;
    private long purgeTimestamp = Long.MAX_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static VersionsCache getInstance() {
        return instance;
    }

    private VersionsCache() {
    }

    public synchronized File getRemoteFile(File baseFile, String revision, ExecutorGroup group) throws IOException, IllegalCommandException, CommandException, AuthenticationException, NotVersionedException {
        File file;
        Entry entry;
        if (revision == REVISION_BASE) {
            revision = this.getBaseRevision(baseFile);
        }
        if (revision.equals(REVISION_HEAD) && (entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(baseFile)) != null && entry.getTag() != null) {
            revision = entry.getTag();
        }
        if ((file = this.getCachedRevision(baseFile, revision)) != null) {
            return file;
        }
        file = this.checkoutRemoteFile(baseFile, revision, group);
        if (file == null) {
            return null;
        }
        file = this.saveRevision(baseFile, file, revision);
        return file;
    }

    public void purgeVolatileRevisions() {
        this.purgeTimestamp = System.currentTimeMillis();
    }

    private File saveRevision(File baseFile, File file, String revision) {
        File cacheDir = baseFile.getParentFile().isDirectory() ? new File(baseFile.getParentFile(), CACHE_DIR) : file.getParentFile();
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            return file;
        }
        File destFile = new File(cacheDir, this.cachedName(baseFile, revision));
        try {
            FileInputStream fin = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(destFile);
            FileUtil.copy((InputStream)fin, (OutputStream)fos);
            fin.close();
            fos.close();
            file.delete();
            return destFile;
        }
        catch (IOException e) {
            return file;
        }
    }

    private File getCachedRevision(File baseFile, String revision) {
        if (revision == REVISION_CURRENT) {
            return baseFile;
        }
        File cachedCopy = new File(baseFile.getParentFile(), CACHE_DIR + this.cachedName(baseFile, revision));
        if (this.isVolatile(revision) && cachedCopy.lastModified() < this.purgeTimestamp) {
            cachedCopy.delete();
        }
        if (cachedCopy.canRead()) {
            return cachedCopy;
        }
        return null;
    }

    private boolean isVolatile(String revision) {
        return revision.indexOf(46) == -1;
    }

    private String getBaseRevision(File file) throws IOException {
        Entry entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
        String rawRev = entry.getRevision();
        if (rawRev != null && rawRev.startsWith("-")) {
            return rawRev.substring(1);
        }
        return rawRev;
    }

    private String cachedName(File baseFile, String revision) {
        return baseFile.getName() + "#" + revision;
    }

    private String getRepositoryForDirectory(File directory, String repository) {
        if (directory == null) {
            return null;
        }
        if (!directory.exists() && MetadataAttic.getMetadata(directory) == null) {
            return this.getRepositoryForDirectory(directory.getParentFile(), repository) + "/" + directory.getName();
        }
        try {
            return CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(directory.getAbsolutePath(), repository);
        }
        catch (IOException e) {
            return null;
        }
    }

    private File checkoutRemoteFile(File baseFile, String revision, ExecutorGroup group) throws IOException {
        GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
        String root = this.getCvsRoot(baseFile.getParentFile());
        CVSRoot cvsRoot = CVSRoot.parse((String)root);
        String repository = cvsRoot.getRepository();
        options.setCVSRoot(root);
        String repositoryPath = this.getRepositoryForDirectory(baseFile.getParentFile(), repository) + "/" + baseFile.getName();
        CheckoutCommand cmd = new CheckoutCommand();
        cmd.setRecursive(false);
        if (!$assertionsDisabled && !repositoryPath.startsWith(repository)) {
            throw new AssertionError((Object)(repositoryPath + " does not start with: " + repository));
        }
        if ((repositoryPath = repositoryPath.substring(repository.length())).startsWith("/")) {
            repositoryPath = repositoryPath.substring(1);
        }
        cmd.setModule(repositoryPath);
        cmd.setPipeToOutput(true);
        cmd.setCheckoutByRevision(revision);
        String msg = NbBundle.getMessage((Class)VersionsCache.class, (String)"MSG_VersionsCache_FetchingProgress", (Object)revision, (Object)baseFile.getName());
        cmd.setDisplayName(msg);
        VersionsCacheExecutor executor = new VersionsCacheExecutor(cmd, options);
        if (group != null) {
            group.progress(msg);
            group.addExecutor(executor);
        }
        executor.execute();
        ExecutorSupport.wait(new ExecutorSupport[]{executor});
        if (group == null) {
            executor.getGroup().executed();
        }
        if (executor.isSuccessful()) {
            return executor.getCheckedOutVersion();
        }
        IOException ioe = new IOException(NbBundle.getMessage((Class)VersionsCache.class, (String)"Bk4001", (Object)revision, (Object)baseFile.getName()));
        ioe.initCause(executor.getFailure());
        throw ioe;
    }

    private String getCvsRoot(File baseFile) throws IOException {
        try {
            return Utils.getCVSRootFor(baseFile);
        }
        catch (IOException e) {
            CvsMetadata data = MetadataAttic.getMetadata(baseFile);
            if (data != null) {
                return data.getRoot();
            }
            throw new IOException("CVS/Root not found");
        }
    }

    static {
        $assertionsDisabled = !VersionsCache.class.desiredAssertionStatus();
        instance = new VersionsCache();
    }
}

