/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

class FilesystemHandler
implements FileChangeListener,
InterceptionListener {
    private static final RequestProcessor eventProcessor = new RequestProcessor("CVS-Event", 1);
    private static final String METADATA_PATTERN = File.separator + "CVS";
    private final FileStatusCache cache;
    private static Thread ignoredThread;

    public FilesystemHandler(CvsVersioningSystem cvs) {
        this.cache = cvs.getStatusCache();
    }

    static void ignoreEvents(boolean ignore) {
        ignoredThread = ignore ? Thread.currentThread() : null;
    }

    static boolean ignoringEvents() {
        return ignoredThread == Thread.currentThread();
    }

    public void fileFolderCreated(FileEvent fe) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        if (!this.shouldHandle(fe)) {
            return;
        }
        eventProcessor.post((Runnable)new FileCreatedTask(FileUtil.toFile((FileObject)fe.getFile())));
    }

    public void fileDataCreated(FileEvent fe) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        if (!this.shouldHandle(fe)) {
            return;
        }
        eventProcessor.post((Runnable)new FileCreatedTask(FileUtil.toFile((FileObject)fe.getFile())));
    }

    public void fileChanged(FileEvent fe) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        if (!this.shouldHandle(fe)) {
            return;
        }
        eventProcessor.post((Runnable)new FileChangedTask(FileUtil.toFile((FileObject)fe.getFile())));
    }

    public void fileDeleted(FileEvent fe) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        if (!this.shouldHandle(fe)) {
            return;
        }
        eventProcessor.post((Runnable)new FileDeletedTask(FileUtil.toFile((FileObject)fe.getFile())));
    }

    public void fileRenamed(FileRenameEvent fe) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        if (!this.shouldHandle((FileEvent)fe)) {
            return;
        }
        eventProcessor.post((Runnable)new FileRenamedTask(fe));
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void createSuccess(FileObject fo) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (!this.shouldHandle(fo)) {
            return;
        }
        if (fo.isFolder() && fo.getNameExt().equals("CVS")) {
            File f = new File(FileUtil.toFile((FileObject)fo), "invalid-metadata");
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                ErrorManager.getDefault().log(65536, "Unable to create marker: " + f.getAbsolutePath());
            }
        }
    }

    public void beforeCreate(FileObject parent, String name, boolean isFolder) {
    }

    public void createFailure(FileObject parent, String name, boolean isFolder) {
    }

    public void beforeDelete(FileObject fo) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (!this.shouldHandle(fo)) {
            return;
        }
        if (fo.isFolder()) {
            this.saveRecursively(FileUtil.toFile((FileObject)fo));
        } else {
            FileObject parent = fo.getParent();
            if ("CVS".equals(parent.getName())) {
                if ((parent = parent.getParent()) == null) {
                    return;
                }
                File matadataOwner = FileUtil.toFile((FileObject)parent);
                this.saveMetadata(matadataOwner);
            }
        }
    }

    private void saveRecursively(File root) {
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isDirectory()) continue;
            if ("CVS".equals(file.getName())) {
                this.saveMetadata(root);
                continue;
            }
            this.saveRecursively(file);
        }
    }

    public void deleteSuccess(FileObject fo) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (!this.shouldHandle(fo)) {
            return;
        }
        File deleted = FileUtil.toFile((FileObject)fo);
        if (fo.isFolder()) {
            this.refreshRecursively(deleted);
        }
        this.fileDeletedImpl(deleted);
    }

    private void refreshRecursively(File file) {
        CvsMetadata data = MetadataAttic.getMetadata(file);
        if (data == null) {
            return;
        }
        Entry[] entries = data.getEntryObjects();
        for (int i = 0; i < entries.length; ++i) {
            Entry entry = entries[i];
            if (entry.getName() == null) continue;
            if (entry.isDirectory()) {
                this.refreshRecursively(new File(file, entry.getName()));
                continue;
            }
            this.cache.refreshCached(new File(file, entry.getName()), 0);
        }
    }

    public void deleteFailure(FileObject fo) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (!this.shouldHandle(fo)) {
            return;
        }
        if (fo.isFolder()) {
            File notDeleted = FileUtil.toFile((FileObject)fo);
            CvsMetadata data = MetadataAttic.getMetadata(notDeleted);
            this.flushMetadata(notDeleted, data);
            this.refreshRecursively(notDeleted);
        }
    }

    void init() {
        Set filesystems = this.getRootFilesystems();
        Iterator i = filesystems.iterator();
        while (i.hasNext()) {
            FileSystem fileSystem = (FileSystem)i.next();
            fileSystem.addFileChangeListener((FileChangeListener)this);
        }
    }

    void shutdown() {
        Set filesystems = this.getRootFilesystems();
        Iterator i = filesystems.iterator();
        while (i.hasNext()) {
            FileSystem fileSystem = (FileSystem)i.next();
            fileSystem.removeFileChangeListener((FileChangeListener)this);
        }
    }

    private Set getRootFilesystems() {
        HashSet<FileSystem> filesystems = new HashSet<FileSystem>();
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)root));
            if (fo == null) continue;
            try {
                filesystems.add(fo.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return filesystems;
    }

    private boolean shouldHandle(FileEvent fe) {
        return this.shouldHandle(fe.getFile());
    }

    private boolean shouldHandle(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        String path = file.getAbsolutePath();
        int idx = path.lastIndexOf(METADATA_PATTERN);
        if (idx != -1) {
            if (idx == path.length() - 4) {
                return true;
            }
            if (path.charAt(idx + 4) == File.separatorChar) {
                return path.indexOf(File.separatorChar, idx + 5) == -1;
            }
        }
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return true;
        }
        int status = cache.getStatus(file).getStatus();
        return (status & 0xFFFFFFFE) != 0;
    }

    private void fileCreatedImpl(File file) {
        if (file == null) {
            return;
        }
        int status = this.cache.refresh(file, 0).getStatus();
        if (file.isDirectory()) {
            CvsMetadata data = MetadataAttic.getMetadata(file);
            this.flushMetadata(file, data);
        }
        if ((status & 0xFFFFFFFE) == 0) {
            return;
        }
        if (status == 256) {
            StandardAdminHandler sah = new StandardAdminHandler();
            Entry entry = null;
            try {
                entry = sah.getEntry(file);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (entry != null && !entry.isDirectory() && entry.isUserFileToBeRemoved()) {
                this.cvsUndoRemoveLocally((AdminHandler)sah, file, entry);
            }
            this.cache.refresh(file, 0);
        }
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
        if (file.isDirectory()) {
            this.cache.directoryContentChanged(file);
        }
    }

    private void flushMetadata(File dir, CvsMetadata data) {
        if (data == null) {
            return;
        }
        try {
            File metadataDir = new File(dir, "CVS");
            if (!metadataDir.exists()) {
                data.save(metadataDir);
            }
            MetadataAttic.setMetadata(dir, null);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private void fileDeletedImpl(File file) {
        if (file == null) {
            return;
        }
        StandardAdminHandler sah = new StandardAdminHandler();
        Entry entry = null;
        try {
            entry = sah.getEntry(file);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (entry != null && !entry.isDirectory() && !entry.isUserFileToBeRemoved()) {
            this.cvsRemoveLocally((AdminHandler)sah, file, entry);
        }
        this.cache.refresh(file, 0);
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
    }

    private void cvsRemoveLocally(AdminHandler ah, File file, Entry entry) {
        try {
            if (entry.isNewUserFile()) {
                ah.removeEntry(file);
            } else {
                entry.setRevision("-" + entry.getRevision());
                entry.setConflict("dummy timestamp");
                ah.setEntry(file, entry);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void cvsUndoRemoveLocally(AdminHandler ah, File file, Entry entry) {
        entry.setRevision(entry.getRevision().substring(1));
        entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(System.currentTimeMillis() - 1000L)));
        try {
            ah.setEntry(file, entry);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void saveMetadata(File dir) {
        if (MetadataAttic.getMetadata(dir = FileUtil.normalizeFile((File)dir)) != null) {
            return;
        }
        MetadataAttic.setMetadata(dir, null);
        try {
            CvsMetadata data = CvsMetadata.readAndRemove(dir);
            MetadataAttic.setMetadata(dir, data);
        }
        catch (IOException e) {
            return;
        }
    }

    private final class FileRenamedTask
    implements Runnable {
        private final FileRenameEvent event;

        public FileRenamedTask(FileRenameEvent event) {
            this.event = event;
        }

        public void run() {
            FileObject newFile = this.event.getFile();
            String oldName = this.event.getName();
            String oldExtension = this.event.getExt();
            if (oldExtension.length() > 0) {
                oldExtension = "." + oldExtension;
            }
            File parent = FileUtil.toFile((FileObject)newFile.getParent());
            File removed = new File(parent, oldName + oldExtension);
            FilesystemHandler.this.fileDeletedImpl(removed);
            FilesystemHandler.this.fileCreatedImpl(FileUtil.toFile((FileObject)newFile));
        }
    }

    private final class FileDeletedTask
    implements Runnable {
        private final File file;

        FileDeletedTask(File file) {
            this.file = file;
        }

        public void run() {
            FilesystemHandler.this.fileDeletedImpl(this.file);
        }
    }

    private final class FileChangedTask
    implements Runnable {
        private final File file;

        FileChangedTask(File file) {
            this.file = file;
        }

        public void run() {
            FilesystemHandler.this.cache.refreshCached(this.file, 0);
            if (this.file.getName().equals(".cvsignore")) {
                FilesystemHandler.this.cache.directoryContentChanged(this.file.getParentFile());
            }
        }
    }

    private final class FileCreatedTask
    implements Runnable {
        private final File file;

        FileCreatedTask(File file) {
            this.file = file;
        }

        public void run() {
            FilesystemHandler.this.fileCreatedImpl(this.file);
        }
    }
}

