/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.plugin;

import java.util.Map;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JUnitPlugin {
    protected JUnitPlugin() {
    }

    protected abstract Location getTestLocation(Location var1);

    protected abstract Location getTestedLocation(Location var1);

    protected abstract FileObject[] createTests(FileObject[] var1, FileObject var2, Map<CreateTestParam, Object> var3);

    static {
        JUnitPluginTrampoline.DEFAULT = new JUnitPluginTrampoline(){

            @Override
            public FileObject[] createTests(JUnitPlugin plugin, FileObject[] filesToTest, FileObject targetRoot, Map<CreateTestParam, Object> params) {
                return plugin.createTests(filesToTest, targetRoot, params);
            }

            @Override
            public Location getTestLocation(JUnitPlugin plugin, Location sourceLocation) {
                return plugin.getTestLocation(sourceLocation);
            }

            @Override
            public Location getTestedLocation(JUnitPlugin plugin, Location testLocation) {
                return plugin.getTestedLocation(testLocation);
            }
        };
    }

    public static final class Location {
        private final FileObject fileObject;
        private final Feature javaElement;

        public Location(FileObject fileObject, Feature javaElement) {
            if (fileObject == null) {
                throw new IllegalArgumentException("fileObject is null");
            }
            if (javaElement != null) {
                if (!(javaElement instanceof JavaClass) && !(javaElement instanceof Method)) {
                    throw new IllegalArgumentException("The Java element is neither JavaClass nor JavaElement");
                }
                if (JavaModel.getFileObject((Resource)javaElement.getResource()) != fileObject) {
                    throw new IllegalArgumentException("The Java element is not contained in the given FileObject.");
                }
            }
            this.fileObject = fileObject;
            this.javaElement = javaElement;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public Feature getJavaElement() {
            return this.javaElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreateTestParam {
        CLASS_NAME(99310),
        INC_PUBLIC(99311),
        INC_PROTECTED(99312),
        INC_PKG_PRIVATE(99313),
        INC_SETUP(99314),
        INC_TEAR_DOWN(99315),
        INC_METHOD_BODIES(99316),
        INC_JAVADOC(99317),
        INC_CODE_HINT(99318),
        INC_PKG_PRIVATE_CLASS(99319),
        INC_ABSTRACT_CLASS(99320),
        INC_EXCEPTION_CLASS(99321),
        INC_GENERATE_SUITE(99322);

        private final int idNumber;

        private CreateTestParam(int idNumber) {
            this.idNumber = idNumber;
        }

        public int getIdNumber() {
            return this.idNumber;
        }
    }
}

