/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.ui.ProjectCustomizer;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class ProjectCustomizerProvider
implements CustomizerProvider {
    private final FreeformProject project;
    private final AntProjectHelper antProjectHelper;
    private final PropertyEvaluator evaluator;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private DialogDescriptor dialogDescriptor;
    private Map customizerPerProject = new WeakHashMap();

    public ProjectCustomizerProvider(FreeformProject project, AntProjectHelper antProjectHelper, PropertyEvaluator evaluator) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
        this.evaluator = evaluator;
    }

    public void showCustomizer() {
        Dialog dlg;
        if (this.customizerPerProject.containsKey(this.project) && (dlg = (Dialog)this.customizerPerProject.get(this.project)).isShowing()) {
            dlg.show();
            return;
        }
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[1].setActionCommand(COMMAND_CANCEL);
        ProjectCustomizer pc = new ProjectCustomizer(this.project, this.antProjectHelper);
        OptionListener optionsListener = new OptionListener(this.project, pc);
        options[0].addActionListener(optionsListener);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"ACSD_Customizer_Ok_Option"));
        options[1].addActionListener(optionsListener);
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"ACSD_Customizer_Cancel_Option"));
        this.dialogDescriptor = new DialogDescriptor((Object)pc, MessageFormat.format(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()), false, options, (Object)options[0], 0, null, null);
        pc.setDialogDescriptor(this.dialogDescriptor);
        this.dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.customizerPerProject.put(this.project, dialog);
        dialog.show();
    }

    private static class OptionListener
    implements ActionListener {
        private Project project;
        private ProjectCustomizer projectCustomizer;

        private OptionListener(Project project, ProjectCustomizer projectCustomizer) {
            this.project = project;
            this.projectCustomizer = projectCustomizer;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (ProjectCustomizerProvider.COMMAND_OK.equals(command)) {
                this.projectCustomizer.save();
                try {
                    ProjectManager.getDefault().saveProject(this.project);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }
}

