/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.spi.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.ProjectAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Util {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    public static Element findElement(Element parent, String name, String namespace) {
        Element result = null;
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            Element el;
            if (l.item(i).getNodeType() != 1 || !name.equals((el = (Element)l.item(i)).getLocalName()) || !namespace.equals(el.getNamespaceURI())) continue;
            if (result == null) {
                result = el;
                continue;
            }
            return null;
        }
        return result;
    }

    public static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static List findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        for (int i = 0; i < l.getLength(); ++i) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
                continue;
            }
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
        }
        return elements;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(AntProjectHelper helper) {
        try {
            Project p = ProjectManager.getDefault().findProject(helper.getProjectDirectory());
            AuxiliaryConfiguration aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class);
            if (!$assertionsDisabled && aux == null) {
                throw new AssertionError();
            }
            return aux;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public static String relativizeLocation(File projectBase, File freeformBase, File location) {
        if (CollocationQuery.areCollocated((File)projectBase, (File)location)) {
            if (projectBase.equals(freeformBase)) {
                return PropertyUtils.relativizeFile((File)projectBase, (File)location);
            }
            if (projectBase.equals(location) && "${project.dir}/".endsWith("/")) {
                return "${project.dir}/".substring(0, "${project.dir}/".length() - 1);
            }
            return "${project.dir}/" + PropertyUtils.relativizeFile((File)projectBase, (File)location);
        }
        return location.getAbsolutePath();
    }

    public static File resolveFile(PropertyEvaluator evaluator, File freeformProjectBase, String val) {
        String location = evaluator.evaluate(val);
        if (location == null) {
            return null;
        }
        return PropertyUtils.resolveFile((File)freeformProjectBase, (String)location);
    }

    public static File getProjectLocation(AntProjectHelper helper, PropertyEvaluator evaluator) {
        String loc = evaluator.getProperty("project.dir");
        if (loc != null) {
            return helper.resolveFile(loc);
        }
        return FileUtil.toFile((FileObject)helper.getProjectDirectory());
    }

    public static void appendChildElement(Element parent, Element el, String[] order) {
        Element insertBefore = null;
        List<String> l = Arrays.asList(order);
        int index = l.indexOf(el.getLocalName());
        if (!$assertionsDisabled && index == -1) {
            throw new AssertionError((Object)(el.getLocalName() + " was not found in " + l));
        }
        Iterator it = Util.findSubElements(parent).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            int index2 = l.indexOf(e.getLocalName());
            if (!$assertionsDisabled && index2 == -1) {
                throw new AssertionError((Object)(e.getLocalName() + " was not found in " + l));
            }
            if (index2 <= index) continue;
            insertBefore = e;
            break;
        }
        parent.insertBefore(el, insertBefore);
    }

    public static FileObject getDefaultAntScript(Project prj) throws IllegalArgumentException {
        ProjectAccessor accessor = (ProjectAccessor)prj.getLookup().lookup(ProjectAccessor.class);
        if (accessor == null) {
            throw new IllegalArgumentException("Only FreeformProjects are supported.");
        }
        return FreeformProjectGenerator.getAntScript(accessor.getHelper(), accessor.getEvaluator());
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

