/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.spi.support;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.ui.BasicProjectInfoWizardPanel;
import org.netbeans.modules.ant.freeform.ui.TargetMappingWizardPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.WizardDescriptor;

public class NewFreeformProjectSupport {
    public static final String PROP_ANT_SCRIPT = "antScript";
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_PROJECT_LOCATION = "projectLocation";
    public static final String PROP_PROJECT_FOLDER = "projectFolder";

    private NewFreeformProjectSupport() {
    }

    public static final WizardDescriptor.Panel createBasicProjectInfoWizardPanel() {
        return new BasicProjectInfoWizardPanel();
    }

    public static final AntProjectHelper instantiateBasicProjectInfoWizardPanel(WizardDescriptor wiz) throws IOException {
        File antScript = (File)wiz.getProperty(PROP_ANT_SCRIPT);
        String projName = (String)wiz.getProperty(PROP_PROJECT_NAME);
        File projLocation = (File)wiz.getProperty(PROP_PROJECT_LOCATION);
        File projectFolder = (File)wiz.getProperty(PROP_PROJECT_FOLDER);
        if (antScript.getParentFile().equals(projectFolder) && antScript.getName().equals("build.xml")) {
            antScript = null;
        }
        return FreeformProjectGenerator.createProject(projLocation, projectFolder, projName, antScript);
    }

    public static final WizardDescriptor.Panel createTargetMappingWizardPanel(List targets) {
        return new TargetMappingWizardPanel(targets);
    }

    public static final void instantiateTargetMappingWizardPanel(AntProjectHelper helper, WizardDescriptor wiz) {
        List mappings = (List)wiz.getProperty("targetMappings");
        FreeformProjectGenerator.putTargetMappings(helper, mappings);
        FreeformProjectGenerator.putContextMenuAction(helper, mappings);
    }

    public static void uninitializeBasicProjectInfoWizardPanel(WizardDescriptor wiz) {
        wiz.putProperty(PROP_ANT_SCRIPT, null);
        wiz.putProperty(PROP_PROJECT_NAME, null);
        wiz.putProperty(PROP_PROJECT_LOCATION, null);
        wiz.putProperty(PROP_PROJECT_FOLDER, null);
    }

    public static void uninitializeTargetMappingWizardPanel(WizardDescriptor wiz) {
        wiz.putProperty("targetMappings", null);
    }
}

