/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.w3c.dom.Element;

final class ArtifactProvider
implements AntArtifactProvider {
    private final FreeformProject project;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArtifactProvider(FreeformProject project) {
        this.project = project;
    }

    public AntArtifact[] getBuildArtifacts() {
        Element data = this.project.helper().getPrimaryConfigurationData(true);
        Iterator exports = Util.findSubElements(data).iterator();
        ArrayList<FreeformArtifact> artifacts = new ArrayList<FreeformArtifact>();
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, FreeformArtifact> uniqueArtifacts = new HashMap<String, FreeformArtifact>();
        while (exports.hasNext()) {
            Element export = (Element)exports.next();
            if (!export.getLocalName().equals("export")) continue;
            FreeformArtifact artifact = new FreeformArtifact(export);
            String artifactKey = artifact.getType() + artifact.getTargetName() + artifact.getScriptLocation().getAbsolutePath();
            FreeformArtifact alreadyHasArtifact = (FreeformArtifact)((Object)uniqueArtifacts.get(artifactKey));
            if (alreadyHasArtifact != null) {
                alreadyHasArtifact.addLocation(ArtifactProvider.readArtifactLocation(export, this.project.evaluator()));
                continue;
            }
            artifact.addLocation(ArtifactProvider.readArtifactLocation(export, this.project.evaluator()));
            uniqueArtifacts.put(artifactKey, artifact);
            String id = artifact.preferredId();
            if (!ids.add(id)) {
                int counter = 2;
                while (true) {
                    String possibleId;
                    if (ids.add(possibleId = id + counter)) {
                        id = possibleId;
                        break;
                    }
                    ++counter;
                }
            }
            artifact.configureId(id);
            artifacts.add(artifact);
        }
        return artifacts.toArray(new AntArtifact[artifacts.size()]);
    }

    public static URI readArtifactLocation(Element export, PropertyEvaluator eval) {
        Element locEl = Util.findElement(export, "location", "http://www.netbeans.org/ns/freeform-project/1");
        if (!$assertionsDisabled && locEl == null) {
            throw new AssertionError();
        }
        String loc = Util.findText(locEl);
        if (!$assertionsDisabled && loc == null) {
            throw new AssertionError();
        }
        String locationResolved = eval.evaluate(loc);
        if (locationResolved == null) {
            return URI.create("file:/UNDEFINED");
        }
        File locF = new File(locationResolved);
        if (locF.isAbsolute()) {
            return locF.toURI();
        }
        try {
            return new URI(null, null, locationResolved.replace(File.separatorChar, '/'), null);
        }
        catch (URISyntaxException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return URI.create("file:/BROKEN");
        }
    }

    static {
        $assertionsDisabled = !ArtifactProvider.class.desiredAssertionStatus();
    }

    private final class FreeformArtifact
    extends AntArtifact {
        private final Element export;
        private String id = null;
        private final Set locations = new LinkedHashSet();
        static final /* synthetic */ boolean $assertionsDisabled;

        public FreeformArtifact(Element export) {
            this.export = export;
        }

        public String preferredId() {
            return this.getTargetName();
        }

        public void configureId(String id) {
            if (!$assertionsDisabled && this.id != null) {
                throw new AssertionError();
            }
            this.id = id;
        }

        public String getType() {
            Element typeEl = Util.findElement(this.export, "type", "http://www.netbeans.org/ns/freeform-project/1");
            if (!$assertionsDisabled && typeEl == null) {
                throw new AssertionError();
            }
            String type = Util.findText(typeEl);
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            return type;
        }

        public String getTargetName() {
            Element targetEl = Util.findElement(this.export, "build-target", "http://www.netbeans.org/ns/freeform-project/1");
            if (!$assertionsDisabled && targetEl == null) {
                throw new AssertionError();
            }
            String target = Util.findText(targetEl);
            if (!$assertionsDisabled && target == null) {
                throw new AssertionError();
            }
            return target;
        }

        public String getCleanTargetName() {
            Element targetEl = Util.findElement(this.export, "clean-target", "http://www.netbeans.org/ns/freeform-project/1");
            if (targetEl != null) {
                String target = Util.findText(targetEl);
                if (!$assertionsDisabled && target == null) {
                    throw new AssertionError();
                }
                return target;
            }
            String target = null;
            Element genldata = ArtifactProvider.this.project.helper().getPrimaryConfigurationData(true);
            Element actionsEl = Util.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
            if (actionsEl != null) {
                Iterator actions = Util.findSubElements(actionsEl).iterator();
                block0: while (actions.hasNext()) {
                    Element actionEl = (Element)actions.next();
                    if (!actionEl.getAttribute("name").equals("clean")) continue;
                    Iterator targets = Util.findSubElements(actionEl).iterator();
                    while (targets.hasNext()) {
                        Element actionTargetEl = (Element)targets.next();
                        if (!actionTargetEl.getLocalName().equals("target")) continue;
                        String possibleTarget = Util.findText(actionTargetEl);
                        if (!$assertionsDisabled && possibleTarget == null) {
                            throw new AssertionError();
                        }
                        if (target == null) {
                            target = possibleTarget;
                            continue;
                        }
                        target = null;
                        break block0;
                    }
                    break block0;
                }
            }
            if (target == null) {
                target = "clean";
            }
            return target;
        }

        public File getScriptLocation() {
            String loc = null;
            Element scriptEl = Util.findElement(this.export, "script", "http://www.netbeans.org/ns/freeform-project/1");
            if (scriptEl != null) {
                String script = Util.findText(scriptEl);
                if (!$assertionsDisabled && script == null) {
                    throw new AssertionError();
                }
                loc = ArtifactProvider.this.project.evaluator().evaluate(script);
            }
            if (loc == null) {
                loc = "build.xml";
            }
            return ArtifactProvider.this.project.helper().resolveFile(loc);
        }

        public Project getProject() {
            return ArtifactProvider.this.project;
        }

        public String getID() {
            if (!$assertionsDisabled && this.id == null) {
                throw new AssertionError();
            }
            return this.id;
        }

        public URI[] getArtifactLocations() {
            return this.locations.toArray(new URI[this.locations.size()]);
        }

        private void addLocation(URI u) {
            this.locations.add(u);
        }

        public String toString() {
            return "FreeformArtifact[" + ArtifactProvider.this.project + ":" + this.id + "]";
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$ant$freeform$ArtifactProvider == null ? (class$org$netbeans$modules$ant$freeform$ArtifactProvider = ArtifactProvider.class$("org.netbeans.modules.ant.freeform.ArtifactProvider")) : class$org$netbeans$modules$ant$freeform$ArtifactProvider).desiredAssertionStatus();
        }
    }
}

