/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.net.URL;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.impl.AbstractResourceProcessor;

public class ClassResourceProcessor
extends AbstractResourceProcessor {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.shale.remoting.Bundle");
    private transient Log log = null;

    protected URL getResourceURL(FacesContext context, String resourceId) {
        String resourceIdLower = resourceId.toLowerCase();
        if (resourceIdLower.endsWith(".class")) {
            if (this.log().isWarnEnabled()) {
                this.log().warn((Object)this.bundle.getString("resource.refuse"));
                this.log().warn((Object)resourceId);
            }
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            URL url = cl.getResource(resourceId.substring(1));
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("getResource(" + resourceId + ") --> " + url));
            }
            return url;
        }
        catch (Exception e) {
            if (this.log().isErrorEnabled()) {
                this.log().error((Object)this.bundle.getString("resource.exception"), (Throwable)e);
                this.log().error((Object)resourceId);
            }
            return null;
        }
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)ClassResourceProcessor.class);
        }
        return this.log;
    }
}

