/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.StringTokenizer;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ErrWriter;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.HeapStorage;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.Storage;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class OutWriter
extends PrintWriter {
    private boolean trouble = false;
    private NbIO owner;
    private boolean disposed = false;
    private static final boolean USE_HEAP_STORAGE = Boolean.getBoolean("nb.output.heap") || Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2;
    static byte[] lineSepBytes = Utilities.isWindows() ? new byte[]{0, 13, 0, 10} : new byte[]{0, 10};
    private Storage storage;
    private AbstractLines lines = new LinesImpl();
    private boolean terminated = false;
    static boolean lowDiskSpace = false;
    private int lineStart = -1;
    private int lineLength = 0;
    private boolean closed = false;

    OutWriter(NbIO owner) {
        this();
        this.owner = owner;
    }

    OutWriter() {
        super(new DummyWriter());
    }

    Storage getStorage() {
        if (this.disposed) {
            throw new IllegalStateException("Output file has been disposed!");
        }
        if (this.storage == null) {
            this.storage = USE_HEAP_STORAGE || lowDiskSpace ? new HeapStorage() : new FileMapStorage();
        }
        return this.storage;
    }

    boolean hasStorage() {
        return this.storage != null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    boolean isEmpty() {
        return this.storage == null ? true : (this.lines == null ? true : this.lines.getLineCount() == 0);
    }

    public String toString() {
        return "OutWriter@" + System.identityHashCode(this) + " for " + this.owner + " closed ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doPrintln(String s) {
        try {
            int idx = s.indexOf("\n");
            int result = 1;
            if (idx != -1) {
                StringTokenizer tok = new StringTokenizer(s, "\n", true);
                result = 0;
                boolean lastWasNewLine = true;
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.equals("\n")) {
                        if (lastWasNewLine) {
                            this.doPrintln("");
                            ++result;
                        }
                        lastWasNewLine = true;
                        continue;
                    }
                    lastWasNewLine = false;
                    this.doPrintln(token);
                    ++result;
                }
            } else {
                OutWriter outWriter = this;
                synchronized (outWriter) {
                    if (s.startsWith("\t")) {
                        char[] c = s.toCharArray();
                        boolean ix = false;
                        StringBuffer sb = new StringBuffer(s.length() + 10);
                        for (int i = 0; i < c.length; ++i) {
                            if ('\t' == c[i]) {
                                sb.append("        ");
                                continue;
                            }
                            sb.append(c[i]);
                        }
                        s = sb.toString();
                    }
                    ByteBuffer buf = this.getStorage().getWriteBuffer(AbstractLines.toByteIndex(s.length()));
                    buf.asCharBuffer().put(s);
                    buf.position(buf.position() + AbstractLines.toByteIndex(s.length()));
                    this.write(buf, true);
                }
            }
            return result;
        }
        catch (IOException ioe) {
            this.handleException(ioe);
            return 0;
        }
    }

    private void handleException(Exception e) {
        this.setError();
        ErrorManager em = ErrorManager.getDefault();
        if (em.findAnnotations((Throwable)e) == null || em.findAnnotations((Throwable)e).length == 0) {
            em.annotate((Throwable)e, NbBundle.getMessage((Class)OutWriter.class, (String)"MSG_GenericError"));
        }
        if (Controller.log) {
            StackTraceElement[] el = e.getStackTrace();
            Controller.log("EXCEPTION: " + e.getClass() + e.getMessage());
            for (int i = 1; i < el.length; ++i) {
                Controller.log(el[i].toString());
            }
        }
        em.notify((Throwable)e);
    }

    public synchronized void write(ByteBuffer bb, boolean completeLine) throws IOException {
        if (this.checkError() || this.terminated) {
            return;
        }
        this.lines.markDirty();
        int length = bb.limit();
        this.closed = false;
        int start = -1;
        try {
            start = this.getStorage().write(bb, completeLine);
        }
        catch (ClosedByInterruptException cbie) {
            this.threadDeathClose();
        }
        catch (AsynchronousCloseException ace) {
            this.threadDeathClose();
        }
        catch (IOException ioe) {
            if (ioe.getMessage().indexOf("There is not enough space on the disk") != -1) {
                lowDiskSpace = true;
                String msg = NbBundle.getMessage((Class)OutWriter.class, (String)"MSG_DiskSpace", (Object)this.storage);
                ErrorManager.getDefault().annotate((Throwable)ioe, 256, ioe.getMessage(), msg, (Throwable)ioe, null);
                ErrorManager.getDefault().notify((Throwable)ioe);
                this.setError();
                this.storage.dispose();
            }
            ErrorManager.getDefault().notify((Throwable)ioe);
            this.threadDeathClose();
        }
        boolean startedNow = false;
        if (start >= 0 && this.lineStart == -1) {
            this.lineStart = start;
            this.lineLength += length;
            startedNow = true;
        }
        if (completeLine) {
            if (this.lineStart >= 0 && !this.terminated && this.lines != null) {
                if (Controller.verbose) {
                    Controller.log(this + ": Wrote " + ((ByteBuffer)bb.flip()).asCharBuffer() + " at " + start);
                }
                if (startedNow) {
                    this.lines.lineWritten(this.lineStart, this.lineLength);
                } else {
                    this.lines.lineFinished(this.lineLength);
                }
                this.lineStart = -1;
                this.lineLength = 0;
                if (this.owner != null && this.owner.hasStreamClosed()) {
                    this.owner.setStreamClosed(false);
                    this.lines.fire();
                }
            }
        } else if (startedNow && this.lineStart >= 0 && !this.terminated && this.lines != null) {
            this.lines.lineStarted(this.lineStart);
            if (this.owner != null && this.owner.hasStreamClosed()) {
                this.owner.setStreamClosed(false);
                this.lines.fire();
            }
        }
    }

    void threadDeathClose() {
        ErrWriter err;
        this.terminated = true;
        if (Controller.log) {
            Controller.log(this + " Close due to termination");
        }
        if ((err = this.owner.writer().err()) != null) {
            err.closed = true;
        }
        this.owner.setStreamClosed(true);
        this.close();
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        if (Controller.log) {
            Controller.log(this + ": OutWriter.dispose - owner is " + (this.owner == null ? "null" : this.owner.getName()));
        }
        this.clearListeners();
        if (this.storage != null) {
            this.storage.dispose();
            this.storage = null;
        }
        if (this.lines != null) {
            this.lines.clear();
        }
        this.trouble = true;
        if (Controller.log) {
            Controller.log(this + ": Setting owner to null, trouble to true, dirty to false.  This OutWriter is officially dead.");
        }
        this.owner = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        if (Controller.log) {
            Controller.log(this + ": Sending outputLineCleared to all listeners");
        }
        if (this.owner == null) {
            return;
        }
        OutWriter outWriter = this;
        synchronized (outWriter) {
            if (this.lines != null && this.lines.hasHyperlinks()) {
                int[] listenerLines = this.lines.allListenerLines();
                Controller.ControllerOutputEvent e = new Controller.ControllerOutputEvent(this.owner, 0);
                for (int i = 0; i < listenerLines.length; ++i) {
                    OutputListener ol = this.lines.getListenerForLine(listenerLines[i]);
                    if (Controller.log) {
                        Controller.log("Clearing listener " + ol);
                    }
                    e.setLine(listenerLines[i]);
                    if (ol != null) {
                        ol.outputLineCleared((OutputEvent)e);
                        continue;
                    }
                    ErrorManager.getDefault().log(1, "Warning: issue #56826 - There was a null OutputListener on line:" + listenerLines[i]);
                }
            } else if (Controller.log) {
                Controller.log(this + ": No listeners to clear");
            }
        }
    }

    public synchronized boolean isClosed() {
        if (this.checkError() || this.storage == null || this.storage.isClosed()) {
            return true;
        }
        return this.closed;
    }

    public Lines getLines() {
        return this.lines;
    }

    public synchronized void close() {
        this.closed = true;
        try {
            if (this.storage != null) {
                this.storage.close();
            }
            if (this.lines != null) {
                this.lines.fire();
            }
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public synchronized void println(String s) {
        if (this.checkError()) {
            return;
        }
        this.doPrintln(s);
    }

    public synchronized void flush() {
        if (this.checkError()) {
            return;
        }
        try {
            this.getStorage().flush();
            if (this.lines != null) {
                this.lines.fire();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public boolean checkError() {
        return this.disposed || this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    public synchronized void write(int c) {
        if (this.checkError()) {
            return;
        }
        try {
            ByteBuffer buf = this.getStorage().getWriteBuffer(AbstractLines.toByteIndex(1));
            buf.asCharBuffer().put((char)c);
            buf.position(buf.position() + AbstractLines.toByteIndex(1));
            this.write(buf, false);
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(char[] data, int off, int len) {
        int count;
        if (this.checkError()) {
            return;
        }
        if (len > 0 && data[off] == '\t') {
            StringBuffer sb = new StringBuffer(data.length + 10);
            int cnt = 0;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == '\t') {
                    sb.append("        ");
                    ++cnt;
                    continue;
                }
                sb.append(data[i]);
            }
            data = sb.toString().toCharArray();
            len += cnt * 4;
        }
        int start = off;
        for (count = off; count < len + off; ++count) {
            char curr = data[count];
            if (curr != '\n') continue;
            String sx = new String(data, start, count + 1 - start);
            this.println(sx);
            start = count + 1;
            if (start < len + off) continue;
            return;
        }
        try {
            OutWriter curr = this;
            synchronized (curr) {
                int lenght = count - start;
                ByteBuffer buf = this.getStorage().getWriteBuffer(AbstractLines.toByteIndex(lenght));
                buf.asCharBuffer().put(data, start, lenght);
                buf.position(buf.position() + AbstractLines.toByteIndex(lenght));
                this.write(buf, false);
            }
        }
        catch (IOException ioe) {
            this.handleException(ioe);
            return;
        }
    }

    public synchronized void write(char[] data) {
        this.write(data, 0, data.length);
    }

    public synchronized void println() {
        this.doPrintln("");
    }

    public synchronized void write(String s, int off, int len) {
        this.write(s.toCharArray(), off, len);
    }

    public synchronized void write(String s) {
        this.write(s.toCharArray());
    }

    public synchronized void println(String s, OutputListener l) throws IOException {
        this.println(s, l, false);
    }

    public synchronized void println(String s, OutputListener l, boolean important) throws IOException {
        if (this.checkError()) {
            return;
        }
        int addedCount = this.doPrintln(s);
        int newCount = this.lines.getLineCount();
        for (int i = newCount - addedCount; i < newCount; ++i) {
            this.lines.addListener(i, l, important);
            this.lines.fire();
        }
    }

    private class LinesImpl
    extends AbstractLines {
        LinesImpl() {
        }

        protected Storage getStorage() {
            return OutWriter.this.getStorage();
        }

        protected boolean isDisposed() {
            return OutWriter.this.disposed;
        }

        protected boolean isTrouble() {
            return OutWriter.this.trouble;
        }

        public Object readLock() {
            return OutWriter.this;
        }

        public boolean isGrowing() {
            return !OutWriter.this.isClosed();
        }

        protected void handleException(Exception e) {
            OutWriter.this.handleException(e);
        }
    }

    static class DummyWriter
    extends Writer {
        DummyWriter() {
            super(new Object());
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }
    }
}

