/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentFactory;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.nodes.JBItemNode;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Util {
    public static final String WAIT_NODE = "wait_node";
    public static final String INFO_NODE = "info_node";

    public static Object getRMIServer(Lookup lookup) {
        return Util.getRMIServer((JBDeploymentManager)lookup.lookup(JBDeploymentManager.class));
    }

    public static Object getRMIServer(JBDeploymentManager manager) {
        return manager.getRMIServer();
    }

    public static Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(JBItemNode.class, (String)"LBL_WaitNode_DisplayName"));
        n.setIconBaseWithExtension("org/openide/src/resources/wait.gif");
        return n;
    }

    public static Node createInfoNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(JBItemNode.class, (String)"LBL_InfoNode_DisplayName"));
        n.setShortDescription(NbBundle.getMessage(JBItemNode.class, (String)"LBL_InfoNode_ToolTip"));
        n.setIconBaseWithExtension("org/netbeans/core/resources/exception.gif");
        return n;
    }

    public static boolean isRemoteManagementSupported(Lookup lookup) {
        try {
            Object server = Util.getRMIServer(lookup);
            ObjectName searchPattern = new ObjectName("jboss.management.local:*");
            Set managedObj = (Set)server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(server, searchPattern, null);
            if (managedObj.size() == 0) {
                return false;
            }
        }
        catch (SecurityException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (MalformedObjectNameException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (NullPointerException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return true;
    }

    public static boolean isObjectDeployed(Object server, ObjectName searchPattern) {
        try {
            Set managedObj = (Set)server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(server, searchPattern, null);
            if (managedObj.size() > 0) {
                return true;
            }
        }
        catch (IllegalArgumentException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (SecurityException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return false;
    }

    public static String getModuleTypeString(ModuleType mt) {
        if (mt.equals(ModuleType.EAR)) {
            return "J2EEApplication";
        }
        if (mt.equals(ModuleType.WAR)) {
            return "WebModule";
        }
        if (mt.equals(ModuleType.EJB)) {
            return "EJBModule";
        }
        return "undefined";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMBeanParameter(JBDeploymentManager dm, String name, String targetObject, Class paramClass) {
        ClassLoader oldLoader = null;
        InstanceProperties ip = dm.getInstanceProperties();
        try {
            oldLoader = Thread.currentThread().getContextClassLoader();
            String serverRoot = ip.getProperty("root-dir");
            URLClassLoader loader = JBDeploymentFactory.getJBClassLoader(serverRoot);
            Thread.currentThread().setContextClassLoader(loader);
            Object srv = dm.refreshRMIServer();
            Class<?> objectName = loader.loadClass("javax.management.ObjectName");
            Method getInstance = objectName.getMethod("getInstance", String.class);
            Object target = getInstance.invoke(null, targetObject);
            Class[] params = new Class[]{loader.loadClass("javax.management.ObjectName"), paramClass};
            Method getAttribute = srv.getClass().getMethod("getAttribute", params);
            Object object = getAttribute.invoke(srv, target, name);
            return object;
        }
        catch (NullPointerException ex) {
            Object var7_13 = null;
            return var7_13;
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Object var7_14 = null;
            return var7_14;
        }
        finally {
            if (oldLoader != null) {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return null;
    }

    public static String getWebContextRoot(String dd) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(dd.getBytes()));
        }
        catch (SAXException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        catch (ParserConfigurationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        org.w3c.dom.Node node = doc.getElementsByTagName("context-root").item(0);
        return node.getTextContent();
    }
}

