/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public class JBPluginProperties {
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_DEPLOY_DIR = "deploy-dir";
    public static final String PROPERTY_SERVER_DIR = "server-dir";
    public static final String PROPERTY_ROOT_DIR = "root-dir";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_PORT = "port";
    private static JBPluginProperties pluginProperties = null;
    private String installLocation;
    private static final String INSTALL_ROOT_KEY = "installRoot";
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private FileObject propertiesFile = null;

    public static JBPluginProperties getInstance() {
        if (pluginProperties == null) {
            pluginProperties = new JBPluginProperties();
        }
        return pluginProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JBPluginProperties() {
        InputStream inStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inStream = this.propertiesFile.getInputStream();
                }
                this.loadPluginProperties(inStream);
                if (null == inStream) return;
            }
            catch (FileNotFoundException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return;
            }
            catch (IOException e2) {
                ErrorManager.getDefault().notify(1, (Throwable)e2);
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.loadPluginProperties(inStream);
                if (null != inStream) {
                    inStream.close();
                }
            }
            inStream.close();
            return;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    void loadPluginProperties(InputStream inStream) {
        String loc;
        Properties inProps = new Properties();
        if (null != inStream) {
            try {
                inProps.load(inStream);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if ((loc = inProps.getProperty(INSTALL_ROOT_KEY)) != null) {
            this.setInstallLocation(loc);
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject dir = fs.findResource("J2EE");
        FileObject retVal = null;
        if (null != dir && null == (retVal = dir.getFileObject("jb", "properties"))) {
            retVal = dir.createData("jb", "properties");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        block11: {
            Properties outProp = new Properties();
            String installRoot = this.getInstallLocation();
            if (installRoot != null) {
                outProp.setProperty(INSTALL_ROOT_KEY, installRoot);
            }
            FileLock l = null;
            OutputStream outStream = null;
            try {
                if (null == this.propertiesFile) break block11;
                try {
                    l = this.propertiesFile.lock();
                    outStream = this.propertiesFile.getOutputStream(l);
                    if (null != outStream) {
                        outProp.store(outStream, "");
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                finally {
                    if (null != outStream) {
                        outStream.close();
                    }
                    if (null != l) {
                        l.releaseLock();
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public boolean isCurrentServerLocationValid() {
        if (this.getInstallLocation() != null) {
            return JBPluginUtils.isGoodJBServerLocation(new File(this.getInstallLocation()));
        }
        return false;
    }

    public void setInstallLocation(String installLocation) {
        if (installLocation.endsWith("/") || installLocation.endsWith("\\")) {
            installLocation = installLocation.substring(0, installLocation.length() - 1);
        }
        this.installLocation = installLocation;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }
}

