/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformImpl;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class JBJ2eePlatformFactory
extends J2eePlatformFactory {
    private static final WeakHashMap<InstanceProperties, J2eePlatformImplImpl> instanceCache = new WeakHashMap();

    public synchronized J2eePlatformImpl getJ2eePlatformImpl(DeploymentManager dm) {
        assert (JBDeploymentManager.class.isAssignableFrom(dm.getClass())) : (Object)((Object)this) + " cannot create platform for unknown deployment manager:" + dm;
        JBDeploymentManager manager = (JBDeploymentManager)dm;
        InstanceProperties ip = manager.getInstanceProperties();
        if (ip == null) {
            throw new RuntimeException("Cannot create J2eePlatformImpl instance for " + manager.getUrl());
        }
        J2eePlatformImplImpl platform = instanceCache.get(ip);
        if (platform == null) {
            platform = new J2eePlatformImplImpl(manager.getProperties());
            instanceCache.put(ip, platform);
        }
        return platform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class J2eePlatformImplImpl
    extends J2eePlatformImpl {
        private static final String J2EE_API_DOC = "docs/javaee5-doc-api.zip";
        private static final Set MODULE_TYPES = new HashSet();
        private static final Set SPEC_VERSIONS;
        private static final Set SPEC_VERSIONS_5;
        private LibraryImplementation[] libraries;
        private final JBProperties properties;

        public J2eePlatformImplImpl(JBProperties properties) {
            this.properties = properties;
        }

        public Set getSupportedSpecVersions() {
            if (this.properties.isJavaEE5()) {
                return SPEC_VERSIONS_5;
            }
            return SPEC_VERSIONS;
        }

        public Set<String> getSupportedSpecVersions(Object moduleType) {
            if (this.properties.isJavaEE5() && !J2eeModule.WAR.equals(moduleType) && !J2eeModule.CLIENT.equals(moduleType)) {
                return SPEC_VERSIONS_5;
            }
            return SPEC_VERSIONS;
        }

        public Set getSupportedModuleTypes() {
            return MODULE_TYPES;
        }

        public Set getSupportedJavaPlatformVersions() {
            HashSet<String> versions = new HashSet<String>();
            versions.add("1.4");
            versions.add("1.5");
            return versions;
        }

        public JavaPlatform getJavaPlatform() {
            return null;
        }

        public File[] getPlatformRoots() {
            return new File[]{this.properties.getRootDir()};
        }

        public LibraryImplementation[] getLibraries() {
            if (this.libraries == null) {
                this.initLibraries();
            }
            return this.libraries;
        }

        public void notifyLibrariesChanged() {
            this.initLibraries();
            this.firePropertyChange("libraries", null, this.libraries.clone());
        }

        public Image getIcon() {
            return null;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JBJ2eePlatformFactory.class, (String)"TITLE_JBOSS_FACTORY");
        }

        public boolean isToolSupported(String toolName) {
            if ("wscompile".equals(toolName) || "appClientRuntime".equals(toolName)) {
                return true;
            }
            if ("org.hibernate.ejb.HibernatePersistence".equals(toolName) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(toolName) || "kodo.persistence.PersistenceProviderImpl".equals(toolName)) {
                return this.containsPersistenceProvider(toolName);
            }
            return "hibernatePersistenceProviderIsDefault".equals(toolName);
        }

        private boolean containsPersistenceProvider(String providerName) {
            return J2eePlatformImplImpl.containsService(this.libraries, "javax.persistence.spi.PersistenceProvider", providerName);
        }

        private static boolean containsService(LibraryImplementation[] libraries, String serviceName, String serviceImplName) {
            for (LibraryImplementation libImpl : libraries) {
                if (!J2eePlatformImplImpl.containsService(libImpl, serviceName, serviceImplName)) continue;
                return true;
            }
            return false;
        }

        private static boolean containsService(LibraryImplementation library, String serviceName, String serviceImplName) {
            List roots = library.getContent("classpath");
            for (URL rootUrl : roots) {
                String serviceRelativePath;
                FileObject archiveRoot;
                FileObject serviceFO;
                FileObject root = URLMapper.findFileObject((URL)rootUrl);
                if (root == null || !"jar".equals(rootUrl.getProtocol()) || (serviceFO = (archiveRoot = FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)root))).getFileObject(serviceRelativePath = "META-INF/services/" + serviceName)) == null || !J2eePlatformImplImpl.containsService(serviceFO, serviceName, serviceImplName)) continue;
                return true;
            }
            return false;
        }

        private static boolean containsService(FileObject serviceFO, String serviceName, String serviceImplName) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(serviceFO.getInputStream()));
                while ((line = br.readLine()) != null) {
                    int ci = line.indexOf(35);
                    if (ci >= 0) {
                        line = line.substring(0, ci);
                    }
                    if (!line.trim().equals(serviceImplName)) continue;
                    return true;
                }
            }
            catch (Exception ex) {
                try {
                    ErrorManager.getDefault().annotate((Throwable)ex, serviceFO.getURL().toString());
                }
                catch (FileStateInvalidException fsie) {
                    // empty catch block
                }
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            return false;
        }

        public File[] getToolClasspathEntries(String toolName) {
            if ("wscompile".equals(toolName)) {
                File root = InstalledFileLocator.getDefault().locate("modules/ext/jaxrpc16", null, false);
                return new File[]{new File(root, "saaj-api.jar"), new File(root, "saaj-impl.jar"), new File(root, "jaxrpc-api.jar"), new File(root, "jaxrpc-impl.jar")};
            }
            if ("appClientRuntime".equals(toolName)) {
                return new File(this.properties.getRootDir(), "client").listFiles(new FF());
            }
            return null;
        }

        private URL fileToUrl(File file) throws MalformedURLException {
            URL url = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            }
            return url;
        }

        public String getToolProperty(String toolName, String propertyName) {
            if ("appClientRuntime".equals(toolName)) {
                if ("main.class".equals(propertyName)) {
                    return "";
                }
                if ("main.class.args".equals(propertyName)) {
                    return "";
                }
                if ("j2ee.clientName".equals(propertyName)) {
                    return "${jar.name}";
                }
                if ("jvm.opts".equals(propertyName)) {
                    return "-Djava.naming.factory.initial=org.jnp.interfaces.NamingContextFactory -Djava.naming.provider.url=jnp://localhost:1099 -Djava.naming.factory.url.pkgs=org.jboss.naming.client";
                }
            }
            return null;
        }

        private void initLibraries() {
            LibraryImplementation lib = new J2eeLibraryTypeProvider().createLibrary();
            lib.setName(NbBundle.getMessage(JBJ2eePlatformFactory.class, (String)"TITLE_JBOSS_LIBRARY"));
            lib.setContent("classpath", this.properties.getClasses());
            lib.setContent("javadoc", this.properties.getJavadocs());
            lib.setContent("src", this.properties.getSources());
            this.libraries = new LibraryImplementation[]{lib};
        }

        static {
            MODULE_TYPES.add(J2eeModule.EAR);
            MODULE_TYPES.add(J2eeModule.WAR);
            MODULE_TYPES.add(J2eeModule.EJB);
            MODULE_TYPES.add(J2eeModule.CONN);
            MODULE_TYPES.add(J2eeModule.CLIENT);
            SPEC_VERSIONS = new HashSet();
            SPEC_VERSIONS_5 = new HashSet();
            SPEC_VERSIONS.add("1.4");
            SPEC_VERSIONS_5.add("1.4");
            SPEC_VERSIONS_5.add("1.5");
        }

        private static class FF
        implements FilenameFilter {
            private FF() {
            }

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || new File(dir, name).isDirectory();
            }
        }
    }
}

