/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.j2ee.jboss4.config.EjbDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.gen.EnterpriseBeans;
import org.netbeans.modules.j2ee.jboss4.config.gen.Entity;
import org.netbeans.modules.j2ee.jboss4.config.gen.Jboss;
import org.netbeans.modules.j2ee.jboss4.config.gen.MessageDestinationRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.MessageDriven;
import org.netbeans.modules.j2ee.jboss4.config.gen.Session;

final class JbossMsgDestRefModifier {
    JbossMsgDestRefModifier() {
    }

    static void modify(Jboss modifiedJboss, String msgDestRefName, Set beanNames, EjbDeploymentConfiguration.BEAN_TYPE beanType, String destPrefix) {
        assert (beanNames.size() > 0);
        if (modifiedJboss.getEnterpriseBeans() == null) {
            modifiedJboss.setEnterpriseBeans(new EnterpriseBeans());
        }
        if (beanType == EjbDeploymentConfiguration.BEAN_TYPE.SESSION) {
            JbossMsgDestRefModifier.addSessionMsgDestReference(modifiedJboss, msgDestRefName, beanNames, destPrefix);
        } else if (beanType == EjbDeploymentConfiguration.BEAN_TYPE.ENTITY) {
            JbossMsgDestRefModifier.addEntityMsgDestReference(modifiedJboss, msgDestRefName, beanNames, destPrefix);
        }
    }

    private static void addSessionMsgDestReference(Jboss modifiedJboss, String msgDestRefName, Set sessionNames, String destPrefix) {
        LinkedList<Session> sesssionsWithoutReference = new LinkedList<Session>();
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        Session[] sessions = eb.getSession();
        for (int i = 0; i < sessions.length; ++i) {
            String mdrn;
            int j;
            String ejbName = sessions[i].getEjbName();
            if (!sessionNames.contains(ejbName)) continue;
            sessionNames.remove(ejbName);
            MessageDestinationRef[] msgDestRefs = sessions[i].getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length && !msgDestRefName.equals(mdrn = msgDestRefs[j].getMessageDestinationRefName()); ++j) {
            }
            if (j != msgDestRefs.length) continue;
            sesssionsWithoutReference.add(sessions[i]);
        }
        for (String sessionName : sessionNames) {
            Session session = new Session();
            session.setEjbName(sessionName);
            session.setJndiName(sessionName);
            eb.addSession(session);
            sesssionsWithoutReference.add(session);
        }
        Iterator it = sesssionsWithoutReference.iterator();
        while (it.hasNext()) {
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JbossMsgDestRefModifier.getJndiName(msgDestRefName, destPrefix);
            mdr.setJndiName(jndiName);
            Session session = (Session)((Object)it.next());
            session.addMessageDestinationRef(mdr);
        }
    }

    private static void addEntityMsgDestReference(Jboss modifiedJboss, String msgDestRefName, Set entityNames, String destPrefix) {
        LinkedList<Entity> entitiesWithoutReference = new LinkedList<Entity>();
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        Entity[] entities = eb.getEntity();
        for (int i = 0; i < entities.length; ++i) {
            String mdrn;
            int j;
            String ejbName = entities[i].getEjbName();
            if (!entityNames.contains(ejbName)) continue;
            entityNames.remove(ejbName);
            MessageDestinationRef[] msgDestRefs = entities[i].getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length && !msgDestRefName.equals(mdrn = msgDestRefs[j].getMessageDestinationRefName()); ++j) {
            }
            if (j != msgDestRefs.length) continue;
            entitiesWithoutReference.add(entities[i]);
        }
        for (String entityName : entityNames) {
            Entity entity = new Entity();
            entity.setEjbName(entityName);
            entity.setJndiName(entityName);
            eb.addEntity(entity);
            entitiesWithoutReference.add(entity);
        }
        Iterator it = entitiesWithoutReference.iterator();
        while (it.hasNext()) {
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JbossMsgDestRefModifier.getJndiName(msgDestRefName, destPrefix);
            mdr.setJndiName(jndiName);
            Entity entity = (Entity)((Object)it.next());
            entity.addMessageDestinationRef(mdr);
        }
    }

    static void modifyMsgDrv(Jboss modifiedJboss, String msgDestRefName, Map beans, String destPrefix) {
        assert (beans.size() > 0);
        if (modifiedJboss.getEnterpriseBeans() == null) {
            modifiedJboss.setEnterpriseBeans(new EnterpriseBeans());
        }
        JbossMsgDestRefModifier.addMsgDrvMsgDestReference(modifiedJboss, msgDestRefName, beans, destPrefix);
    }

    private static void addMsgDrvMsgDestReference(Jboss modifiedJboss, String msgDestRefName, Map beans, String destPrefix) {
        LinkedList<MessageDriven> msgdrvsWithoutReference = new LinkedList<MessageDriven>();
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        MessageDriven[] msgDrivens = eb.getMessageDriven();
        for (int i = 0; i < msgDrivens.length; ++i) {
            String mdrn;
            int j;
            String ejbName = msgDrivens[i].getEjbName();
            if (!beans.containsKey(ejbName)) continue;
            beans.remove(ejbName);
            MessageDestinationRef[] msgDestRefs = msgDrivens[i].getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length && !msgDestRefName.equals(mdrn = msgDestRefs[j].getMessageDestinationRefName()); ++j) {
            }
            if (j != msgDestRefs.length) continue;
            msgdrvsWithoutReference.add(msgDrivens[i]);
        }
        for (String ejbName : beans.keySet()) {
            MessageDriven mdb = new MessageDriven();
            mdb.setEjbName(ejbName);
            String msgDestination = (String)beans.get(ejbName);
            mdb.setDestinationJndiName(msgDestination);
            eb.addMessageDriven(mdb);
            msgdrvsWithoutReference.add(mdb);
        }
        Iterator<Object> it = msgdrvsWithoutReference.iterator();
        while (it.hasNext()) {
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JbossMsgDestRefModifier.getJndiName(msgDestRefName, destPrefix);
            mdr.setJndiName(jndiName);
            MessageDriven mdb = (MessageDriven)((Object)it.next());
            mdb.addMessageDestinationRef(mdr);
        }
    }

    private static String getJndiName(String msgDestRefName, String destPrefix) {
        String jndiName = msgDestRefName;
        if (msgDestRefName.startsWith("jms/")) {
            jndiName = destPrefix + msgDestRefName.substring("jms/".length());
        }
        return jndiName;
    }
}

