/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.util;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.debug.util.JspNameUtil;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

public class Utils {
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.web.debug");

    public static ErrorManager getEM() {
        return err;
    }

    public static FileObject getFileObjectFromUrl(String url) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fo;
    }

    public static boolean isJsp(FileObject fo) {
        return fo != null && "text/x-jsp".equals(fo.getMIMEType());
    }

    public static boolean isJsp(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        return Utils.isJsp(fo);
    }

    public static boolean isTag(FileObject fo) {
        return fo != null && "text/x-tag".equals(fo.getMIMEType());
    }

    public static boolean isTag(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        return Utils.isTag(fo);
    }

    public static String getTargetServerID(FileObject fo) {
        J2eeModuleProvider mp;
        Project p;
        if (fo != null && (p = FileOwnerQuery.getOwner((FileObject)fo)) != null && (mp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            String serverID = mp.getServerID();
            return serverID;
        }
        return null;
    }

    public static String getJspName(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        if (fo != null) {
            return fo.getNameExt();
        }
        return url == null ? null : url.toString();
    }

    public static String getJspPath(String url) {
        WebModule wm;
        FileObject fo = Utils.getFileObjectFromUrl(url);
        String jspRelativePath = url;
        if (fo != null && (wm = WebModule.getWebModule((FileObject)fo)) != null) {
            jspRelativePath = FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)fo);
        }
        return jspRelativePath;
    }

    public static String getServletClass(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        if (fo == null) {
            return null;
        }
        JSPServletFinder finder = JSPServletFinder.findJSPServletFinder((FileObject)fo);
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm == null) {
            return null;
        }
        String jspRelativePath = FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)fo);
        String contextPath = wm.getContextPath();
        String servletPath = finder.getServletResourcePath(jspRelativePath);
        if (servletPath == null) {
            servletPath = JspNameUtil.getServletResourcePath(contextPath, jspRelativePath);
        }
        if (servletPath != null) {
            servletPath = servletPath.substring(0, servletPath.length() - 5);
            servletPath = servletPath.replace('/', '.');
        }
        Utils.getEM().log("servlet class: " + servletPath);
        return servletPath;
    }

    public static String getClassFilter(String url) {
        String filter = Utils.getServletClass(url);
        if (filter != null && (filter = filter.substring(0, filter.lastIndexOf(46)) + ".*").startsWith("org.apache.jsp")) {
            filter = "org.apache.jsp.*";
        }
        return filter;
    }

    public static String getContextPath(String url) {
        FileObject wmfo = Utils.getFileObjectFromUrl(url);
        if (wmfo == null) {
            return null;
        }
        WebModule wm = WebModule.getWebModule((FileObject)wmfo);
        if (wm != null) {
            return wm.getContextPath();
        }
        return null;
    }

    public static EditorCookie getCurrentEditorCookie() {
        Node[] nodes = TopComponent.getRegistry().getCurrentNodes();
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        Node n = nodes[0];
        return (EditorCookie)n.getCookie(EditorCookie.class);
    }

    public static JEditorPane getCurrentEditor() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        return Utils.getCurrentEditor(e);
    }

    public static JEditorPane getCurrentEditor(EditorCookie e) {
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    public static String getJavaIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static boolean isScriptlet(StyledDocument doc, JEditorPane ep, int offset) {
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            while (line > 0) {
                int lineLen;
                Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
                if (lineElem == null) continue;
                int lineStartOffset = lineElem.getStartOffset();
                String t = doc.getText(lineStartOffset, lineLen = lineElem.getEndOffset() - lineStartOffset);
                if (t != null && t.length() > 1) {
                    for (int identStart = line == NbDocument.findLineNumber((StyledDocument)doc, (int)offset) ? col : lineLen - 1; identStart > 0; --identStart) {
                        if (t.charAt(identStart) == '%' && t.charAt(identStart - 1) == '<') {
                            return true;
                        }
                        if (t.charAt(identStart) != '>' || t.charAt(identStart - 1) != '%') continue;
                        return false;
                    }
                }
                --line;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return false;
    }

    public static String getELIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            if (t.startsWith("$") && t.endsWith("}")) {
                return t;
            }
            return null;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && t.charAt(identStart) != '$'; --identStart) {
            }
            if (identStart > 0 && t.charAt(identStart) == '$' && t.charAt(identStart - 1) == '\\') {
                return null;
            }
            for (identEnd = col; identEnd < lineLen && identEnd > 0 && identEnd <= t.length() && t.charAt(identEnd - 1) != '}'; ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            String outp = t.substring(identStart, identEnd);
            if (outp.startsWith("$") && outp.endsWith("}")) {
                return outp;
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static String getJavaIdentifier() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane ep = Utils.getCurrentEditor(e);
        if (ep == null) {
            return null;
        }
        return Utils.getJavaIdentifier(e.getDocument(), ep, ep.getCaret().getDot());
    }

    public static boolean isScriptlet() {
        EditorCookie e = Utils.getCurrentEditorCookie();
        if (e == null) {
            return false;
        }
        JEditorPane ep = Utils.getCurrentEditor(e);
        if (ep == null) {
            return false;
        }
        return Utils.isScriptlet(e.getDocument(), ep, ep.getCaret().getDot());
    }
}

