/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaFastImport;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.openide.util.NbBundle;

public class NbJavaJMIFastImport
extends JavaFastImport {
    private static final int OK = 0;
    private static final int AMBIGUOUS = 1;
    private static final int CLASHING = 2;
    private JMIUtils jmiUtils;
    private NbJavaJMISyntaxSupport support;

    public NbJavaJMIFastImport(JTextComponent target) {
        super(target);
        this.jmiUtils = JMIUtils.get(Utilities.getDocument((JTextComponent)target));
        this.support = (NbJavaJMISyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)target).get(NbJavaJMISyntaxSupport.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List findClasses(String exp, int importType) {
        ArrayList<NbJMIResultItem> ret = new ArrayList<NbJMIResultItem>();
        this.jmiUtils.beginTrans(false);
        try {
            List classes = this.jmiUtils.findClasses(null, exp, true, true, true, this.support.getTopJavaClass(), false, false);
            if (importType == 1) {
                JavaPackage pkg;
                TreeSet<JavaPackage> ts = new TreeSet<JavaPackage>(JMIUtils.getNaturalMemberNameComparator());
                for (int i = 0; i < classes.size(); ++i) {
                    pkg = (JavaPackage)((JavaClass)classes.get(i)).getResource().refImmediateComposite();
                    if (pkg == null) continue;
                    ts.add(pkg);
                }
                Iterator it = ts.iterator();
                while (it.hasNext()) {
                    pkg = (JavaPackage)it.next();
                    ret.add(new NbJMIResultItem.PackageResultItem(pkg, true));
                }
            } else {
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    ret.add(new NbJMIResultItem.ClassResultItem((JavaClass)it.next(), true, false, false));
                }
            }
        }
        finally {
            this.jmiUtils.endTrans(false);
        }
        return ret;
    }

    protected void setFastImportSettings(int importType) {
        BaseOptions bop;
        Class kitClass = Utilities.getKitClass((JTextComponent)this.target);
        if (kitClass != null && (bop = BaseOptions.getOptions((Class)kitClass)) instanceof JavaOptions) {
            ((JavaOptions)bop).setFastImportSelection(importType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImport(Object item) {
        if (item instanceof NbJMIResultItem.PackageResultItem || item instanceof NbJMIResultItem.ClassResultItem) {
            String fqn = null;
            this.jmiUtils.beginTrans(true);
            try {
                Resource resource = this.support.getResource();
                if (resource != null) {
                    if (item instanceof NbJMIResultItem.ClassResultItem) {
                        int status;
                        JavaClass cls = (JavaClass)((NbJMIResultItem.ClassResultItem)item).getAssociatedObject();
                        if (this.isClassAlreadyImported(cls, resource, status = this.checkImport(cls, resource))) {
                            Utilities.setStatusText((JTextComponent)this.target, (String)MessageFormat.format(NbBundle.getMessage((Class)NbJavaJMIFastImport.class, (String)"NJFI_CLASS_ALREADY_IMPORTED"), cls.getName()));
                        } else {
                            this.addImport((NamedElement)cls, resource);
                        }
                    } else if (item instanceof NbJMIResultItem.PackageResultItem) {
                        JavaPackage pkg = (JavaPackage)((NbJMIResultItem.PackageResultItem)item).getAssociatedObject();
                        if (this.isPackageAlreadyImported(pkg, resource)) {
                            Utilities.setStatusText((JTextComponent)this.target, (String)MessageFormat.format(NbBundle.getMessage((Class)NbJavaJMIFastImport.class, (String)"NJFI_PACKAGE_ALREADY_IMPORTED"), pkg.getName()));
                        } else {
                            this.addImport((NamedElement)pkg, resource);
                        }
                    }
                }
            }
            finally {
                this.jmiUtils.endTrans(false);
            }
            if (fqn != null) {
                this.pasteFQN(fqn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAutoImport(Object item) {
        if (item instanceof NbJMIResultItem.ClassResultItem) {
            this.jmiUtils.beginTrans(true);
            try {
                Resource resource = this.support.getResource();
                if (resource != null) {
                    JavaClass cls = (JavaClass)((NbJMIResultItem.ClassResultItem)item).getAssociatedObject();
                    if (!cls.isValid()) {
                        boolean bl = false;
                        return bl;
                    }
                    int status = this.checkImport(cls, resource);
                    if (status == 2) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = !this.isClassAlreadyImported(cls, resource, status);
                    return bl;
                }
            }
            finally {
                this.jmiUtils.endTrans(false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean autoImport(JavaClass cls, boolean pasteFQN) {
        this.jmiUtils.beginTrans(true);
        boolean fail = true;
        try {
            if (!cls.isValid()) {
                boolean bl = true;
                return bl;
            }
            Resource resource = this.support.getResource();
            if (resource != null) {
                int status = this.checkImport(cls, resource);
                if (status == 2) {
                    if (pasteFQN) {
                        this.pasteFQN(cls.getName());
                    }
                    fail = false;
                    boolean bl = false;
                    return bl;
                }
                if (!this.isClassAlreadyImported(cls, resource, status)) {
                    this.addImport((NamedElement)cls, resource);
                }
            }
            fail = false;
            boolean bl = true;
            return bl;
        }
        finally {
            this.jmiUtils.endTrans(fail);
        }
    }

    protected String getItemFQN(Object item) {
        if (item instanceof NbJMIResultItem.ClassResultItem) {
            JavaClass cls = (JavaClass)((NbJMIResultItem.ClassResultItem)item).getAssociatedObject();
            return cls.getName();
        }
        return super.getItemFQN(item);
    }

    protected boolean isInnerClass(Object item) {
        if (item instanceof NbJMIResultItem.ClassResultItem) {
            JavaClass cls = (JavaClass)((NbJMIResultItem.ClassResultItem)item).getAssociatedObject();
            return cls.isInner();
        }
        return super.isInnerClass(item);
    }

    private boolean isClassAlreadyImported(JavaClass cls, Resource resource, int status) {
        Import imp;
        Iterator it;
        String pkgName = this.jmiUtils.getPackageName((ClassDefinition)cls);
        if (!cls.isInner()) {
            if (("java.lang".equals(pkgName) || resource.getPackageName().equals(pkgName)) && status == 0) {
                return true;
            }
            it = resource.getImports().iterator();
            while (it.hasNext()) {
                imp = (Import)it.next();
                if (!imp.isOnDemand() || !imp.getImportedElements().contains(cls) || status != 0) continue;
                return true;
            }
        } else if (status == 0 && resource == cls.getResource()) {
            return true;
        }
        it = resource.getImports().iterator();
        while (it.hasNext()) {
            imp = (Import)it.next();
            if (imp.isOnDemand() || !cls.equals(imp.getImportedNamespace())) continue;
            return true;
        }
        return false;
    }

    private int checkImport(JavaClass cls, Resource resource) {
        int status = 0;
        String simpleName = cls.getSimpleName();
        Iterator it = resource.getImports().iterator();
        block0: while (it.hasNext()) {
            Import imp = (Import)it.next();
            if (imp.isOnDemand()) {
                if (status != 0) continue;
                Iterator itt = imp.getImportedElements().iterator();
                while (itt.hasNext()) {
                    NamedElement el = (NamedElement)itt.next();
                    if (!(el instanceof JavaClass) || !simpleName.equals(((JavaClass)el).getSimpleName()) || el.equals(cls)) continue;
                    status = 1;
                    continue block0;
                }
                continue;
            }
            NamedElement el = imp.getImportedNamespace();
            if (!(el instanceof JavaClass) || !simpleName.equals(((JavaClass)el).getSimpleName()) || el.equals(cls)) continue;
            return 2;
        }
        return status;
    }

    private boolean isPackageAlreadyImported(JavaPackage pkg, Resource resource) {
        String pkgName = pkg.getName();
        if ("java.lang".equals(pkgName) || resource.getPackageName().equals(pkgName)) {
            return true;
        }
        Iterator it = resource.getImports().iterator();
        while (it.hasNext()) {
            Import imp = (Import)it.next();
            if (!imp.getImportedNamespace().equals(pkg)) continue;
            return true;
        }
        return false;
    }

    private void addImport(NamedElement element, Resource resource) {
        String name = element.getName();
        ListIterator<Import> it = resource.getImports().listIterator();
        while (it.hasNext()) {
            Import imp = (Import)it.next();
            String impName = imp.getName();
            if (impName == null || name.compareTo(impName) >= 0) continue;
            it.previous();
            break;
        }
        ImportClass proxy = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        it.add(proxy.createImport(name, null, false, element instanceof JavaPackage));
    }
}

