/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class NbJMIPaintComponent
extends JPanel {
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif";
    static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
    static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
    static final String ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
    static final String ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
    static final String LOCAL_VARIABLE = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
    static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
    static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
    static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
    static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
    static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
    static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
    static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
    static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
    static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
    static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
    static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
    static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
    static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
    static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
    static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
    static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
    static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
    static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
    static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
    static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
    private static final int ICON_WIDTH = 16;
    private static final int ICON_TEXT_GAP = 5;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    public static final Color KEYWORD_COLOR = Color.darkGray;
    public static final Color TYPE_COLOR = Color.black;
    static final Color ENCLOSING_CALL_COLOR = Color.gray;
    static final Color ACTIVE_PARAMETER_COLOR = Color.black;

    public NbJMIPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    protected void draw(Graphics g) {
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        this.drawX += 21;
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics g, String s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, String s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, String s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, String s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics g, String s, Color c) {
        if (g == null) {
            this.drawString(g, "   ");
            this.drawString(g, s, c);
        } else {
            int spaceWidth;
            int w = this.getWidth() - this.getWidth(s) - this.drawX;
            if (w > (spaceWidth = this.getWidth(" ")) * 2) {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s);
            } else {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s) - this.getWidth("...   ");
                g.setColor(this.getBackground());
                g.fillRect(this.drawX, 0, this.getWidth() - this.drawX, this.getHeight());
                this.drawString(g, "...   ", c);
            }
            this.drawString(g, s, c);
        }
    }

    protected void drawStringToGraphics(Graphics g, String s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font, boolean strike) {
        if (g != null) {
            if (!strike) {
                g.drawString(s, this.drawX, this.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(s);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s) {
        Integer i = (Integer)this.widths.get(s);
        if (i != null) {
            return i;
        }
        if (s == null) {
            s = "";
        }
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public static class NbStringPaintComponent
    extends NbJMIPaintComponent {
        private String str;

        public void setString(String str) {
            this.str = str;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, null);
            this.drawString(g, this.str, TYPE_COLOR);
        }
    }

    public static class NbAttributePaintComponent
    extends NbJMIPaintComponent {
        private String typeName;
        private Color typeColor;
        private String attrName;
        private String defaultValueText;
        private Color ATTR_COLOR = Color.darkGray;

        public void setAttrName(String attrName) {
            this.attrName = attrName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setDefaultValueText(String defaultValueText) {
            this.defaultValueText = defaultValueText;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, null);
            this.drawString(g, this.typeName, this.typeColor);
            this.drawString(g, " ");
            if (this.defaultValueText == null) {
                this.drawString(g, this.attrName, this.ATTR_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            } else {
                this.drawString(g, this.attrName, this.ATTR_COLOR);
                this.drawString(g, " = ");
                this.drawString(g, this.defaultValueText);
            }
        }
    }

    public static class NbConstructorPaintComponent
    extends NbCallableFeaturePaintComponent {
        private Color CONSTRUCTOR_COLOR = Color.orange.darker();
        private Icon[] icon = new Icon[4];

        protected Icon getIcon() {
            String iconPath = NbJMIPaintComponent.CONSTRUCTOR_PUBLIC;
            int level = JavaCompletion.getLevel((int)this.getCFModifiers());
            Icon cachedIcon = this.icon[level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            switch (level) {
                case 0: {
                    iconPath = NbJMIPaintComponent.CONSTRUCTOR_PRIVATE;
                    break;
                }
                case 1: {
                    iconPath = NbJMIPaintComponent.CONSTRUCTOR_PACKAGE;
                    break;
                }
                case 2: {
                    iconPath = NbJMIPaintComponent.CONSTRUCTOR_PROTECTED;
                    break;
                }
                case 3: {
                    iconPath = NbJMIPaintComponent.CONSTRUCTOR_PUBLIC;
                }
            }
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage((String)iconPath));
            this.icon[level] = newIcon;
            return newIcon;
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            Icon icon = this.isEnclosingCall() ? null : this.getIcon();
            this.drawIcon(g, icon);
            Color ctrColor = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.CONSTRUCTOR_COLOR;
            this.drawString(g, this.getCFName(), ctrColor, null, strike);
            this.drawParameterList(g, this.getParamList());
        }
    }

    public static class NbMethodPaintComponent
    extends NbCallableFeaturePaintComponent {
        private Color METHOD_COLOR = Color.red.darker().darker();
        private Icon[][] icon = new Icon[2][4];

        protected Icon getIcon() {
            int level = JavaCompletion.getLevel((int)this.getCFModifiers());
            boolean isStatic = (this.getCFModifiers() & 8) != 0;
            Icon cachedIcon = this.icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = NbJMIPaintComponent.METHOD_PUBLIC;
            if ((this.getCFModifiers() & 8) != 0) {
                switch (level) {
                    case 0: {
                        iconPath = NbJMIPaintComponent.METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = NbJMIPaintComponent.METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = NbJMIPaintComponent.METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = NbJMIPaintComponent.METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = NbJMIPaintComponent.METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = NbJMIPaintComponent.METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = NbJMIPaintComponent.METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = NbJMIPaintComponent.METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage((String)iconPath));
            this.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }

        protected void draw(Graphics g) {
            Color methodColor;
            boolean strike = this.isDeprecated();
            Icon icon = this.isEnclosingCall() ? null : this.getIcon();
            this.drawIcon(g, icon);
            Color color = methodColor = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.METHOD_COLOR;
            if ((this.getCFModifiers() & 0x20000000) != 0 && !this.isEnclosingCall()) {
                this.drawString(g, this.getCFName(), methodColor, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), strike);
            } else {
                this.drawString(g, this.getCFName(), methodColor, null, strike);
            }
            this.drawParameterList(g, this.getParamList());
            Color typeColor = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.getTypeColor();
            this.drawTypeName(g, this.getTypeName(), typeColor);
        }
    }

    public static class NbCallableFeaturePaintComponent
    extends NbJMIPaintComponent {
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private String cfName;
        private String typeName;
        private Color typeColor;
        private int activeParameterIndex = -1;
        private int drawParamIndex;

        public int getCFModifiers() {
            return this.modifiers;
        }

        public String getCFName() {
            return this.cfName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        public void setFeatureName(String cfName) {
            this.cfName = cfName;
        }

        public void setParams(List params) {
            this.params = params;
        }

        public void setExceptions(List excs) {
            this.excs = excs;
        }

        protected List getParamList() {
            return this.params;
        }

        protected List getExceptionList() {
            return this.excs;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int activeParamIndex) {
            this.activeParameterIndex = activeParamIndex;
        }

        boolean isEnclosingCall() {
            return this.activeParameterIndex != -1;
        }

        protected void drawExceptions(Graphics g, List exc, boolean strike) {
            if (exc.size() > 0) {
                Color color = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : KEYWORD_COLOR;
                this.drawString(g, NbJMIPaintComponent.THROWS, color, null, strike);
                Iterator it = exc.iterator();
                while (it.hasNext()) {
                    NbJMIResultItem.ExcStr ex = (NbJMIResultItem.ExcStr)it.next();
                    Color exColor = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : ex.getTypeColor();
                    this.drawString(g, ex.getName(), exColor, null, strike);
                    if (!it.hasNext()) continue;
                    Color commaColor = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.getForeground();
                    this.drawString(g, ", ", commaColor, this.getFont(), strike);
                }
            }
        }

        protected void drawParameter(Graphics g, NbJMIResultItem.ParamStr prm) {
            this.drawParameter(g, prm, false);
        }

        protected void drawParameter(Graphics g, NbJMIResultItem.ParamStr prm, boolean strike) {
            String name;
            Color foreColor;
            Font prmFont;
            Font font = prmFont = this.isEnclosingCall() && this.drawParamIndex == this.activeParameterIndex ? new Font(this.getFont().getName(), 1, this.getFont().getSize()) : this.getFont();
            Color typeColor = this.isEnclosingCall() ? (this.drawParamIndex == this.activeParameterIndex ? ACTIVE_PARAMETER_COLOR : ENCLOSING_CALL_COLOR) : prm.getTypeColor();
            this.drawString(g, prm.getSimpleTypeName(), typeColor, prmFont, strike);
            Color color = this.isEnclosingCall() ? (this.drawParamIndex == this.activeParameterIndex ? ACTIVE_PARAMETER_COLOR : ENCLOSING_CALL_COLOR) : (foreColor = this.getForeground());
            if (prm.isVarArg()) {
                this.drawString(g, "...", foreColor, this.getFont(), strike);
            }
            if ((name = prm.getName()) != null && name.length() > 0) {
                this.drawString(g, " ", foreColor, this.getFont(), strike);
                Color prmNameColor = this.isEnclosingCall() ? (this.drawParamIndex == this.activeParameterIndex ? ACTIVE_PARAMETER_COLOR : ENCLOSING_CALL_COLOR) : this.PARAMETER_NAME_COLOR;
                this.drawString(g, prm.getName(), prmNameColor, prmFont, strike);
            }
        }

        protected void drawParameterList(Graphics g, List prmList) {
            this.drawParameterList(g, prmList, false);
        }

        protected void drawParameterList(Graphics g, List prmList, boolean strike) {
            Color foreColor = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.getForeground();
            this.drawString(g, "(", foreColor, this.getFont(), strike);
            this.drawParamIndex = 0;
            Iterator it = prmList.iterator();
            while (it.hasNext()) {
                this.drawParameter(g, (NbJMIResultItem.ParamStr)it.next(), strike);
                if (it.hasNext()) {
                    this.drawString(g, ", ", foreColor, this.getFont(), strike);
                }
                ++this.drawParamIndex;
            }
            this.drawString(g, ")", foreColor, this.getFont(), strike);
        }
    }

    public static class NbFieldPaintComponent
    extends NbJMIPaintComponent {
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isLocalVar;
        private Icon[][] icon = new Icon[2][4];
        private Icon localIcon;
        private Color FIELD_COLOR = Color.blue.darker();
        private Color VAR_COLOR = Color.blue.darker().darker();

        public NbFieldPaintComponent(boolean isLocalVar) {
            this.isLocalVar = isLocalVar;
        }

        public void setFieldName(String fldName) {
            this.fldName = fldName;
        }

        public String getFieldName() {
            return this.fldName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            this.drawIcon(g, this.getIcon());
            if ((this.modifiers & 0x20000000) != 0) {
                this.drawString(g, this.fldName, this.isLocalVar ? this.VAR_COLOR : this.FIELD_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), strike);
            } else {
                this.drawString(g, this.fldName, this.isLocalVar ? this.VAR_COLOR : this.FIELD_COLOR, null, strike);
            }
            this.drawTypeName(g, this.typeName, this.typeColor);
        }

        protected Icon getIcon() {
            String iconPath = NbJMIPaintComponent.FIELD_PUBLIC;
            int level = JavaCompletion.getLevel((int)this.modifiers);
            if (this.isLocalVar && level == 1) {
                if (this.localIcon == null) {
                    this.localIcon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.LOCAL_VARIABLE));
                }
                return this.localIcon;
            }
            boolean isStatic = (this.modifiers & 8) != 0;
            Icon cachedIcon = this.icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            if (isStatic) {
                switch (level) {
                    case 0: {
                        iconPath = NbJMIPaintComponent.FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = NbJMIPaintComponent.FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = NbJMIPaintComponent.FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = NbJMIPaintComponent.FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = NbJMIPaintComponent.FIELD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = NbJMIPaintComponent.FIELD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = NbJMIPaintComponent.FIELD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = NbJMIPaintComponent.FIELD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage((String)iconPath));
            this.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }
    }

    public static class NbAnnotationPaintComponent
    extends NbClassPaintComponent {
        private Icon icon;

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.ANNOTATION));
            }
            return this.icon;
        }
    }

    public static class NbEnumPaintComponent
    extends NbClassPaintComponent {
        private Icon icon;

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.ENUM));
            }
            return this.icon;
        }
    }

    public static class NbInterfacePaintComponent
    extends NbClassPaintComponent {
        private Icon icon;
        private Color INTERFACE_COLOR = Color.darkGray;

        protected Color getColor() {
            return this.INTERFACE_COLOR;
        }

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.INTERFACE));
            }
            return this.icon;
        }
    }

    public static class NbClassPaintComponent
    extends NbJMIPaintComponent {
        private Color CLASS_COLOR = Color.red.darker().darker().darker();
        private Color PACKAGE_COLOR = Color.gray;
        String simpleClassName;
        String fqName = null;
        private Icon icon;
        JavaClass cls;

        public void setSimpleClassName(String simpleClassName) {
            this.simpleClassName = simpleClassName;
        }

        public void setFQName(String fqName) {
            this.fqName = fqName;
        }

        public void setCls(JavaClass cls) {
            this.cls = cls;
        }

        protected void draw(Graphics g) {
            boolean strike = this.isDeprecated();
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.simpleClassName, this.getColor(), null, strike);
            if (this.fqName != null && this.fqName.length() > 0) {
                this.drawString(g, this.fqName, this.PACKAGE_COLOR, null, strike);
            }
        }

        protected Color getColor() {
            return this.CLASS_COLOR;
        }

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.CLASS));
            }
            return this.icon;
        }

        public String getToolTipText() {
            if (this.cls == null) {
                return "";
            }
            FileObject resourceFO = JavaMetamodel.getManager().getFileObject(this.cls.getResource());
            if (resourceFO != null) {
                return FileUtil.getFileDisplayName((FileObject)resourceFO);
            }
            return "";
        }
    }

    public static class NbPackagePaintComponent
    extends NbJMIPaintComponent {
        private String pkgName;
        private boolean displayFullPackagePath;
        private Color PACKAGE_COLOR = Color.green.darker().darker().darker();
        private Icon icon;

        public void setPackageName(String pkgName) {
            this.pkgName = pkgName;
        }

        public void setDisplayFullPackagePath(boolean displayFullPackagePath) {
            this.displayFullPackagePath = displayFullPackagePath;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            String name = this.pkgName;
            if (!this.displayFullPackagePath) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            this.drawString(g, name, this.PACKAGE_COLOR);
        }

        protected Icon getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            Icon newIcon = null;
            Object newIconObj = UIManager.get("Nb.Explorer.Folder.icon");
            if (newIconObj == null) {
                newIcon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.PACKAGE));
            } else if (newIconObj instanceof Image) {
                newIcon = new ImageIcon((Image)newIconObj);
            } else if (newIconObj instanceof Icon) {
                newIcon = (Icon)newIconObj;
            }
            this.icon = newIcon;
            return newIcon;
        }
    }
}

