/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.BracketCompletion;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaFixAllImports;
import org.netbeans.modules.editor.java.NbJMICompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMIFastImport;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.java.editor.JavaEditorModule;
import org.netbeans.modules.javacore.TryWrapper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaKit
extends NbEditorKit
implements HelpCtx.Provider {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    static final long serialVersionUID = -5445829962533684922L;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport;
    static /* synthetic */ Class class$org$netbeans$editor$BaseAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Element;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper;

    public JavaKit() {
        JavaEditorModule.init();
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JavaKit.class);
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument(((Object)((Object)this)).getClass());
        doc.putProperty((Object)"write-line-separator", (Object)"\n");
        return doc;
    }

    public Syntax createSyntax(Document doc) {
        return new JavaSyntax(this.getSourceLevel((BaseDocument)doc));
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new NbJavaJMISyntaxSupport(doc);
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return new NbJMICompletionJavaDoc(extEditorUI);
    }

    public String getSourceLevel(BaseDocument doc) {
        DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
        return dob != null ? SourceLevelQuery.getSourceLevel((FileObject)dob.getPrimaryFile()) : null;
    }

    public Formatter createFormatter() {
        return new JavaFormatter(((Object)((Object)this)).getClass());
    }

    protected void toolTipAnnotationsLock(Document doc) {
        JavaModel.getJavaRepository().beginTrans(false);
    }

    protected void toolTipAnnotationsUnlock(Document doc) {
        JavaModel.getJavaRepository().endTrans();
    }

    protected void initDocument(BaseDocument doc) {
        doc.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        doc.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
        doc.putProperty((Object)SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID id, TokenContextPath contextPath, int offset, int length) {
                if (JavaTokenContext.LINE_COMMENT == id) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, id, contextPath, offset, length));
                }
            }
        });
    }

    protected Action[] createActions() {
        Action[] javaActions = new Action[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new FastImportAction(), new JavaGenerateGoToPopupAction(), new JavaGotoSuperImplementation(), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new ExpandAllJavadocFolds(), new CollapseAllJavadocFolds(), new ExpandAllCodeBlockFolds(), new CollapseAllCodeBlockFolds(), new JavaGenerateFoldPopupAction(), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false)};
        Action[] jmiAction = new Action[]{new JavaJMIGotoHelpAction(), new JavaJMIGotoSourceAction(), new JavaJMIGotoDeclarationAction(), new JavaFixAllImports(), new TryCatchAction()};
        Action[] mergedActions = TextAction.augmentList(javaActions, jmiAction);
        return TextAction.augmentList(super.createActions(), mergedActions);
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.addAction(target, menu, JavaKit.collapseAllJavadocFolds);
            this.addAction(target, menu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(target, menu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(target, menu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public CollapseAllCodeBlockFolds() {
            super(JavaKit.collapseAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.collapseAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-collapse-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, types);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public ExpandAllCodeBlockFolds() {
            super(JavaKit.expandAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.expandAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-expand-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)hierarchy, types);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        public CollapseAllJavadocFolds() {
            super(JavaKit.collapseAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.collapseAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-collapse-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        public ExpandAllJavadocFolds() {
            super(JavaKit.expandAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.expandAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-expand-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
            BracketCompletion.charBackspaced(doc, dotPos, caret, ch);
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            int dotPos = caret.getDot();
            if (BracketCompletion.posWithinString(doc, dotPos)) {
                try {
                    doc.insertString(dotPos, "\" + \"", null);
                    caret.setDot(dotPos += 3);
                    return new Integer(dotPos);
                }
                catch (BadLocationException ex) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(doc, dotPos)) {
                        int end = BracketCompletion.getRowOrBlockEnd(doc, dotPos);
                        doc.insertString(end, "}", null);
                        doc.getFormatter().indentNewLine((Document)doc, end);
                        caret.setDot(dotPos);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
            if (cookie != null && cookie instanceof Integer) {
                int nowDotPos = caret.getDot();
                caret.setDot(nowDotPos + 1);
            }
        }
    }

    public static class TryCatchAction
    extends BaseAction {
        public TryCatchAction() {
            super(JavaKit.tryCatchAction);
        }

        protected boolean asynchonous() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                TryStatement t;
                int selectionEnd;
                BaseDocument doc = (BaseDocument)target.getDocument();
                int caretPosition = -1;
                int selectionStart = target.getSelectionStart();
                if (selectionStart == (selectionEnd = target.getSelectionEnd())) {
                    try {
                        selectionStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)selectionStart);
                        selectionEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)selectionEnd) + 1;
                    }
                    catch (BadLocationException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                JavaModel.getJavaRepository().beginTrans(true);
                try {
                    FileObject fo = NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile();
                    JavaModel.setClassPath((FileObject)fo);
                    TryWrapper wrapper = new TryWrapper(fo, selectionStart, selectionEnd);
                    t = wrapper.wrap();
                }
                catch (JmiException e) {
                    Utilities.setStatusBoldText((JTextComponent)target, (String)e.getLocalizedMessage());
                    return;
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    StatementBlock finalizer = t.getFinalizer();
                    if (finalizer != null) {
                        caretPosition = finalizer.getEndOffset() - 1;
                    } else {
                        Catch cat = (Catch)t.getCatches().get(0);
                        caretPosition = cat.getEndOffset() - 1;
                    }
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
                if (caretPosition != -1) {
                    target.setCaretPosition(caretPosition);
                    target.setSelectionStart(caretPosition);
                    target.setSelectionEnd(caretPosition);
                }
            }
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = JavaKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }

        public static final class MainMenuWrapper
        extends MainMenuAction {
            private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

            public MainMenuWrapper() {
                this.setMenu();
            }

            protected String getMenuItemText() {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper == null ? (class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$TryCatchAction$MainMenuWrapper")) : class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper)).getString("try_catch_main_menu_item");
            }

            public JMenuItem getMenuPresenter() {
                return this.menuItem;
            }

            protected String getActionName() {
                return JavaKit.tryCatchAction;
            }
        }
    }

    public static class FastImportAction
    extends BaseAction {
        public FastImportAction() {
            super(JavaKit.fastImportAction);
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            Runnable run = new Runnable(){

                public void run() {
                    if (target != null) {
                        new NbJavaJMIFastImport(target).setDialogVisible(true);
                    }
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)JavaKit.fastImportAction));
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                StringBuffer sb = new StringBuffer("System.out.println(\"");
                String title = (String)doc.getProperty((Object)"title");
                if (title != null) {
                    sb.append(title);
                    sb.append(':');
                }
                try {
                    sb.append(Utilities.getLineOffset((BaseDocument)doc, (int)target.getCaret().getDot()) + 1);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                sb.append(' ');
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                if (kit == null) {
                    return;
                }
                Action a = kit.getActionByName("insert-content");
                if (a != null) {
                    Utilities.performAction((Action)a, (ActionEvent)new ActionEvent(target, 1001, sb.toString()), (JTextComponent)target);
                }
            }
        }
    }

    public static class JavaJMIGotoHelpAction
    extends JavaGotoHelpAction {
        protected boolean asynchonous() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL[] getJavaDocURLs(JTextComponent target) {
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
            NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
            BaseDocument doc = (BaseDocument)target.getDocument();
            JMIUtils jmiUtils = JMIUtils.get(doc);
            jmiUtils.beginTrans(false);
            try {
                Object item = JMIUtils.findItemAtCaretPos(target);
                URL[] uRLArray = item == null ? null : nbJavaSup.getJavaDocURLs(item);
                return uRLArray;
            }
            finally {
                jmiUtils.endTrans(false);
            }
        }
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        public JavaGotoHelpAction() {
            super("goto-help", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoHelpAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction).getName());
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("java-desc-goto-help"));
        }

        public URL[] getJavaDocURLs(JTextComponent target) {
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            Object item = JCExtension.findItemAtCaretPos(target);
            return item == null ? null : nbJavaSup.getJavaDocURLs(item);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                URL[] urls = this.getJavaDocURLs(target);
                if (urls != null && urls.length > 0) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urls[0]);
                } else {
                    Utilities.setStatusText((JTextComponent)target, (String)NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("cannot_find_javadoc"));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("show_javadoc");
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            Keymap km = target.getKeymap();
            if (km != null) {
                KeyStroke ks;
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                    item.setAccelerator(ks);
                }
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, Action a) {
            if (a != null) {
                String actionName = (String)a.getValue("Name");
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null) {
                    String itemText = (String)a.getValue("trimmed-text");
                    if (itemText == null) {
                        itemText = this.getItemText(target, actionName, a);
                    }
                    if (itemText != null) {
                        item = new JMenuItem(itemText);
                        Mnemonics.setLocalizedText((AbstractButton)item, (String)itemText);
                        item.addActionListener(a);
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(a.isEnabled());
                        Object helpID = a.getValue("helpID");
                        if (helpID != null && helpID instanceof String) {
                            item.putClientProperty("HelpID", helpID);
                        }
                    } else if ("goto-source".equals(actionName)) {
                        item = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(false);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                this.addAction(target, menu, a);
            } else {
                menu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            String menuText = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("generate-goto-popup");
            JMenu jm = new JMenu(menuText);
            return jm;
        }
    }

    public static class JavaGotoSuperImplementation
    extends BaseAction {
        public JavaGotoSuperImplementation() {
            super("goto-super-implementation");
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto-super-implementation"));
            String name = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto-super-implementation-trimmed");
            this.putValue("trimmed-text", name);
            this.putValue("PopupMenuText", name);
        }

        protected boolean asynchonous() {
            return false;
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        RequestProcessor.getDefault().post((Runnable)this);
                        return;
                    }
                    Node selNode = NbEditorUtilities.getTopComponent((JTextComponent)target).getActivatedNodes()[0];
                    Element feature = (Element)selNode.getLookup().lookup(class$org$netbeans$jmi$javamodel$Element == null ? (class$org$netbeans$jmi$javamodel$Element = JavaKit.class$("org.netbeans.jmi.javamodel.Element")) : class$org$netbeans$jmi$javamodel$Element);
                    if (!(feature instanceof Method)) {
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    JMIUtils jmiUtils = JMIUtils.get(doc);
                    FileObject fo = NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile();
                    Method f = null;
                    jmiUtils.beginTrans(false);
                    try {
                        JavaMetamodel.getManager().setClassPath(fo, true);
                        Collection methods = JavaModelUtil.getOverriddenMethods((Method)((Method)feature));
                        if (!methods.isEmpty()) {
                            f = (Method)methods.iterator().next();
                        }
                    }
                    finally {
                        jmiUtils.endTrans(false);
                    }
                    SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
                    NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                    nbJavaSup.openSource(f, false);
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)"goto-super-implementation"));
        }
    }

    public static class JavaJMIGotoSourceAction
    extends JavaGotoSourceAction {
        protected boolean asynchonous() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String openSource(JTextComponent target) {
            String itemDesc = null;
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
            NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
            BaseDocument doc = (BaseDocument)target.getDocument();
            JMIUtils jmiUtils = JMIUtils.get(doc);
            Object item = null;
            jmiUtils.beginTrans(false);
            try {
                item = JMIUtils.findItemAtCaretPos(target);
                if (item instanceof NbJMIResultItem.VarResultItem) {
                    item = ((NbJMIResultItem.VarResultItem)item).getType();
                }
                if (item instanceof ClassDefinition) {
                    item = JMIUtils.getSourceElementIfExists((ClassDefinition)item);
                }
                itemDesc = nbJavaSup.openSource(item, false);
            }
            finally {
                jmiUtils.endTrans(false);
            }
            if (itemDesc != null) {
                boolean isPkg = item instanceof JavaPackage;
                String msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(isPkg ? "goto_source_package_not_found" : "goto_source_source_not_found");
                return MessageFormat.format(msg, itemDesc);
            }
            return null;
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted");
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = JavaKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }
    }

    public static class JavaGotoSourceAction
    extends BaseAction {
        public JavaGotoSourceAction() {
            super("goto-source", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoSourceAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction).getName());
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/gotosource.gif");
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            Runnable run = new Runnable(){

                public void run() {
                    String msg;
                    if (SwingUtilities.isEventDispatchThread()) {
                        RequestProcessor.getDefault().post((Runnable)this);
                        return;
                    }
                    if (target != null && (msg = JavaGotoSourceAction.this.openSource(target)) != null) {
                        Toolkit.getDefaultToolkit().beep();
                        StatusDisplayer.getDefault().setStatusText(msg);
                    }
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)"goto-source"));
        }

        public String openSource(JTextComponent target) {
            Object item;
            String itemDesc = null;
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
            NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            itemDesc = nbJavaSup.openSource(item = JCExtension.findItemAtCaretPos(target), false);
            if (itemDesc != null) {
                boolean isPkg = item instanceof JCPackage;
                String msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(isPkg ? "goto_source_package_not_found" : "goto_source_source_not_found");
                return MessageFormat.format(msg, itemDesc);
            }
            return null;
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted");
        }
    }

    public static class JavaJMIGotoDeclarationAction
    extends JavaGotoDeclarationAction {
        public JavaJMIGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaJMIGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction).getName());
        }

        protected boolean asynchonous() {
            return false;
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        RequestProcessor.getDefault().post((Runnable)this);
                        return;
                    }
                    if (target != null) {
                        SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
                        NbJavaJMISyntaxSupport nbJavaSup = (NbJavaJMISyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                        BaseDocument doc = (BaseDocument)target.getDocument();
                        JMIUtils jmiUtils = JMIUtils.get(doc);
                        Object item = null;
                        String itemDesc = null;
                        jmiUtils.beginTrans(false);
                        try {
                            item = JMIUtils.findItemAtCaretPos(target);
                            if (item instanceof NbJMIResultItem.VarResultItem) {
                                int pos = nbJavaSup.findLocalDeclarationPosition(((NbJMIResultItem.VarResultItem)item).getItemText(), target.getCaretPosition());
                                if (pos != -1) {
                                    target.setCaretPosition(pos);
                                    JumpList.checkAddEntry((JTextComponent)target);
                                }
                            } else {
                                if (item instanceof ClassDefinition) {
                                    item = JMIUtils.getSourceElementIfExists((ClassDefinition)item);
                                }
                                itemDesc = nbJavaSup.openSource(item, true);
                            }
                        }
                        finally {
                            jmiUtils.endTrans(false);
                        }
                        if (itemDesc != null) {
                            Toolkit.getDefaultToolkit().beep();
                            boolean isPkg = item instanceof JavaPackage;
                            String msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(isPkg ? "goto_source_package_not_found" : "goto_source_source_not_found");
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, itemDesc));
                        }
                    }
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)"goto-declaration"));
        }
    }

    public static class JavaGotoDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        public JavaGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Completion completion = ExtUtilities.getCompletion((JTextComponent)target);
                SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
                NbJavaSyntaxSupport nbJavaSup = (NbJavaSyntaxSupport)sup.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
                if (completion != null) {
                    String itemDesc = null;
                    Object item = null;
                    if (completion.isPaneVisible()) {
                        item = JCExtension.findItemAtCaretPos(target);
                        itemDesc = nbJavaSup.openSource(item, true);
                    } else {
                        boolean found = false;
                        int dotPos = target.getCaret().getDot();
                        BaseDocument doc = (BaseDocument)target.getDocument();
                        try {
                            int pos;
                            int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)doc, (int)dotPos);
                            if (idFunBlk != null && idFunBlk.length == 2 && ((pos = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)idFunBlk[0])) < 0 || doc.getChars(pos, 1)[0] != '.')) {
                                found = this.gotoDeclaration(target);
                            }
                            if (!found) {
                                item = JCExtension.findItemAtCaretPos(target);
                                itemDesc = nbJavaSup.openSource(item, true);
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                    }
                    if (itemDesc != null) {
                        Toolkit.getDefaultToolkit().beep();
                        boolean isPkg = item instanceof JCPackage;
                        String msg = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(isPkg ? "goto_source_package_not_found" : "goto_source_source_not_found");
                        StatusDisplayer.getDefault().setStatusText(MessageFormat.format(msg, itemDesc));
                    }
                }
            }
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            if (insertedChar == '\"' || insertedChar == '\'') {
                boolean inserted = BracketCompletion.completeQuote(doc, dotPos, caret, insertedChar);
                if (inserted) {
                    caret.setDot(dotPos + 1);
                } else {
                    super.insertString(doc, dotPos, caret, str, overwrite);
                }
            } else {
                super.insertString(doc, dotPos, caret, str, overwrite);
                BracketCompletion.charInserted(doc, dotPos, caret, insertedChar);
            }
        }

        protected void replaceSelection(JTextComponent target, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            Document doc = target.getDocument();
            if (insertedChar == '\"' || insertedChar == '\'') {
                if (doc != null) {
                    try {
                        boolean inserted = false;
                        int p0 = Math.min(caret.getDot(), caret.getMark());
                        int p1 = Math.max(caret.getDot(), caret.getMark());
                        if (p0 != p1) {
                            doc.remove(p0, p1 - p0);
                        }
                        int caretPosition = caret.getDot();
                        if (doc instanceof BaseDocument) {
                            inserted = BracketCompletion.completeQuote((BaseDocument)doc, caretPosition, caret, insertedChar);
                        }
                        if (inserted) {
                            caret.setDot(caretPosition + 1);
                        } else if (str != null && str.length() > 0) {
                            doc.insertString(p0, str, null);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(target, dotPos, caret, str, overwrite);
                if (doc instanceof BaseDocument) {
                    BracketCompletion.charInserted((BaseDocument)doc, caret.getDot() - 1, caret, insertedChar);
                }
            }
        }
    }
}

