/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefException;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AnnotationTypeClass;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TagDefinition;
import org.netbeans.jmi.javamodel.TagValue;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMICompletionQuery;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class JMIUtils {
    private static MDRepository repository = JavaModel.getJavaRepository();
    private static JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
    private static boolean caseSensitive = true;
    private static boolean naturalSort = true;
    private static boolean showDeprecated = true;
    private static SettingsChangeListener settingsListener = new SettingsListener();
    static final boolean debugCompletionFailures = Boolean.getBoolean("org.netbeans.editor.debug.completion.failures");
    private static final Comparator NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator(true);
    private static final Comparator INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator(false);
    private static final boolean[][] assignVals = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {false, true, false, true, true, true, true, true, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false}, {false, false, false, true, true, true, true, false, false}, {false, false, false, true, true, false, true, false, false}, {false, false, false, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, true}};
    private BaseDocument doc;
    private FileObject fileObject = null;
    private boolean is15Enabled = true;
    private Resource resource;

    public static synchronized JMIUtils get(BaseDocument doc) {
        JMIUtils utils = (JMIUtils)doc.getProperty((Object)JMIUtils.class);
        if (utils == null) {
            utils = new JMIUtils(doc);
            doc.putProperty((Object)JMIUtils.class, (Object)utils);
        }
        return utils;
    }

    public static boolean isCaseSensitive() {
        return caseSensitive;
    }

    public void beginTrans(boolean write) {
        repository.beginTrans(write);
        this.resource = null;
        if (this.fileObject != null) {
            try {
                JavaModel.setClassPath((FileObject)this.fileObject);
            }
            catch (RuntimeException e) {
                repository.endTrans(write);
                throw e;
            }
            catch (Error e) {
                repository.endTrans(write);
                throw e;
            }
        }
    }

    public void endTrans(boolean fail) {
        repository.endTrans(fail);
    }

    public Type resolveType(String typeName) {
        if (!"null".equals(typeName)) {
            return JavaModel.getDefaultExtent().getType().resolve(typeName);
        }
        return null;
    }

    public Type resolveArray(Type type) {
        return ((JavaModelPackage)type.refImmediatePackage()).getArray().resolveArray(type);
    }

    public Type resolveParameterizedType(JavaClass def, List params) {
        JavaModelPackage pck = (JavaModelPackage)def.refImmediatePackage();
        return pck.getParameterizedType().resolveParameterizedType(def, params, null);
    }

    public boolean isAssignable(Type from, Type to) {
        if (from == null || to == null) {
            return false;
        }
        if (from.equals(to)) {
            return true;
        }
        if (from instanceof Array && to instanceof Array) {
            return this.isAssignable(((Array)from).getType(), ((Array)to).getType());
        }
        if (to instanceof PrimitiveType && (this.is15Enabled || from instanceof PrimitiveType)) {
            return assignVals[this.getPrimitiveTypeIdx(from)][this.getPrimitiveTypeIdx(to)];
        }
        if (to.getName().equals("java.lang.Object") && (this.is15Enabled || !(from instanceof PrimitiveType))) {
            return true;
        }
        if (to instanceof JavaClass && this.is15Enabled && from instanceof PrimitiveType) {
            return this.isAssignable(this.getObjectType((PrimitiveType)from), to);
        }
        if (from instanceof JavaClass && to instanceof JavaClass) {
            return this.isSubTypeOf((JavaClass)from, (JavaClass)to);
        }
        return false;
    }

    public boolean isSubTypeOf(JavaClass thisCls, JavaClass otherCls) {
        if (otherCls instanceof TypeParameter) {
            if (!this.isSubTypeOf(thisCls, otherCls.getSuperClass())) {
                return false;
            }
            Iterator it = otherCls.getInterfaces().iterator();
            while (it.hasNext()) {
                if (this.isSubTypeOf(thisCls, (JavaClass)it.next())) continue;
                return false;
            }
            return true;
        }
        if (thisCls.isSubTypeOf((ClassDefinition)otherCls)) {
            List thisParams = thisCls instanceof ParameterizedType ? ((ParameterizedType)thisCls).getParameters() : new ArrayList();
            List otherParams = otherCls instanceof ParameterizedType ? ((ParameterizedType)otherCls).getParameters() : new ArrayList();
            int thisParamsCount = thisParams.size();
            int otherParamsCount = otherParams.size();
            if (thisParamsCount == 0 || otherParamsCount == 0) {
                return true;
            }
            if (thisParamsCount != otherParamsCount) {
                return false;
            }
            Iterator it = thisParams.iterator();
            Iterator itt = otherParams.iterator();
            while (it.hasNext()) {
                if (this.isAssignable((Type)it.next(), (Type)itt.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isEqualType(Type thisCls, Type otherCls) {
        return this.isAssignable(thisCls, otherCls) && this.isAssignable(otherCls, thisCls);
    }

    public JavaPackage getExactPackage(String packageName) {
        return this.resolvePackage(packageName, true);
    }

    public String getPackageName(ClassDefinition jc) {
        String result;
        Resource res;
        if (jc instanceof UnresolvedClass) {
            String name = jc.getName();
            int index = name.lastIndexOf(46);
            return index < 0 ? "" : name.substring(0, index);
        }
        if (jc instanceof JavaClass && jc.isValid() && (res = jc.getResource()) != null && (result = res.getPackageName()) != null) {
            return result;
        }
        return "";
    }

    public JavaClass getExactClass(String name, String pkgName) {
        return this.getExactClass(pkgName != null && pkgName.length() != 0 ? pkgName + "." + name : name);
    }

    public JavaClass getExactClass(String classFullName) {
        Type cls = this.resolveType(classFullName);
        if (cls instanceof UnresolvedClass) {
            return null;
        }
        if (cls instanceof JavaClass) {
            return (JavaClass)cls;
        }
        return null;
    }

    public List findPackages(String name, boolean exactMatch, boolean subPackages, boolean createResultItems) {
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory;
        ArrayList<NbJMIResultItem.PackageResultItem> ret = new ArrayList<NbJMIResultItem.PackageResultItem>();
        NbJavaJMICompletionQuery.JMIItemFactory jMIItemFactory = itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        if (exactMatch) {
            JavaPackage pkg = this.getExactPackage(name);
            if (pkg != null) {
                if (itemFactory != null) {
                    ret.add(itemFactory.createPackageResultItem(pkg));
                } else {
                    ret.add((NbJMIResultItem.PackageResultItem)pkg);
                }
            }
        } else {
            int index = name.lastIndexOf(46);
            String prefix = index > 0 ? name.substring(0, index) : "";
            JavaPackage pkg = this.resolvePackage(prefix, caseSensitive);
            if (pkg != null) {
                Collection subpackages = pkg.getSubPackages();
                Iterator it = subpackages.iterator();
                while (it.hasNext()) {
                    JavaPackage subPackage = (JavaPackage)it.next();
                    if (!JMIUtils.startsWith(subPackage.getName(), name)) continue;
                    if (itemFactory != null) {
                        ret.add(itemFactory.createPackageResultItem(subPackage));
                        continue;
                    }
                    ret.add((NbJMIResultItem.PackageResultItem)subPackage);
                }
            }
        }
        if (subPackages) {
            int size = ret.size();
            for (int x = 0; x < size; ++x) {
                JavaPackage sPkg = (JavaPackage)ret.get(x);
                this.addSubPackages(ret, sPkg, createResultItems);
            }
        }
        Collections.sort(ret, JMIUtils.getNaturalMemberNameComparator());
        return ret;
    }

    public List findClasses(JavaPackage pkg, String name, boolean exactMatch, boolean includeInnerClasses, boolean includeAnnotations, JavaClass context, boolean createResultItems, boolean isInstanceCreationCtx) {
        TreeSet<Object> ret = new TreeSet<Object>(JMIUtils.getNaturalMemberNameComparator());
        ClassPath cp = JavaMetamodel.getManager().getClassPath();
        FileObject[] cpRoots = cp.getRoots();
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        for (int i = 0; i < cpRoots.length; ++i) {
            ClassIndex ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)cpRoots[i]));
            if (ci == null) continue;
            Set<Object> col = null;
            if (pkg == null) {
                col = exactMatch ? ci.getClassesBySimpleName(name) : ci.getClassesBySNPrefix(name, caseSensitive);
            } else {
                String clsName;
                String string = clsName = pkg.getName().length() > 0 ? pkg.getName() + '.' + name : name;
                if (exactMatch) {
                    JavaClass cls = ci.getClassByFqn(clsName);
                    if (cls != null) {
                        col = Collections.singleton(cls);
                    }
                } else {
                    col = ci.getClassesByFQNPrefix(clsName, caseSensitive);
                }
            }
            if (col == null) continue;
            Iterator it = col.iterator();
            while (it.hasNext()) {
                JavaClass javaClass = (JavaClass)it.next();
                if (!includeAnnotations && javaClass instanceof AnnotationType || !showDeprecated && javaClass.isDeprecated() || !includeInnerClasses && javaClass.isInner() || !this.isAccessible((ClassDefinition)javaClass, context)) continue;
                if (itemFactory == null) {
                    ret.add(javaClass);
                    continue;
                }
                ret.add(itemFactory.createClassResultItem(javaClass, pkg == null, isInstanceCreationCtx));
            }
        }
        return new ArrayList(ret);
    }

    public List findAnnotations(JavaPackage pkg, String name, boolean exactMatch, JavaClass context, boolean createResultItems) {
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        TreeSet<NbJMIResultItem.ClassResultItem> ret = new TreeSet<NbJMIResultItem.ClassResultItem>(JMIUtils.getNaturalMemberNameComparator());
        ClassPath cp = JavaMetamodel.getManager().getClassPath();
        FileObject[] cpRoots = cp.getRoots();
        for (int i = 0; i < cpRoots.length; ++i) {
            JavaModelPackage jmp = JavaModel.getJavaExtent((FileObject)cpRoots[i]);
            if (jmp == null) continue;
            AnnotationTypeClass atc = jmp.getAnnotationType();
            Iterator it = atc.refAllOfType().iterator();
            while (it.hasNext()) {
                AnnotationType at = (AnnotationType)it.next();
                if (!showDeprecated && at.isDeprecated()) continue;
                if (exactMatch) {
                    if (pkg != null) {
                        String string = name = pkg.getName().length() > 0 ? pkg.getName() + '.' + name : name;
                        if (!(caseSensitive ? at.getName().equals(name) : at.getName().equalsIgnoreCase(name)) || !this.isAccessible((ClassDefinition)at, context)) continue;
                        if (itemFactory != null) {
                            ret.add(itemFactory.createClassResultItem((JavaClass)at, false, false));
                            continue;
                        }
                        ret.add((NbJMIResultItem.ClassResultItem)at);
                        continue;
                    }
                    if (!(caseSensitive ? at.getSimpleName().equals(name) : at.getSimpleName().equalsIgnoreCase(name)) || !this.isAccessible((ClassDefinition)at, context)) continue;
                    if (itemFactory != null) {
                        ret.add(itemFactory.createClassResultItem((JavaClass)at, true, false));
                        continue;
                    }
                    ret.add((NbJMIResultItem.ClassResultItem)at);
                    continue;
                }
                if (pkg != null) {
                    if (!(caseSensitive ? this.getPackageName((ClassDefinition)at).equals(pkg.getName()) : this.getPackageName((ClassDefinition)at).equalsIgnoreCase(pkg.getName())) || !JMIUtils.startsWith(at.getSimpleName(), name) || !this.isAccessible((ClassDefinition)at, context)) continue;
                    if (itemFactory != null) {
                        ret.add(itemFactory.createClassResultItem((JavaClass)at, false, false));
                        continue;
                    }
                    ret.add((NbJMIResultItem.ClassResultItem)at);
                    continue;
                }
                if (!JMIUtils.startsWith(at.getSimpleName(), name) || !this.isAccessible((ClassDefinition)at, context)) continue;
                if (itemFactory != null) {
                    ret.add(itemFactory.createClassResultItem((JavaClass)at, true, false));
                    continue;
                }
                ret.add((NbJMIResultItem.ClassResultItem)at);
            }
        }
        return new ArrayList(ret);
    }

    public List findFeatures(Type type, String name, boolean exactMatch, boolean inspectOuterClasses, JavaClass context, boolean staticContext, boolean thisContext, JCExpression exp, boolean createResultItems, boolean preferSources, boolean isInstanceCreationCtx, boolean sorted) {
        return this.findFeatures(type, name, exactMatch, true, inspectOuterClasses, context, staticContext, thisContext, Feature.class, exp, createResultItems, preferSources, isInstanceCreationCtx, sorted);
    }

    public List findFields(Type type, String name, boolean exactMatch, boolean inspectOuterClasses, JavaClass context, boolean staticContext, boolean thisContext, boolean createResultItems, boolean preferSources) {
        return this.findFeatures(type, name, exactMatch, true, inspectOuterClasses, context, staticContext, thisContext, Field.class, null, createResultItems, preferSources, false, true);
    }

    public List findMethods(Type type, String name, boolean exactMatch, boolean inspectOuterClasses, JavaClass context, boolean staticContext, boolean thisContext, JCExpression exp, boolean createResultItems, boolean preferSources) {
        return this.findFeatures(type, name, exactMatch, true, inspectOuterClasses, context, staticContext, thisContext, Method.class, exp, createResultItems, preferSources, false, true);
    }

    public List findConstructors(Type type, JavaClass context, boolean thisContext) {
        return this.findFeatures(type, "", false, false, false, context, false, thisContext, Constructor.class, null, false, true, false, true);
    }

    public List findInnerClasses(Type type, String name, boolean exactMatch, boolean inspectOuterClasses, JavaClass context, boolean thisContext, boolean createResultItems, boolean preferSources, boolean isInstanceCreationCtx) {
        return this.findFeatures(type, name, exactMatch, true, inspectOuterClasses, context, false, thisContext, JavaClass.class, null, createResultItems, preferSources, isInstanceCreationCtx, true);
    }

    public List findEnumConstants(JavaEnum en, String name, boolean exactMatch, boolean createResultItems, boolean preferSources) {
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory;
        NbJavaJMICompletionQuery.JMIItemFactory jMIItemFactory = itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        if (preferSources) {
            en = (JavaEnum)JMIUtils.getSourceElementIfExists((ClassDefinition)en);
        }
        TreeSet<NbJMIResultItem.FieldResultItem> ret = new TreeSet<NbJMIResultItem.FieldResultItem>(JMIUtils.getNaturalMemberNameComparator());
        Iterator it = en.getConstants().iterator();
        while (it.hasNext()) {
            Field constant = (Field)it.next();
            if (!showDeprecated && constant.isDeprecated()) continue;
            String constantName = constant.getName();
            if (!exactMatch ? !JMIUtils.startsWith(constantName, name) : !constantName.equals(name)) continue;
            if (itemFactory != null) {
                ret.add(itemFactory.createFieldResultItem(constant, null, (ClassDefinition)en));
                continue;
            }
            ret.add((NbJMIResultItem.FieldResultItem)constant);
        }
        return new ArrayList(ret);
    }

    public List findAnnotationMembers(AnnotationType type, String name, boolean exactMatch, boolean createResultItems, boolean preferSources) {
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory;
        NbJavaJMICompletionQuery.JMIItemFactory jMIItemFactory = itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        if (preferSources) {
            type = (AnnotationType)JMIUtils.getSourceElementIfExists((ClassDefinition)type);
        }
        ArrayList<NbJMIResultItem.AttributeResultItem> ret = new ArrayList<NbJMIResultItem.AttributeResultItem>();
        Iterator it = type.getContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Attribute)) continue;
            Attribute attr = (Attribute)o;
            String attrName = attr.getName();
            if (!exactMatch ? !JMIUtils.startsWith(attrName, name) : !attrName.equals(name)) continue;
            if (itemFactory != null) {
                ret.add(itemFactory.createAttributeResultItem(attr));
                continue;
            }
            ret.add((NbJMIResultItem.AttributeResultItem)attr);
        }
        return ret;
    }

    public Resource getResource() {
        if (this.resource == null || !this.resource.isValid()) {
            DataObject dob = NbEditorUtilities.getDataObject((Document)this.doc);
            this.resource = dob != null ? JavaModel.getResource((FileObject)dob.getPrimaryFile()) : null;
        }
        return this.resource;
    }

    public JavaClass getImportedClass(String simpleName, JavaClass topClass, JavaClass context, Resource res) {
        JavaClass ret = null;
        if (res != null) {
            String simpleNamePrefix = ".".concat(simpleName);
            Object[] imports = res.getImports().toArray();
            for (int i = 0; i < imports.length; ++i) {
                Import imp = (Import)imports[i];
                if (imp.isOnDemand() || imp.isStatic() || !imp.getName().endsWith(simpleNamePrefix)) continue;
                return (JavaClass)imp.getImportedNamespace();
            }
            ret = this.getExactClass(simpleName, this.getPackageName((ClassDefinition)topClass));
            if (ret != null) {
                return ret;
            }
            List clsList = this.findClasses(this.getExactPackage("java.lang"), simpleName, true, false, true, context, false, false);
            if (clsList != null && clsList.size() > 0) {
                return (JavaClass)clsList.get(0);
            }
            for (int i = 0; i < imports.length; ++i) {
                NamedElement el;
                Import imp = (Import)imports[i];
                if (!imp.isOnDemand() || !((el = imp.getImportedNamespace()) instanceof JavaPackage ? (clsList = this.findClasses((JavaPackage)el, simpleName, true, false, true, context, false, false)) != null && clsList.size() > 0 : el instanceof JavaClass && (clsList = this.findInnerClasses((Type)((JavaClass)el), simpleName, true, true, context, false, false, false, false)) != null && clsList.size() > 0)) continue;
                return (JavaClass)clsList.get(0);
            }
        }
        return ret;
    }

    public List getStaticallyImportedFields(String name, boolean exactMatch, JavaClass context, boolean isThisContext) {
        ArrayList<NamedElement> ret = new ArrayList<NamedElement>();
        Resource res = this.getResource();
        if (res != null) {
            Iterator it = res.getImports().iterator();
            while (it.hasNext()) {
                Import imp = (Import)it.next();
                if (!imp.isStatic()) continue;
                Iterator itt = imp.getImportedElements().iterator();
                while (itt.hasNext()) {
                    NamedElement el = (NamedElement)itt.next();
                    if (el instanceof Field && (((Field)el).getModifiers() & 8) != 0) {
                        ClassDefinition sourceDecl;
                        ClassDefinition decl;
                        if (exactMatch) {
                            if (el.getName() != null && el.getName().equals(name)) {
                                decl = ((Field)el).getDeclaringClass();
                                if (decl != (sourceDecl = JMIUtils.getSourceElementIfExists(decl))) {
                                    el = sourceDecl.getField(el.getName(), true);
                                }
                                ret.add(el);
                            }
                        } else if (el.getName() != null && el.getName().startsWith(name)) {
                            decl = ((Field)el).getDeclaringClass();
                            if (decl != (sourceDecl = JMIUtils.getSourceElementIfExists(decl))) {
                                el = sourceDecl.getField(el.getName(), true);
                            }
                            ret.add(el);
                        }
                    }
                    if (!(el instanceof JavaClass)) continue;
                    ret.addAll(this.findFeatures((Type)JMIUtils.getSourceElementIfExists((ClassDefinition)((JavaClass)el)), name, exactMatch, true, false, context, true, isThisContext, class$org$netbeans$jmi$javamodel$Field == null ? JMIUtils.class$("org.netbeans.jmi.javamodel.Field") : class$org$netbeans$jmi$javamodel$Field, null, false, false, false, true));
                }
            }
        }
        return ret;
    }

    public List getStaticallyImportedMethods(String name, boolean exactMatch, JavaClass context, boolean isThisContext) {
        ArrayList<NamedElement> ret = new ArrayList<NamedElement>();
        Resource res = this.getResource();
        if (res != null) {
            Iterator it = res.getImports().iterator();
            while (it.hasNext()) {
                Import imp = (Import)it.next();
                if (!imp.isStatic()) continue;
                Iterator itt = imp.getImportedElements().iterator();
                while (itt.hasNext()) {
                    NamedElement el = (NamedElement)itt.next();
                    if (el instanceof Method && (((Method)el).getModifiers() & 8) != 0) {
                        Iterator i;
                        ArrayList<Type> params;
                        ClassDefinition sourceDecl;
                        ClassDefinition decl;
                        if (exactMatch) {
                            if (el.getName() != null && el.getName().equals(name)) {
                                decl = ((Method)el).getDeclaringClass();
                                if (decl != (sourceDecl = JMIUtils.getSourceElementIfExists(decl))) {
                                    params = new ArrayList<Type>();
                                    i = ((Method)el).getParameters().iterator();
                                    while (i.hasNext()) {
                                        params.add(((Parameter)i.next()).getType());
                                    }
                                    el = sourceDecl.getMethod(el.getName(), params, true);
                                }
                                ret.add(el);
                            }
                        } else if (el.getName() != null && el.getName().startsWith(name)) {
                            decl = ((Method)el).getDeclaringClass();
                            if (decl != (sourceDecl = JMIUtils.getSourceElementIfExists(decl))) {
                                params = new ArrayList();
                                i = ((Method)el).getParameters().iterator();
                                while (i.hasNext()) {
                                    params.add(((Parameter)i.next()).getType());
                                }
                                el = sourceDecl.getMethod(el.getName(), params, true);
                            }
                            ret.add(el);
                        }
                    }
                    if (!(el instanceof JavaClass)) continue;
                    ret.addAll(this.findFeatures((Type)JMIUtils.getSourceElementIfExists((ClassDefinition)((JavaClass)el)), name, exactMatch, true, false, context, true, isThisContext, class$org$netbeans$jmi$javamodel$Method == null ? JMIUtils.class$("org.netbeans.jmi.javamodel.Method") : class$org$netbeans$jmi$javamodel$Method, null, false, false, false, true));
                }
            }
        }
        return ret;
    }

    public List getImportedInnerClasses(String name, boolean exactMatch, JavaClass context, boolean isThisContext, boolean createResultItems, boolean isInstanceCreationCtx) {
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        ArrayList<NbJMIResultItem.ClassResultItem> ret = new ArrayList<NbJMIResultItem.ClassResultItem>();
        Resource res = this.getResource();
        if (res != null) {
            Iterator it = res.getImports().iterator();
            while (it.hasNext()) {
                Import imp = (Import)it.next();
                NamedElement el = imp.getImportedNamespace();
                if (!(el instanceof JavaClass)) continue;
                if (imp.isOnDemand()) {
                    ret.addAll(this.findInnerClasses((Type)((JavaClass)el), name, exactMatch, true, context, isThisContext, createResultItems, false, isInstanceCreationCtx));
                    continue;
                }
                if (!((JavaClass)el).isInner()) continue;
                if (exactMatch) {
                    if (((JavaClass)el).getSimpleName() == null || !((JavaClass)el).getSimpleName().equals(name)) continue;
                    if (itemFactory != null) {
                        ret.add(itemFactory.createClassResultItem((JavaClass)el, false, isInstanceCreationCtx));
                        continue;
                    }
                    ret.add((NbJMIResultItem.ClassResultItem)el);
                    continue;
                }
                if (((JavaClass)el).getSimpleName() == null || !((JavaClass)el).getSimpleName().startsWith(name)) continue;
                if (itemFactory != null) {
                    ret.add(itemFactory.createClassResultItem((JavaClass)el, false, isInstanceCreationCtx));
                    continue;
                }
                ret.add((NbJMIResultItem.ClassResultItem)el);
            }
        }
        return ret;
    }

    public Collection filterNames(Collection col, String namePrefix, boolean exactMatch) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (exactMatch) {
                if (!s.equals(namePrefix)) continue;
                ret.add(s);
                continue;
            }
            if (!JMIUtils.startsWith(s, namePrefix)) continue;
            ret.add(s);
        }
        return ret;
    }

    public List findMatchingTypes(TypeParameter tp, JavaClass context, boolean createResultItems) {
        TreeSet<Object> ts;
        block11: {
            Iterator it;
            JavaClass sup;
            block10: {
                ts = new TreeSet<Object>(JMIUtils.getNaturalMemberNameComparator());
                sup = tp.getSuperClass();
                if (sup != null) {
                    if ("java.lang.Object".equals(sup.getName())) {
                        if (tp.getInterfaces().size() == 0) {
                            ts.addAll(this.findClasses(null, "", false, false, true, context, createResultItems, false));
                        } else {
                            sup = null;
                        }
                    } else {
                        ts.add(sup);
                        NbJavaJMICompletionQuery.JMIItemFactory itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
                        Iterator it2 = sup.findSubTypes(true).iterator();
                        while (it2.hasNext()) {
                            JavaClass subType = (JavaClass)it2.next();
                            if (!showDeprecated && subType.isDeprecated() || !(subType.isInner() ? this.isAccessible((Feature)subType, null, context) : this.isTopLevelClassAccessible(subType, context))) continue;
                            if (itemFactory == null) {
                                ts.add(subType);
                                continue;
                            }
                            ts.add(itemFactory.createClassResultItem(subType, true, false));
                        }
                    }
                }
                if (ts.size() == 0) break block10;
                it = tp.getInterfaces().iterator();
                while (it.hasNext()) {
                    ts.retainAll(((JavaClass)it.next()).findSubTypes(true));
                }
                break block11;
            }
            if (sup != null) break block11;
            it = tp.getInterfaces().iterator();
            if (it.hasNext()) {
                ts.addAll(((JavaClass)it.next()).findSubTypes(true));
            }
            while (it.hasNext()) {
                ts.retainAll(((JavaClass)it.next()).findSubTypes(true));
            }
        }
        return new ArrayList(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean openElement(final Element element) {
        repository.beginTrans(false);
        try {
            Resource resource = element.getResource();
            if (resource != null) {
                EditorCookie.Observable ec;
                javaMetamodel.setClassPath(resource);
                DataObject dob = javaMetamodel.getDataObject(resource);
                if (dob != null && (ec = (EditorCookie.Observable)dob.getCookie(EditorCookie.Observable.class)) != null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)JMIUtils.class, (String)"opening-element", (Object)(element instanceof NamedElement ? ((NamedElement)element).getName() : "")));
                    Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                        public void run() {
                            JEditorPane[] panes = ec.getOpenedPanes();
                            if (panes != null && panes.length > 0) {
                                JMIUtils.selectElementInPane(panes[0], element, false);
                            } else {
                                ec.addPropertyChangeListener(new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if ("openedPanes".equals(evt.getPropertyName())) {
                                            JEditorPane[] panes = ec.getOpenedPanes();
                                            if (panes != null && panes.length > 0) {
                                                JMIUtils.selectElementInPane(panes[0], element, true);
                                            }
                                            ec.removePropertyChangeListener((PropertyChangeListener)this);
                                        }
                                    }
                                });
                                ec.open();
                            }
                        }
                    });
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            repository.endTrans(false);
        }
        return false;
    }

    public static ClassDefinition getSourceElementIfExists(ClassDefinition next) {
        return ((JMManager)javaMetamodel).getSourceElementIfExists(next);
    }

    public static Feature getDefintion(Feature e) {
        if (e instanceof ParameterizedType) {
            return JMIUtils.getDefintion((Feature)((ParameterizedType)e).getDefinition());
        }
        try {
            return JMIUtils.getDefintion((Feature)((ParameterizedTypeImpl.Wrapper)e).getWrappedObject());
        }
        catch (Exception exception) {
            return e;
        }
    }

    public static String getTypeName(Type typ, boolean displayFQN, boolean substituteTypeParams) {
        if (typ instanceof Array) {
            return JMIUtils.getTypeName(((Array)typ).getType(), displayFQN, false) + "[]";
        }
        if (typ instanceof TypeParameter && substituteTypeParams) {
            return JMIUtils.getTypeName((Type)((TypeParameter)typ).getSuperClass(), displayFQN, true);
        }
        if (typ instanceof AnnotationType || typ instanceof ParameterizedType && ((ParameterizedType)typ).getDefinition() instanceof AnnotationType) {
            return "@" + (displayFQN ? ((JavaClass)typ).getName() : ((JavaClass)typ).getSimpleName());
        }
        if (typ instanceof JavaClass) {
            return displayFQN ? ((JavaClass)typ).getName() : ((JavaClass)typ).getSimpleName();
        }
        return typ != null ? typ.getName() : "";
    }

    public boolean isAccessible(ClassDefinition cls, JavaClass from) {
        if (cls == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        while (cls instanceof Array) {
            Type typ = ((Array)cls).getType();
            if (typ instanceof ClassDefinition) {
                cls = (ClassDefinition)typ;
                continue;
            }
            return true;
        }
        return ((JavaClass)cls).isInner() ? this.isAccessible((Feature)((JavaClass)cls), ((JavaClass)cls).getDeclaringClass(), from) : this.isTopLevelClassAccessible((JavaClass)cls, from);
    }

    private JMIUtils(BaseDocument doc) {
        FileObject fo;
        ClassPath sourceCP;
        this.doc = doc;
        DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
        if (dob != null && (sourceCP = ClassPath.getClassPath((FileObject)(fo = dob.getPrimaryFile()), (String)"classpath/source")) != null) {
            this.fileObject = sourceCP.findOwnerRoot(fo);
        }
    }

    private List findFeatures(Type type, String name, boolean exactMatch, boolean inspectSuperTypes, boolean inspectOuterClasses, JavaClass context, boolean staticContext, boolean thisContext, Class featureType, JCExpression exp, boolean createResultItems, boolean preferSources, boolean isInstanceCreationCtx, boolean sorted) {
        if (type == null || type instanceof PrimitiveType) {
            return new ArrayList();
        }
        AbstractCollection ts = null;
        ts = sorted ? new TreeSet(JMIUtils.getNaturalMemberNameComparator()) : new ArrayList();
        boolean camelCase = name.length() > 1 && name.equals(name.toUpperCase());
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        ClassDefinition typeCtx = preferSources ? JMIUtils.getSourceElementIfExists((ClassDefinition)type) : (ClassDefinition)type;
        int outerInd = 0;
        JavaClass cls = thisContext ? (type.equals(context) ? null : context) : (type instanceof ClassDefinition ? (ClassDefinition)type : null);
        boolean matchName = exactMatch || name.length() > 0;
        boolean staticType = type instanceof JavaClass && Modifier.isStatic(((JavaClass)type).getModifiers());
        List outerList = inspectOuterClasses && type instanceof JavaClass ? this.getOuterClasses((JavaClass)type) : Collections.singletonList(type);
        Iterator<Type> it = outerList.iterator();
        while (it.hasNext()) {
            ClassesIterator itt = new ClassesIterator(it.next(), inspectSuperTypes, preferSources);
            while (itt.hasNext()) {
                ClassDefinition cd;
                ClassDefinition tempClass = (ClassDefinition)itt.next();
                AccessibilityDescriptor accessDesc = new AccessibilityDescriptor(tempClass, (ClassDefinition)cls, context);
                Object[] features = tempClass.getFeatures().toArray();
                int ctorsCount = 0;
                for (int i = 0; i < features.length; ++i) {
                    Feature feature = (Feature)features[i];
                    if (!featureType.isInstance(feature)) continue;
                    if (featureType.isAssignableFrom(class$org$netbeans$jmi$javamodel$Constructor == null ? JMIUtils.class$("org.netbeans.jmi.javamodel.Constructor") : class$org$netbeans$jmi$javamodel$Constructor)) {
                        ++ctorsCount;
                    }
                    if (matchName) {
                        String featureName;
                        String string = featureName = feature instanceof JavaClass ? ((JavaClass)feature).getSimpleName() : feature.getName();
                        if (featureName == null) {
                            featureName = "";
                        }
                        if (exactMatch ? !featureName.equals(name) : !JMIUtils.startsWith(featureName, name) && (!camelCase || !(feature instanceof JavaClass) || !JMIUtils.matchesCamelCase(featureName, name))) continue;
                    }
                    int mods = feature.getModifiers();
                    if (staticContext && !(feature instanceof JavaClass) && (mods & 8) == 0 || outerInd > 0 && staticType && (mods & 8) == 0 || !showDeprecated && feature.isDeprecated() || !accessDesc.isAccessible(mods)) continue;
                    if (itemFactory != null) {
                        ts.add(itemFactory.createResultItem(feature, exp, typeCtx, isInstanceCreationCtx));
                        continue;
                    }
                    ts.add(feature);
                }
                if (tempClass instanceof JavaEnum && featureType.isAssignableFrom(class$org$netbeans$jmi$javamodel$Method == null ? JMIUtils.class$("org.netbeans.jmi.javamodel.Method") : class$org$netbeans$jmi$javamodel$Method) && (thisContext || !(type instanceof JavaClass) || this.isAccessible((ClassDefinition)((JavaClass)type), context))) {
                    FakeJavaDoc jd;
                    if (exactMatch) {
                        if ("values".equals(name)) {
                            List<FakeTagValue> tags = Collections.singletonList(new FakeTagValue(this.createTagDefinition("@return"), "an array containing the constants of this enum class, in the order they're declare"));
                            jd = new FakeJavaDoc(tags, "Returns an array containing the constants of this enum class, in the order they're declared. This method may be used to iterate over the constants as follows:<blockquote><pre>for(ClassName c : ClassName.values())<br>    System.out.println(c);</pre></blockquote>");
                            FakeMethod mtd = new FakeMethod("values", tempClass, this.resolveArray((Type)tempClass), Collections.EMPTY_LIST, jd);
                            if (itemFactory != null) {
                                ts.add(itemFactory.createResultItem(mtd, exp, typeCtx, false));
                            } else {
                                ts.add(mtd);
                            }
                        } else if ("valueOf".equals(name)) {
                            ArrayList<FakeTagValue> tags = new ArrayList<FakeTagValue>(3);
                            tags.add(new FakeTagValue(this.createTagDefinition("@param"), "name the name of the constant to return"));
                            tags.add(new FakeTagValue(this.createTagDefinition("@return"), "the enum constant with the specified name"));
                            tags.add(new FakeTagValue(this.createTagDefinition("@throws"), "IllegalArgumentException if this enum class has no constant with the specified name"));
                            jd = new FakeJavaDoc(tags, "Returns the enum constant of this class with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)");
                            FakeMethod mtd = new FakeMethod("valueOf", tempClass, (Type)tempClass, Collections.singletonList(new FakeParameter("name", this.resolveType("java.lang.String"))), jd);
                            if (itemFactory != null) {
                                ts.add(itemFactory.createResultItem(mtd, exp, typeCtx, false));
                            } else {
                                ts.add(mtd);
                            }
                        }
                    } else {
                        if (JMIUtils.startsWith("values", name)) {
                            List<FakeTagValue> tags = Collections.singletonList(new FakeTagValue(this.createTagDefinition("@return"), "an array containing the constants of this enum class, in the order they're declare"));
                            jd = new FakeJavaDoc(tags, "Returns an array containing the constants of this enum class, in the order they're declared. This method may be used to iterate over the constants as follows:<blockquote><pre>for(ClassName c : ClassName.values())<br>    System.out.println(c);</pre></blockquote>");
                            FakeMethod mtd = new FakeMethod("values", tempClass, this.resolveArray((Type)tempClass), Collections.EMPTY_LIST, jd);
                            if (itemFactory != null) {
                                ts.add(itemFactory.createResultItem(mtd, exp, typeCtx, false));
                            } else {
                                ts.add(mtd);
                            }
                        }
                        if (JMIUtils.startsWith("valueOf", name)) {
                            ArrayList<FakeTagValue> tags = new ArrayList<FakeTagValue>(3);
                            tags.add(new FakeTagValue(this.createTagDefinition("@param"), "name the name of the constant to return"));
                            tags.add(new FakeTagValue(this.createTagDefinition("@return"), "the enum constant with the specified name"));
                            tags.add(new FakeTagValue(this.createTagDefinition("@throws"), "IllegalArgumentException if this enum class has no constant with the specified name"));
                            jd = new FakeJavaDoc(tags, "Returns the enum constant of this class with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)");
                            FakeMethod mtd = new FakeMethod("valueOf", tempClass, (Type)tempClass, Collections.singletonList(new FakeParameter("name", this.resolveType("java.lang.String"))), jd);
                            if (itemFactory != null) {
                                ts.add(itemFactory.createResultItem(mtd, exp, typeCtx, false));
                            } else {
                                ts.add(mtd);
                            }
                        }
                    }
                }
                if (ctorsCount != 0 || !featureType.isAssignableFrom(class$org$netbeans$jmi$javamodel$Constructor == null ? JMIUtils.class$("org.netbeans.jmi.javamodel.Constructor") : class$org$netbeans$jmi$javamodel$Constructor) || !((cd = tempClass instanceof ParameterizedType ? ((ParameterizedType)tempClass).getDefinition() : tempClass) instanceof JavaClass)) continue;
                String cdName = ((JavaClass)cd).getSimpleName();
                if (exactMatch) {
                    if (!name.equals(cdName)) continue;
                    FakeConstructor ctr = new FakeConstructor(cd, null);
                    if (itemFactory != null) {
                        ts.add(itemFactory.createResultItem(ctr, exp, typeCtx, false));
                        continue;
                    }
                    ts.add(ctr);
                    continue;
                }
                if (!JMIUtils.startsWith(cdName, name)) continue;
                FakeConstructor ctr = new FakeConstructor(cd, null);
                if (itemFactory != null) {
                    ts.add(itemFactory.createResultItem(ctr, exp, typeCtx, false));
                    continue;
                }
                ts.add(ctr);
            }
            ++outerInd;
        }
        return ts instanceof List ? (List)((Object)ts) : new ArrayList(ts);
    }

    private static void selectElementInPane(final JEditorPane pane, final Element element, boolean delayProcessing) {
        final Cursor editCursor = pane.getCursor();
        pane.setCursor(Cursor.getPredefinedCursor(3));
        if (delayProcessing) {
            pane.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            int caretPos = pane.getCaretPosition();
                            Container parent = pane.getParent();
                            Point viewPos = parent instanceof JViewport ? ((JViewport)parent).getViewPosition() : null;
                            PositionBounds bounds = null;
                            repository.beginTrans(false);
                            try {
                                javaMetamodel.setClassPath(element.getResource());
                                bounds = JavaMetamodel.getManager().getElementPosition(element);
                            }
                            finally {
                                repository.endTrans(false);
                            }
                            if (bounds != null && pane.getCaretPosition() == caretPos && (viewPos == null || viewPos.equals(((JViewport)parent).getViewPosition()))) {
                                pane.setCaretPosition(bounds.getBegin().getOffset());
                            }
                            JumpList.checkAddEntry((JTextComponent)pane);
                            pane.setCursor(editCursor);
                            StatusDisplayer.getDefault().setStatusText("");
                        }
                    });
                    pane.removeFocusListener(this);
                }
            });
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int caretPos = pane.getCaretPosition();
                    Container parent = pane.getParent();
                    Point viewPos = parent instanceof JViewport ? ((JViewport)parent).getViewPosition() : null;
                    PositionBounds bounds = null;
                    repository.beginTrans(false);
                    try {
                        javaMetamodel.setClassPath(element.getResource());
                        bounds = JavaMetamodel.getManager().getElementPosition(element);
                    }
                    finally {
                        repository.endTrans(false);
                    }
                    if (bounds != null && pane.getCaretPosition() == caretPos && (viewPos == null || viewPos.equals(((JViewport)parent).getViewPosition()))) {
                        pane.setCaretPosition(bounds.getBegin().getOffset());
                    }
                    JumpList.checkAddEntry((JTextComponent)pane);
                    pane.setCursor(editCursor);
                    StatusDisplayer.getDefault().setStatusText("");
                }
            });
            Container temp = pane;
            while (!(temp instanceof TopComponent)) {
                temp = temp.getParent();
            }
            ((TopComponent)temp).requestActive();
        }
    }

    private JavaPackage resolvePackage(String packageName, boolean caseSensitive) {
        JavaPackageClass pkgProxy = JavaModel.getDefaultExtent().getJavaPackage();
        if (caseSensitive) {
            return pkgProxy.resolvePackage(packageName);
        }
        return pkgProxy.resolvePackage(packageName);
    }

    private TagDefinition createTagDefinition(String def) {
        JavaModelPackage pkg = JavaModel.getDefaultExtent();
        return pkg.getTagDefinition().createTagDefinition(def);
    }

    private void addSubPackages(List list, JavaPackage pkg, boolean createResultItems) {
        NbJavaJMICompletionQuery.JMIItemFactory itemFactory = createResultItems ? NbJavaJMICompletionQuery.getJMIItemFactory() : null;
        Iterator iter = pkg.getSubPackages().iterator();
        while (iter.hasNext()) {
            JavaPackage p = (JavaPackage)iter.next();
            if (itemFactory != null) {
                list.add(itemFactory.createPackageResultItem(p));
            } else {
                list.add(p);
            }
            this.addSubPackages(list, p, createResultItems);
        }
    }

    private List getOuterClasses(JavaClass jc) {
        ArrayList<JavaClass> outers = new ArrayList<JavaClass>();
        outers.add(jc);
        while (jc.isInner() && (jc = (JavaClass)jc.getDeclaringClass()) != null) {
            outers.add(jc);
        }
        return outers;
    }

    private JavaClass getOutermostClass(JavaClass jc) {
        while (jc.isInner()) {
            JavaClass decl = (JavaClass)jc.getDeclaringClass();
            if (decl == null) {
                return jc;
            }
            jc = decl;
        }
        return jc;
    }

    private boolean isTopLevelClassAccessible(JavaClass cls, JavaClass from) {
        if (cls == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        if ((cls.getModifiers() & 1) != 0) {
            return true;
        }
        String pkgName = this.getPackageName((ClassDefinition)cls);
        String fromPkgName = this.getPackageName((ClassDefinition)from);
        return pkgName.equals(fromPkgName);
    }

    private boolean isAccessible(Feature feature, ClassDefinition cls, JavaClass from) {
        ClassDefinition decCls = feature.getDeclaringClass();
        AccessibilityDescriptor desc = new AccessibilityDescriptor(decCls, cls, from);
        return desc.isAccessible(feature.getModifiers());
    }

    public static boolean startsWith(String theString, String prefix) {
        return caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean matchesCamelCase(String simpleName, String prefix) {
        int pi = 0;
        for (int sni = 0; sni < simpleName.length() && pi < prefix.length(); ++sni) {
            char ch = simpleName.charAt(sni);
            if (!Character.isUpperCase(ch) || ch == prefix.charAt(pi++)) continue;
            return false;
        }
        return pi == prefix.length();
    }

    private byte getPrimitiveTypeIdx(Type type) {
        PrimitiveTypeKind kind;
        PrimitiveTypeKind primitiveTypeKind = kind = type instanceof PrimitiveType ? ((PrimitiveType)type).getKind() : null;
        if ("java.lang.Boolean".equals(type.getName()) || PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return 0;
        }
        if ("java.lang.Byte".equals(type.getName()) || PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return 1;
        }
        if ("java.lang.Char".equals(type.getName()) || PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return 2;
        }
        if ("java.lang.Double".equals(type.getName()) || PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return 3;
        }
        if ("java.lang.Float".equals(type.getName()) || PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return 4;
        }
        if ("java.lang.Integer".equals(type.getName()) || PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return 5;
        }
        if ("java.lang.Long".equals(type.getName()) || PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return 6;
        }
        if ("java.lang.Short".equals(type.getName()) || PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return 7;
        }
        return 8;
    }

    private Type getObjectType(PrimitiveType type) {
        PrimitiveTypeKind kind = type.getKind();
        if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return this.resolveType("java.lang.Boolean");
        }
        if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return this.resolveType("java.lang.Byte");
        }
        if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return this.resolveType("java.lang.Char");
        }
        if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return this.resolveType("java.lang.Double");
        }
        if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return this.resolveType("java.lang.Float");
        }
        if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return this.resolveType("java.lang.Integer");
        }
        if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return this.resolveType("java.lang.Long");
        }
        if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return this.resolveType("java.lang.Short");
        }
        return null;
    }

    public static Object findItemAtCaretPos(JTextComponent target) {
        try {
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)target);
            NbJavaJMICompletionQuery query = new NbJavaJMICompletionQuery(true);
            int dotPos = target.getCaret().getDot();
            BaseDocument doc = (BaseDocument)target.getDocument();
            int[] idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)doc, (int)dotPos);
            if (idFunBlk == null) {
                idFunBlk = new int[]{dotPos, dotPos};
            }
            if (idFunBlk.length == 3) {
                int endOfMethod = JCExtension.findEndOfMethod(target, idFunBlk[2]);
                if (endOfMethod > -1) {
                    dotPos = endOfMethod;
                }
            } else if (idFunBlk.length == 2) {
                dotPos = idFunBlk[1];
            }
            CompletionQuery.Result result = query.query(target, dotPos, sup, true);
            if (result != null && result.getData().size() > 0) {
                return JMIUtils.getAssociatedObject(result.getData().get(0));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static Object getAssociatedObject(Object item) {
        if (item instanceof NbJMIResultItem) {
            Object ret = ((NbJMIResultItem)item).getAssociatedObject();
            if (ret instanceof FakeConstructor) {
                ret = ((FakeConstructor)ret).getDeclaringClass();
            }
            if (ret != null) {
                return ret;
            }
        }
        return item;
    }

    private static void refreshSettings() {
        Class kitClass = JavaKit.class;
        caseSensitive = SettingsUtil.getBoolean((Class)kitClass, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
        naturalSort = SettingsUtil.getBoolean((Class)kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
        showDeprecated = SettingsUtil.getBoolean((Class)kitClass, (String)"show-deprecated-members", (Boolean)ExtSettingsDefaults.defaultShowDeprecatedMembers);
    }

    public static int getDefaultSelectionWeight(JavaClass cls) {
        int weight = 500;
        String fullName = cls.getName();
        if (fullName.startsWith("java.lang.") || fullName.startsWith("java.util.")) {
            weight += 100;
        } else if (fullName.startsWith("org.omg.") || fullName.startsWith("org.apache.")) {
            weight -= 100;
        } else if (fullName.startsWith("com.sun.") || fullName.startsWith("com.ibm.") || fullName.startsWith("com.apple.")) {
            weight -= 200;
        } else if (fullName.startsWith("sun.") || fullName.startsWith("sunw.") || fullName.startsWith("netscape.")) {
            weight -= 300;
        }
        if (!cls.isInner()) {
            weight += 1000;
        }
        return weight;
    }

    public static Comparator getNaturalMemberNameComparator() {
        return naturalSort ? INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR : NATURAL_MEMBER_NAME_COMPARATOR;
    }

    static {
        JMIUtils.refreshSettings();
        Settings.addSettingsChangeListener((SettingsChangeListener)settingsListener);
    }

    private static class FakeTagValue
    extends FakeBase
    implements TagValue {
        private TagDefinition def;
        private String value;

        public FakeTagValue(TagDefinition def, String value) {
            this.def = def;
            this.value = value;
        }

        public TagDefinition getDefinition() {
            return this.def;
        }

        public String getValue() {
            return this.value;
        }

        public void setDefinition(TagDefinition newValue) {
        }

        public void setValue(String newValue) {
        }
    }

    private static class FakeJavaDoc
    extends FakeBase
    implements JavaDoc {
        private List tags;
        private String text;

        public FakeJavaDoc(List tags, String text) {
            this.tags = tags;
            this.text = text;
        }

        public List getTags() {
            return this.tags;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String newValue) {
        }
    }

    private static class FakeTypedBase
    extends FakeBase {
        private String name;
        private Type type;

        public FakeTypedBase(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public List getAnnotations() {
            return Collections.EMPTY_LIST;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newValue) {
        }

        public Collection getReferences() {
            return null;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type newValue) {
        }

        public String refMofId() {
            return "JMIUtils-TypedBase-" + this.getName();
        }
    }

    private static class FakeBase {
        public Element duplicate() {
            return null;
        }

        public List getChildren() {
            return Collections.EMPTY_LIST;
        }

        public int getEndOffset() {
            return 0;
        }

        public int getPartEndOffset(ElementPartKind part) {
            return 0;
        }

        public int getPartStartOffset(ElementPartKind part) {
            return 0;
        }

        public Resource getResource() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public boolean isValid() {
            return true;
        }

        public void replaceChild(Element oldChild, Element newChild) {
        }

        public RefClass refClass() {
            return null;
        }

        public void refDelete() {
        }

        public RefFeatured refImmediateComposite() {
            return null;
        }

        public boolean refIsInstanceOf(RefObject refObject, boolean b) {
            return false;
        }

        public RefFeatured refOutermostComposite() {
            return null;
        }

        public Object refGetValue(RefObject refObject) {
            return null;
        }

        public Object refGetValue(String s) {
            return null;
        }

        public Object refInvokeOperation(RefObject refObject, List list) throws RefException {
            return null;
        }

        public Object refInvokeOperation(String s, List list) throws RefException {
            return null;
        }

        public void refSetValue(RefObject refObject, Object o) {
        }

        public void refSetValue(String s, Object o) {
        }

        public RefPackage refImmediatePackage() {
            return null;
        }

        public RefObject refMetaObject() {
            return null;
        }

        public String refMofId() {
            return null;
        }

        public RefPackage refOutermostPackage() {
            return null;
        }

        public Collection refVerifyConstraints(boolean b) {
            return null;
        }
    }

    private static class FakeParameter
    extends FakeTypedBase
    implements Parameter {
        public FakeParameter(String name, Type type) {
            super(name, type);
        }

        public boolean isVarArg() {
            return false;
        }

        public void setVarArg(boolean newValue) {
        }

        public boolean isFinal() {
            return false;
        }

        public void setFinal(boolean newValue) {
        }

        public TypeReference getTypeName() {
            return null;
        }

        public void setTypeName(TypeReference newValue) {
        }

        public int getDimCount() {
            return 0;
        }

        public void setDimCount(int newValue) {
        }
    }

    private static class FakeCallableFeature
    extends FakeTypedBase
    implements CallableFeature {
        private ClassDefinition declClass;
        private int modifiers;
        private List params;
        private JavaDoc javaDoc;

        public FakeCallableFeature(String name, ClassDefinition declClass, Type retType, List params, int modifiers, JavaDoc javaDoc) {
            super(name, retType);
            this.declClass = declClass;
            this.params = params;
            this.modifiers = modifiers;
            this.javaDoc = javaDoc;
        }

        public List getParameters() {
            return this.params;
        }

        public List getExceptionNames() {
            return Collections.EMPTY_LIST;
        }

        public List getExceptions() {
            return Collections.EMPTY_LIST;
        }

        public StatementBlock getBody() {
            return null;
        }

        public void setBody(StatementBlock newValue) {
        }

        public String getBodyText() {
            return null;
        }

        public void setBodyText(String newValue) {
        }

        public boolean isDeprecated() {
            return false;
        }

        public void setDeprecated(boolean newValue) {
        }

        public ClassDefinition getDeclaringClass() {
            return this.declClass;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(int newValue) {
        }

        public String getJavadocText() {
            return null;
        }

        public void setJavadocText(String newValue) {
        }

        public JavaDoc getJavadoc() {
            return this.javaDoc;
        }

        public void setJavadoc(JavaDoc newValue) {
        }

        public List getTypeParameters() {
            return Collections.EMPTY_LIST;
        }
    }

    static class FakeConstructor
    extends FakeCallableFeature
    implements Constructor {
        public FakeConstructor(ClassDefinition declClass, JavaDoc javaDoc) {
            super(null, declClass, (Type)declClass, Collections.EMPTY_LIST, 1, javaDoc);
        }
    }

    private static class FakeMethod
    extends FakeCallableFeature
    implements Method {
        public FakeMethod(String name, ClassDefinition declClass, Type retType, List params, JavaDoc javaDoc) {
            super(name, declClass, retType, params, 9, javaDoc);
        }

        public boolean signatureEquals(Method method) {
            return false;
        }

        public Collection findDependencies(boolean usages, boolean overridingMethods, boolean fromBaseClass) {
            return null;
        }

        public TypeReference getTypeName() {
            return null;
        }

        public void setTypeName(TypeReference newValue) {
        }

        public int getDimCount() {
            return 0;
        }

        public void setDimCount(int newValue) {
        }
    }

    private static final class NaturalMemberNameComparator
    implements Comparator {
        private boolean sensitive;

        public NaturalMemberNameComparator(boolean sensitive) {
            this.sensitive = sensitive;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            int order = this.getOrderLevel(o1) - this.getOrderLevel(o2);
            if (order != 0) {
                return order;
            }
            if (o1 instanceof NbJMIResultItem) {
                if (o2 instanceof NbJMIResultItem) {
                    String o1Text = ((NbJMIResultItem)o1).getItemText();
                    String o2Text = ((NbJMIResultItem)o2).getItemText();
                    int n = order = this.sensitive ? o1Text.compareTo(o2Text) : o1Text.compareToIgnoreCase(o2Text);
                    if (order != 0) {
                        return order;
                    }
                    List param1 = o1 instanceof NbJMIResultItem.CallableFeatureResultItem ? ((NbJMIResultItem.CallableFeatureResultItem)o1).getParams() : Collections.EMPTY_LIST;
                    List param2 = o2 instanceof NbJMIResultItem.CallableFeatureResultItem ? ((NbJMIResultItem.CallableFeatureResultItem)o2).getParams() : Collections.EMPTY_LIST;
                    int commonCnt = Math.min(param1.size(), param2.size());
                    for (int i = 0; i < commonCnt; ++i) {
                        int n2 = order = this.sensitive ? ((NbJMIResultItem.ParamStr)param1.get(i)).getTypeName().compareTo(((NbJMIResultItem.ParamStr)param2.get(i)).getTypeName()) : ((NbJMIResultItem.ParamStr)param1.get(i)).getTypeName().compareToIgnoreCase(((NbJMIResultItem.ParamStr)param2.get(i)).getTypeName());
                        if (order == 0) continue;
                        return order;
                    }
                    order = param1.size() - param2.size();
                    if (order != 0) {
                        return order;
                    }
                    int sameName = o1Text.compareTo(o2Text);
                    if (sameName != 0) {
                        return sameName;
                    }
                    o1 = ((NbJMIResultItem)o1).getAssociatedObject();
                    o2 = ((NbJMIResultItem)o2).getAssociatedObject();
                } else {
                    o1 = ((NbJMIResultItem)o1).getAssociatedObject();
                }
            } else if (o2 instanceof NbJMIResultItem) {
                o2 = ((NbJMIResultItem)o2).getAssociatedObject();
            }
            if (o1 instanceof Feature && o2 instanceof Feature) {
                String f2Name;
                String f1Name;
                Feature f1 = (Feature)o1;
                Feature f2 = (Feature)o2;
                String string = f1Name = f1 instanceof JavaClass ? ((JavaClass)f1).getSimpleName() : f1.getName();
                if (f1Name == null) {
                    f1Name = "";
                }
                String string2 = f2Name = f2 instanceof JavaClass ? ((JavaClass)f2).getSimpleName() : f2.getName();
                if (f2Name == null) {
                    f2Name = "";
                }
                int n = order = this.sensitive ? f1Name.compareTo(f2Name) : f1Name.compareToIgnoreCase(f2Name);
                if (order != 0) {
                    return order;
                }
                if (f1 instanceof JavaClass && f2 instanceof JavaClass) {
                    f1Name = f1.getName();
                    f2Name = f2.getName();
                    return this.sensitive ? f1Name.compareTo(f2Name) : f1Name.compareToIgnoreCase(f2Name);
                }
                List param1 = f1 instanceof CallableFeature ? ((CallableFeature)f1).getParameters() : Collections.EMPTY_LIST;
                Object[] params1 = param1.toArray();
                List param2 = f2 instanceof CallableFeature ? ((CallableFeature)f2).getParameters() : Collections.EMPTY_LIST;
                Object[] params2 = param2.toArray();
                int commonCnt = Math.min(params1.length, params2.length);
                for (int i = 0; i < commonCnt; ++i) {
                    String param1Name = ((Parameter)params1[i]).getType().getName();
                    if (((Parameter)params1[i]).isVarArg()) {
                        param1Name = param1Name + "...";
                    }
                    String param2Name = ((Parameter)params2[i]).getType().getName();
                    if (((Parameter)params2[i]).isVarArg()) {
                        param2Name = param2Name + "...";
                    }
                    int n3 = order = this.sensitive ? param1Name.compareTo(param2Name) : param1Name.compareToIgnoreCase(param2Name);
                    if (order == 0) continue;
                    return order;
                }
                order = params1.length - params2.length;
                if (order != 0) {
                    return order;
                }
                int sameName = f1Name.compareTo(f2Name);
                if (sameName != 0) {
                    return sameName;
                }
                return order;
            }
            if (o1 instanceof NamedElement && o2 instanceof NamedElement) {
                return this.sensitive ? ((NamedElement)o1).getName().compareTo(((NamedElement)o2).getName()) : ((NamedElement)o1).getName().compareToIgnoreCase(((NamedElement)o2).getName());
            }
            return 0;
        }

        private int getOrderLevel(Object o) {
            if (o instanceof NbJMIResultItem.FieldResultItem || o instanceof Field) {
                return 10;
            }
            if (o instanceof NbJMIResultItem.ConstructorResultItem || o instanceof Constructor) {
                return 20;
            }
            if (o instanceof NbJMIResultItem.MethodResultItem || o instanceof Method) {
                return 30;
            }
            if (o instanceof NbJMIResultItem.ClassResultItem || o instanceof JavaClass) {
                return 40;
            }
            return 50;
        }
    }

    private final class ClassesIterator
    implements Iterator {
        private LinkedList toVisit = new LinkedList();
        private HashSet addedToVisit = new HashSet();
        private boolean inspectSuperTypes;
        private boolean preferSources;
        private JavaClass objectClass = (JavaClass)JMIUtils.this.resolveType("java.lang.Object");

        public ClassesIterator(Type type, boolean inspectSuperTypes, boolean preferSources) {
            if (type instanceof ClassDefinition) {
                this.toVisit.add(type);
                this.addedToVisit.add(type.getName());
            }
            this.inspectSuperTypes = inspectSuperTypes;
            this.preferSources = preferSources;
        }

        public boolean hasNext() {
            return !this.toVisit.isEmpty();
        }

        public Object next() {
            ClassDefinition next = (ClassDefinition)this.toVisit.removeFirst();
            if (next == null) {
                throw new NoSuchElementException();
            }
            if (this.inspectSuperTypes) {
                String name;
                JavaClass superCls = next.getSuperClass();
                if (superCls == null) {
                    superCls = this.objectClass;
                }
                if (!this.addedToVisit.contains(name = superCls.getName())) {
                    this.toVisit.add(superCls);
                    this.addedToVisit.add(name);
                }
                Iterator it = next.getInterfaces().iterator();
                while (it.hasNext()) {
                    JavaClass iface = (JavaClass)it.next();
                    name = iface.getName();
                    if (this.addedToVisit.contains(name)) continue;
                    this.toVisit.add(iface);
                    this.addedToVisit.add(name);
                }
            }
            if (this.preferSources) {
                next = JMIUtils.getSourceElementIfExists(next);
            }
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SettingsListener
    implements SettingsChangeListener {
        public void settingsChange(SettingsChangeEvent evt) {
            JMIUtils.refreshSettings();
        }
    }

    private class AccessibilityDescriptor {
        int mprotected = -1;
        int mpackprivate = -1;
        int mprivate = -1;
        ClassDefinition decCls;
        ClassDefinition cls;
        JavaClass from;

        AccessibilityDescriptor(ClassDefinition decCls, ClassDefinition cls, JavaClass from) {
            if (from == null) {
                this.mprivate = 1;
                this.mpackprivate = 1;
                this.mprotected = 1;
                return;
            }
            if (cls instanceof TypeParameter) {
                cls = decCls;
            }
            if (cls != null && !from.equals(cls) && !JMIUtils.this.isAccessible(cls, from)) {
                this.mprivate = 0;
                this.mpackprivate = 0;
                this.mprotected = 0;
                return;
            }
            this.decCls = decCls;
            this.cls = cls;
            this.from = from;
        }

        private void computeProtectedAccess() {
            for (JavaClass jc = this.from; jc != null; jc = (JavaClass)jc.getDeclaringClass()) {
                if (!JMIUtils.this.isAssignable((Type)jc, (Type)this.decCls) || this.cls != null && !JMIUtils.this.isAssignable((Type)this.cls, (Type)jc)) continue;
                this.mprotected = 1;
                return;
            }
            this.mprotected = 0;
        }

        private void computePackagePrivateAccess() {
            String pkgName;
            String fromPkgName = JMIUtils.this.getPackageName((ClassDefinition)this.from);
            boolean mpackpriv = fromPkgName.equals(pkgName = JMIUtils.this.getPackageName(this.decCls));
            if (mpackpriv) {
                this.mpackprivate = 1;
                this.mprotected = 1;
            } else {
                this.mpackprivate = 0;
            }
        }

        private void computePrivateAccess() {
            boolean mpriv = JMIUtils.this.getOutermostClass(this.from).equals(this.decCls instanceof JavaClass ? JMIUtils.this.getOutermostClass(this.decCls instanceof ParameterizedType ? ((ParameterizedType)this.decCls).getDefinition() : (JavaClass)this.decCls) : null);
            if (mpriv) {
                this.mprivate = 1;
                this.mpackprivate = 1;
                this.mprotected = 1;
            } else {
                this.mprivate = 0;
            }
        }

        boolean isAccessible(int modifiers) {
            if (Modifier.isPublic(modifiers)) {
                return true;
            }
            if (this.mprivate == -1) {
                this.computePrivateAccess();
            }
            if (this.mprivate == 1) {
                return true;
            }
            if (Modifier.isPrivate(modifiers)) {
                return false;
            }
            if (this.mpackprivate == -1) {
                this.computePackagePrivateAccess();
            }
            if (this.mpackprivate == 1) {
                return true;
            }
            if (!Modifier.isProtected(modifiers)) {
                return false;
            }
            if (this.mprotected == -1) {
                this.computeProtectedAccess();
            }
            return this.mprotected == 1;
        }
    }
}

