/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class AddDriverDialog
extends JPanel {
    private DefaultListModel dlm;
    private List drvs;
    private boolean customizer = false;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private static final String BUNDLE = "org.netbeans.modules.db.resources.Bundle";
    private JButton browseButton;
    private JComboBox drvClassComboBox;
    private JLabel drvClassLabel;
    private JList drvList;
    private JLabel drvListLabel;
    private JScrollPane drvListScrollPane;
    private JButton findButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JButton removeButton;

    public AddDriverDialog() {
        this.initComponents();
        this.initAccessibility();
        this.dlm = (DefaultListModel)this.drvList.getModel();
        this.drvs = new LinkedList();
    }

    public AddDriverDialog(JDBCDriver drv) {
        this();
        this.customizer = true;
        URL[] urls = drv.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            String fileName;
            FileObject fo = URLMapper.findFileObject((URL)urls[i]);
            if (fo == null) {
                try {
                    fileName = new File(new URI(urls[i].toExternalForm())).getAbsolutePath();
                }
                catch (URISyntaxException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    fileName = null;
                }
            } else {
                fileName = FileUtil.toFile((FileObject)fo).getAbsolutePath();
            }
            if (fileName == null) continue;
            this.dlm.addElement(fileName);
            this.drvs.add(urls[i]);
        }
        this.drvClassComboBox.addItem(drv.getClassName());
        this.drvClassComboBox.setSelectedItem(drv.getClassName());
        this.nameTextField.setText(drv.getDisplayName());
    }

    private void initAccessibility() {
        ResourceBundle b = NbBundle.getBundle((String)BUNDLE);
        this.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverDialogA11yDesc"));
        this.drvListLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverDriverFileA11yDesc"));
        this.drvList.getAccessibleContext().setAccessibleName(b.getString("ACS_AddDriverDriverFileListA11yName"));
        this.drvClassLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverDriverDriverClassA11yDesc"));
        this.drvClassComboBox.getAccessibleContext().setAccessibleName(b.getString("ACS_AddDriverDriverDriverClassComboBoxA11yName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverDriverNameA11yDesc"));
        this.nameTextField.getAccessibleContext().setAccessibleName(b.getString("ACS_AddDriverDriverNameTextFieldA11yName"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverAddButtonA11yDesc"));
        this.findButton.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverRemoveButtonA11yDesc"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverFindButtonA11yDesc"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleName(b.getString("ACS_AddDriverProgressBarA11yName"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AddDriverProgressBarA11yDesc"));
    }

    private void initComponents() {
        this.drvListLabel = new JLabel();
        this.drvListScrollPane = new JScrollPane();
        this.drvList = new JList();
        this.browseButton = new JButton();
        this.removeButton = new JButton();
        this.drvClassLabel = new JLabel();
        this.drvClassComboBox = new JComboBox();
        this.findButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.drvListLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverFile_Mnemonic").charAt(0));
        this.drvListLabel.setLabelFor(this.drvList);
        this.drvListLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.drvListLabel, gridBagConstraints);
        this.drvList.setModel(new DefaultListModel());
        this.drvListScrollPane.setViewportView(this.drvList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.drvListScrollPane, gridBagConstraints);
        this.browseButton.setMnemonic(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverAdd_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverAdd"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDriverDialog.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.removeButton.setMnemonic(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverRemove_Mnemonic").charAt(0));
        this.removeButton.setText(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverRemove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDriverDialog.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.drvClassLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverClass_Mnemonic").charAt(0));
        this.drvClassLabel.setLabelFor(this.drvClassComboBox);
        this.drvClassLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.drvClassLabel, gridBagConstraints);
        this.drvClassComboBox.setEditable(true);
        this.drvClassComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDriverDialog.this.drvClassComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 12);
        this.add((Component)this.drvClassComboBox, gridBagConstraints);
        this.findButton.setMnemonic(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverFind_Mnemonic").charAt(0));
        this.findButton.setText(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverFind"));
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDriverDialog.this.findButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.findButton, gridBagConstraints);
        this.nameLabel.setDisplayedMnemonic(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverName_Mnemonic").charAt(0));
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameLabel.setText(NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 12);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.progressMessageLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.progressMessageLabel, gridBagConstraints);
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.progressContainerPanel, gridBagConstraints);
    }

    private void drvClassComboBoxActionPerformed(ActionEvent evt) {
        if (!this.customizer) {
            this.nameTextField.setText(DriverListUtil.findFreeName(DriverListUtil.getName((String)this.drvClassComboBox.getSelectedItem())));
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.stopProgress();
        ListSelectionModel lsm = this.drvList.getSelectionModel();
        int count = this.dlm.getSize();
        int i = 0;
        if (count < 1) {
            return;
        }
        do {
            if (lsm.isSelectedIndex(i)) {
                this.dlm.remove(i);
                this.drvs.remove(i);
                --count;
                continue;
            }
            ++i;
        } while (count != i);
        this.findDriverClass();
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AddDriverDialog.this.startProgress();
                for (int i = 0; i < AddDriverDialog.this.drvs.size(); ++i) {
                    try {
                        URL url = (URL)AddDriverDialog.this.drvs.get(i);
                        File file = new File(new URI(url.toExternalForm()));
                        JarFile jf = new JarFile(file);
                        try {
                            Enumeration<JarEntry> entries = jf.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry entry = entries.nextElement();
                                String className = entry.getName();
                                if (!className.endsWith(".class")) continue;
                                className = className.replace('/', '.');
                                className = className.substring(0, className.length() - 6);
                                InputStream stream = jf.getInputStream(entry);
                                try {
                                    ClassFile classFile = new ClassFile(stream, false);
                                    Iterator iter = classFile.getInterfaces().iterator();
                                    while (iter.hasNext()) {
                                        ClassName interfaceName = (ClassName)iter.next();
                                        if (!"java.sql.Driver".equals(interfaceName.getExternalName())) continue;
                                        AddDriverDialog.this.addDriverClass(className);
                                    }
                                }
                                finally {
                                    stream.close();
                                }
                            }
                            continue;
                        }
                        finally {
                            jf.close();
                        }
                    }
                    catch (IOException exc) {
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                AddDriverDialog.this.stopProgress();
            }
        }, 0);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.stopProgress();
        JFileChooser fc = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fc, null);
        fc.setDialogTitle(NbBundle.getBundle((String)BUNDLE).getString("AddDriver_Chooser_Title"));
        fc.setMultiSelectionEnabled(true);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
            }

            public String getDescription() {
                return NbBundle.getBundle((String)AddDriverDialog.BUNDLE).getString("AddDriver_Chooser_Filter");
            }
        });
        if (fc.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File[] files = fc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || !files[i].isFile()) continue;
                this.dlm.addElement(files[i].toString());
                try {
                    this.drvs.add(files[i].toURI().toURL());
                    continue;
                }
                catch (MalformedURLException exc) {
                    // empty catch block
                }
            }
            this.findDriverClass();
        }
    }

    public String getDisplayName() {
        return this.nameTextField.getText();
    }

    public List getDriverLocation() {
        return this.drvs;
    }

    public String getDriverClass() {
        return (String)this.drvClassComboBox.getSelectedItem();
    }

    private void findDriverClass() {
        String[] drivers = DriverListUtil.getDrivers().toArray(new String[DriverListUtil.getDrivers().size()]);
        this.drvClassComboBox.removeAllItems();
        for (int i = 0; i < this.drvs.size(); ++i) {
            try {
                URL url = (URL)this.drvs.get(i);
                File file = new File(new URI(url.toExternalForm()));
                JarFile jf = new JarFile(file);
                for (int j = 0; j < drivers.length; ++j) {
                    if (jf.getEntry(drivers[j].replace('.', '/') + ".class") == null) continue;
                    this.addDriverClass(drivers[j]);
                }
                jf.close();
                continue;
            }
            catch (IOException exc) {
                continue;
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }

    private void addDriverClass(String drv) {
        if (((DefaultComboBoxModel)this.drvClassComboBox.getModel()).getIndexOf(drv) < 0) {
            this.drvClassComboBox.addItem(drv);
        }
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddDriverDialog.this.progressHandle = ProgressHandleFactory.createHandle(null);
                AddDriverDialog.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)AddDriverDialog.this.progressHandle);
                AddDriverDialog.this.progressContainerPanel.add((Component)AddDriverDialog.this.progressComponent, "Center");
                AddDriverDialog.this.progressHandle.start();
                AddDriverDialog.this.progressMessageLabel.setText(NbBundle.getBundle((String)AddDriverDialog.BUNDLE).getString("AddDriverProgressStart"));
            }
        });
    }

    private void stopProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AddDriverDialog.this.progressHandle != null) {
                    AddDriverDialog.this.progressHandle.finish();
                    AddDriverDialog.this.progressHandle = null;
                    AddDriverDialog.this.progressMessageLabel.setText(" ");
                    AddDriverDialog.this.progressContainerPanel.remove(AddDriverDialog.this.progressComponent);
                    AddDriverDialog.this.repaint();
                }
            }
        });
    }
}

