/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.ProcedureNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DatabaseNodeChildren
extends Children.Array {
    private ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    private TreeSet children;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private static Object sync = new Object();
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("finished")) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        DatabaseNodeChildren.this.remove(DatabaseNodeChildren.this.getNodes());
                        DatabaseNodeChildren.this.nodes = DatabaseNodeChildren.this.getCh();
                        DatabaseNodeChildren.this.refresh();
                    }
                });
                DatabaseNodeChildren.this.removeListener();
            }
        }
    };

    protected Collection initCollection() {
        this.propertySupport.addPropertyChangeListener(this.listener);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DatabaseNodeInfo nodeinfo = ((DatabaseNode)DatabaseNodeChildren.this.getNode()).getInfo();
                Map nodeord = (Map)nodeinfo.get("children_ordering");
                boolean sort = !nodeinfo.getName().equals("Drivers") && !(nodeinfo instanceof TableNodeInfo) && !(nodeinfo instanceof ViewNodeInfo) && !(nodeinfo instanceof ProcedureNodeInfo);
                TreeSet<Node> children = new TreeSet<Node>(new NodeComparator(nodeord, sort));
                try {
                    Vector chlist;
                    Object object = sync;
                    synchronized (object) {
                        chlist = nodeinfo.getChildren();
                    }
                    for (int i = 0; i < chlist.size(); ++i) {
                        Object snode = null;
                        Object sinfo = chlist.elementAt(i);
                        if (sinfo instanceof DatabaseNodeInfo) {
                            DatabaseNodeInfo dni = (DatabaseNodeInfo)sinfo;
                            snode = DatabaseNodeChildren.this.createNode(dni);
                        } else if (sinfo instanceof Node) {
                            snode = (Node)sinfo;
                        }
                        if (snode == null) continue;
                        children.add((Node)snode);
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    DatabaseNodeChildren.this.showException(e);
                    children.clear();
                }
                DatabaseNodeChildren.this.setCh(children);
                DatabaseNodeChildren.this.propertySupport.firePropertyChange("finished", null, null);
            }
        }, 0);
        TreeSet<Node> ts = new TreeSet<Node>();
        ts.add(this.createWaitNode());
        return ts;
    }

    public boolean getChildrenInitialized() {
        return this.isInitialized();
    }

    private Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(this.bundle.getString("WaitNode"));
        n.setIconBase("org/netbeans/modules/db/resources/wait");
        return n;
    }

    private TreeSet getCh() {
        return this.children;
    }

    private void setCh(TreeSet children) {
        this.children = children;
    }

    private void removeListener() {
        this.propertySupport.removePropertyChangeListener(this.listener);
    }

    public DatabaseNode createNode(DatabaseNodeInfo info) {
        String nclass = (String)info.get("class");
        DatabaseNode node = null;
        try {
            node = (DatabaseNode)((Object)Class.forName(nclass).newInstance());
            node.setInfo(info);
            node.getInfo().setNode(node);
        }
        catch (Exception e) {
            this.showException(e);
        }
        return node;
    }

    public DatabaseNode createSubnode(DatabaseNodeInfo info, boolean addToChildrenFlag) throws DatabaseException {
        DatabaseNode subnode = this.createNode(info);
        if (subnode != null && addToChildrenFlag) {
            DatabaseNodeInfo ninfo = ((DatabaseNode)this.getNode()).getInfo();
            ninfo.getChildren().add(info);
            if (this.isInitialized()) {
                this.add(new Node[]{subnode});
            }
        }
        return subnode;
    }

    private void showException(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
                String format = bundle.getString("EXC_ConnectionIsBroken");
                String message = bundle.getString("ReadStructureErrorPrefix") + " " + MessageFormat.format(format, e.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
        });
    }

    class NodeComparator
    implements Comparator {
        private Map map = null;
        private boolean sort;

        public NodeComparator(Map map, boolean sort) {
            this.map = map;
            this.sort = sort;
        }

        public int compare(Object o1, Object o2) {
            Integer o2i;
            int o2val;
            if (!this.sort) {
                return 1;
            }
            if (!(o1 instanceof DatabaseNode)) {
                return -1;
            }
            if (!(o2 instanceof DatabaseNode)) {
                return 1;
            }
            Integer o1i = (Integer)this.map.get(o1.getClass().getName());
            int o1val = o1i != null ? o1i : Integer.MAX_VALUE;
            int diff = o1val - (o2val = (o2i = (Integer)this.map.get(o2.getClass().getName())) != null ? o2i : Integer.MAX_VALUE);
            if (diff == 0) {
                return ((DatabaseNode)((Object)o1)).getInfo().getName().compareTo(((DatabaseNode)((Object)o2)).getInfo().getName());
            }
            return diff;
        }
    }
}

