/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.web.monitor.client.ComboBoxTableCellEditor;
import org.netbeans.modules.web.monitor.client.DisplayTableModel;
import org.netbeans.modules.web.monitor.client.DisplayTableSorter;
import org.netbeans.modules.web.monitor.client.NameValueCellEditor;
import org.netbeans.modules.web.monitor.data.Param;
import org.openide.util.NbBundle;

public class DisplayTable
extends JTable {
    private static final boolean debug = false;
    public static final int UNEDITABLE = 0;
    public static final int REQUEST = 1;
    public static final int SERVER = 2;
    public static final int HEADERS = 3;
    public static final int PARAMS = 4;
    public static final int COOKIES = 5;
    public static final int NEUTRAL = 0;
    public static final int A2Z = 1;
    public static final int Z2A = 2;
    private int numRows = 0;
    private int numCols = 3;
    private Object[][] data = null;
    private TableCellEditor[][] cellEditors = null;
    private boolean editableNames = false;
    private int editable = 0;
    private int sort = 0;
    private boolean sortable = false;
    boolean fontChanged = true;

    public DisplayTable(String[] categories) {
        this(categories, null, 0, false);
    }

    public DisplayTable(String[] categories, boolean sortable) {
        this(categories, null, 0, sortable);
    }

    public DisplayTable(String[] categories, int editable) {
        this(categories, null, editable, false);
    }

    public DisplayTable(String[] categories, int editable, boolean sortable) {
        this(categories, null, editable, sortable);
    }

    public DisplayTable(String[] names, String[] values) {
        this(names, values, 0, false);
    }

    public DisplayTable(String[] names, String[] values, boolean sortable) {
        this(names, values, 0, sortable);
    }

    public DisplayTable(String[] names, String[] values, int editable) {
        this(names, values, editable, false);
    }

    public DisplayTable(String[] names, String[] values, int editable, boolean sortable) {
        this.numRows = names.length;
        this.editableNames = false;
        this.editable = editable;
        this.sortable = sortable;
        this.data = new Object[this.numRows][this.numCols];
        this.cellEditors = new TableCellEditor[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            this.data[i][0] = names[i];
            this.data[i][1] = values == null ? new String("") : values[i];
            this.data[i][2] = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$DisplayTable == null ? DisplayTable.class$("org.netbeans.modules.web.monitor.client.DisplayTable") : class$org$netbeans$modules$web$monitor$client$DisplayTable)).getString("MON_Edit_dots");
            this.cellEditors[i][2] = NameValueCellEditor.createCellEditor(this, this.data, false, i, editable);
        }
        this.setMyModel(this.data, editable > 0);
        this.setup();
    }

    public DisplayTable(Param[] params) {
        this(params, 0, false);
    }

    public DisplayTable(Param[] params, boolean sortable) {
        this(params, 0, sortable);
    }

    public DisplayTable(Param[] params, int editable) {
        this(params, editable, false);
    }

    public DisplayTable(Param[] params, int editable, boolean sortable) {
        this.editableNames = editable >= 3;
        this.editable = editable;
        this.sortable = sortable;
        this.numRows = params.length;
        this.data = new Object[this.numRows][this.numCols];
        this.cellEditors = new TableCellEditor[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            this.data[i][0] = params[i].getAttributeValue("name");
            this.data[i][1] = params[i].getAttributeValue("value");
            this.data[i][2] = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$DisplayTable == null ? DisplayTable.class$("org.netbeans.modules.web.monitor.client.DisplayTable") : class$org$netbeans$modules$web$monitor$client$DisplayTable)).getString("MON_Edit_dots");
            this.cellEditors[i][2] = NameValueCellEditor.createCellEditor(this, this.data, true, i, editable);
        }
        this.setMyModel(this.data, editable > 0);
        this.setup();
    }

    private void setup() {
        this.setBorderAndColorScheme();
        Dimension margins = new Dimension(6, 4);
        this.setIntercellSpacing(margins);
        this.sort();
    }

    private void setBorderAndColorScheme() {
        this.setBorderAndColorScheme(this.editable != 0);
    }

    private void setBorderAndColorScheme(boolean editable) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color bg = !editable ? this.getBackground().darker() : Color.white;
        this.setTableHeader(null);
        this.setBackground(bg);
    }

    public JComboBox setChoices(int row, int col, String[] choices, boolean editable) {
        ComboBoxTableCellEditor ed = new ComboBoxTableCellEditor(choices);
        this.cellEditors[row][col] = ed;
        this.data[row][2] = NbBundle.getBundle((Class)DisplayTable.class).getString("MON_Editing");
        this.cellEditors[row][2] = null;
        return ed.getComboBox();
    }

    public TableCellEditor getCellEditor(int row, int col) {
        TableCellEditor ed = this.cellEditors[row][col];
        if (ed == null) {
            return super.getCellEditor(row, col);
        }
        return ed;
    }

    public void setSorting(int state) {
        this.sort = state;
        if (this.getModel() instanceof DisplayTableSorter) {
            ((DisplayTableSorter)this.getModel()).sort(this.sort);
        }
    }

    public void sort() {
        if (this.getModel() instanceof DisplayTableSorter) {
            ((DisplayTableSorter)this.getModel()).sort(this.sort);
        }
    }

    private void setMyModel(Object[][] data, boolean canEdit) {
        DisplayTableModel model = new DisplayTableModel(data, canEdit, this.editable > 2);
        if (this.sortable) {
            DisplayTableSorter sorter = new DisplayTableSorter(model);
            this.setModel(sorter);
        } else {
            this.setModel(model);
        }
        TableColumnModel tcm = this.getColumnModel();
        if (tcm.getColumnCount() > 0) {
            TableColumn column = tcm.getColumn(0);
            column.setPreferredWidth(10);
            tcm.getColumn(2).setMaxWidth(5);
        }
    }

    public void addTableModelListener(TableModelListener tml) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.addTableModelListener(tml);
        }
    }

    public void removeTableModelListener(TableModelListener tml) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.removeTableModelListener(tml);
        }
    }

    public Object[][] getData() {
        return this.data;
    }

    public void setFont(Font f) {
        this.fontChanged = true;
        super.setFont(f);
    }

    public void paint(Graphics g) {
        if (this.fontChanged) {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            int rowHeight = fm.getHeight();
            this.fontChanged = false;
            this.setRowHeight(rowHeight);
            return;
        }
        super.paint(g);
    }

    private void log(String s) {
        System.out.println("DisplayTable::" + s);
    }
}

