/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.clazz.SerParser;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class SerStructureNode {
    static /* synthetic */ Class class$org$netbeans$modules$clazz$SerStructureNode;

    private SerStructureNode() {
    }

    private static String prettify(String type) {
        if (type.equals("B")) {
            return "byte";
        }
        if (type.equals("S")) {
            return "short";
        }
        if (type.equals("I")) {
            return "int";
        }
        if (type.equals("J")) {
            return "long";
        }
        if (type.equals("F")) {
            return "float";
        }
        if (type.equals("D")) {
            return "double";
        }
        if (type.equals("C")) {
            return "char";
        }
        if (type.equals("Z")) {
            return "boolean";
        }
        if (type.startsWith("L") && type.endsWith(";")) {
            String fqn = type.substring(1, type.length() - 1).replace('/', '.').replace('$', '.');
            if (fqn.startsWith("java.lang.")) {
                fqn = fqn.substring(10, fqn.length());
            }
            return fqn;
        }
        if (type.startsWith("[")) {
            return SerStructureNode.prettify(type.substring(1, type.length())) + "[]";
        }
        return "ILLEGAL<" + type + ">";
    }

    private static final class NbMarshalledObjectChildren
    extends Children.Keys {
        private final SerParser.ObjectWrapper ow;

        public NbMarshalledObjectChildren(SerParser.ObjectWrapper ow) {
            this.ow = ow;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(Collections.singleton(Boolean.TRUE));
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            List pairs = this.ow.data;
            Iterator it = pairs.iterator();
            while (it.hasNext()) {
                Object pair = it.next();
                if (!(pair instanceof SerParser.NameValue)) continue;
                SerParser.NameValue nv = (SerParser.NameValue)pair;
                if (!nv.name.name.equals("objBytes") || !nv.name.type.equals("[B")) continue;
                SerParser.ArrayWrapper aw = (SerParser.ArrayWrapper)nv.value;
                List vals = aw.values;
                byte[] b = new byte[vals.size()];
                for (int i = 0; i < b.length; ++i) {
                    b[i] = (Byte)vals.get(i);
                }
                ByteArrayInputStream is = new ByteArrayInputStream(b);
                try {
                    SerParser.Stream stream = new SerParser(is).parse();
                    return new Node[]{new StreamNode(stream)};
                }
                catch (SerParser.CorruptException spce) {
                    ErrorManager.getDefault().notify(1, (Throwable)spce);
                    return new Node[0];
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                    return new Node[0];
                }
                catch (RuntimeException re) {
                    ErrorManager.getDefault().notify((Throwable)re);
                    return new Node[0];
                }
            }
            return new Node[0];
        }
    }

    private static class GeneralChildren
    extends Children.Keys {
        private final List things;

        public GeneralChildren(List things) {
            this.things = things;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.things);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{this.createNode(key)};
        }

        protected Node createNode(Object key) {
            if (key instanceof SerParser.NameValue) {
                SerParser.NameValue nv = (SerParser.NameValue)key;
                Node n = this.createNode(nv.value);
                n.setName(SerStructureNode.prettify(nv.name.type) + " " + nv.name.name + " = " + n.getName());
                return n;
            }
            if (key instanceof SerParser.ObjectWrapper) {
                SerParser.ObjectWrapper ow = (SerParser.ObjectWrapper)key;
                String name = SerStructureNode.prettify(ow.classdesc.name);
                Children.Keys ch = name.equals("org.openide.util.io.NbMarshalledObject") ? new NbMarshalledObjectChildren(ow) : new GeneralChildren(ow.data);
                AbstractNode n = new AbstractNode((Children)ch);
                n.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$clazz$SerStructureNode == null ? (class$org$netbeans$modules$clazz$SerStructureNode = SerStructureNode.class$("org.netbeans.modules.clazz.SerStructureNode")) : class$org$netbeans$modules$clazz$SerStructureNode), (String)"LBL_instance_of", (Object)name));
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            if (key instanceof SerParser.ArrayWrapper) {
                SerParser.ArrayWrapper aw = (SerParser.ArrayWrapper)key;
                AbstractNode n = new AbstractNode((Children)new GeneralChildren(aw.values));
                if (!aw.classdesc.name.startsWith("[")) {
                    throw new IllegalStateException("Strange array name: " + aw.classdesc.name);
                }
                n.setName(SerStructureNode.prettify(aw.classdesc.name.substring(1, aw.classdesc.name.length())) + "[" + aw.values.size() + "]");
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            if (key instanceof byte[]) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName(SerParser.hexify((byte[])key));
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            if (key instanceof SerParser.ClassDesc) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName("class " + SerStructureNode.prettify(((SerParser.ClassDesc)key).name));
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            if (key == SerParser.NULL) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName("null");
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            if (key instanceof String) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName("\"" + (String)key + "\"");
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            if (key instanceof Boolean || key instanceof Character || key instanceof Byte || key instanceof Short || key instanceof Integer || key instanceof Long || key instanceof Float || key instanceof Double) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName(key.toString());
                n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return n;
            }
            AbstractNode n = new AbstractNode(Children.LEAF);
            n.setName("What is this? " + key + " [" + key.getClass().getName() + "]");
            n.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
            return n;
        }
    }

    public static final class StreamNode
    extends AbstractNode {
        public StreamNode(SerParser.Stream s) {
            super((Children)new GeneralChildren(s.contents));
            this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$clazz$SerStructureNode == null ? (class$org$netbeans$modules$clazz$SerStructureNode = SerStructureNode.class$("org.netbeans.modules.clazz.SerStructureNode")) : class$org$netbeans$modules$clazz$SerStructureNode), (String)"LBL_ser_stream"));
            this.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
        }
    }
}

