/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ToolTipSupport;

public class ExtEditorUI
extends EditorUI {
    private ToolTipSupport toolTipSupport;
    private JPopupMenu popupMenu;
    private Completion completion;
    private PopupManager popupManager;
    private CompletionJavaDoc completionJavaDoc;
    private boolean noCompletion;
    private boolean noCompletionJavaDoc;

    public ExtEditorUI() {
        this.getToolTipSupport();
        this.getCompletion();
        this.getCompletionJavaDoc();
    }

    public ToolTipSupport getToolTipSupport() {
        if (this.toolTipSupport == null) {
            this.toolTipSupport = new ToolTipSupport(this);
        }
        return this.toolTipSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completion getCompletion() {
        if (this.completion == null) {
            if (this.noCompletion) {
                return null;
            }
            Object object = this.getComponentLock();
            synchronized (object) {
                BaseKit kit;
                JTextComponent component = this.getComponent();
                if (component != null && (kit = Utilities.getKit(component)) != null && kit instanceof ExtKit) {
                    this.completion = ((ExtKit)kit).createCompletion(this);
                    if (this.completion == null) {
                        this.noCompletion = true;
                    }
                }
            }
        }
        return this.completion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionJavaDoc getCompletionJavaDoc() {
        if (this.completionJavaDoc == null) {
            if (this.noCompletionJavaDoc) {
                return null;
            }
            Object object = this.getComponentLock();
            synchronized (object) {
                BaseKit kit;
                JTextComponent component = this.getComponent();
                if (component != null && (kit = Utilities.getKit(component)) != null && kit instanceof ExtKit) {
                    this.completionJavaDoc = ((ExtKit)kit).createCompletionJavaDoc(this);
                    if (this.completionJavaDoc == null) {
                        this.noCompletionJavaDoc = true;
                    }
                }
            }
        }
        return this.completionJavaDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupManager getPopupManager() {
        if (this.popupManager == null) {
            Object object = this.getComponentLock();
            synchronized (object) {
                JTextComponent component = this.getComponent();
                if (component != null) {
                    this.popupManager = new PopupManager(component);
                }
            }
        }
        return this.popupManager;
    }

    public void showPopupMenu(int x, int y) {
        JTextComponent component = this.getComponent();
        if (component != null) {
            JPopupMenu pm;
            Action a;
            BaseKit kit = Utilities.getKit(component);
            if (kit != null && (a = kit.getActionByName("build-popup-menu")) != null) {
                a.actionPerformed(new ActionEvent(component, 0, ""));
            }
            if ((pm = this.getPopupMenu()) != null && component.isShowing()) {
                pm.show(component, x, y);
            }
        }
    }

    public void hidePopupMenu() {
        JPopupMenu pm = this.getPopupMenu();
        if (pm != null) {
            pm.setVisible(false);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }
}

