/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappConfiguration
implements DeploymentConfiguration,
PropertyChangeListener,
XpathListener {
    private final DeployableObject deplObj;
    private final int tomcatVersion;
    private DataObject contextDataObject;
    private File contextXml;
    private Context context;
    private final String ATTR_PATH = "path";

    public WebappConfiguration(DeployableObject deplObj, int aTomcatVersion) {
        this.deplObj = deplObj;
        this.tomcatVersion = aTomcatVersion;
    }

    public void init(File contextXml) {
        DDBeanRoot root;
        this.contextXml = contextXml;
        this.getContext();
        if (this.contextDataObject == null) {
            try {
                this.contextDataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)contextXml));
                this.contextDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
        if ((root = this.deplObj.getDDBeanRoot()) != null) {
            root.addXpathListener("/web-app/resource-ref", (XpathListener)this);
        }
    }

    public synchronized Context getContext() {
        if (this.context == null) {
            try {
                if (this.contextXml.exists()) {
                    try {
                        this.context = Context.createGraph(this.contextXml);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                    catch (RuntimeException re) {
                        ErrorManager.getDefault().notify(1, (Throwable)re);
                    }
                } else {
                    this.context = this.genereateContext();
                    this.writefile(this.contextXml);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.context;
    }

    public String getContextPath() throws ConfigurationException {
        Context ctx = this.getContext();
        if (ctx == null) {
            throw new ConfigurationException("Context.xml is not parseable, cannot read the context path value.");
        }
        return ctx.getAttributeValue("path");
    }

    Set<Datasource> getDatasources() {
        Context context = this.getContext();
        if (context == null) {
            ErrorManager.getDefault().log(1, "Context.xml is not parseable, cannot get the module datasources");
            return Collections.emptySet();
        }
        HashSet<Datasource> result = new HashSet<Datasource>();
        int length = context.getResource().length;
        if (this.tomcatVersion == 1) {
            for (int i = 0; i < length; ++i) {
                String type = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(type)) continue;
                String name = context.getResourceName(i);
                String username = context.getResourceUsername(i);
                String url = context.getResourceUrl(i);
                String password = context.getResourcePassword(i);
                String driverClassName = context.getResourceDriverClassName(i);
                if (name == null || username == null || url == null || driverClassName == null) continue;
                result.add(new TomcatDatasource(username, url, password, name, driverClassName));
            }
        } else {
            ResourceParams[] resourceParams = context.getResourceParams();
            for (int i = 0; i < length; ++i) {
                String type = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(type)) continue;
                String name = context.getResourceName(i);
                for (int j = 0; j < resourceParams.length; ++j) {
                    if (!name.equals(resourceParams[j].getName())) continue;
                    Parameter[] params = resourceParams[j].getParameter();
                    HashMap<String, String> paramNameValueMap = new HashMap<String, String>(params.length);
                    for (Parameter parameter : params) {
                        paramNameValueMap.put(parameter.getName(), parameter.getValue());
                    }
                    String username = (String)paramNameValueMap.get("username");
                    String url = (String)paramNameValueMap.get("url");
                    String password = (String)paramNameValueMap.get("password");
                    String driverClassName = (String)paramNameValueMap.get("driverClassName");
                    if (username == null || url == null || driverClassName == null) continue;
                    result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                }
            }
        }
        return result;
    }

    Datasource createDatasource(String jndiName, String url, String username, String password, String driver) throws ConfigurationException, DatasourceAlreadyExistsException {
        return this.createJDBCReference(jndiName, url, username, password, driver);
    }

    public void setContextPath(String contextPath) throws ConfigurationException {
        if (!this.isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            StringTokenizer tok = new StringTokenizer(contextPath, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebappConfiguration.class, (String)"MSG_invalidCP", (Object)contextPath), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextPath = ctxRoot;
        }
        final String newContextPath = contextPath;
        this.modifyContext(new ContextModifier(){

            public void modify(Context context) {
                if (WebappConfiguration.this.tomcatVersion == 0) {
                    String oldContextPath = context.getAttributeValue("path");
                    String oldPrefix = context.getLoggerPrefix();
                    if (oldPrefix != null && oldPrefix.equals(WebappConfiguration.this.computeLoggerPrefix(oldContextPath))) {
                        context.setLoggerPrefix(WebappConfiguration.this.computeLoggerPrefix(newContextPath));
                    }
                }
                context.setAttributeValue("path", newContextPath);
            }
        });
    }

    public DataObject getContextDataObject() {
        return this.contextDataObject;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            this.context = null;
        }
    }

    public void fireXpathEvent(XpathEvent xpe) {
        DDBean eventDDBean = xpe.getBean();
        if ("/web-app/resource-ref".equals(eventDDBean.getXpath()) && xpe.isAddEvent()) {
            String[] name = eventDDBean.getText("res-ref-name");
            String[] type = eventDDBean.getText("res-type");
            if (name.length > 0 && type.length > 0) {
                try {
                    this.addResReference(name[0], type[0]);
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify(1, (Throwable)ce);
                }
            }
        }
    }

    public DeployableObject getDeployableObject() {
        return this.deplObj;
    }

    public void save(OutputStream os) throws ConfigurationException {
        Context ctx = this.getContext();
        if (ctx == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            ctx.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
        throw new BeanNotFoundException("Bean not found in WebappConfiguration " + dConfigBeanRoot);
    }

    public void restore(InputStream is) throws ConfigurationException {
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream is, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void saveDConfigBean(OutputStream os, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
    }

    private Context genereateContext() {
        Context newContext = new Context();
        String path = "";
        newContext.setAttributeValue("path", path);
        if (this.tomcatVersion == 0) {
            newContext.setLogger(true);
            newContext.setLoggerClassName("org.apache.catalina.logger.FileLogger");
            newContext.setLoggerPrefix(this.computeLoggerPrefix(path));
            newContext.setLoggerSuffix(".log");
            newContext.setLoggerTimestamp("true");
        }
        return newContext;
    }

    private Datasource createJDBCReference(final String name, final String url, final String username, final String password, final String driverClassName) throws ConfigurationException, DatasourceAlreadyExistsException {
        ArrayList<Datasource> conflictingDS = new ArrayList<Datasource>();
        for (Datasource datasource : this.getDatasources()) {
            if (!name.equals(datasource.getJndiName())) continue;
            conflictingDS.add(datasource);
        }
        if (conflictingDS.size() > 0) {
            throw new DatasourceAlreadyExistsException(conflictingDS);
        }
        if (this.tomcatVersion == 1) {
            this.modifyContext(new ContextModifier(){

                public void modify(Context context) {
                    int idx = context.addResource(true);
                    context.setResourceName(idx, name);
                    context.setResourceAuth(idx, "Container");
                    context.setResourceType(idx, "javax.sql.DataSource");
                    context.setResourceDriverClassName(idx, driverClassName);
                    context.setResourceUrl(idx, url);
                    context.setResourceUsername(idx, username);
                    context.setResourcePassword(idx, password);
                    context.setResourceMaxActive(idx, "20");
                    context.setResourceMaxIdle(idx, "10");
                    context.setResourceMaxWait(idx, "-1");
                }
            });
        } else {
            this.modifyContext(new ContextModifier(){

                public void modify(Context context) {
                    int idx = context.addResource(true);
                    context.setResourceName(idx, name);
                    context.setResourceAuth(idx, "Container");
                    context.setResourceType(idx, "javax.sql.DataSource");
                    ResourceParams[] resourceParams = context.getResourceParams();
                    for (int i = 0; i < resourceParams.length; ++i) {
                        if (!name.equals(resourceParams[i].getName())) continue;
                        context.removeResourceParams(resourceParams[i]);
                    }
                    ResourceParams newResourceParams = WebappConfiguration.this.createResourceParams(name, new Parameter[]{WebappConfiguration.this.createParameter("factory", "org.apache.commons.dbcp.BasicDataSourceFactory"), WebappConfiguration.this.createParameter("driverClassName", driverClassName), WebappConfiguration.this.createParameter("url", url), WebappConfiguration.this.createParameter("username", username), WebappConfiguration.this.createParameter("password", password), WebappConfiguration.this.createParameter("maxActive", "20"), WebappConfiguration.this.createParameter("maxIdle", "10"), WebappConfiguration.this.createParameter("maxWait", "-1")});
                    context.addResourceParams(newResourceParams);
                }
            });
        }
        return new TomcatDatasource(username, url, password, name, driverClassName);
    }

    private void addResReference(final String name, String type) throws ConfigurationException {
        if ("javax.sql.DataSource".equals(type)) {
            this.modifyContext(new ContextModifier(){

                public void modify(Context context) {
                    int lengthResource = context.getResource().length;
                    for (int i = 0; i < lengthResource; ++i) {
                        if (!name.equals(context.getResourceName(i))) continue;
                        return;
                    }
                    int lengthResourceLink = context.getResourceLink().length;
                    for (int i = 0; i < lengthResourceLink; ++i) {
                        if (!name.equals(context.getResourceLinkName(i))) continue;
                        return;
                    }
                    int idx = context.addResourceLink(true);
                    context.setResourceLinkName(idx, name);
                    context.setResourceLinkGlobal(idx, name);
                    context.setResourceLinkType(idx, "javax.sql.DataSource");
                }
            });
        }
    }

    private void modifyContext(ContextModifier modifier) throws ConfigurationException {
        assert (this.contextDataObject != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.contextDataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Context newContext = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newContext = Context.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                Context oldContext = this.getContext();
                if (oldContext == null) {
                    throw new ConfigurationException("Configuration data are not parseable cannot perform changes.");
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WebappConfiguration.class, (String)"MSG_ContextXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newContext = oldContext;
            }
            modifier.modify(newContext);
            boolean modified = this.contextDataObject.isModified();
            this.replaceDocument(doc, newContext);
            if (!modified && (cookie = (SaveCookie)this.contextDataObject.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            this.context = newContext;
        }
        catch (BadLocationException ble) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ble);
        }
        catch (IOException ioe) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ioe);
        }
    }

    private Parameter createParameter(String name, String value) {
        Parameter parameter = new Parameter();
        parameter.setName(name);
        parameter.setValue(value);
        return parameter;
    }

    private ResourceParams createResourceParams(String name, Parameter[] parameters) {
        ResourceParams resourceParams = new ResourceParams();
        resourceParams.setName(name);
        for (int i = 0; i < parameters.length; ++i) {
            resourceParams.addParameter(parameters[i]);
        }
        return resourceParams;
    }

    private String computeLoggerPrefix(String contextPath) {
        return contextPath.length() > 0 ? contextPath.substring(1).replace('/', '_').concat(".") : "ROOT.";
    }

    private void writefile(final File file) throws ConfigurationException {
        try {
            FileObject cfolder = FileUtil.toFileObject((File)file.getParentFile());
            if (cfolder == null) {
                File parentFile = file.getParentFile();
                try {
                    cfolder = FileUtil.toFileObject((File)parentFile.getParentFile()).createFolder(parentFile.getName());
                }
                catch (IOException ioe) {
                    throw new ConfigurationException(NbBundle.getMessage(WebappConfiguration.class, (String)"MSG_FailedToCreateConfigFolder", (Object)parentFile.getAbsolutePath()));
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = folder.getFileObject(name);
                        if (configFO == null) {
                            configFO = folder.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        Context ctx = WebappConfiguration.this.getContext();
                        if (ctx != null) {
                            ctx.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }

    private void replaceDocument(final StyledDocument doc, BaseBean graph) {
        final StringWriter out = new StringWriter();
        try {
            graph.write((Writer)out);
        }
        catch (Schema2BeansException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
            }
        });
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    private static interface ContextModifier {
        public void modify(Context var1);
    }
}

