/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.welcome.WelcomeComponent;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class ContentPanel
extends JPanel
implements Constants,
PropertyChangeListener,
MouseListener {
    private JLabel lblTitle;
    private JComponent content;
    private JComponent bottomContent;
    protected final ImageIcon hTopLeftInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_topleft.png"));
    protected final ImageIcon hTopRightInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_topright.png"));
    protected final ImageIcon hBottomLeftInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_bottomleft.png"));
    protected final ImageIcon hBottomRightInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_bottomright.png"));
    protected final ImageIcon hTopInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_top.png"));
    protected final ImageIcon hBottomInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_bottom.png"));
    protected final ImageIcon hLeftInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_left.png"));
    protected final ImageIcon hRightInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/t_right.png"));
    protected final ImageIcon leftSideInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/leftside.png"));
    protected final ImageIcon rightSideInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/rightside.png"));
    protected final ImageIcon fTopLeftInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_topleft.png"));
    protected final ImageIcon fTopRightInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_topright.png"));
    protected final ImageIcon fBottomLeftInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_bottomleft.png"));
    protected final ImageIcon fBottomRightInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_bottomright.png"));
    protected final ImageIcon fTopInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_top.png"));
    protected final ImageIcon fBottomInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_bottom.png"));
    protected final ImageIcon fLeftInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_left.png"));
    protected final ImageIcon fRightInFocus = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/b_right.png"));
    protected final ImageIcon hTopLeftDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_topleft.png"));
    protected final ImageIcon hTopRightDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_topright.png"));
    protected final ImageIcon hBottomLeftDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_bottomleft.png"));
    protected final ImageIcon hBottomRightDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_bottomright.png"));
    protected final ImageIcon hTopDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_top.png"));
    protected final ImageIcon hBottomDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_bottom.png"));
    protected final ImageIcon hLeftDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_left.png"));
    protected final ImageIcon hRightDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_t_right.png"));
    protected final ImageIcon leftSideDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_leftside.png"));
    protected final ImageIcon rightSideDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_rightside.png"));
    protected final ImageIcon fTopLeftDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_topleft.png"));
    protected final ImageIcon fTopRightDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_topright.png"));
    protected final ImageIcon fBottomLeftDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_bottomleft.png"));
    protected final ImageIcon fBottomRightDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_bottomright.png"));
    protected final ImageIcon fTopDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_top.png"));
    protected final ImageIcon fBottomDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_bottom.png"));
    protected final ImageIcon fLeftDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_left.png"));
    protected final ImageIcon fRightDeselect = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/desel_b_right.png"));
    private boolean focusedBorder = false;
    private static Component lastFocusOwner = null;
    private boolean isFocusOwner = false;

    public ContentPanel(String title) {
        super(new GridBagLayout());
        this.lblTitle = new JLabel(title);
        this.lblTitle.setFont(HEADER_FONT);
        this.lblTitle.setForeground(Utils.getColor("HeaderTextColor"));
        this.lblTitle.setHorizontalAlignment(2);
        this.lblTitle.setOpaque(false);
        int vertFill = 3;
        if (this.lblTitle.getPreferredSize().height + 2 * vertFill < this.hTopInFocus.getIconHeight() + this.hBottomInFocus.getIconHeight()) {
            vertFill = (this.hTopInFocus.getIconHeight() + this.hBottomInFocus.getIconHeight() - this.lblTitle.getPreferredSize().height) / 2;
        }
        this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(vertFill, 10, vertFill, 10), 0, 0));
        this.setBackground(Utils.getColor("DefaultBackgroundColor"));
        this.setOpaque(false);
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)kfm));
        this.addMouseListener(this);
    }

    public void setContent(JComponent c) {
        if (null != this.content) {
            this.remove(this.content);
            this.content.removeMouseListener(this);
        }
        this.content = c;
        if (null != this.content) {
            this.add((Component)this.content, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
            this.content.addMouseListener(this);
        }
    }

    public void setBottomContent(JComponent c) {
        this.bottomContent = c;
        if (null != this.bottomContent) {
            int prefHeight = this.bottomContent.getPreferredSize().height;
            int topFill = 5;
            int bottomFill = 10;
            int imageHeight = this.fTopInFocus.getIconHeight() + this.fBottomInFocus.getIconHeight();
            if (prefHeight + topFill + bottomFill < imageHeight) {
                topFill = (imageHeight - prefHeight) / 2;
                bottomFill = (imageHeight - prefHeight) / 2 + (imageHeight - prefHeight) % 2;
            }
            this.add((Component)this.bottomContent, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(topFill, 10, bottomFill, 10), 0, 0));
            this.bottomContent.addMouseListener(this);
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = Utils.prepareGraphics(g);
        g2.setColor(Utils.getColor("DefaultBackgroundColor"));
        int header = this.getHeaderContentHeight();
        int footer = this.getFooterHeight();
        g2.fillRect(0, header, this.getWidth(), this.getHeight() - header - footer);
        this.paintTop(g2);
        this.paintBottom(g2);
        this.paintSides(g2);
    }

    private void paintTop(Graphics2D g2) {
        int width = this.getWidth();
        int contentHeight = this.getHeaderContentHeight();
        ImageIcon hTop = this.focusedBorder ? this.hTopInFocus : this.hTopDeselect;
        ImageIcon hBottom = this.focusedBorder ? this.hBottomInFocus : this.hBottomDeselect;
        ImageIcon hTopLeft = this.focusedBorder ? this.hTopLeftInFocus : this.hTopLeftDeselect;
        ImageIcon hBottomLeft = this.focusedBorder ? this.hBottomLeftInFocus : this.hBottomLeftDeselect;
        ImageIcon hTopRight = this.focusedBorder ? this.hTopRightInFocus : this.hTopRightDeselect;
        ImageIcon hBottomRight = this.focusedBorder ? this.hBottomRightInFocus : this.hBottomRightDeselect;
        ImageIcon hRight = this.focusedBorder ? this.hRightInFocus : this.hRightDeselect;
        ImageIcon hLeft = this.focusedBorder ? this.hLeftInFocus : this.hLeftDeselect;
        int imageHeight = hTop.getIconHeight() + hBottom.getIconHeight();
        int headerHeight = this.getHeaderContentHeight();
        int fillHeight = 0;
        if (imageHeight > contentHeight) {
            headerHeight = imageHeight;
        } else {
            fillHeight = headerHeight - imageHeight;
        }
        g2.drawImage(hTopLeft.getImage(), 0, 0, null);
        g2.drawImage(hBottomLeft.getImage(), 0, headerHeight - hBottomLeft.getIconHeight(), null);
        if (fillHeight > 0) {
            g2.drawImage(hLeft.getImage(), 0, hTopLeft.getIconHeight(), hLeft.getIconWidth(), fillHeight, null);
        }
        g2.drawImage(hTopRight.getImage(), width - hTopRight.getIconWidth(), 0, null);
        g2.drawImage(hBottomRight.getImage(), width - hBottomRight.getIconWidth(), headerHeight - hBottomRight.getIconHeight(), null);
        if (fillHeight > 0) {
            g2.drawImage(hRight.getImage(), width - hBottomRight.getIconWidth(), hTopRight.getIconHeight(), hRight.getIconWidth(), fillHeight, null);
        }
        g2.drawImage(hTop.getImage(), hTopLeft.getIconWidth(), 0, width - hTopLeft.getIconWidth() - hTopRight.getIconWidth(), hTop.getIconHeight(), null);
        g2.drawImage(hBottom.getImage(), hBottomLeft.getIconWidth(), headerHeight - hBottom.getIconHeight(), width - hBottomLeft.getIconWidth() - hBottomRight.getIconWidth(), hBottom.getIconHeight(), null);
        if (fillHeight > 0) {
            g2.setColor(Utils.getColor("HeaderFillColor"));
            g2.fillRect(hLeft.getIconWidth(), hTopLeft.getIconHeight(), width - hLeft.getIconWidth() - hRight.getIconWidth(), fillHeight);
        }
    }

    private void paintBottom(Graphics2D g2) {
        int fillHeight;
        int width = this.getWidth();
        int height = this.getHeight();
        ImageIcon fTop = this.focusedBorder ? this.fTopInFocus : this.fTopDeselect;
        ImageIcon fBottom = this.focusedBorder ? this.fBottomInFocus : this.fBottomDeselect;
        ImageIcon fTopLeft = this.focusedBorder ? this.fTopLeftInFocus : this.fTopLeftDeselect;
        ImageIcon fBottomLeft = this.focusedBorder ? this.fBottomLeftInFocus : this.fBottomLeftDeselect;
        ImageIcon fTopRight = this.focusedBorder ? this.fTopRightInFocus : this.fTopRightDeselect;
        ImageIcon fBottomRight = this.focusedBorder ? this.fBottomRightInFocus : this.fBottomRightDeselect;
        ImageIcon fRight = this.focusedBorder ? this.fRightInFocus : this.fRightDeselect;
        ImageIcon fLeft = this.focusedBorder ? this.fLeftInFocus : this.fLeftDeselect;
        int contentHeight = this.getFooterContentHeight();
        int imageHeight = null == this.bottomContent ? fBottom.getIconHeight() : fTop.getIconHeight() + fBottom.getIconHeight();
        int footerHeight = this.getFooterContentHeight();
        int n = fillHeight = null == this.bottomContent ? 0 : 1;
        if (imageHeight > contentHeight) {
            footerHeight = imageHeight;
        } else {
            fillHeight = footerHeight - imageHeight;
        }
        g2.drawImage(fBottomLeft.getImage(), 0, height - fBottomLeft.getIconHeight(), null);
        if (fillHeight > 0) {
            g2.drawImage(fTopLeft.getImage(), 0, height - footerHeight, null);
            g2.drawImage(fLeft.getImage(), 0, height - footerHeight + fTopLeft.getIconHeight(), fLeft.getIconWidth(), fillHeight, null);
        }
        g2.drawImage(fBottomRight.getImage(), width - fTopRight.getIconWidth(), height - fBottomRight.getIconHeight(), null);
        if (fillHeight > 0) {
            g2.drawImage(fTopRight.getImage(), width - fTopRight.getIconWidth(), height - footerHeight, null);
            g2.drawImage(fRight.getImage(), width - fRight.getIconWidth(), height - footerHeight + fTopRight.getIconHeight(), fRight.getIconWidth(), fillHeight, null);
        }
        g2.drawImage(fBottom.getImage(), fBottomLeft.getIconWidth(), height - fBottom.getIconHeight(), width - fBottomLeft.getIconWidth() - fBottomRight.getIconWidth(), fBottom.getIconHeight(), null);
        if (fillHeight > 0) {
            g2.setColor(Utils.getColor("FooterFillColor"));
            g2.fillRect(fLeft.getIconWidth(), height - footerHeight + fTop.getIconHeight(), width - fLeft.getIconWidth() - fRight.getIconWidth(), fillHeight);
            g2.drawImage(fTop.getImage(), fTopLeft.getIconWidth(), height - footerHeight, width - fTopLeft.getIconWidth() - fTopRight.getIconWidth(), fTop.getIconHeight(), null);
        }
    }

    private void paintSides(Graphics2D g2) {
        ImageIcon leftSide = this.focusedBorder ? this.leftSideInFocus : this.leftSideDeselect;
        ImageIcon rightSide = this.focusedBorder ? this.rightSideInFocus : this.rightSideDeselect;
        g2.drawImage(leftSide.getImage(), 0, this.getHeaderHeight(), leftSide.getIconWidth(), this.getHeight() - this.getHeaderHeight() - this.getFooterHeight(), null);
        g2.drawImage(rightSide.getImage(), this.getWidth() - rightSide.getIconWidth(), this.getHeaderHeight(), rightSide.getIconWidth(), this.getHeight() - this.getHeaderHeight() - this.getFooterHeight(), null);
    }

    private int getHeaderContentHeight() {
        Insets insets = this.lblTitle.getInsets();
        return this.lblTitle.getHeight() + insets.top + insets.bottom;
    }

    private int getHeaderHeight() {
        return Math.max(this.getHeaderContentHeight(), this.hTopInFocus.getIconHeight() + this.hBottomInFocus.getIconHeight());
    }

    private int getFooterContentHeight() {
        if (null == this.bottomContent) {
            return 0;
        }
        GridBagConstraints constr = ((GridBagLayout)this.getLayout()).getConstraints(this.bottomContent);
        return this.bottomContent.getHeight() + constr.insets.top + constr.insets.bottom;
    }

    private int getFooterHeight() {
        if (null == this.bottomContent) {
            return this.fBottomInFocus.getIconHeight();
        }
        return Math.max(this.getFooterContentHeight(), this.fTopInFocus.getIconHeight() + this.fBottomInFocus.getIconHeight());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("focusOwner".equals(evt.getPropertyName()) && evt.getNewValue() instanceof Component) {
            Component focusOwner = (Component)evt.getNewValue();
            ContentPanel focusAncestor = (ContentPanel)SwingUtilities.getAncestorOfClass(ContentPanel.class, focusOwner);
            boolean bl = this.isFocusOwner = null != focusAncestor && this == focusAncestor;
            if (this.isFocusOwner) {
                lastFocusOwner = focusOwner;
            }
            if (this.isFocusOwner != this.focusedBorder) {
                this.focusedBorder = this.isFocusOwner;
                this.lblTitle.setForeground(Utils.getColor(this.focusedBorder ? "SelHeaderTextColor" : "HeaderTextColor"));
                this.getParent().repaint();
            }
        }
    }

    public void switchFocus() {
        if (this.isFocusOwner) {
            return;
        }
        if (null == lastFocusOwner || !lastFocusOwner.isShowing()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
        } else {
            lastFocusOwner.requestFocusInWindow();
        }
    }

    protected void requestAttention() {
        this.focusedBorder = true;
        this.lblTitle.setForeground(Utils.getColor("SelHeaderTextColor"));
        this.getParent().repaint();
        if (WindowManager.getDefault().getRegistry().getActivated().equals((Object)WelcomeComponent.findComp())) {
            this.switchFocus();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        lastFocusOwner = null;
        this.switchFocus();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

