/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.completion.CompletionItemComparator;
import org.netbeans.modules.editor.completion.CompletionLayout;
import org.netbeans.modules.editor.completion.CompletionResultSetImpl;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompletionImpl
extends MouseAdapter
implements DocumentListener,
CaretListener,
KeyListener,
FocusListener,
ListSelectionListener,
ChangeListener,
SettingsChangeListener {
    private static final boolean debug;
    private static CompletionImpl singleton;
    private static final String FOLDER_NAME = "CompletionProviders";
    private static final String NO_SUGGESTIONS;
    private static final String PLEASE_WAIT;
    private static final String POPUP_HIDE = "popup-hide";
    private static final String COMPLETION_SHOW = "completion-show";
    private static final String DOC_SHOW = "doc-show";
    private static final String TOOLTIP_SHOW = "tooltip-show";
    private static final int PLEASE_WAIT_TIMEOUT = 250;
    private WeakReference activeComponent = null;
    private WeakReference activeDocument = null;
    private InputMap inputMap;
    private ActionMap actionMap;
    private final CompletionLayout layout = new CompletionLayout();
    private CompletionProvider[] activeProviders = null;
    private HashMap providersCache = new HashMap();
    private Result completionResult;
    private Result docResult;
    private Result toolTipResult;
    private Timer completionAutoPopupTimer;
    private Timer docAutoPopupTimer;
    private Timer pleaseWaitTimer;
    private boolean refreshedQuery = false;
    private boolean explicitQuery = false;
    private boolean tabCompletionWaiting = false;
    private LinkedList waitingEvents = new LinkedList();
    private int modEndOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static CompletionImpl get() {
        if (singleton == null) {
            singleton = new CompletionImpl();
        }
        return singleton;
    }

    private CompletionImpl() {
        Registry.addChangeListener((ChangeListener)this);
        this.completionAutoPopupTimer = new Timer(0, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Result localCompletionResult;
                1 var3_2 = this;
                synchronized (var3_2) {
                    localCompletionResult = CompletionImpl.this.completionResult;
                }
                if (localCompletionResult != null && !localCompletionResult.isQueryInvoked()) {
                    CompletionImpl.this.pleaseWaitTimer.restart();
                    CompletionImpl.queryResultSets(localCompletionResult.getResultSets());
                    localCompletionResult.queryInvoked();
                }
            }
        });
        this.completionAutoPopupTimer.setRepeats(false);
        this.docAutoPopupTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompletionImpl.this.showDocumentation(true);
            }
        });
        this.docAutoPopupTimer.setRepeats(false);
        this.pleaseWaitTimer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String waitText = PLEASE_WAIT;
                Iterator it = CompletionImpl.this.completionResult.getResultSets().iterator();
                while (it.hasNext()) {
                    CompletionResultSetImpl resultSet = (CompletionResultSetImpl)it.next();
                    if (resultSet.getWaitText() == null) continue;
                    waitText = resultSet.getWaitText();
                    break;
                }
                CompletionImpl.this.layout.showCompletion(Collections.singletonList(waitText), null, -1, CompletionImpl.this);
            }
        });
        this.pleaseWaitTimer.setRepeats(false);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    private JTextComponent getActiveComponent() {
        return this.activeComponent != null ? (JTextComponent)this.activeComponent.get() : null;
    }

    private Document getActiveDocument() {
        return this.activeDocument != null ? (Document)this.activeDocument.get() : null;
    }

    public int getSortType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (!DocumentUtilities.isTypingModification((DocumentEvent)e)) {
            return;
        }
        if (this.activeProviders != null) {
            try {
                this.modEndOffset = e.getOffset() + e.getLength();
                if (this.getActiveComponent().getCaretPosition() != this.modEndOffset) {
                    return;
                }
                String typedText = e.getDocument().getText(e.getOffset(), e.getLength());
                for (int i = 0; i < this.activeProviders.length; ++i) {
                    boolean tooltipResultNull;
                    boolean completionResultNull;
                    int type = this.activeProviders[i].getAutoQueryTypes(this.getActiveComponent(), typedText);
                    CompletionImpl completionImpl = this;
                    synchronized (completionImpl) {
                        completionResultNull = this.completionResult == null;
                    }
                    if (completionResultNull && (type & 1) != 0 && CompletionSettings.INSTANCE.completionAutoPopup()) {
                        this.showCompletion(false, true);
                    }
                    CompletionImpl completionImpl2 = this;
                    synchronized (completionImpl2) {
                        tooltipResultNull = this.toolTipResult == null;
                    }
                    if (!tooltipResultNull || (type & 4) == 0) continue;
                    this.showToolTip();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.completionAutoPopupTimer.isRunning()) {
                this.restartCompletionAutoPopupTimer();
            }
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.modEndOffset = e.getOffset();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void caretUpdate(CaretEvent e) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.activeProviders != null) {
            Result localCompletionResult;
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                localCompletionResult = this.completionResult;
            }
            if ((this.completionAutoPopupTimer.isRunning() || localCompletionResult != null) && !this.layout.isCompletionVisible() && e.getDot() != this.modEndOffset) {
                this.hideCompletion();
            }
            this.completionRefresh();
            this.toolTipRefresh();
        }
    }

    public void keyPressed(KeyEvent e) {
        this.dispatchKeyEvent(e);
    }

    public void keyReleased(KeyEvent e) {
        this.dispatchKeyEvent(e);
    }

    public void keyTyped(KeyEvent e) {
        this.dispatchKeyEvent(e);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.hideAll();
    }

    public void mouseClicked(MouseEvent e) {
        this.hideAll();
    }

    public void hideAll() {
        this.hideToolTip();
        this.hideCompletion();
        this.hideDocumentation();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.layout.isDocumentationVisible()) {
            this.restartDocumentationAutoPopupTimer();
        }
    }

    public void stateChanged(ChangeEvent e) {
        BaseDocument document;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        boolean cancel = false;
        JTextComponent component = Registry.getMostActiveComponent();
        if (component != this.getActiveComponent()) {
            this.activeProviders = this.getCompletionProvidersForComponent(component);
            if (debug) {
                StringBuffer sb = new StringBuffer("Completion PROVIDERS:\n");
                if (this.activeProviders != null) {
                    for (int i = 0; i < this.activeProviders.length; ++i) {
                        sb.append("providers[");
                        sb.append(i);
                        sb.append("]: ");
                        sb.append(this.activeProviders[i].getClass());
                        sb.append('\n');
                    }
                }
                System.err.println(sb.toString());
            }
            if (this.getActiveComponent() != null) {
                this.getActiveComponent().removeCaretListener(this);
                this.getActiveComponent().removeKeyListener(this);
                this.getActiveComponent().removeFocusListener(this);
                this.getActiveComponent().removeMouseListener(this);
            }
            if (component != null) {
                component.addCaretListener(this);
                component.addKeyListener(this);
                component.addFocusListener(this);
                component.addMouseListener(this);
            }
            this.activeComponent = component != null ? new WeakReference<JTextComponent>(component) : null;
            CompletionSettings.INSTANCE.notifyEditorComponentChange(this.getActiveComponent());
            this.layout.setEditorComponent(this.getActiveComponent());
            this.installKeybindings();
            cancel = true;
        }
        if ((document = Registry.getMostActiveDocument()) != this.getActiveDocument()) {
            this.activeProviders = this.getCompletionProvidersForComponent(component);
            if (debug) {
                StringBuffer sb = new StringBuffer("Completion PROVIDERS:\n");
                if (this.activeProviders != null) {
                    for (int i = 0; i < this.activeProviders.length; ++i) {
                        sb.append("providers[");
                        sb.append(i);
                        sb.append("]: ");
                        sb.append(this.activeProviders[i].getClass());
                        sb.append('\n');
                    }
                }
                System.err.println(sb.toString());
            }
            if (this.getActiveDocument() != null) {
                DocumentUtilities.removeDocumentListener((Document)this.getActiveDocument(), (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
            }
            if (this.activeProviders != null) {
                DocumentUtilities.addDocumentListener((Document)document, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
            }
            this.activeDocument = new WeakReference<BaseDocument>(document);
            cancel = true;
        }
        if (cancel) {
            this.completionCancel();
        }
    }

    private void restartCompletionAutoPopupTimer() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        int completionDelay = CompletionSettings.INSTANCE.completionAutoPopupDelay();
        this.completionAutoPopupTimer.setInitialDelay(completionDelay);
        this.completionAutoPopupTimer.restart();
    }

    private void restartDocumentationAutoPopupTimer() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        int docDelay = CompletionSettings.INSTANCE.documentationAutoPopupDelay();
        this.docAutoPopupTimer.setInitialDelay(docDelay);
        this.docAutoPopupTimer.restart();
    }

    private CompletionProvider[] getCompletionProvidersForComponent(JTextComponent component) {
        String mimeType;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (component == null) {
            return null;
        }
        Object mimeTypeObj = component.getDocument().getProperty("mimeType");
        if (mimeTypeObj instanceof String) {
            mimeType = (String)mimeTypeObj;
        } else {
            BaseKit kit = Utilities.getKit((JTextComponent)component);
            if (kit == null) {
                return new CompletionProvider[0];
            }
            mimeType = kit.getContentType();
        }
        if (this.providersCache.containsKey(mimeType)) {
            return (CompletionProvider[])this.providersCache.get(mimeType);
        }
        ArrayList list = new ArrayList();
        MimeLookup lookup = MimeLookup.getMimeLookup((String)mimeType);
        list.addAll(lookup.lookup(new Lookup.Template(CompletionProvider.class)).allInstances());
        int size = list.size();
        CompletionProvider[] ret = size == 0 ? null : list.toArray(new CompletionProvider[size]);
        this.providersCache.put(mimeType, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dispatchKeyEvent(KeyEvent e) {
        Action action;
        if (e == null) {
            return;
        }
        if (this.tabCompletionWaiting) {
            this.waitingEvents.add(e);
            e.consume();
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        Object obj = this.inputMap.get(ks);
        if (obj != null && (action = this.actionMap.get(obj)) != null) {
            action.actionPerformed(null);
            e.consume();
            return;
        }
        if (this.layout.isCompletionVisible()) {
            CompletionItem item = this.layout.getSelectedCompletionItem();
            if (item != null) {
                item.processKeyEvent(e);
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyCode() == 10 && e.getID() == 401) {
                    e.consume();
                    item.defaultAction(this.getActiveComponent());
                    return;
                }
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 33 || e.getKeyCode() == 34 || e.getKeyCode() == 36 || e.getKeyCode() == 35) {
                this.hideCompletion();
            }
            if (e.getKeyCode() == 9) {
                e.consume();
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    if (this.completionResult == null) {
                        return;
                    }
                    if (!CompletionImpl.isAllResultsFinished(this.completionResult.getResultSets())) {
                        this.tabCompletionWaiting = true;
                    } else {
                        this.insertCommonPrefix();
                    }
                }
                return;
            }
        }
        this.layout.processKeyEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completionQuery(boolean delayQuery) {
        this.refreshedQuery = false;
        Result newCompletionResult = new Result(this.activeProviders.length);
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            if (!$assertionsDisabled && this.completionResult != null) {
                throw new AssertionError();
            }
            this.completionResult = newCompletionResult;
        }
        List completionResultSets = newCompletionResult.getResultSets();
        for (int i = 0; i < this.activeProviders.length; ++i) {
            CompletionTask compTask = this.activeProviders[i].createTask(1, this.getActiveComponent());
            if (compTask == null) continue;
            CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newCompletionResult, compTask, 1);
            completionResultSets.add(resultSet);
        }
        if (delayQuery) {
            this.restartCompletionAutoPopupTimer();
        } else {
            this.pleaseWaitTimer.restart();
            CompletionImpl.queryResultSets(completionResultSets);
            newCompletionResult.queryInvoked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionRefresh() {
        Result localCompletionResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localCompletionResult = this.completionResult;
        }
        if (localCompletionResult != null) {
            this.refreshedQuery = true;
            Result refreshResult = localCompletionResult.createRefreshResult();
            CompletionImpl completionImpl2 = this;
            synchronized (completionImpl2) {
                this.completionResult = refreshResult;
            }
            refreshResult.invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionCancel() {
        Result oldCompletionResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            oldCompletionResult = this.completionResult;
            this.completionResult = null;
            if (this.tabCompletionWaiting) {
                this.tabCompletionWaiting = false;
                this.waitingEvents.clear();
            }
        }
        if (oldCompletionResult != null) {
            oldCompletionResult.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCommonPrefix() {
        Result localCompletionResult;
        JTextComponent c = this.getActiveComponent();
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localCompletionResult = this.completionResult;
        }
        if (localCompletionResult != null) {
            CharSequence commonText = null;
            int anchorOffset = -1;
            Iterator it = localCompletionResult.getResultSets().iterator();
            block8: while (it.hasNext()) {
                CompletionResultSetImpl resultSet = (CompletionResultSetImpl)it.next();
                if (anchorOffset == -1) {
                    anchorOffset = resultSet.getAnchorOffset();
                }
                Iterator itt = resultSet.getItems().iterator();
                block9: while (itt.hasNext()) {
                    CharSequence text = ((CompletionItem)itt.next()).getInsertPrefix();
                    if (text == null) {
                        commonText = null;
                        break block8;
                    }
                    if (commonText == null) {
                        commonText = text;
                        continue;
                    }
                    int minLen = Math.min(text.length(), commonText.length());
                    for (int commonInd = 0; commonInd < minLen; ++commonInd) {
                        if (text.charAt(commonInd) == commonText.charAt(commonInd)) continue;
                        if (commonInd == 0) {
                            commonText = null;
                            break block8;
                        }
                        commonText = commonText.subSequence(0, commonInd);
                        continue block9;
                    }
                }
            }
            if (commonText != null) {
                int caretOffset = c.getCaret().getDot();
                if (anchorOffset > -1 && caretOffset - anchorOffset < commonText.length()) {
                    commonText = commonText.subSequence(caretOffset - anchorOffset, commonText.length());
                    BaseDocument doc = (BaseDocument)this.getActiveDocument();
                    doc.atomicLock();
                    try {
                        doc.insertString(caretOffset, ((Object)commonText).toString(), null);
                    }
                    catch (BadLocationException e) {
                    }
                    finally {
                        doc.atomicUnlock();
                    }
                }
            }
        }
        if (this.tabCompletionWaiting) {
            this.tabCompletionWaiting = false;
            while (!this.waitingEvents.isEmpty()) {
                KeyEvent e = (KeyEvent)this.waitingEvents.removeFirst();
                e = new KeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
                c.dispatchEvent(e);
            }
        }
    }

    public void showCompletion() {
        this.showCompletion(false, false);
    }

    private void showCompletion(boolean explicitQuery, boolean delayQuery) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(0));
            return;
        }
        this.explicitQuery = explicitQuery;
        if (this.activeProviders == null) {
            Completion completion = ExtUtilities.getCompletion((JTextComponent)this.getActiveComponent());
            if (completion != null) {
                completion.setPaneVisible(true);
            }
            return;
        }
        this.completionAutoPopupTimer.stop();
        this.completionCancel();
        this.completionQuery(delayQuery);
    }

    void requestShowCompletionPane(Result result) {
        this.pleaseWaitTimer.stop();
        int sortedResultsSize = 0;
        List completionResultSets = result.getResultSets();
        for (int i = completionResultSets.size() - 1; i >= 0; --i) {
            CompletionResultSetImpl resultSet = (CompletionResultSetImpl)completionResultSets.get(i);
            sortedResultsSize += resultSet.getItems().size();
        }
        final ArrayList sortedResultItems = new ArrayList(sortedResultsSize);
        String title = null;
        int anchorOffset = -1;
        boolean addIndex = false;
        for (int i = 0; i < completionResultSets.size(); ++i) {
            CompletionResultSetImpl resultSet = (CompletionResultSetImpl)completionResultSets.get(i);
            List resultItems = resultSet.getItems();
            if (resultItems.size() <= 0) continue;
            sortedResultItems.addAll(resultItems);
            if (title == null) {
                title = resultSet.getTitle();
            }
            if (anchorOffset != -1) continue;
            anchorOffset = resultSet.getAnchorOffset();
        }
        Collections.sort(sortedResultItems, CompletionItemComparator.get(this.getSortType()));
        final String displayTitle = title;
        final int displayAnchorOffset = anchorOffset;
        Runnable requestShowRunnable = new Runnable(){

            public void run() {
                int caretOffset = CompletionImpl.this.getActiveComponent().getCaretPosition();
                if (sortedResultItems.size() == 1 && !CompletionImpl.this.refreshedQuery && CompletionImpl.this.explicitQuery && CompletionSettings.INSTANCE.completionInstantSubstitution()) {
                    try {
                        CompletionItem item;
                        int[] block = Utilities.getIdentifierBlock((JTextComponent)CompletionImpl.this.getActiveComponent(), (int)caretOffset);
                        if ((block == null || block[1] == caretOffset) && (item = (CompletionItem)sortedResultItems.get(0)).instantSubstitution(CompletionImpl.this.getActiveComponent())) {
                            return;
                        }
                    }
                    catch (BadLocationException ex) {
                        // empty catch block
                    }
                }
                ArrayList<String> res = new ArrayList<String>(sortedResultItems);
                boolean noSuggestions = false;
                if (res.size() == 0) {
                    res.add(NO_SUGGESTIONS);
                    noSuggestions = true;
                }
                CompletionImpl.this.layout.showCompletion(res, displayTitle, displayAnchorOffset, CompletionImpl.this);
                if (CompletionSettings.INSTANCE.documentationAutoPopup()) {
                    if (noSuggestions) {
                        CompletionImpl.this.hideDocumentation();
                    } else {
                        CompletionImpl.this.restartDocumentationAutoPopupTimer();
                    }
                }
            }
        };
        CompletionImpl.runInAWT(requestShowRunnable);
    }

    public boolean hideCompletion() {
        this.completionCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(3));
            return false;
        }
        return this.hideCompletionPane();
    }

    private boolean hideCompletionPane() {
        this.completionAutoPopupTimer.stop();
        this.pleaseWaitTimer.stop();
        boolean hidePerformed = this.layout.hideCompletion();
        if (hidePerformed && CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.hideDocumentation();
        }
        return hidePerformed;
    }

    public void showDocumentation() {
        this.showDocumentation(false);
    }

    void showDocumentation(boolean clearHistory) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(1));
            return;
        }
        if (this.activeProviders != null) {
            this.documentationCancel();
            if (clearHistory) {
                this.layout.clearDocumentationHistory();
            }
        } else {
            CompletionJavaDoc completionDoc = ExtUtilities.getCompletionJavaDoc((JTextComponent)this.getActiveComponent());
            if (completionDoc != null) {
                completionDoc.setJavaDocVisible(true);
            }
            return;
        }
        this.documentationQuery();
    }

    void requestShowDocumentationPane(Result result) {
        final CompletionResultSetImpl resultSet = CompletionImpl.findFirstValidResult(result.getResultSets());
        if (resultSet != null) {
            CompletionImpl.runInAWT(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CompletionImpl completionImpl = CompletionImpl.this;
                    synchronized (completionImpl) {
                        CompletionImpl.this.layout.showDocumentation(resultSet.getDocumentation(), resultSet.getAnchorOffset());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationQuery() {
        CompletionTask docTask;
        Result newDocumentationResult = new Result(1);
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            if (!$assertionsDisabled && this.docResult != null) {
                throw new AssertionError();
            }
            this.docResult = newDocumentationResult;
        }
        List documentationResultSets = this.docResult.getResultSets();
        CompletionItem selectedItem = this.layout.getSelectedCompletionItem();
        if (selectedItem != null && (docTask = selectedItem.createDocumentationTask()) != null) {
            CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newDocumentationResult, docTask, 2);
            documentationResultSets.add(resultSet);
        } else {
            for (int i = 0; i < this.activeProviders.length; ++i) {
                docTask = this.activeProviders[i].createTask(2, this.getActiveComponent());
                if (docTask == null) continue;
                CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newDocumentationResult, docTask, 2);
                documentationResultSets.add(resultSet);
            }
        }
        CompletionImpl.queryResultSets(documentationResultSets);
        newDocumentationResult.queryInvoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationRefresh() {
        Result localDocumentationResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localDocumentationResult = this.docResult;
        }
        if (localDocumentationResult != null) {
            Result refreshResult = localDocumentationResult.createRefreshResult();
            CompletionImpl completionImpl2 = this;
            synchronized (completionImpl2) {
                this.docResult = refreshResult;
            }
            refreshResult.invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationCancel() {
        Result oldDocumentationResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            oldDocumentationResult = this.docResult;
            this.docResult = null;
        }
        if (oldDocumentationResult != null) {
            oldDocumentationResult.cancel();
        }
    }

    public boolean hideDocumentation() {
        this.documentationCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(4));
            return false;
        }
        return this.hideDocumentationPane();
    }

    boolean hideDocumentationPane() {
        this.docAutoPopupTimer.stop();
        boolean hidePerformed = this.layout.hideDocumentation();
        if (hidePerformed && CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.hideCompletion();
        }
        return hidePerformed;
    }

    public void showToolTip() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(2));
            return;
        }
        if (this.activeProviders != null) {
            this.toolTipCancel();
            this.toolTipQuery();
        }
    }

    void requestShowToolTipPane(Result result) {
        final CompletionResultSetImpl resultSet = CompletionImpl.findFirstValidResult(result.getResultSets());
        CompletionImpl.runInAWT(new Runnable(){

            public void run() {
                if (resultSet != null) {
                    CompletionImpl.this.layout.showToolTip(resultSet.getToolTip(), resultSet.getAnchorOffset());
                } else {
                    CompletionImpl.this.hideToolTip();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipQuery() {
        CompletionTask toolTipTask;
        Result newToolTipResult = new Result(1);
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            if (!$assertionsDisabled && this.toolTipResult != null) {
                throw new AssertionError();
            }
            this.toolTipResult = newToolTipResult;
        }
        List toolTipResultSets = newToolTipResult.getResultSets();
        CompletionItem selectedItem = this.layout.getSelectedCompletionItem();
        if (selectedItem != null && (toolTipTask = selectedItem.createToolTipTask()) != null) {
            CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newToolTipResult, toolTipTask, 4);
            toolTipResultSets.add(resultSet);
        } else {
            for (int i = 0; i < this.activeProviders.length; ++i) {
                toolTipTask = this.activeProviders[i].createTask(4, this.getActiveComponent());
                if (toolTipTask == null) continue;
                CompletionResultSetImpl resultSet = new CompletionResultSetImpl(this, newToolTipResult, toolTipTask, 4);
                toolTipResultSets.add(resultSet);
            }
        }
        CompletionImpl.queryResultSets(toolTipResultSets);
        newToolTipResult.queryInvoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipRefresh() {
        Result localToolTipResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            localToolTipResult = this.toolTipResult;
        }
        if (localToolTipResult != null) {
            Result refreshResult = localToolTipResult.createRefreshResult();
            CompletionImpl completionImpl2 = this;
            synchronized (completionImpl2) {
                this.toolTipResult = refreshResult;
            }
            refreshResult.invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipCancel() {
        Result oldToolTipResult;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            oldToolTipResult = this.toolTipResult;
            this.toolTipResult = null;
        }
        if (oldToolTipResult != null) {
            oldToolTipResult.cancel();
        }
    }

    public boolean hideToolTip() {
        this.toolTipCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(5));
            return false;
        }
        return this.hideToolTipPane();
    }

    boolean hideToolTipPane() {
        return this.layout.hideToolTip();
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        if (editorActionName != null && this.getActiveComponent() != null) {
            Action a;
            EditorKit kit;
            TextUI ui = this.getActiveComponent().getUI();
            Keymap km = this.getActiveComponent().getKeymap();
            if (ui != null && km != null && (kit = ui.getEditorKit(this.getActiveComponent())) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null) {
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    ret = keys;
                } else {
                    MultiKeymap km2 = ((BaseKit)kit).getKeymap();
                    KeyStroke[] keys2 = km2.getKeyStrokesForAction(a);
                    if (keys2 != null && keys2.length > 0) {
                        ret = keys2;
                    }
                }
            }
        }
        return ret;
    }

    private void installKeybindings() {
        int i;
        this.actionMap = new ActionMap();
        this.inputMap = new InputMap();
        KeyStroke[] keys = this.findEditorKeys(COMPLETION_SHOW, KeyStroke.getKeyStroke(32, 2));
        for (i = 0; i < keys.length; ++i) {
            this.inputMap.put(keys[i], COMPLETION_SHOW);
        }
        this.actionMap.put(COMPLETION_SHOW, new CompletionShowAction());
        keys = this.findEditorKeys("documentation-show", KeyStroke.getKeyStroke(32, 3));
        for (i = 0; i < keys.length; ++i) {
            this.inputMap.put(keys[i], DOC_SHOW);
        }
        this.actionMap.put(DOC_SHOW, new DocShowAction());
        keys = this.findEditorKeys(TOOLTIP_SHOW, KeyStroke.getKeyStroke(80, 8));
        for (i = 0; i < keys.length; ++i) {
            this.inputMap.put(keys[i], TOOLTIP_SHOW);
        }
        this.actionMap.put(TOOLTIP_SHOW, new ToolTipShowAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishNotify(CompletionResultSetImpl finishedResult) {
        switch (finishedResult.getQueryType()) {
            case 1: {
                Result localCompletionResult;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    localCompletionResult = this.completionResult;
                }
                if (finishedResult.getResultId() != localCompletionResult || !CompletionImpl.isAllResultsFinished(localCompletionResult.getResultSets())) break;
                this.requestShowCompletionPane(localCompletionResult);
                completionImpl = this;
                synchronized (completionImpl) {
                    if (this.tabCompletionWaiting) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                CompletionImpl.this.insertCommonPrefix();
                            }
                        });
                    }
                    break;
                }
            }
            case 2: {
                Result localDocumentationResult;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    localDocumentationResult = this.docResult;
                }
                if (finishedResult.getResultId() != localDocumentationResult || !CompletionImpl.isAllResultsFinished(localDocumentationResult.getResultSets())) break;
                this.requestShowDocumentationPane(localDocumentationResult);
                break;
            }
            case 4: {
                Result localToolTipResult;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    localToolTipResult = this.toolTipResult;
                }
                if (finishedResult.getResultId() != localToolTipResult || !CompletionImpl.isAllResultsFinished(localToolTipResult.getResultSets())) break;
                this.requestShowToolTipPane(localToolTipResult);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean isAllResultsFinished(List resultSets) {
        for (int i = resultSets.size() - 1; i >= 0; --i) {
            CompletionResultSetImpl result = (CompletionResultSetImpl)resultSets.get(i);
            if (result.isFinished()) continue;
            if (debug) {
                System.err.println("CompletionTask: " + result.getTask() + " not finished yet");
            }
            return false;
        }
        if (debug) {
            System.err.println("----- All tasks finished -----");
        }
        return true;
    }

    private static CompletionResultSetImpl findFirstValidResult(List resultSets) {
        block4: for (int i = 0; i < resultSets.size(); ++i) {
            CompletionResultSetImpl result = (CompletionResultSetImpl)resultSets.get(i);
            switch (result.getQueryType()) {
                case 2: {
                    if (result.getDocumentation() == null) continue block4;
                    return result;
                }
                case 4: {
                    if (result.getToolTip() == null) continue block4;
                    return result;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    private static void runInAWT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private static void queryResultSets(List resultSets) {
        for (int i = 0; i < resultSets.size(); ++i) {
            CompletionResultSetImpl resultSet = (CompletionResultSetImpl)resultSets.get(i);
            resultSet.getTask().query(resultSet.getResultSet());
        }
    }

    private static void createRefreshResultSets(List resultSets, Result refreshResult) {
        List refreshResultSets = refreshResult.getResultSets();
        int size = resultSets.size();
        for (int i = 0; i < size; ++i) {
            CompletionResultSetImpl result = (CompletionResultSetImpl)resultSets.get(i);
            result.markInactive();
            result = new CompletionResultSetImpl(result.getCompletionImpl(), refreshResult, result.getTask(), result.getQueryType());
            refreshResultSets.add(result);
        }
    }

    private static void refreshResultSets(List resultSets, boolean beforeQuery) {
        try {
            int size = resultSets.size();
            for (int i = 0; i < size; ++i) {
                CompletionResultSetImpl result = (CompletionResultSetImpl)resultSets.get(i);
                result.getTask().refresh(beforeQuery ? null : result.getResultSet());
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static void cancelResultSets(List resultSets) {
        int size = resultSets.size();
        for (int i = 0; i < size; ++i) {
            CompletionResultSetImpl result = (CompletionResultSetImpl)resultSets.get(i);
            result.markInactive();
            result.getTask().cancel();
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String settingName = evt.getSettingName();
        if ("key-bindings".equals(settingName) || settingName == null) {
            Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                public void run() {
                    CompletionImpl.this.installKeybindings();
                }
            });
        }
    }

    static {
        $assertionsDisabled = !CompletionImpl.class.desiredAssertionStatus();
        debug = Boolean.getBoolean("netbeans.debug.editor.completion");
        singleton = null;
        NO_SUGGESTIONS = NbBundle.getMessage((Class)CompletionImpl.class, (String)"completion-no-suggestions");
        PLEASE_WAIT = NbBundle.getMessage((Class)CompletionImpl.class, (String)"completion-please-wait");
    }

    static final class Result {
        private final List resultSets;
        private boolean invoked;
        private boolean cancelled;
        private boolean beforeQuery = true;
        static final /* synthetic */ boolean $assertionsDisabled;

        Result(int resultSetsSize) {
            this.resultSets = new ArrayList(resultSetsSize);
        }

        List getResultSets() {
            return this.resultSets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            boolean fin;
            Result result = this;
            synchronized (result) {
                if (!$assertionsDisabled && this.cancelled) {
                    throw new AssertionError();
                }
                fin = this.invoked;
                if (!this.invoked) {
                    this.cancelled = true;
                }
            }
            if (fin) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
        }

        synchronized boolean isQueryInvoked() {
            return this.invoked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean queryInvoked() {
            boolean canc;
            Result result = this;
            synchronized (result) {
                if (!$assertionsDisabled && this.invoked) {
                    throw new AssertionError();
                }
                this.invoked = true;
                canc = this.cancelled;
                this.beforeQuery = false;
            }
            if (canc) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
            return canc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result createRefreshResult() {
            Result result = this;
            synchronized (result) {
                if (this.cancelled) {
                    return null;
                }
                if (this.beforeQuery) {
                    return this;
                }
                if (!$assertionsDisabled && !this.invoked) {
                    throw new AssertionError();
                }
                this.invoked = false;
            }
            Result refreshResult = new Result(this.getResultSets().size());
            refreshResult.beforeQuery = this.beforeQuery;
            CompletionImpl.createRefreshResultSets(this.resultSets, refreshResult);
            return refreshResult;
        }

        void invokeRefresh() {
            CompletionImpl.refreshResultSets(this.getResultSets(), this.beforeQuery);
            if (!this.beforeQuery) {
                this.queryInvoked();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$completion$CompletionImpl == null ? (class$org$netbeans$modules$editor$completion$CompletionImpl = CompletionImpl.class$("org.netbeans.modules.editor.completion.CompletionImpl")) : class$org$netbeans$modules$editor$completion$CompletionImpl).desiredAssertionStatus();
        }
    }

    private final class ParamRunnable
    implements Runnable {
        private static final int SHOW_COMPLETION = 0;
        private static final int SHOW_DOCUMENTATION = 1;
        private static final int SHOW_TOOL_TIP = 2;
        private static final int HIDE_COMPLETION_PANE = 3;
        private static final int HIDE_DOCUMENTATION_PANE = 4;
        private static final int HIDE_TOOL_TIP_PANE = 5;
        private final int opCode;

        ParamRunnable(int opCode) {
            this.opCode = opCode;
        }

        public void run() {
            switch (this.opCode) {
                case 0: {
                    CompletionImpl.this.showCompletion();
                    break;
                }
                case 1: {
                    CompletionImpl.this.showDocumentation();
                    break;
                }
                case 2: {
                    CompletionImpl.this.showToolTip();
                    break;
                }
                case 3: {
                    CompletionImpl.this.hideCompletionPane();
                    break;
                }
                case 4: {
                    CompletionImpl.this.hideDocumentationPane();
                    break;
                }
                case 5: {
                    CompletionImpl.this.hideToolTipPane();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private final class ToolTipShowAction
    extends AbstractAction {
        private ToolTipShowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CompletionImpl.this.showToolTip();
        }
    }

    private final class DocShowAction
    extends AbstractAction {
        private DocShowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CompletionImpl.this.showDocumentation(false);
        }
    }

    private final class CompletionShowAction
    extends AbstractAction {
        private CompletionShowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            CompletionImpl.this.showCompletion(true, false);
        }
    }
}

