/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JSplitPane;
import org.netbeans.modules.beans.beaninfo.BiNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class BiPanel
extends TopComponent
implements ExplorerManager.Provider {
    public static final String BEANINFO_HELP = "beans.beaninfo.nodes";
    private static ExplorerManager em;
    private BeanTreeView btv;
    static final long serialVersionUID = 4088175782441275332L;

    public BiPanel() {
        BiNode.Wait waitNode = new BiNode.Wait();
        this.createContent((Node)waitNode);
    }

    private void createContent(Node biNode) {
        this.btv = new BeanTreeView();
        em = new ExplorerManager();
        PropertySheetView psv = new PropertySheetView();
        try {
            psv.setSortingMode(0);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        JSplitPane sp = new JSplitPane(1, (Component)this.btv, (Component)psv);
        em.setRootContext(biNode);
        em.setExploredContext(biNode);
        this.btv.setDefaultActionAllowed(true);
        this.setLayout(new BorderLayout());
        this.add("Center", sp);
        this.initAccessibility();
    }

    public Dimension getPreferredSize() {
        Dimension sup = super.getPreferredSize();
        return new Dimension(Math.max(sup.width, 450), Math.max(sup.height, 300));
    }

    protected void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)em, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)em, (boolean)false);
        super.componentDeactivated();
    }

    void expandAll() {
        this.btv.expandAll();
    }

    static Node[] getSelectedNodes() {
        return em.getSelectedNodes();
    }

    void setContext(Node node) {
        em.setRootContext(node);
        em.setExploredContext(node);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BEANINFO_HELP);
    }

    private void initAccessibility() {
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.beans.beaninfo.Bundle").getString("ACSN_BeanInfoLeftTreeView"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.beans.beaninfo.Bundle").getString("ACSD_BeanInfoLeftTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }
}

