/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.beans.Introspector;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.EventSetPatternPanel;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.IdxPropertyPatternPanel;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternChildren;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyPatternPanel;
import org.netbeans.modules.beans.UEventSetPatternPanel;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.NewAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public final class PatternGroupNode
extends AbstractNode {
    static final int PATTERN_KIND_PROPERTY = 0;
    static final int PATTERN_KIND_IDX_PROPERTY = 1;
    static final int PATTERN_KIND_UC_EVENT_SET = 2;
    static final int PATTERN_KIND_MC_EVENT_SET = 3;
    private boolean isWritable = true;
    private static final SystemAction[] DEFAULT_ACTIONS;
    private static final SystemAction[] DEFAULT_ACTIONS_NON_WRITEABLE;
    public static final String ICON_BASE = "org/netbeans/modules/beans/resources/patternGroup";
    static final /* synthetic */ boolean $assertionsDisabled;

    public PatternGroupNode(PatternChildren children) {
        this(children, true);
    }

    public PatternGroupNode(PatternChildren children, boolean isWriteable) {
        super((Children)children);
        this.isWritable = isWriteable;
        if (this.isWritable) {
            this.setActions(DEFAULT_ACTIONS);
        } else {
            this.setActions(DEFAULT_ACTIONS_NON_WRITEABLE);
        }
        this.setName(PatternNode.getString("Patterns"));
        this.setShortDescription(PatternNode.getString("Patterns_HINT"));
        this.setIconBase(ICON_BASE);
        CookieSet cs = this.getCookieSet();
        cs.add((Node.Cookie)children.getPatternAnalyser());
    }

    public void setActions(SystemAction[] actions) {
        this.systemActions = actions;
    }

    public NewType[] getNewTypes() {
        return new NewType[]{this.createNewType(PatternNode.getString("MENU_CREATE_PROPERTY"), 0), this.createNewType(PatternNode.getString("MENU_CREATE_IDXPROPERTY"), 1), this.createNewType(PatternNode.getString("MENU_CREATE_UNICASTSE"), 2), this.createNewType(PatternNode.getString("MENU_CREATE_MULTICASTSE"), 3)};
    }

    private NewType createNewType(final String name, final int kind) {
        return new NewType(){

            public String getName() {
                return name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void create() throws IOException {
                try {
                    JMIUtils.beginTrans(true);
                    boolean rollback = true;
                    try {
                        PatternGroupNode.this.createElement(kind);
                        rollback = false;
                    }
                    finally {
                        JMIUtils.endTrans(rollback);
                    }
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        };
    }

    private void createElement(int kind) throws JmiException, GenerateBeanException {
        boolean forInterface = false;
        PatternAnalyser pa = (PatternAnalyser)this.getCookie(PatternAnalyser.class);
        if (pa != null) {
            forInterface = pa.getClassElement() == null ? false : pa.getClassElement().isInterface();
        }
        switch (kind) {
            case 0: {
                PropertyPatternPanel propertyPanel = new PropertyPatternPanel();
                DialogDescriptor dd = new DialogDescriptor((Object)propertyPanel, PatternNode.getString("CTL_TITLE_NewProperty"), true, (ActionListener)propertyPanel);
                dd.setHelpCtx(new HelpCtx("beans.properties"));
                dd.setClosingOptions(new Object[0]);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                propertyPanel.setDialog(dialog);
                propertyPanel.setForInterface(forInterface);
                propertyPanel.setGroupNode(this);
                dialog.setVisible(true);
                if (dd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                    PropertyPatternPanel.Result result = propertyPanel.getResult();
                    PropertyPattern.create(this.getPatternAnalyser(), Introspector.decapitalize(result.name), result.type, result.mode, result.bound, result.constrained, result.withField, result.withReturn, result.withSet, result.withSupport);
                }
                return;
            }
            case 1: {
                IdxPropertyPatternPanel idxPropertyPanel = new IdxPropertyPatternPanel();
                DialogDescriptor dd = new DialogDescriptor((Object)idxPropertyPanel, PatternNode.getString("CTL_TITLE_NewIdxProperty"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("beans.properties"), (ActionListener)idxPropertyPanel);
                dd.setClosingOptions(new Object[0]);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                idxPropertyPanel.setDialog(dialog);
                idxPropertyPanel.setForInterface(forInterface);
                idxPropertyPanel.setGroupNode(this);
                dialog.setVisible(true);
                if (dd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                    IdxPropertyPatternPanel.Result result = idxPropertyPanel.getResult();
                    IdxPropertyPattern.create(this.getPatternAnalyser(), Introspector.decapitalize(result.name), result.type, result.mode, result.bound, result.constrained, result.withField, result.withReturn, result.withSet, result.withSupport, result.niGetter, result.niWithReturn, result.niSetter, result.niWithSet);
                }
                return;
            }
            case 2: {
                UEventSetPatternPanel uEventSetPanel = new UEventSetPatternPanel(this.getPatternAnalyser());
                DialogDescriptor dd = new DialogDescriptor((Object)uEventSetPanel, PatternNode.getString("CTL_TITLE_NewUniCastES"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("beans.eventsets"), (ActionListener)uEventSetPanel);
                dd.setClosingOptions(new Object[0]);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                uEventSetPanel.setDialog(dialog);
                uEventSetPanel.setForInterface(forInterface);
                uEventSetPanel.setGroupNode(this);
                dialog.setVisible(true);
                if (dd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                    UEventSetPatternPanel.Result result = uEventSetPanel.getResult();
                    EventSetPattern.create(this.getPatternAnalyser(), result.type, result.implementation, result.firing, result.passEvent, true);
                }
                return;
            }
            case 3: {
                EventSetPatternPanel eventSetPanel = new EventSetPatternPanel(this.getPatternAnalyser());
                DialogDescriptor dd = new DialogDescriptor((Object)eventSetPanel, PatternNode.getString("CTL_TITLE_NewMultiCastES"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("beans.eventsets"), (ActionListener)eventSetPanel);
                dd.setClosingOptions(new Object[0]);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                eventSetPanel.setDialog(dialog);
                eventSetPanel.setForInterface(forInterface);
                eventSetPanel.setGroupNode(this);
                dialog.setVisible(true);
                if (dd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                    EventSetPatternPanel.Result result = eventSetPanel.getResult();
                    EventSetPattern.create(this.getPatternAnalyser(), result.type, result.implementation, result.firing, result.passEvent, false);
                }
                return;
            }
        }
    }

    boolean propertyExists(String name) {
        Collection[] patterns = new Collection[2];
        String decapName = Introspector.decapitalize(name);
        PatternAnalyser pa = this.getPatternAnalyser();
        if (!pa.isAnalyzed()) {
            pa.analyzeAll();
        }
        patterns[0] = pa.getPropertyPatterns();
        patterns[1] = pa.getIdxPropertyPatterns();
        for (int i = 0; i < patterns.length && patterns[i] != null; ++i) {
            Iterator it = patterns[i].iterator();
            while (it.hasNext()) {
                if (!((Pattern)it.next()).getName().equals(decapName)) continue;
                return true;
            }
        }
        return false;
    }

    EventSetPattern findEventSetPattern(Type type) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (!(type instanceof JavaClass)) {
            return null;
        }
        String name = Introspector.decapitalize(((JavaClass)type).getSimpleName());
        Collection eventSets = this.getPatternAnalyser().getEventSetPatterns();
        Iterator it = eventSets.iterator();
        while (it.hasNext()) {
            EventSetPattern pattern = (EventSetPattern)it.next();
            if (!name.equals(pattern.getName())) continue;
            return pattern;
        }
        return null;
    }

    private PatternAnalyser getPatternAnalyser() {
        return (PatternAnalyser)this.getCookie(PatternAnalyser.class);
    }

    static {
        $assertionsDisabled = !PatternGroupNode.class.desiredAssertionStatus();
        DEFAULT_ACTIONS = new SystemAction[]{SystemAction.get((Class)GenerateBeanInfoAction.class), null, SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
        DEFAULT_ACTIONS_NON_WRITEABLE = new SystemAction[]{SystemAction.get((Class)GenerateBeanInfoAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }
}

