/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

public class ImportBuildfile
extends JPanel
implements DocumentListener {
    private JButton ok;
    private File buildFileDir;
    private JLabel jLabelBuildName;
    private JLabel jLabelCreatedFile;
    private JLabel jLabelDesc;
    private JTextField jTextFieldBuildName;
    private JTextField jTextFieldCreatedFile;

    public ImportBuildfile(File buildFile, JButton okButton) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportBuildfile.class, (String)"ACS_IW_BuildFileDialog_A11YDesc"));
        this.ok = okButton;
        this.buildFileDir = buildFile.getParentFile();
        this.ok.setEnabled(false);
        String msg = MessageFormat.format(NbBundle.getMessage(ImportBuildfile.class, (String)"LBL_IW_BuildfileDesc_Label"), buildFile.getAbsolutePath());
        this.jLabelDesc.setText(msg);
        this.jTextFieldBuildName.getDocument().addDocumentListener(this);
        this.jTextFieldBuildName.setText(NbBundle.getMessage(ImportBuildfile.class, (String)"LBL_IW_ProposedName_TextField"));
        this.resize();
    }

    private void resize() {
        int width = new Double(this.jLabelDesc.getFontMetrics(this.jLabelDesc.getFont()).getStringBounds(this.jLabelDesc.getText(), this.getGraphics()).getWidth() / 2.7).intValue() + 40;
        int height = this.jLabelDesc.getFont().getSize() * 5 + 100;
        if (width < 400) {
            width = 400;
        }
        if (height < 160) {
            height = 160;
        }
        Dimension dim = new Dimension(width, height);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    private void initComponents() {
        this.jLabelDesc = new JLabel();
        this.jLabelBuildName = new JLabel();
        this.jTextFieldBuildName = new JTextField();
        this.jLabelCreatedFile = new JLabel();
        this.jTextFieldCreatedFile = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.jLabelDesc, gridBagConstraints);
        this.jLabelBuildName.setDisplayedMnemonic(NbBundle.getMessage(ImportBuildfile.class, (String)"LBL_IW_BuildFilename_LabelMnemonic").charAt(0));
        this.jLabelBuildName.setLabelFor(this.jTextFieldBuildName);
        this.jLabelBuildName.setText(NbBundle.getMessage(ImportBuildfile.class, (String)"LBL_IW_BuildFilename_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.jLabelBuildName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jTextFieldBuildName, gridBagConstraints);
        this.jTextFieldBuildName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportBuildfile.class, (String)"ACS_LBL_IW_BuildFilename_A11YDesc"));
        this.jLabelCreatedFile.setDisplayedMnemonic(NbBundle.getMessage(ImportBuildfile.class, (String)"LBL_IW_CreatedFile_LabelMnemonic").charAt(0));
        this.jLabelCreatedFile.setLabelFor(this.jTextFieldCreatedFile);
        this.jLabelCreatedFile.setText(NbBundle.getMessage(ImportBuildfile.class, (String)"LBL_IW_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.add((Component)this.jLabelCreatedFile, gridBagConstraints);
        this.jTextFieldCreatedFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jTextFieldCreatedFile, gridBagConstraints);
        this.jTextFieldCreatedFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportBuildfile.class, (String)"ACS_LBL_IW_CreatedFile_A11YDesc"));
    }

    protected String getBuildName() {
        return this.jTextFieldBuildName.getText().trim();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateButton();
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateButton();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateButton();
    }

    private void updateButton() {
        String buildFileName = this.getBuildName();
        File buildFile = new File(this.buildFileDir, buildFileName);
        this.jTextFieldCreatedFile.setText(buildFile.getAbsolutePath());
        this.ok.setEnabled(buildFileName.length() != 0 && !buildFile.exists());
    }
}

