/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewLayoutQueue;
import org.netbeans.editor.view.spi.ViewLayoutState;
import org.netbeans.lib.editor.view.GapBoxView;
import org.netbeans.lib.editor.view.GapBoxViewChildren;
import org.netbeans.lib.editor.view.GapDocumentViewChildren;

public class GapDocumentView
extends GapBoxView {
    private static final boolean debugPaint = Boolean.getBoolean("netbeans.debug.editor.view.paint");
    private static final boolean debugRepaint = Boolean.getBoolean("netbeans.debug.editor.view.repaint");
    private static final int ASYNC_CHILDREN_UPDATE_COUNT = 20;
    private static final int CHILDREN_UPDATE_SUBTASK_COUNT = 50;
    private ChildrenUpdateTask childrenUpdateTask;
    private int lastAllocationX;
    private int lastAllocationY;
    private int lastAllocationWidth;
    private int lastAllocationHeight;
    private double firstRepaintChildYSubOffset;
    private double firstRepaintChildYSubSpan;
    private float firstRepaintChildXSubOffset;
    private int layoutLockDepth;

    public GapDocumentView(Element elem) {
        super(elem, 1);
    }

    protected GapBoxViewChildren createChildren() {
        return new GapDocumentViewChildren(this);
    }

    protected Rectangle reallocate(Shape a) {
        Rectangle alloc = super.reallocate(a);
        this.lastAllocationX = alloc.x;
        this.lastAllocationY = alloc.y;
        this.lastAllocationWidth = alloc.width;
        this.lastAllocationHeight = alloc.height;
        return alloc;
    }

    protected void directUpdateLayout() {
        if (this.layoutLockDepth == 0) {
            super.directUpdateLayout();
        }
    }

    protected final void layoutLock() {
        ++this.layoutLockDepth;
    }

    protected final void layoutUnlock() {
        --this.layoutLockDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderWithUpdateLayout(Runnable r) {
        ++this.layoutLockDepth;
        try {
            r.run();
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(View parent) {
        ++this.layoutLockDepth;
        try {
            super.setParent(parent);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(float width, float height) {
        ++this.layoutLockDepth;
        try {
            super.setSize(width, height);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
        ++this.layoutLockDepth;
        try {
            super.insertUpdate(evt, a, f);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(DocumentEvent evt, Shape a, ViewFactory f) {
        ++this.layoutLockDepth;
        try {
            super.removeUpdate(evt, a, f);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        ++this.layoutLockDepth;
        try {
            super.changedUpdate(e, a, f);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, Shape a) {
        if (debugPaint) {
            System.err.println("VIEW-PAINT: clip=" + g.getClipBounds() + ", alloc=" + a);
        }
        ++this.layoutLockDepth;
        try {
            super.paint(g, a);
        }
        finally {
            this.updateLayout();
            --this.layoutLockDepth;
        }
    }

    public void repaint(ViewLayoutState child, double majorAxisOffset, double majorAxisSpan, float minorAxisOffset, float minorAxisSpan) {
        int childIndex = this.getChildIndexNoCheck(child);
        if (this.markRepaint(childIndex, false)) {
            this.firstRepaintChildYSubOffset = majorAxisOffset;
            this.firstRepaintChildXSubOffset = minorAxisOffset;
        }
    }

    protected boolean markRepaint(int childIndex, boolean repaintTillEnd) {
        boolean lowerIndexMarked = super.markRepaint(childIndex, repaintTillEnd);
        if (lowerIndexMarked) {
            this.firstRepaintChildYSubOffset = 0.0;
            this.firstRepaintChildXSubOffset = 0.0f;
        }
        return lowerIndexMarked;
    }

    protected void processRepaint(ViewLayoutState.Parent lsParent) {
        int firstRepaintChildIndex = this.getChildren().getFirstRepaintChildIndex();
        if (firstRepaintChildIndex >= 0 && firstRepaintChildIndex < this.getViewCount()) {
            Container c;
            int repaintHeight;
            int repaintX;
            double repY = this.getChildren().getMajorAxisOffset(firstRepaintChildIndex);
            int repaintY = (int)Math.floor(repY += this.firstRepaintChildYSubOffset);
            if (this.isRepaintTillEnd()) {
                repaintX = 0;
                repaintHeight = this.lastAllocationHeight;
            } else {
                repaintX = (int)Math.floor(this.firstRepaintChildXSubOffset);
                double repYEnd = repY + this.getChild(firstRepaintChildIndex).getLayoutMajorAxisPreferredSpan();
                repaintHeight = (int)Math.ceil(repYEnd) - repaintY;
            }
            int repaintWidth = this.lastAllocationWidth - repaintX;
            repaintX += this.lastAllocationX;
            if (debugRepaint) {
                System.err.println("REPAINT(childIndex=" + firstRepaintChildIndex + ", rect(" + repaintX + ", " + repaintY + ", " + repaintWidth + ", " + repaintHeight + "))");
            }
            if ((c = this.getContainer()) != null) {
                c.repaint(repaintX, repaintY, repaintWidth, repaintHeight);
            }
        }
    }

    ChildrenUpdateTask getChildrenUpdateTask() {
        if (this.childrenUpdateTask == null) {
            this.childrenUpdateTask = new ChildrenUpdateTask();
        }
        return this.childrenUpdateTask;
    }

    protected void resetEstimatedSpan(int childIndex, int count) {
        if (count >= 20) {
            ChildrenUpdateTask updateTask = this.getChildrenUpdateTask();
            updateTask.markResetChildEstimatedSpan();
            updateTask.setChildIndex(childIndex);
            if (!updateTask.isRunning()) {
                updateTask.start();
            }
        } else {
            super.resetEstimatedSpan(childIndex, count);
        }
    }

    protected void markSizeInvalid(int childIndex, int count) {
        if (count >= 20) {
            ChildrenUpdateTask updateTask = this.getChildrenUpdateTask();
            updateTask.markUpdateChildSize();
            updateTask.setChildIndex(0);
            if (!updateTask.isRunning()) {
                updateTask.start();
            }
        } else {
            super.markSizeInvalid(childIndex, count);
        }
    }

    protected final int getLastAllocationX() {
        return this.lastAllocationX;
    }

    protected final int getLastAllocationY() {
        return this.lastAllocationY;
    }

    protected final int getLastAllocationWidth() {
        return this.lastAllocationWidth;
    }

    protected final int getLastAllocationHeight() {
        return this.lastAllocationHeight;
    }

    protected ViewLayoutQueue getLayoutQueue() {
        return ViewLayoutQueue.getDefaultQueue();
    }

    final class ChildrenUpdateTask
    implements Runnable {
        private int childIndex = Integer.MAX_VALUE;
        private boolean running;
        private boolean updateChildSize;
        private boolean resetChildEstimatedSpan;

        ChildrenUpdateTask() {
        }

        void markUpdateChildSize() {
            this.updateChildSize = true;
        }

        void markResetChildEstimatedSpan() {
            this.resetChildEstimatedSpan = true;
        }

        void start() {
            this.running = true;
            GapDocumentView.this.getLayoutQueue().addTask(this);
        }

        boolean isRunning() {
            return this.running;
        }

        private void finish() {
            this.running = false;
            this.updateChildSize = false;
            this.resetChildEstimatedSpan = false;
            this.childIndex = Integer.MAX_VALUE;
        }

        void setChildIndex(int childIndex) {
            if (childIndex < this.childIndex) {
                this.childIndex = childIndex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                AbstractDocument doc = (AbstractDocument)GapDocumentView.this.getDocument();
                if (doc != null) {
                    doc.readLock();
                    try {
                        LockView lockView = LockView.get(GapDocumentView.this);
                        if (lockView == null) break block10;
                        lockView.lock();
                        try {
                            GapDocumentView.this.layoutLock();
                            try {
                                this.updateView(lockView);
                            }
                            finally {
                                GapDocumentView.this.updateLayout();
                                GapDocumentView.this.layoutUnlock();
                            }
                        }
                        finally {
                            lockView.unlock();
                        }
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
            }
        }

        private void updateView(LockView lockView) {
            if (GapDocumentView.this.getContainer() == null) {
                this.finish();
                return;
            }
            int viewCount = GapDocumentView.this.getViewCount();
            int updateCount = Math.max(1, viewCount / 50);
            while (updateCount > 0 && this.childIndex < viewCount && !lockView.isPriorityThreadWaiting()) {
                ViewLayoutState child = GapDocumentView.this.getChild(this.childIndex);
                if (!child.isFlyweight()) {
                    View childView = child.getView();
                    if (this.resetChildEstimatedSpan && childView instanceof EstimatedSpanView) {
                        ((EstimatedSpanView)((Object)childView)).setEstimatedSpan(false);
                    }
                    if (this.updateChildSize) {
                        child.markViewSizeInvalid();
                    }
                    child.updateLayout();
                    --updateCount;
                }
                ++this.childIndex;
            }
            if (this.childIndex < viewCount) {
                GapDocumentView.this.getLayoutQueue().addTask(this);
            } else {
                this.finish();
            }
        }
    }
}

