/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.WeakEventListenerList;

public class Registry {
    private static final WeakReference[] EMPTY = new WeakReference[0];
    private static WeakReference[] docRefs = EMPTY;
    private static int docRefsCount;
    private static final ArrayList docAct;
    private static WeakReference[] compRefs;
    private static int compRefsCount;
    private static final ArrayList compAct;
    private static final WeakEventListenerList listenerList;
    private static int consolidateCounter;

    public static void addChangeListener(ChangeListener l) {
        listenerList.add(ChangeListener.class, l);
    }

    public static void removeChangeListener(ChangeListener l) {
        listenerList.remove(ChangeListener.class, l);
    }

    public static synchronized int getID(BaseDocument doc) {
        Integer i = Registry.getIDInteger(doc);
        return i != null ? i : -1;
    }

    public static synchronized int getID(JTextComponent c) {
        return Registry.getIDImpl(c);
    }

    public static synchronized BaseDocument getDocument(int docID) {
        if (docID < 0 || docID >= docRefsCount) {
            return null;
        }
        WeakReference wr = docRefs[docID];
        return wr != null ? (BaseDocument)wr.get() : null;
    }

    public static synchronized JTextComponent getComponent(int compID) {
        if (compID < 0 || compID >= compRefsCount) {
            return null;
        }
        WeakReference wr = compRefs[compID];
        return wr != null ? (JTextComponent)wr.get() : null;
    }

    public static synchronized int addDocument(BaseDocument doc) {
        Integer docID = Registry.getIDInteger(doc);
        if (docID != null) {
            return docID;
        }
        if (docRefsCount >= docRefs.length) {
            docRefs = Registry.realloc(docRefs);
        }
        Registry.docRefs[Registry.docRefsCount] = new WeakReference<BaseDocument>(doc);
        doc.putProperty("id", new Integer(docRefsCount));
        return docRefsCount++;
    }

    public static synchronized int addComponent(JTextComponent c) {
        int compID = Registry.getIDImpl(c);
        if (compID != -1) {
            return compID;
        }
        if (compRefsCount >= compRefs.length) {
            compRefs = Registry.realloc(compRefs);
        }
        Registry.compRefs[Registry.compRefsCount] = new WeakReference<JTextComponent>(c);
        ((BaseTextUI)c.getUI()).componentID = compRefsCount;
        return compRefsCount++;
    }

    public static synchronized int removeComponent(JTextComponent c) {
        int compID = Registry.getIDImpl(c);
        if (compID != -1) {
            Registry.compRefs[compID] = null;
            for (int i = compAct.size() - 1; i >= 0; --i) {
                if ((Integer)compAct.get(i) != compID) continue;
                compAct.remove(i);
                break;
            }
        }
        return compID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(JTextComponent c) {
        boolean activated = true;
        Class clazz = Registry.class;
        synchronized (clazz) {
            Document doc;
            int ind;
            int compID = Registry.getIDImpl(c);
            if (compID == -1) {
                return;
            }
            int actSize = compAct.size();
            for (ind = 0; ind < actSize; ++ind) {
                int id = (Integer)compAct.get(ind);
                if (id != compID) continue;
                if (ind == 0) break;
                compAct.add(0, compAct.remove(ind));
                activated = true;
                break;
            }
            if (ind == actSize) {
                compAct.add(0, new Integer(compID));
                activated = true;
            }
            if ((doc = c.getDocument()) instanceof BaseDocument && Registry.doActivate((BaseDocument)doc)) {
                activated = true;
            }
        }
        if (activated) {
            Registry.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(BaseDocument doc) {
        boolean activated;
        Class clazz = Registry.class;
        synchronized (clazz) {
            activated = Registry.doActivate(doc);
        }
        if (activated) {
            Registry.fireChange();
        }
    }

    public static synchronized BaseDocument getMostActiveDocument() {
        return Registry.getValidDoc(0, true);
    }

    public static synchronized BaseDocument getLeastActiveDocument() {
        int lastInd = docAct.size() - 1;
        return Registry.getValidDoc(lastInd, false);
    }

    public static BaseDocument getLessActiveDocument(BaseDocument doc) {
        return Registry.getLessActiveDocument(Registry.getID(doc));
    }

    public static synchronized BaseDocument getLessActiveDocument(int docID) {
        return Registry.getNextActiveDoc(docID, true);
    }

    public static BaseDocument getMoreActiveDocument(BaseDocument doc) {
        return Registry.getMoreActiveDocument(Registry.getID(doc));
    }

    public static synchronized BaseDocument getMoreActiveDocument(int docID) {
        return Registry.getNextActiveDoc(docID, false);
    }

    public static synchronized Iterator getDocumentIterator() {
        Registry.consolidate();
        ArrayList docList = new ArrayList();
        int actSize = docAct.size();
        for (int i = 0; i < actSize; ++i) {
            Object doc;
            int ind = (Integer)docAct.get(i);
            WeakReference wr = docRefs[ind];
            if (wr == null || (doc = wr.get()) == null) continue;
            docList.add(doc);
        }
        return docList.iterator();
    }

    public static synchronized JTextComponent getMostActiveComponent() {
        return Registry.getValidComp(0, true);
    }

    public static synchronized JTextComponent getLeastActiveComponent() {
        int lastInd = compAct.size() - 1;
        return Registry.getValidComp(lastInd, false);
    }

    public static JTextComponent getLessActiveComponent(JTextComponent c) {
        return Registry.getLessActiveComponent(Registry.getID(c));
    }

    public static synchronized JTextComponent getLessActiveComponent(int compID) {
        return Registry.getNextActiveComp(compID, true);
    }

    public static JTextComponent getMoreActiveComponent(JTextComponent c) {
        return Registry.getMoreActiveComponent(Registry.getID(c));
    }

    public static synchronized JTextComponent getMoreActiveComponent(int compID) {
        return Registry.getNextActiveComp(compID, false);
    }

    public static synchronized Iterator getComponentIterator() {
        Registry.consolidate();
        ArrayList compList = new ArrayList();
        int actSize = compAct.size();
        for (int i = 0; i < actSize; ++i) {
            Object comp;
            int ind = (Integer)compAct.get(i);
            WeakReference wr = compRefs[ind];
            if (wr == null || (comp = wr.get()) == null) continue;
            compList.add(comp);
        }
        return compList.iterator();
    }

    private static WeakReference[] realloc(WeakReference[] refs) {
        WeakReference[] tmp = new WeakReference[refs.length * 2 + 4];
        System.arraycopy(refs, 0, tmp, 0, refs.length);
        return tmp;
    }

    private static void consolidate() {
        while (++consolidateCounter >= 20) {
            WeakReference wr;
            int ind;
            int i;
            consolidateCounter = 0;
            for (i = docAct.size() - 1; i >= 0; --i) {
                ind = (Integer)docAct.get(i);
                wr = docRefs[ind];
                if (wr == null || wr.get() != null) continue;
                docAct.remove(i);
                Registry.docRefs[ind] = null;
            }
            for (i = compAct.size() - 1; i >= 0; --i) {
                ind = (Integer)compAct.get(i);
                wr = compRefs[ind];
                if (wr == null || wr.get() != null) continue;
                compAct.remove(i);
                Registry.compRefs[ind] = null;
            }
        }
    }

    private static int getIDImpl(JTextComponent c) {
        if (c == null) {
            return -1;
        }
        return ((BaseTextUI)c.getUI()).componentID;
    }

    private static Integer getIDInteger(BaseDocument doc) {
        if (doc == null) {
            return null;
        }
        return (Integer)doc.getProperty("id");
    }

    private static boolean doActivate(BaseDocument doc) {
        Integer docIDInteger = Registry.getIDInteger(doc);
        if (docIDInteger == null) {
            return false;
        }
        int docID = docIDInteger != null ? docIDInteger : -1;
        int size = docAct.size();
        for (int ind = 0; ind < size; ++ind) {
            int id = (Integer)docAct.get(ind);
            if (id != docID) continue;
            if (ind == 0) {
                return false;
            }
            docAct.add(0, docAct.remove(ind));
            return true;
        }
        docAct.add(0, docIDInteger);
        return true;
    }

    private static BaseDocument getValidDoc(int ind, boolean forward) {
        Registry.consolidate();
        int actSize = docAct.size();
        while (ind >= 0 && ind < actSize) {
            BaseDocument doc;
            int docID = (Integer)docAct.get(ind);
            WeakReference wr = docRefs[docID];
            BaseDocument baseDocument = doc = wr != null ? (BaseDocument)wr.get() : null;
            if (doc != null) {
                return doc;
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static BaseDocument getNextActiveDoc(int docID, boolean forward) {
        int ind;
        Registry.consolidate();
        int actSize = docAct.size();
        int n = ind = forward ? 0 : actSize - 1;
        while (ind >= 0 && ind < actSize) {
            if ((Integer)docAct.get(ind) == docID) {
                return Registry.getValidDoc(ind += forward ? 1 : -1, forward);
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getValidComp(int ind, boolean forward) {
        Registry.consolidate();
        int actSize = compAct.size();
        while (ind >= 0 && ind < actSize) {
            JTextComponent c;
            int compID = (Integer)compAct.get(ind);
            WeakReference wr = compRefs[compID];
            JTextComponent jTextComponent = c = wr != null ? (JTextComponent)wr.get() : null;
            if (c != null) {
                return c;
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getNextActiveComp(int compID, boolean forward) {
        int ind;
        int actSize = compAct.size();
        int n = ind = forward ? 0 : actSize - 1;
        while (ind >= 0 && ind < actSize) {
            if ((Integer)compAct.get(ind) == compID) {
                return Registry.getValidComp(ind += forward ? 1 : -1, forward);
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static void fireChange() {
        ChangeListener[] listeners = (ChangeListener[])listenerList.getListeners(ChangeListener.class);
        ChangeEvent evt = new ChangeEvent(Registry.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(evt);
        }
    }

    public static synchronized String registryToString() {
        WeakReference wr;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Document References:\n");
        for (i = 0; i < docRefsCount; ++i) {
            wr = docRefs[i];
            sb.append("docRefs[" + i + "]=" + (wr != null ? wr.get() : "null") + "\n");
        }
        sb.append("Component References:\n");
        for (i = 0; i < compRefsCount; ++i) {
            wr = compRefs[i];
            sb.append("compRefs[" + i + "]=" + (wr != null ? wr.get() : "null") + "\n");
        }
        sb.append("\nActive Document Indexes:\n");
        for (i = 0; i < docAct.size(); ++i) {
            sb.append(docAct.get(i));
            if (i == docAct.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("\nActive Component Indexes:\n");
        for (i = 0; i < compAct.size(); ++i) {
            sb.append(compAct.get(i));
            if (i == compAct.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    static {
        docAct = new ArrayList();
        compRefs = EMPTY;
        compAct = new ArrayList();
        listenerList = new WeakEventListenerList();
    }
}

