/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JmsResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PropertyElement;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.editors.IsolationLevelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ListServerInstances;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceConfigurator;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.share.serverresources.SunDatasource;
import org.netbeans.modules.j2ee.sun.sunresources.beans.DatabaseUtils;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ResourceUtils
implements WizardConstants {
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.beans.Bundle");
    static final String[] sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool", "jdbc/__default"};
    static final String[] sysConnpools = new String[]{"__CallFlowPool", "__TimerPool", "DerbyPool"};
    static final String SAMPLE_DATASOURCE = "jdbc/sample";
    static final String SAMPLE_CONNPOOL = "SamplePool";
    static final String MAP_RESOURCES = "com.sun.appserv:type=resources,category=config";
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final char REPLACEMENT_CHAR = '_';
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|', ','};
    private static final char[] ILLEGAL_RESOURCE_NAME_CHARS = new char[]{':', '*', '?', '\"', '<', '>', '|', ','};

    public static void saveNodeToXml(FileObject resFile, Resources res) {
        try {
            res.write(FileUtil.toFile((FileObject)resFile));
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public static void register(Resources resource, SunDeploymentManagerInterface sunDm, boolean update, String resType) throws Exception {
        if (sunDm.isRunning()) {
            ServerInterface mejb = sunDm.getManagement();
            if (resType.equals("jdbc-connection-pool")) {
                ResourceUtils.register(resource.getJdbcConnectionPool(0), mejb, update);
            } else if (resType.equals("jdbc-resource")) {
                ResourceUtils.register(resource.getJdbcResource(0), mejb, update);
            } else if (resType.equals("persistence-manager-factory-resource")) {
                ResourceUtils.register(resource.getPersistenceManagerFactoryResource(0), mejb, update);
            } else if (resType.equals("mail-resource")) {
                ResourceUtils.register(resource.getMailResource(0), mejb, update);
            } else if (resType.equals("jms-resource")) {
                if (resource.getAdminObjectResource().length != 0) {
                    ResourceUtils.register(resource.getAdminObjectResource(0), mejb, update);
                } else if (resource.getConnectorResource().length != 0 && resource.getConnectorConnectionPool().length != 0) {
                    ResourceUtils.register(resource.getConnectorConnectionPool(0), mejb, update);
                    ResourceUtils.register(resource.getConnectorResource(0), mejb, update);
                }
            }
        } else {
            throw new Exception(bundle.getString("Err_RegResServerStopped"));
        }
    }

    public static void register(JdbcConnectionPool resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource, mejb);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getJdbcConnectionPool")) {
            ResourceUtils.createResource("createJdbcConnectionPool", params, mejb);
        }
    }

    public static void register(JdbcResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getJdbcResource")) {
            ResourceUtils.createResource("createJdbcResource", params, mejb);
        }
    }

    public static void register(PersistenceManagerFactoryResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getPersistenceManagerFactoryResource")) {
            ResourceUtils.createResource("createPersistenceManagerFactoryResource", params, mejb);
        }
    }

    public static void register(AdminObjectResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getAdminObjectResource")) {
            ResourceUtils.createResource("createAdminObjectResource", params, mejb);
        }
    }

    public static void register(ConnectorResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        Properties propsList = new Properties();
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getConnectorResource")) {
            ResourceUtils.createResource("createConnectorResource", params, mejb);
        }
    }

    public static void register(ConnectorConnectionPool resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getConnectorConnectionPool")) {
            ResourceUtils.createResource("createConnectorConnectionPool", params, mejb);
        }
    }

    public static void register(MailResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getMailResource")) {
            ResourceUtils.createResource("createMailResource", params, mejb);
        }
    }

    public static void register(JmsResource resource, ServerInterface mejb, boolean update) throws Exception {
        AttributeList attrList = ResourceUtils.getResourceAttributes(resource);
        PropertyElement[] props = resource.getPropertyElement();
        Properties propsList = ResourceUtils.getProperties(props);
        Object[] params = new Object[]{attrList, propsList, null};
        String operName = NbBundle.getMessage((Class)ListServerInstances.class, (String)"CreateJMS");
        String resourceName = resource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(resourceName, mejb, attrList, propsList, "getJmsResource")) {
            ResourceUtils.createResource(operName, params, mejb);
        }
    }

    private static boolean isResourceUpdated(String resourceName, ServerInterface mejb, AttributeList attrList, Properties props, String operName) {
        boolean isResUpdated = false;
        try {
            ObjectName objName = new ObjectName(MAP_RESOURCES);
            ObjectName[] resourceObjects = null;
            if (operName.equals("getPersistenceManagerFactoryResource") || operName.equals("getJmsResource")) {
                String[] signature = new String[]{"java.lang.String"};
                Object[] params = new Object[]{null};
                resourceObjects = (ObjectName[])mejb.invoke(objName, operName, params, signature);
            } else {
                resourceObjects = (ObjectName[])mejb.invoke(objName, operName, null, null);
            }
            if (resourceObjects != null) {
                ObjectName resOnServer = null;
                resOnServer = operName.equals("getJdbcConnectionPool") || operName.equals("getConnectorConnectionPool") ? ResourceUtils.getResourceDeployed(resourceObjects, resourceName, false) : ResourceUtils.getResourceDeployed(resourceObjects, resourceName, true);
                if (resOnServer != null) {
                    isResUpdated = true;
                    ResourceUtils.updateResourceAttributes(resOnServer, attrList, mejb);
                    ResourceUtils.updateResourceProperties(resOnServer, props, mejb);
                }
            }
        }
        catch (Exception ex) {
            String errorMsg = MessageFormat.format(bundle.getString("Err_ResourceUpdate"), resourceName);
            System.out.println(errorMsg);
        }
        return isResUpdated;
    }

    private static ObjectName getResourceDeployed(ObjectName[] resourceObjects, String resourceName, boolean useJndi) {
        for (int i = 0; i < resourceObjects.length; ++i) {
            ObjectName resObj = resourceObjects[i];
            String jndiName = null;
            jndiName = useJndi ? resObj.getKeyProperty("jndi-name") : resObj.getKeyProperty("name");
            if (!jndiName.equals(resourceName)) continue;
            return resObj;
        }
        return null;
    }

    public static void updateResourceAttributes(ObjectName objName, AttributeList attrList, ServerInterface mejb) throws Exception {
        try {
            Map attributeInfos = ResourceUtils.getResourceAttributeNames(objName, mejb);
            String[] attrNames = attributeInfos.keySet().toArray(new String[attributeInfos.size()]);
            AttributeList existAttrList = mejb.getAttributes(objName, attrNames);
            for (int i = 0; i < existAttrList.size(); ++i) {
                Attribute existAttr = (Attribute)existAttrList.get(i);
                String existAttrName = existAttr.getName();
                for (int j = 0; j < attrList.size(); ++j) {
                    Attribute resAttr = (Attribute)attrList.get(j);
                    String resAttrName = resAttr.getName();
                    if (!existAttrName.equals(resAttrName)) continue;
                    if (resAttr.getValue() == null && existAttr.getValue() != null) {
                        mejb.setAttribute(objName, resAttr);
                        continue;
                    }
                    if (existAttr.getValue() == null) {
                        if (resAttr.getValue() == null || resAttr.getValue().toString().equals("")) continue;
                        mejb.setAttribute(objName, resAttr);
                        continue;
                    }
                    if (resAttr.getValue().toString().equals(existAttr.getValue().toString())) continue;
                    mejb.setAttribute(objName, resAttr);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage());
        }
    }

    public static void updateResourceProperties(ObjectName objName, Properties props, ServerInterface mejb) throws Exception {
        try {
            String[] signature = new String[]{"javax.management.Attribute"};
            Object[] params = null;
            AttributeList attrList = (AttributeList)mejb.invoke(objName, "getProperties", null, null);
            for (int i = 0; i < attrList.size(); ++i) {
                Attribute oldAttr = (Attribute)attrList.get(i);
                String oldAttrName = oldAttr.getName();
                if (props.containsKey(oldAttrName)) {
                    if (oldAttr.getValue() != null) {
                        String oldAttrValue = oldAttr.getValue().toString();
                        if (props.getProperty(oldAttrName).equals(oldAttrValue)) continue;
                        Attribute attr = new Attribute(oldAttrName, props.getProperty(oldAttrName));
                        params = new Object[]{attr};
                        mejb.invoke(objName, "setProperty", params, signature);
                        continue;
                    }
                    if (props.getProperty(oldAttrName) == null) continue;
                    Attribute attr = new Attribute(oldAttrName, props.getProperty(oldAttrName));
                    params = new Object[]{attr};
                    mejb.invoke(objName, "setProperty", params, signature);
                    continue;
                }
                Attribute removeAttr = new Attribute(oldAttrName, null);
                params = new Object[]{removeAttr};
                mejb.invoke(objName, "setProperty", params, signature);
            }
            ResourceUtils.addNewExtraProperties(objName, props, attrList, mejb);
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage());
        }
    }

    private static Map getResourceAttributeNames(ObjectName objName, ServerInterface mejb) throws Exception {
        try {
            HashMap<String, MBeanAttributeInfo> attributeInfos = new HashMap<String, MBeanAttributeInfo>();
            MBeanInfo info = mejb.getMBeanInfo(objName);
            MBeanAttributeInfo[] attrs = info.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] == null) continue;
                attributeInfos.put(attrs[i].getName(), attrs[i]);
            }
            return attributeInfos;
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage());
        }
    }

    private static void addNewExtraProperties(ObjectName objName, Properties props, AttributeList attrList, ServerInterface mejb) throws Exception {
        try {
            String[] signature = new String[]{"javax.management.Attribute"};
            Object[] params = null;
            if (props.size() > attrList.size()) {
                Enumeration<?> listProps = props.propertyNames();
                while (listProps.hasMoreElements()) {
                    String propName = listProps.nextElement().toString();
                    if (attrList.contains(propName)) continue;
                    Attribute attr = new Attribute(propName, props.getProperty(propName));
                    params = new Object[]{attr};
                    mejb.invoke(objName, "setProperty", params, signature);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage());
        }
    }

    public static void createResource(String operName, Object[] params, ServerInterface mejb) throws Exception {
        try {
            ObjectName objName = new ObjectName(MAP_RESOURCES);
            String[] signature = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
            mejb.invoke(objName, operName, params, signature);
        }
        catch (Exception ex) {
            throw new Exception(ex.getLocalizedMessage());
        }
    }

    public static AttributeList getResourceAttributes(JdbcConnectionPool connPool, ServerInterface mejb) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("name", connPool.getName()));
        attrs.add(new Attribute("datasource-classname", connPool.getDatasourceClassname()));
        attrs.add(new Attribute("res-type", connPool.getResType()));
        attrs.add(new Attribute("steady-pool-size", connPool.getSteadyPoolSize()));
        attrs.add(new Attribute("max-pool-size", connPool.getMaxPoolSize()));
        attrs.add(new Attribute("max-wait-time-in-millis", connPool.getMaxWaitTimeInMillis()));
        attrs.add(new Attribute("pool-resize-quantity", connPool.getPoolResizeQuantity()));
        attrs.add(new Attribute("idle-timeout-in-seconds", connPool.getIdleTimeoutInSeconds()));
        String isolation = connPool.getTransactionIsolationLevel();
        if (isolation != null && (isolation.length() == 0 || isolation.equals(NbBundle.getMessage((Class)IsolationLevelEditor.class, (String)"LBL_driver_default")))) {
            isolation = null;
        }
        attrs.add(new Attribute("transaction-isolation-level", isolation));
        attrs.add(new Attribute("is-isolation-level-guaranteed", connPool.getIsIsolationLevelGuaranteed()));
        attrs.add(new Attribute("is-connection-validation-required", connPool.getIsConnectionValidationRequired()));
        attrs.add(new Attribute("connection-validation-method", connPool.getConnectionValidationMethod()));
        attrs.add(new Attribute("validation-table-name", connPool.getValidationTableName()));
        attrs.add(new Attribute("fail-all-connections", connPool.getFailAllConnections()));
        attrs.add(new Attribute("description", connPool.getDescription()));
        if (ResourceUtils.is90Server(mejb)) {
            attrs.add(new Attribute("non-transactional-connections", connPool.getNonTransactionalConnections()));
            attrs.add(new Attribute("allow-non-component-callers", connPool.getAllowNonComponentCallers()));
        }
        return attrs;
    }

    public static AttributeList getResourceAttributes(JdbcResource jdbcResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", jdbcResource.getJndiName()));
        attrs.add(new Attribute("pool-name", jdbcResource.getPoolName()));
        attrs.add(new Attribute("object-type", jdbcResource.getObjectType()));
        attrs.add(new Attribute("enabled", jdbcResource.getEnabled()));
        attrs.add(new Attribute("description", jdbcResource.getDescription()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(PersistenceManagerFactoryResource pmResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", pmResource.getJndiName()));
        attrs.add(new Attribute("factory-class", pmResource.getFactoryClass()));
        attrs.add(new Attribute("jdbc-resource-jndi-name", pmResource.getJdbcResourceJndiName()));
        attrs.add(new Attribute("enabled", pmResource.getEnabled()));
        attrs.add(new Attribute("description", pmResource.getDescription()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(AdminObjectResource aoResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", aoResource.getJndiName()));
        attrs.add(new Attribute("description", aoResource.getDescription()));
        attrs.add(new Attribute("enabled", aoResource.getEnabled()));
        attrs.add(new Attribute("res-type", aoResource.getResType()));
        attrs.add(new Attribute("res-adapter", aoResource.getResAdapter()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(ConnectorResource connResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", connResource.getJndiName()));
        attrs.add(new Attribute("pool-name", connResource.getPoolName()));
        attrs.add(new Attribute("description", connResource.getDescription()));
        attrs.add(new Attribute("enabled", connResource.getEnabled()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(ConnectorConnectionPool connPoolResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("name", connPoolResource.getName()));
        attrs.add(new Attribute("resource-adapter-name", connPoolResource.getResourceAdapterName()));
        attrs.add(new Attribute("connection-definition-name", connPoolResource.getConnectionDefinitionName()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(MailResource mailResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi-name", mailResource.getJndiName()));
        attrs.add(new Attribute("store-protocol", mailResource.getStoreProtocol()));
        attrs.add(new Attribute("store-protocol-class", mailResource.getStoreProtocolClass()));
        attrs.add(new Attribute("transport-protocol", mailResource.getTransportProtocol()));
        attrs.add(new Attribute("transport-protocol-class", mailResource.getTransportProtocolClass()));
        attrs.add(new Attribute("host", mailResource.getHost()));
        attrs.add(new Attribute("user", mailResource.getUser()));
        attrs.add(new Attribute("from", mailResource.getFrom()));
        attrs.add(new Attribute("debug", mailResource.getDebug()));
        attrs.add(new Attribute("enabled", mailResource.getEnabled()));
        attrs.add(new Attribute("description", mailResource.getDescription()));
        return attrs;
    }

    public static AttributeList getResourceAttributes(JmsResource jmsResource) {
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("jndi_name", jmsResource.getJndiName()));
        attrs.add(new Attribute("res-type", jmsResource.getResType()));
        attrs.add(new Attribute("enabled", jmsResource.getEnabled()));
        attrs.add(new Attribute("description", jmsResource.getDescription()));
        return attrs;
    }

    private static Properties getProperties(PropertyElement[] props) throws Exception {
        Properties propList = new Properties();
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getName();
            String value = props[i].getValue();
            if (value == null || value.trim().length() == 0) continue;
            propList.put(name, value);
        }
        return propList;
    }

    public List getTargetServers() {
        String[] instances = InstanceProperties.getInstanceList();
        ArrayList<DeploymentManager> targets = new ArrayList<DeploymentManager>();
        for (int i = 0; i < instances.length; ++i) {
            if (instances[i].startsWith("deployer:Sun:AppServer::")) {
                targets.add(InstanceProperties.getInstanceProperties((String)instances[i]).getDeploymentManager());
                continue;
            }
            if (!instances[i].startsWith("[")) continue;
            targets.add(InstanceProperties.getInstanceProperties((String)instances[i]).getDeploymentManager());
        }
        return targets;
    }

    public static void saveConnPoolDatatoXml(ResourceConfigData data) {
        try {
            Vector vec = data.getProperties();
            Resources res = ResourceUtils.getResourceGraph();
            JdbcConnectionPool connPool = res.newJdbcConnectionPool();
            String[] keys = data.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = data.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = connPool.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        connPool.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = data.getString(key);
                if (key.equals("name")) {
                    connPool.setName(value);
                    data.setTargetFile(value);
                    continue;
                }
                if (key.equals("datasource-classname")) {
                    connPool.setDatasourceClassname(value);
                    continue;
                }
                if (key.equals("res-type")) {
                    connPool.setResType(value);
                    continue;
                }
                if (key.equals("steady-pool-size")) {
                    connPool.setSteadyPoolSize(value);
                    continue;
                }
                if (key.equals("max-pool-size")) {
                    connPool.setMaxPoolSize(value);
                    continue;
                }
                if (key.equals("max-wait-time-in-millis")) {
                    connPool.setMaxWaitTimeInMillis(value);
                    continue;
                }
                if (key.equals("pool-resize-quantity")) {
                    connPool.setPoolResizeQuantity(value);
                    continue;
                }
                if (key.equals("idle-timeout-in-seconds")) {
                    connPool.setIdleTimeoutInSeconds(value);
                    continue;
                }
                if (key.equals("transaction-isolation-level")) {
                    if (value.equals(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$sun$ide$editors$IsolationLevelEditor == null ? ResourceUtils.class$("org.netbeans.modules.j2ee.sun.ide.editors.IsolationLevelEditor") : class$org$netbeans$modules$j2ee$sun$ide$editors$IsolationLevelEditor), (String)"LBL_driver_default"))) {
                        value = null;
                    }
                    connPool.setTransactionIsolationLevel(value);
                    continue;
                }
                if (key.equals("is-isolation-level-guaranteed")) {
                    connPool.setIsIsolationLevelGuaranteed(value);
                    continue;
                }
                if (key.equals("is-connection-validation-required")) {
                    connPool.setIsConnectionValidationRequired(value);
                    continue;
                }
                if (key.equals("connection-validation-method")) {
                    connPool.setConnectionValidationMethod(value);
                    continue;
                }
                if (key.equals("validation-table-name")) {
                    connPool.setValidationTableName(value);
                    continue;
                }
                if (key.equals("fail-all-connections")) {
                    connPool.setFailAllConnections(value);
                    continue;
                }
                if (key.equals("description")) {
                    connPool.setDescription(value);
                    continue;
                }
                if (key.equals("non-transactional-connections")) {
                    connPool.setNonTransactionalConnections(value);
                    continue;
                }
                if (!key.equals("allow-non-component-callers")) continue;
                connPool.setAllowNonComponentCallers(value);
            }
            res.addJdbcConnectionPool(connPool);
            ResourceUtils.createFile(data.getTargetFileObject(), data.getTargetFile(), res);
        }
        catch (Exception ex) {
            System.out.println("Unable to saveConnPoolDatatoXml ");
        }
    }

    public static void saveJDBCResourceDatatoXml(ResourceConfigData dsData, ResourceConfigData cpData) {
        try {
            Resources res = ResourceUtils.getResourceGraph();
            JdbcResource datasource = res.newJdbcResource();
            String[] keys = dsData.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = dsData.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = datasource.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        datasource.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = dsData.getString(key);
                if (key.equals("jndi-name")) {
                    datasource.setJndiName(value);
                    dsData.setTargetFile(value);
                    continue;
                }
                if (key.equals("pool-name")) {
                    datasource.setPoolName(value);
                    continue;
                }
                if (key.equals("object-type")) {
                    datasource.setObjectType(value);
                    continue;
                }
                if (key.equals("enabled")) {
                    datasource.setEnabled(value);
                    continue;
                }
                if (!key.equals("description")) continue;
                datasource.setDescription(value);
            }
            res.addJdbcResource(datasource);
            if (cpData != null) {
                ResourceUtils.saveConnPoolDatatoXml(cpData);
            }
            ResourceUtils.createFile(dsData.getTargetFileObject(), dsData.getTargetFile(), res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Unable to saveJDBCResourceDatatoXml ");
        }
    }

    public static void savePMFResourceDatatoXml(ResourceConfigData pmfData, ResourceConfigData dsData, ResourceConfigData cpData) {
        try {
            Resources res = ResourceUtils.getResourceGraph();
            PersistenceManagerFactoryResource pmfresource = res.newPersistenceManagerFactoryResource();
            String[] keys = pmfData.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = pmfData.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = pmfresource.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        pmfresource.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = pmfData.getString(key);
                if (key.equals("jndi-name")) {
                    pmfresource.setJndiName(value);
                    pmfData.setTargetFile(value);
                    continue;
                }
                if (key.equals("factory-class")) {
                    pmfresource.setFactoryClass(value);
                    continue;
                }
                if (key.equals("jdbc-resource-jndi-name")) {
                    pmfresource.setJdbcResourceJndiName(value);
                    continue;
                }
                if (key.equals("enabled")) {
                    pmfresource.setEnabled(value);
                    continue;
                }
                if (!key.equals("description")) continue;
                pmfresource.setDescription(value);
            }
            res.addPersistenceManagerFactoryResource(pmfresource);
            ResourceUtils.createFile(pmfData.getTargetFileObject(), pmfData.getTargetFile(), res);
            if (dsData != null) {
                ResourceUtils.saveJDBCResourceDatatoXml(dsData, cpData);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to savePMFResourceDatatoXml ");
        }
    }

    public static void saveJMSResourceDatatoXml(ResourceConfigData jmsData) {
        try {
            Resources res = ResourceUtils.getResourceGraph();
            String type = jmsData.getString("res-type");
            if (type.equals("javax.jms.Queue") || type.equals("javax.jms.Topic")) {
                AdminObjectResource aoresource = res.newAdminObjectResource();
                aoresource.setDescription(jmsData.getString("description"));
                aoresource.setEnabled(jmsData.getString("enabled"));
                aoresource.setJndiName(jmsData.getString("jndi-name"));
                aoresource.setResType(jmsData.getString("res-type"));
                aoresource.setResAdapter("jmsra");
                Vector props = jmsData.getProperties();
                for (int j = 0; j < props.size(); ++j) {
                    NameValuePair pair = (NameValuePair)props.elementAt(j);
                    PropertyElement prop = aoresource.newPropertyElement();
                    prop = ResourceUtils.populatePropertyElement(prop, pair);
                    aoresource.addPropertyElement(prop);
                }
                res.addAdminObjectResource(aoresource);
            } else {
                ConnectorResource connresource = res.newConnectorResource();
                connresource.setDescription(jmsData.getString("description"));
                connresource.setEnabled(jmsData.getString("enabled"));
                connresource.setJndiName(jmsData.getString("jndi-name"));
                connresource.setPoolName(jmsData.getString("jndi-name"));
                ConnectorConnectionPool connpoolresource = res.newConnectorConnectionPool();
                connpoolresource.setName(jmsData.getString("jndi-name"));
                connpoolresource.setConnectionDefinitionName(jmsData.getString("res-type"));
                connpoolresource.setResourceAdapterName("jmsra");
                Vector props = jmsData.getProperties();
                for (int j = 0; j < props.size(); ++j) {
                    NameValuePair pair = (NameValuePair)props.elementAt(j);
                    PropertyElement prop = connpoolresource.newPropertyElement();
                    prop = ResourceUtils.populatePropertyElement(prop, pair);
                    connpoolresource.addPropertyElement(prop);
                }
                res.addConnectorResource(connresource);
                res.addConnectorConnectionPool(connpoolresource);
            }
            ResourceUtils.createFile(jmsData.getTargetFileObject(), jmsData.getTargetFile(), res);
        }
        catch (Exception ex) {
            System.out.println("Unable to saveJMSResourceDatatoXml ");
        }
    }

    public static void saveMailResourceDatatoXml(ResourceConfigData data) {
        try {
            Vector vec = data.getProperties();
            Resources res = ResourceUtils.getResourceGraph();
            MailResource mlresource = res.newMailResource();
            String[] keys = data.getFieldNames();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("properties")) {
                    Vector props = data.getProperties();
                    for (int j = 0; j < props.size(); ++j) {
                        NameValuePair pair = (NameValuePair)props.elementAt(j);
                        PropertyElement prop = mlresource.newPropertyElement();
                        prop = ResourceUtils.populatePropertyElement(prop, pair);
                        mlresource.addPropertyElement(prop);
                    }
                    continue;
                }
                String value = data.getString(key);
                if (key.equals("jndi-name")) {
                    mlresource.setJndiName(value);
                    data.setTargetFile(value);
                    continue;
                }
                if (key.equals("store-protocol")) {
                    mlresource.setStoreProtocol(value);
                    continue;
                }
                if (key.equals("store-protocol-class")) {
                    mlresource.setStoreProtocolClass(value);
                    continue;
                }
                if (key.equals("transport-protocol")) {
                    mlresource.setTransportProtocol(value);
                    continue;
                }
                if (key.equals("transport-protocol-class")) {
                    mlresource.setTransportProtocolClass(value);
                    continue;
                }
                if (key.equals("host")) {
                    mlresource.setHost(value);
                    continue;
                }
                if (key.equals("user")) {
                    mlresource.setUser(value);
                    continue;
                }
                if (key.equals("from")) {
                    mlresource.setFrom(value);
                    continue;
                }
                if (key.equals("debug")) {
                    mlresource.setDebug(value);
                    continue;
                }
                if (!key.equals("description")) continue;
                mlresource.setDescription(value);
            }
            res.addMailResource(mlresource);
            ResourceUtils.createFile(data.getTargetFileObject(), data.getTargetFile(), res);
        }
        catch (Exception ex) {
            System.out.println("Unable to saveMailResourceDatatoXml ");
        }
    }

    public static void createFile(FileObject targetFolder, String filename, final Resources res) {
        try {
            if (filename.indexOf("/") != -1) {
                filename = filename.substring(0, filename.indexOf("/")) + "_" + filename.substring(filename.indexOf("/") + 1, filename.length());
            }
            if (filename.indexOf("\\") != -1) {
                filename = filename.substring(0, filename.indexOf("\\")) + "_" + filename.substring(filename.indexOf("\\") + 1, filename.length());
            }
            String oldName = filename;
            targetFolder = ResourceUtils.setUpExists(targetFolder);
            final String resFileName = filename = FileUtil.findFreeFileName((FileObject)targetFolder, (String)filename, (String)"sun-resource");
            final FileObject resTargetFolder = targetFolder;
            FileSystem fs = targetFolder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject newfile = resTargetFolder.createData(resFileName, "sun-resource");
                    FileLock lock = newfile.lock();
                    Object w = null;
                    try {
                        OutputStreamWriter out = new OutputStreamWriter(newfile.getOutputStream(lock), "UTF8");
                        res.write((Writer)out);
                        ((Writer)out).flush();
                        ((Writer)out).close();
                    }
                    catch (Exception ex) {
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
            });
        }
        catch (Exception ex) {
            System.out.println("Error while creating file");
        }
    }

    public static String createUniqueFileName(String in_targetName, FileObject fo, String defName) {
        String targetName = in_targetName;
        if (targetName == null || targetName.length() == 0) {
            targetName = defName;
        }
        targetName = ResourceUtils.makeLegalFilename(targetName);
        targetName = FileUtil.findFreeFileName((FileObject)fo, (String)targetName, (String)"sun-resource");
        targetName = ResourceUtils.revertToResName(targetName);
        return targetName;
    }

    public static List getRegisteredConnectionPools(ResourceConfigData data) {
        List<String> connPools = new ArrayList();
        try {
            String OPER_OBJ_ConnPoolResource = "getJdbcConnectionPool";
            String keyProp = "name";
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(data.getTargetFileObject());
            if (instanceProperties != null) {
                connPools = ResourceUtils.getResourceNames(instanceProperties, OPER_OBJ_ConnPoolResource, keyProp);
            }
            connPools.removeAll(Arrays.asList(sysConnpools));
            List projectCP = ResourceUtils.getProjectResources(data, "connectionPool");
            for (int i = 0; i < projectCP.size(); ++i) {
                String localCP = projectCP.get(i).toString();
                if (connPools.contains(localCP)) continue;
                connPools.add(localCP);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return connPools;
    }

    public static List getRegisteredJdbcResources(ResourceConfigData data) {
        List<String> dataSources = new ArrayList();
        try {
            String keyProp = "jndi-name";
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(data.getTargetFileObject());
            if (instanceProperties != null) {
                dataSources = ResourceUtils.getResourceNames(instanceProperties, "getJdbcResource", keyProp);
            }
            dataSources.removeAll(Arrays.asList(sysDatasources));
            List projectDS = ResourceUtils.getProjectResources(data, "jdbc/myDatasource");
            for (int i = 0; i < projectDS.size(); ++i) {
                String localDS = projectDS.get(i).toString();
                if (dataSources.contains(localDS)) continue;
                dataSources.add(localDS);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return dataSources;
    }

    private static List getResourceNames(InstanceProperties instProps, String query, String keyProperty) {
        List retVal;
        DeploymentManager tmp = instProps.getDeploymentManager();
        if (tmp instanceof SunDeploymentManagerInterface) {
            SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)tmp;
            retVal = ResourceUtils.getResourceNames(eightDM, query, keyProperty);
        } else {
            retVal = Collections.EMPTY_LIST;
        }
        return retVal;
    }

    private static List getResourceNames(SunDeploymentManagerInterface eightDM, String query, String keyProperty) {
        ArrayList<String> resList = new ArrayList<String>();
        String MAP_RESOURCES = "ias:type=resources,category=config";
        try {
            ServerInterface mejb = eightDM.getManagement();
            ObjectName objName = new ObjectName(MAP_RESOURCES);
            ObjectName[] beans = (ObjectName[])mejb.invoke(objName, query, null, null);
            for (int i = 0; i < beans.length; ++i) {
                String resName = beans[i].getKeyProperty(keyProperty);
                resList.add(resName);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return resList;
    }

    private static List getProjectResources(ResourceConfigData data, String resourceType) {
        List projectResources = new ArrayList();
        FileObject targetFolder = data.getTargetFileObject();
        if (targetFolder != null) {
            FileObject setUpFolder = ResourceUtils.setUpExists(targetFolder);
            Enumeration en = setUpFolder.getData(false);
            while (en.hasMoreElements()) {
                FileObject resourceFile = (FileObject)en.nextElement();
                File resource = FileUtil.toFile((FileObject)resourceFile);
                if (resourceType.equals("connectionPool")) {
                    projectResources = ResourceUtils.filterConnectionPools(resource, projectResources);
                    continue;
                }
                projectResources = ResourceUtils.filterDataSources(resource, projectResources);
            }
        }
        return projectResources;
    }

    private static List filterConnectionPools(File primaryFile, List projectCP) {
        try {
            if (!primaryFile.isDirectory()) {
                FileInputStream in = new FileInputStream(primaryFile);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                for (int i = 0; i < pools.length; ++i) {
                    projectCP.add(pools[i].getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return projectCP;
    }

    private static List filterDataSources(File primaryFile, List projectDS) {
        try {
            if (!primaryFile.isDirectory()) {
                FileInputStream in = new FileInputStream(primaryFile);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                JdbcResource[] dataSources = resources.getJdbcResource();
                for (int i = 0; i < dataSources.length; ++i) {
                    projectDS.add(dataSources[i].getJndiName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return projectDS;
    }

    public static FileObject setUpExists(FileObject targetFolder) {
        FileObject pkgLocation = ResourceUtils.getResourceDirectory(targetFolder);
        if (pkgLocation == null) {
            return targetFolder;
        }
        return pkgLocation;
    }

    private static Resources getResourceGraph() {
        return DDProvider.getDefault().getResourcesGraph();
    }

    private static PropertyElement populatePropertyElement(PropertyElement prop, NameValuePair pair) {
        prop.setName(pair.getParamName());
        prop.setValue(pair.getParamValue());
        return prop;
    }

    public static boolean isLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String filename) {
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return ResourceUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    public static boolean isLegalResourceName(String filename) {
        for (int i = 0; i < ILLEGAL_RESOURCE_NAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_RESOURCE_NAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static FileObject getResourceDirectory(FileObject fo) {
        File resourceLoc;
        J2eeModuleProvider provider;
        Project holdingProj = FileOwnerQuery.getOwner((FileObject)fo);
        FileObject resourceDir = null;
        if (holdingProj != null && (provider = (J2eeModuleProvider)holdingProj.getLookup().lookup(J2eeModuleProvider.class)) != null && (resourceLoc = provider.getEnterpriseResourceDirectory()) != null) {
            if (resourceLoc.exists()) {
                resourceDir = FileUtil.toFileObject((File)resourceLoc);
            } else {
                resourceLoc.mkdirs();
                resourceDir = FileUtil.toFileObject((File)resourceLoc);
            }
        }
        return resourceDir;
    }

    public static HashSet getServerDataSources(DeploymentManager dm) {
        HashSet datasources = new HashSet();
        try {
            ObjectName configObjName = new ObjectName(MAP_RESOURCES);
            SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)dm;
            ServerInterface mejb = eightDM.getManagement();
            List<String> systemDS = Arrays.asList(sysDatasources);
            if (eightDM.isRunning()) {
                ResourceUtils.updateSampleDatasource(eightDM, configObjName);
                ObjectName[] resourceObjects = (ObjectName[])mejb.invoke(configObjName, "getJdbcResource", null, null);
                for (int i = 0; i < resourceObjects.length; ++i) {
                    String poolName;
                    HashMap poolValues;
                    ObjectName objName = resourceObjects[i];
                    String dsJndiName = (String)mejb.getAttribute(objName, "jndi-name");
                    if (systemDS.contains(dsJndiName) || (poolValues = ResourceUtils.fillInPoolValues(eightDM, configObjName, poolName = (String)mejb.getAttribute(objName, "pool-name"))).isEmpty()) continue;
                    String username = (String)poolValues.get("User");
                    String password = (String)poolValues.get("Password");
                    String url = (String)poolValues.get("URL");
                    String driverClassName = (String)poolValues.get("driverClassName");
                    SunDatasource ds = new SunDatasource(dsJndiName, url, username, password, driverClassName);
                    datasources.add(ds);
                }
            } else if (eightDM.isLocal()) {
                datasources = ResourceUtils.formatXmlSunDatasources(eightDM.getSunDatasourcesFromXml());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return datasources;
    }

    private static void updateSampleDatasource(SunDeploymentManagerInterface eightDM, ObjectName configObjName) {
        try {
            if (!eightDM.isLocal()) {
                return;
            }
            List datasources = ResourceUtils.getResourceNames(eightDM, "getJdbcResource", "jndi-name");
            if (!datasources.contains(SAMPLE_DATASOURCE)) {
                ServerInterface mejb = eightDM.getManagement();
                if (ResourceUtils.getConnectionPoolObjByName(mejb, configObjName, SAMPLE_CONNPOOL) == null) {
                    AttributeList poolAttrs = new AttributeList();
                    Attribute attr = new Attribute("name", SAMPLE_CONNPOOL);
                    poolAttrs.add(attr);
                    attr = new Attribute("datasource-classname", "org.apache.derby.jdbc.ClientDataSource");
                    poolAttrs.add(attr);
                    attr = new Attribute("res-type", "javax.sql.DataSource");
                    poolAttrs.add(attr);
                    Properties propsList = new Properties();
                    propsList.put("User", "app");
                    propsList.put("Password", "app");
                    propsList.put("serverName", "localhost");
                    propsList.put("PortNumber", "1527");
                    propsList.put("DatabaseName", "sample");
                    Object[] poolParams = new Object[]{poolAttrs, propsList, null};
                    ResourceUtils.createResource("createJdbcConnectionPool", poolParams, mejb);
                }
                AttributeList attrs = new AttributeList();
                attrs.add(new Attribute("jndi-name", SAMPLE_DATASOURCE));
                attrs.add(new Attribute("pool-name", SAMPLE_CONNPOOL));
                attrs.add(new Attribute("object-type", "user"));
                attrs.add(new Attribute("enabled", "true"));
                Object[] params = new Object[]{attrs, new Properties(), null};
                ResourceUtils.createResource("createJdbcResource", params, mejb);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashMap fillInPoolValues(SunDeploymentManagerInterface eightDM, ObjectName configObjName, String poolName) throws Exception {
        DatabaseConnection databaseConnection;
        HashMap<String, String> connPoolAttrs = new HashMap<String, String>();
        ServerInterface mejb = eightDM.getManagement();
        ObjectName connPoolObj = ResourceUtils.getConnectionPoolByName(mejb, configObjName, poolName);
        String driverClassName = (String)mejb.getAttribute(connPoolObj, "datasource-classname");
        String url = "";
        String username = "";
        String password = "";
        String serverName = "";
        String portNo = "";
        String dbName = "";
        String sid = "";
        AttributeList attrList = (AttributeList)mejb.invoke(connPoolObj, "getProperties", null, null);
        HashMap attrs = ResourceUtils.getObjMap(attrList);
        Object[] keys = attrs.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String keyName = (String)keys[i];
            if (keyName.equalsIgnoreCase("databaseName")) {
                if (driverClassName.indexOf("pointbase") != -1) {
                    url = ResourceUtils.getStringVal(attrs.get(keyName));
                    continue;
                }
                dbName = ResourceUtils.getStringVal(attrs.get(keyName));
                continue;
            }
            if (keyName.equalsIgnoreCase("User")) {
                username = ResourceUtils.getStringVal(attrs.get(keyName));
                continue;
            }
            if (keyName.equalsIgnoreCase("Password")) {
                password = ResourceUtils.getStringVal(attrs.get(keyName));
                continue;
            }
            if (keyName.equalsIgnoreCase("URL")) {
                url = ResourceUtils.getStringVal(attrs.get(keyName));
                continue;
            }
            if (keyName.equalsIgnoreCase("serverName")) {
                serverName = ResourceUtils.getStringVal(attrs.get(keyName));
                continue;
            }
            if (keyName.equalsIgnoreCase("PortNumber")) {
                portNo = ResourceUtils.getStringVal(attrs.get(keyName));
                continue;
            }
            if (!keyName.equalsIgnoreCase("SID")) continue;
            sid = ResourceUtils.getStringVal(attrs.get(keyName));
        }
        if (driverClassName.indexOf("derby") != -1) {
            url = "jdbc:derby://";
            if (serverName != null) {
                url = url + serverName;
                if (portNo != null) {
                    url = url + ":" + portNo;
                }
                url = url + "/" + dbName;
            }
        } else if (url.equals("")) {
            String urlPrefix = DatabaseUtils.getUrlPrefix(driverClassName);
            String vName = ResourceConfigurator.getDatabaseVendorName(urlPrefix, null);
            if (serverName != null) {
                url = vName.equals("sybase2") ? urlPrefix + serverName : urlPrefix + "//" + serverName;
                if (portNo != null) {
                    url = url + ":" + portNo;
                }
            }
            if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                url = url + ";SID=" + sid;
            } else if (Arrays.asList(WizardConstants.Reqd_DBName).contains(vName)) {
                url = url + ";databaseName=" + dbName;
            } else if (Arrays.asList(WizardConstants.VendorsDBNameProp).contains(vName)) {
                url = url + "/" + dbName;
            }
        }
        if (!eightDM.isLocal() && url.indexOf("localhost") != -1) {
            String hostName = eightDM.getHost();
            url = url.replaceFirst("localhost", hostName);
        }
        if ((databaseConnection = ResourceUtils.getDatabaseConnection(url)) != null) {
            driverClassName = databaseConnection.getDriverClass();
        } else {
            String drivername = DatabaseUtils.getDriverName(url);
            if (drivername != null) {
                driverClassName = drivername;
            }
        }
        connPoolAttrs.put("User", username);
        connPoolAttrs.put("Password", password);
        connPoolAttrs.put("URL", url);
        connPoolAttrs.put("driverClassName", driverClassName);
        return connPoolAttrs;
    }

    private static ObjectName getConnectionPoolByName(ServerInterface mejb, ObjectName configObjName, String poolName) throws Exception {
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{poolName};
        ObjectName connPoolObj = (ObjectName)mejb.invoke(configObjName, "getJdbcConnectionPoolByName", params, signature);
        return connPoolObj;
    }

    private static ObjectName getConnectionPoolObjByName(ServerInterface mejb, ObjectName configObjName, String poolName) {
        ObjectName connPoolObj = null;
        try {
            connPoolObj = ResourceUtils.getConnectionPoolByName(mejb, configObjName, poolName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return connPoolObj;
    }

    private static String getStringVal(Object val) {
        String value = null;
        if (val != null) {
            value = val.toString();
        }
        return value;
    }

    private static HashMap getObjMap(AttributeList attrList) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (int k = 0; k < attrList.size(); ++k) {
            Attribute currAttr = (Attribute)attrList.get(k);
            String pname = currAttr.getName();
            Object pObjvalue = currAttr.getValue();
            attrs.put(pname, pObjvalue);
        }
        return attrs;
    }

    public static String revertToResName(String filename) {
        if (filename.indexOf("jdbc_") != -1) {
            filename = filename.replaceFirst("jdbc_", "jdbc/");
        }
        if (filename.indexOf("mail_") != -1) {
            filename = filename.replaceFirst("mail_", "mail/");
        }
        if (filename.indexOf("jms_") != -1) {
            filename = filename.replaceFirst("jms_", "jms/");
        }
        return filename;
    }

    public static boolean isUniqueFileName(String in_targetName, FileObject fo, String defName) {
        boolean isUniq = true;
        String targetName = in_targetName;
        if (targetName != null && targetName.length() != 0) {
            targetName = ResourceUtils.makeLegalFilename(targetName);
            targetName = targetName + "." + "sun-resource";
            File targFile = new File(fo.getPath(), targetName);
            if (targFile.exists()) {
                isUniq = false;
            }
        }
        return isUniq;
    }

    public static DatabaseConnection getDatabaseConnection(String url) {
        DatabaseConnection[] dbConns = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < dbConns.length; ++i) {
            String dbConnUrl = dbConns[i].getDatabaseURL();
            if (!dbConnUrl.startsWith(url)) continue;
            return dbConns[i];
        }
        return null;
    }

    public static InstanceProperties getTargetServer(FileObject fo) {
        J2eeModuleProvider modProvider;
        InstanceProperties serverName = null;
        Project holdingProj = FileOwnerQuery.getOwner((FileObject)fo);
        if (holdingProj != null && (modProvider = (J2eeModuleProvider)holdingProj.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            serverName = modProvider.getInstanceProperties();
        }
        return serverName;
    }

    public static HashMap getConnPoolValues(File resourceDir, String poolName) {
        HashMap poolValues = new HashMap();
        try {
            ObjectName configObjName = new ObjectName(MAP_RESOURCES);
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(FileUtil.toFileObject((File)resourceDir));
            if (instanceProperties != null) {
                SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)instanceProperties.getDeploymentManager();
                if (eightDM.isRunning()) {
                    ServerInterface mejb = eightDM.getManagement();
                    poolValues = ResourceUtils.fillInPoolValues(eightDM, configObjName, poolName);
                } else if (eightDM.isLocal()) {
                    HashMap poolMap = eightDM.getConnPoolsFromXml();
                    poolValues = ResourceUtils.formatPoolMap((HashMap)poolMap.get(poolName));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return poolValues;
    }

    public static HashSet formatXmlSunDatasources(HashMap dsMap) {
        HashSet<SunDatasource> datasources = new HashSet<SunDatasource>();
        String[] keys = dsMap.keySet().toArray(new String[dsMap.size()]);
        for (int i = 0; i < keys.length; ++i) {
            String jndiName = keys[i];
            HashMap poolValues = (HashMap)dsMap.get(jndiName);
            poolValues = ResourceUtils.formatPoolMap(poolValues);
            String url = ResourceUtils.getStringVal(poolValues.get("URL"));
            String username = ResourceUtils.getStringVal(poolValues.get("User"));
            String password = ResourceUtils.getStringVal(poolValues.get("Password"));
            String driverClassName = ResourceUtils.getStringVal(poolValues.get("driverClassName"));
            if (url == null || url.equals("")) continue;
            SunDatasource ds = new SunDatasource(jndiName, url, username, password, driverClassName);
            datasources.add(ds);
        }
        return datasources;
    }

    private static HashMap formatPoolMap(HashMap poolValues) {
        String driverClassName = ResourceUtils.getStringVal(poolValues.get("dsClassName"));
        String url = "";
        String serverName = ResourceUtils.getStringVal(poolValues.get("serverName"));
        String portNo = ResourceUtils.getStringVal(poolValues.get("PortNumber"));
        String dbName = ResourceUtils.getStringVal(poolValues.get("DatabaseName"));
        String dbVal = ResourceUtils.getStringVal(poolValues.get("databaseName"));
        String portVal = ResourceUtils.getStringVal(poolValues.get("portNumber"));
        String sid = ResourceUtils.getStringVal(poolValues.get("SID"));
        if (driverClassName.indexOf("pointbase") != -1) {
            url = ResourceUtils.getStringVal(poolValues.get("databaseName"));
        } else if (driverClassName.indexOf("derby") != -1) {
            if (serverName != null) {
                url = "jdbc:derby://" + serverName;
                if (portNo != null) {
                    url = url + ":" + portNo;
                }
                url = url + "/" + dbName;
            }
        } else {
            String in_url = ResourceUtils.getStringVal(poolValues.get("URL"));
            if (in_url != null) {
                url = in_url;
            }
            if (url.equals("")) {
                String urlPrefix = DatabaseUtils.getUrlPrefix(driverClassName);
                String vName = ResourceConfigurator.getDatabaseVendorName(urlPrefix, null);
                if (serverName != null) {
                    url = vName.equals("sybase2") ? urlPrefix + serverName : urlPrefix + "//" + serverName;
                    if (portVal != null) {
                        url = url + ":" + portVal;
                    }
                }
                if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                    url = url + ";SID=" + sid;
                } else if (Arrays.asList(WizardConstants.Reqd_DBName).contains(vName)) {
                    url = url + ";databaseName=" + dbVal;
                } else if (Arrays.asList(WizardConstants.VendorsDBNameProp).contains(vName)) {
                    url = url + "/" + dbVal;
                }
            }
        }
        DatabaseConnection databaseConnection = ResourceUtils.getDatabaseConnection(url);
        if (databaseConnection != null) {
            driverClassName = databaseConnection.getDriverClass();
        } else {
            String drivername = DatabaseUtils.getDriverName(url);
            if (drivername != null) {
                driverClassName = drivername;
            }
        }
        poolValues.put("URL", url);
        poolValues.put("driverClassName", driverClassName);
        return poolValues;
    }

    public static boolean is90Server(ServerInterface mejb) {
        boolean is90Server = true;
        SunDeploymentManagerInterface sunDm = (SunDeploymentManagerInterface)mejb.getDeploymentManager();
        if (sunDm.isLocal()) {
            is90Server = ResourceUtils.is90ServerLocal(sunDm);
        } else {
            try {
                ObjectName serverObj = new ObjectName("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime");
                String serverName = (String)mejb.getAttribute(serverObj, "serverVersion");
                if (serverName != null && serverName.indexOf("8.") != -1) {
                    is90Server = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is90Server;
    }

    private static boolean is90ServerLocal(SunDeploymentManagerInterface sunDm) {
        boolean isGlassfish = true;
        try {
            isGlassfish = ServerLocationManager.isGlassFish(sunDm.getPlatformRoot());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isGlassfish;
    }
}

