/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;

public class MultiLineField
extends JComponent
implements Accessible {
    private static final int CHARS_DISPLAYED = 80;
    private static final int LINES_DISPLAYED = 4;
    private static final int LINE_SPACING = 2;
    private static final int DEFAULT_WIDTH = 400;
    private static final int MIN_WIDTH = 50;
    private static final String SPACE = " ";
    private static final Insets INSETS = new Insets(0, 5, 5, 5);
    protected static final Color ERROR_COLOR = Color.red;
    private String[] stringsToDisplay;
    private AttributedString[] attributedStrings;
    private Object lockObject = new Object();
    protected FontMetrics fontMetrics;
    protected int totalWidth;
    protected Dimension preferredSize;
    private Insets insets;
    private int numberLines;
    private int lineHeight;
    private int charHeight;
    private int lineSpacing;
    private boolean useMonospacedFont;
    private boolean formatText;

    public MultiLineField() {
        this.setText(new String[0]);
        this.init(4);
    }

    public MultiLineField(String text) {
        this.setText(text);
        this.init(this.stringsToDisplay.length);
    }

    public MultiLineField(String text, boolean format) {
        this(text);
        this.formatText = format;
    }

    public MultiLineField(String[] strs) {
        this.setText(strs);
        this.init(this.stringsToDisplay.length);
    }

    private void init(int nLines) {
        this.formatText = false;
        this.insets = INSETS;
        this.numberLines = nLines;
        this.useMonospacedFont = false;
        this.preferredSize = new Dimension(100, 20);
    }

    public void setInsets(Insets i) {
        this.insets = i;
    }

    public void useMonospacedFont(boolean b) {
        this.useMonospacedFont = b;
    }

    public void addNotify() {
        super.addNotify();
        int ptSize = this.getFont().getSize();
        if (this.useMonospacedFont) {
            Font font = new Font("Monospaced", 0, ptSize);
            this.setFont(font);
        }
        this.fontMetrics = this.getFontMetrics(this.getFont());
        int width = 0;
        if (this.stringsToDisplay == null) {
            width = this.fontMetrics.charWidth('v') * 80;
        } else if (this.formatText) {
            width = 400;
        } else {
            for (int i = 0; i < this.stringsToDisplay.length; ++i) {
                int lineWidth = this.fontMetrics.stringWidth(this.stringsToDisplay[i]);
                if (lineWidth <= width) continue;
                width = lineWidth;
            }
        }
        this.charHeight = this.fontMetrics.getMaxAscent() + this.fontMetrics.getMaxDescent();
        this.lineSpacing = 0;
        this.lineSpacing = ptSize > 12 ? 2 + (ptSize - 4) / 4 : 2;
        this.totalWidth = this.insets.left + this.insets.right + width;
        this.lineHeight = this.charHeight + this.lineSpacing;
        if (this.formatText) {
            this.reformat();
        }
        int totalHeight = this.insets.top + this.insets.bottom + this.charHeight * this.numberLines + this.lineSpacing * (this.numberLines - 1);
        this.preferredSize = new Dimension(this.totalWidth, totalHeight);
    }

    private void reformat() {
        if (this.stringsToDisplay == null || this.stringsToDisplay.length < 1) {
            return;
        }
        String entireString = this.stringsToDisplay[0];
        for (int i = 1; i < this.stringsToDisplay.length; ++i) {
            entireString = entireString.concat(SPACE + this.stringsToDisplay[i]);
        }
        this.reformat(entireString);
    }

    private void reformat(String s) {
        if (this.totalWidth < 50) {
            return;
        }
        int lineWidth = this.totalWidth - (this.insets.left + this.insets.right);
        StringTokenizer st = new StringTokenizer(s, SPACE);
        Vector<String> v = new Vector<String>();
        String prevString = st.nextToken();
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            String curString = prevString + SPACE + curToken;
            int curWidth = this.fontMetrics.stringWidth(curString);
            if (curWidth > lineWidth) {
                v.addElement(prevString);
                prevString = curToken;
                continue;
            }
            prevString = curString;
        }
        v.addElement(prevString);
        this.numberLines = v.size();
        this.stringsToDisplay = new String[this.numberLines];
        v.copyInto(this.stringsToDisplay);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public void setSize(Dimension d) {
        if (d.width != this.totalWidth) {
            this.totalWidth = d.width;
            if (this.formatText) {
                this.reformat();
            }
        }
        super.setSize(d);
    }

    public void setBounds(Rectangle r) {
        if (r.width != this.totalWidth) {
            this.totalWidth = r.width;
            if (this.formatText) {
                this.reformat();
            }
        }
        super.setBounds(r);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width != this.totalWidth) {
            this.totalWidth = width;
            if (this.formatText) {
                this.reformat();
            }
        }
        super.setBounds(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (size.width != this.totalWidth) {
            this.totalWidth = size.width;
        }
        g.clearRect(0, 0, size.width, size.height);
        Object object = this.lockObject;
        synchronized (object) {
            int offset = this.insets.top + this.fontMetrics.getMaxAscent();
            int blankLines = (this.numberLines - this.stringsToDisplay.length) / 2;
            if (blankLines > 0) {
                offset += this.lineHeight * blankLines;
            }
            for (int i = 0; i < this.stringsToDisplay.length; ++i) {
                if (this.attributedStrings != null) {
                    this.attributedStrings[i].addAttribute(TextAttribute.FONT, this.getFont());
                    g.drawString(this.attributedStrings[i].getIterator(), this.insets.left, offset);
                } else {
                    g.drawString(this.stringsToDisplay[i], this.insets.left, offset);
                }
                offset += this.lineHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(AttributedString[] strs) {
        Object object = this.lockObject;
        synchronized (object) {
            this.attributedStrings = strs;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String[] strs) {
        Object object = this.lockObject;
        synchronized (object) {
            this.stringsToDisplay = strs;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getText() {
        String[] retStrings = null;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.stringsToDisplay != null && this.stringsToDisplay.length > 0) {
                retStrings = new String[this.stringsToDisplay.length];
                System.arraycopy(this.stringsToDisplay, 0, retStrings, 0, this.stringsToDisplay.length);
            }
        }
        return retStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String s) {
        Object object = this.lockObject;
        synchronized (object) {
            this.attributedStrings = null;
            if (s == null) {
                this.stringsToDisplay = new String[1];
                this.stringsToDisplay[0] = SPACE;
            } else if (this.formatText) {
                if (this.fontMetrics != null) {
                    this.reformat(s);
                } else {
                    this.stringsToDisplay = new String[1];
                    this.stringsToDisplay[0] = s;
                }
            } else {
                StringTokenizer st = new StringTokenizer(s, "\n");
                int nTokens = st.countTokens();
                this.stringsToDisplay = new String[nTokens];
                for (int i = 0; i < nTokens; ++i) {
                    this.stringsToDisplay[i] = st.nextToken();
                }
            }
        }
    }

    public void setError(boolean val) {
        if (val) {
            if (this.stringsToDisplay == null) {
                return;
            }
            this.attributedStrings = new AttributedString[this.stringsToDisplay.length];
            for (int i = 0; i < this.stringsToDisplay.length; ++i) {
                this.attributedStrings[i] = new AttributedString(this.stringsToDisplay[i]);
                this.attributedStrings[i].addAttribute(TextAttribute.FOREGROUND, ERROR_COLOR);
            }
        } else {
            this.attributedStrings = null;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiLineField();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiLineField
    extends JComponent.AccessibleJComponent {
        protected AccessibleMultiLineField() {
            super(MultiLineField.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

