/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.core.wizard.AbstractPanel;
import org.netbeans.modules.xml.core.wizard.DTDPanel;
import org.netbeans.modules.xml.core.wizard.DocumentModel;
import org.netbeans.modules.xml.core.wizard.DocumentPanel;
import org.netbeans.modules.xml.core.wizard.SchemaPanel;
import org.netbeans.modules.xml.core.wizard.Util;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public class XMLWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 5070430920636117204L;
    private static final String XML_EXT = "xml";
    private transient TemplateWizard templateWizard;
    private transient DocumentModel model;
    private transient int current;
    private static final int TARGET_PANEL = 0;
    private transient WizardDescriptor.Panel targetPanel;
    private static final int DOCUMENT_PANEL = 1;
    private transient DocumentPanel documentPanel;
    private static final int CONSTRAINT_PANEL = 2;
    private transient SchemaPanel schemaPanel;
    private transient DTDPanel dtdPanel;
    private static XMLWizardIterator instance;
    private transient Map listenersMap = new HashMap(2);
    private transient String[] beforeSteps;
    private transient Object targetSteps;

    public static synchronized XMLWizardIterator singleton() {
        if (instance == null) {
            instance = new XMLWizardIterator();
        }
        return instance;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.templateWizard = templateWizard;
        this.current = 0;
        URL targetFolderURL = null;
        try {
            DataFolder folder = templateWizard.getTargetFolder();
            targetFolderURL = folder.getPrimaryFile().getURL();
            if (!targetFolderURL.toExternalForm().endsWith("/")) {
                targetFolderURL = new URL(targetFolderURL.toExternalForm() + "/");
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.model = new DocumentModel(targetFolderURL);
        Object prop = templateWizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            this.beforeSteps = (String[])prop;
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.targetPanel != null) {
            ((JComponent)this.targetPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.targetSteps);
            this.targetPanel = null;
        }
        this.current = -1;
        this.model = null;
        templateWizard = null;
        this.schemaPanel = null;
        this.dtdPanel = null;
        this.documentPanel = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        DataFolder folder = templateWizard.getTargetFolder();
        String extension = XML_EXT;
        String targetName = templateWizard.getTargetName();
        if (targetName == null || "null".equals(targetName)) {
            targetName = "XMLDocument";
        }
        final FileObject targetFolder = folder.getPrimaryFile();
        String uniqueTargetName = targetName;
        int i = 2;
        while (targetFolder.getFileObject(uniqueTargetName, XML_EXT) != null) {
            uniqueTargetName = targetName + i;
            ++i;
        }
        final String name = uniqueTargetName;
        FileSystem filesystem = targetFolder.getFileSystem();
        final FileObject[] fileObject = new FileObject[1];
        FileSystem.AtomicAction fsAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fo = targetFolder.createData(name, XMLWizardIterator.XML_EXT);
                FileLock lock = null;
                try {
                    lock = fo.lock();
                    OutputStream out = fo.getOutputStream(lock);
                    out = new BufferedOutputStream(out, 999);
                    OutputStreamWriter writer = new OutputStreamWriter(out, "UTF8");
                    String root = XMLWizardIterator.this.model.getRoot();
                    if (root == null) {
                        root = "root";
                    }
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    writer.write("\n");
                    String nameExt = name + "." + XMLWizardIterator.XML_EXT;
                    Date now = new Date();
                    String currentDate = DateFormat.getDateInstance(1).format(now);
                    String currentTime = DateFormat.getTimeInstance(3).format(now);
                    String userName = System.getProperty("user.name");
                    writer.write("<!--\n");
                    writer.write("    Document   : " + nameExt + "\n");
                    writer.write("    Created on : " + currentDate + ", " + currentTime + "\n");
                    writer.write("    Author     : " + userName + "\n");
                    writer.write("    Description:\n");
                    writer.write("        Purpose of the document follows.\n");
                    writer.write("-->\n");
                    writer.write("\n");
                    int n = XMLWizardIterator.this.model.getType();
                    XMLWizardIterator.this.model;
                    if (n == 1) {
                        if (XMLWizardIterator.this.model.getPublicID() == null) {
                            writer.write("<!DOCTYPE " + root + " SYSTEM '" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                        } else {
                            writer.write("<!DOCTYPE " + root + " PUBLIC '" + XMLWizardIterator.this.model.getPublicID() + "' '" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                        }
                        writer.write("<" + root + ">\n");
                    } else {
                        int n2 = XMLWizardIterator.this.model.getType();
                        XMLWizardIterator.this.model;
                        if (n2 == 2) {
                            String namespace = XMLWizardIterator.this.model.getNamespace();
                            if (namespace == null || "".equals(namespace)) {
                                writer.write("<" + root + " xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                                writer.write("  xsi:noNamespaceSchemaLocation='" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                            } else {
                                writer.write("<" + root + " xmlns='" + namespace + "'\n");
                                writer.write("  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                                writer.write("  xsi:schemaLocation='" + namespace + " " + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                            }
                        } else {
                            writer.write("<" + root + ">\n");
                        }
                    }
                    writer.write("\n");
                    writer.write("</" + root + ">\n");
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    lock.releaseLock();
                    lock = null;
                    fileObject[0] = fo;
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        };
        filesystem.runAtomicAction(fsAction);
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        DataObject createdObject = DataObject.find((FileObject)fileObject[0]);
        Util.performDefaultAction(createdObject);
        set.add(createdObject);
        return set;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.currentComponent();
        if (panel.getComponent() instanceof JComponent) {
            ((JComponent)panel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.current));
        }
        return panel;
    }

    private WizardDescriptor.Panel currentComponent() {
        switch (this.current) {
            case 0: {
                return this.getTargetPanel();
            }
            case 1: {
                return this.getDocumentPanel();
            }
            case 2: {
                switch (this.model.getType()) {
                    case 1: {
                        return this.getDTDPanel();
                    }
                    case 2: {
                        return this.getSchemaPanel();
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        boolean none = this.model.getType() == 0;
        int length = none ? 1 : 2;
        return this.current < length;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public String name() {
        return "//TODO";
    }

    public void nextPanel() {
        ++this.current;
    }

    public void previousPanel() {
        --this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            Object bridge = this.listenersMap.remove(changeListener);
            if (bridge == null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            this.model.removePropertyChangeListener((PropertyChangeListener)bridge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(final ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            PropertyChangeListener listenerBridge = new PropertyChangeListener(){
                final ChangeEvent EVENT;
                {
                    this.EVENT = new ChangeEvent(XMLWizardIterator.this);
                }

                public void propertyChange(PropertyChangeEvent e) {
                    changeListener.stateChanged(this.EVENT);
                }
            };
            if (this.listenersMap.put(changeListener, listenerBridge) == null) {
                this.model.addPropertyChangeListener(listenerBridge);
            }
        }
    }

    private WizardDescriptor.Panel getDocumentPanel() {
        if (this.documentPanel == null) {
            this.documentPanel = new DocumentPanel();
            this.documentPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString("MSG_unknown")};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.documentPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.documentPanel);
    }

    private WizardDescriptor.Panel getDTDPanel() {
        if (this.dtdPanel == null) {
            this.dtdPanel = new DTDPanel();
            this.dtdPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getDTDPanelName()};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.dtdPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.dtdPanel);
    }

    private WizardDescriptor.Panel getSchemaPanel() {
        if (this.schemaPanel == null) {
            this.schemaPanel = new SchemaPanel();
            this.schemaPanel.setObject(this.model);
            String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName()};
            String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
            this.schemaPanel.putClientProperty("WizardPanel_contentData", newSteps);
        }
        return new AbstractPanel.WizardStep(this.schemaPanel);
    }

    private WizardDescriptor.Panel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = this.templateWizard.targetChooser();
            if (this.targetPanel.getComponent() instanceof JComponent) {
                JComponent panel = (JComponent)this.targetPanel.getComponent();
                this.targetSteps = panel.getClientProperty("WizardPanel_contentData");
                String[] steps = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString("MSG_unknown")};
                String[] newSteps = XMLWizardIterator.createSteps(this.beforeSteps, steps);
                panel.putClientProperty("WizardPanel_contentData", newSteps);
            }
        }
        return this.targetPanel;
    }

    private String getTargetPanelName() {
        Component panel = this.getTargetPanel().getComponent();
        if (panel instanceof JComponent) {
            return ((JComponent)panel).getName();
        }
        return "";
    }

    private String getDocumentPanelName() {
        return Util.THIS.getString("PROP_doc_panel_name");
    }

    private String getDTDPanelName() {
        return Util.THIS.getString("PROP_dtd_panel_name");
    }

    private String getSchemaPanelName() {
        return Util.THIS.getString("PROP_schema_panel_name");
    }

    private static String[] createSteps(String[] before, String[] panelNames) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panelNames.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panelNames[i - before.length + diff];
        }
        return res;
    }
}

