/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Dialog;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.httpserver.GrantAccessEvent;
import org.netbeans.modules.httpserver.GrantAccessListener;
import org.netbeans.modules.httpserver.GrantAccessPanel;
import org.netbeans.modules.httpserver.HttpServerModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class HttpServerSettings
extends SystemOption {
    private static final int MAX_START_RETRIES = 20;
    private static int currentRetries = 0;
    protected static EventListenerList listenerList = new EventListenerList();
    static boolean inited = false;
    private static Hashtable whoAsking = new Hashtable();
    public static final int SERVER_STARTUP_TIMEOUT = 3000;
    public static final String LOCALHOST = "local";
    public static final String ANYHOST = "any";
    public static final HostProperty hostProperty = new HostProperty("", "local");
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST_PROPERTY = "hostProperty";
    static final String PROP_WRAPPER_BASEURL = "wrapperBaseURL";
    public static final String PROP_RUNNING = "running";
    private static final String PROP_SHOW_GRANT_ACCESS = "showGrantAccess";
    private static final int DEFAULT_PORT = 8082;
    private static String wrapperBaseURL = "/resource/";
    static boolean running = false;
    private static boolean startStopMessages = true;
    private static Properties mappedServlets = new Properties();
    public static HttpServerSettings OPTIONS = null;
    private static Object httpLock;
    static final long serialVersionUID = 7387407495740535307L;

    static final Object httpLock() {
        if (httpLock == null) {
            httpLock = new Object();
        }
        return httpLock;
    }

    protected void initialize() {
        super.initialize();
    }

    public String displayName() {
        return NbBundle.getMessage((Class)HttpServerSettings.class, (String)"CTL_HTTP_settings");
    }

    public boolean isRunning() {
        if (this.isWriteExternal()) {
            if (inited) {
                return running;
            }
            return true;
        }
        if (inited) {
            return running;
        }
        this.setRunning(false);
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSuccess() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            currentRetries = 0;
            running = true;
            HttpServerSettings.httpLock().notifyAll();
        }
    }

    void runFailure(Throwable t) {
        running = false;
        if (t instanceof IncompatibleClassChangeError) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_HTTP_SERVER_incompatbleClasses"), 2));
        } else if (t instanceof BindException) {
            if (++currentRetries <= 20) {
                this.setPort(this.getPort() + 1);
                this.setRunning(true);
            } else {
                currentRetries = 0;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL"), 2));
                int p = this.getPort();
                if (p < 1024 && inited && Utilities.isUnix()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_onlyRootOnUnix"), 2));
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL_unknown"), 2));
        }
    }

    private void restartIfNecessary(boolean printMessages) {
        if (this.isReadExternal()) {
            return;
        }
        if (running) {
            if (!printMessages) {
                this.setStartStopMessages(false);
            }
            HttpServerModule.stopHTTPServer();
            HttpServerModule.initHTTPServer();
        }
    }

    private String getCanonicalRelativeURL(String url) {
        String newURL;
        if (url.length() == 0) {
            newURL = "/";
        } else {
            newURL = url.charAt(0) != '/' ? "/" + url : url;
            if (newURL.charAt(newURL.length() - 1) != '/') {
                newURL = newURL + "/";
            }
        }
        return newURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) {
        if (this.isReadExternal()) {
            return;
        }
        inited = true;
        if (HttpServerSettings.running == running) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (running) {
                HttpServerModule.initHTTPServer();
            } else {
                HttpServerSettings.running = false;
                HttpServerModule.stopHTTPServer();
            }
        }
        this.firePropertyChange(PROP_RUNNING, !running ? Boolean.TRUE : Boolean.FALSE, running ? Boolean.TRUE : Boolean.FALSE);
    }

    String getWrapperBaseURL() {
        return wrapperBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWrapperBaseURL(String wrapperBaseURL) {
        String oldURL;
        String newURL = this.getCanonicalRelativeURL(wrapperBaseURL);
        if (HttpServerSettings.wrapperBaseURL.equals(newURL)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            oldURL = HttpServerSettings.wrapperBaseURL;
            HttpServerSettings.wrapperBaseURL = newURL;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_WRAPPER_BASEURL, oldURL, HttpServerSettings.wrapperBaseURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int p) {
        if (p <= 0 || p > 65535) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)HttpServerSettings.class, (String)"ERR_PortNumberOutOfRange", (Object)new Integer(p)), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        Object old = this.getProperty(PROP_PORT);
        int port = old == null ? 8082 : (Integer)old;
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            old = this.putProperty(PROP_PORT, new Integer(p), false);
            if (old != null && p == (Integer)old) {
                return;
            }
            this.restartIfNecessary(true);
        }
        this.firePropertyChange(PROP_PORT, old, new Integer(p));
    }

    public int getPort() {
        Object prop = this.getProperty(PROP_PORT);
        return prop == null ? 8082 : (Integer)prop;
    }

    public void setStartStopMessages(boolean ssm) {
        startStopMessages = ssm;
    }

    public boolean isStartStopMessages() {
        return startStopMessages;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HttpServerSettings.class);
    }

    void firePropertyChange0(String name, Object oldVal, Object newVal) {
        this.firePropertyChange(name, oldVal, newVal);
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public void addGrantAccessListener(GrantAccessListener l) {
        listenerList.add(GrantAccessListener.class, l);
    }

    public void removeGrantAccessListener(GrantAccessListener l) {
        listenerList.remove(GrantAccessListener.class, l);
    }

    protected boolean fireGrantAccessEvent(InetAddress clientAddress, String resource) {
        Object[] listeners = listenerList.getListenerList();
        GrantAccessEvent grantAccessEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$netbeans$modules$httpserver$GrantAccessListener == null ? HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener") : class$org$netbeans$modules$httpserver$GrantAccessListener)) continue;
            if (grantAccessEvent == null) {
                grantAccessEvent = new GrantAccessEvent((Object)this, clientAddress, resource);
            }
            ((GrantAccessListener)listeners[i + 1]).grantAccess(grantAccessEvent);
        }
        return grantAccessEvent == null ? false : grantAccessEvent.isGranted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean allowAccess(InetAddress addr, String requestPath) {
        if (this.accessAllowedNow(addr, requestPath)) {
            return true;
        }
        Thread askThread = null;
        Serializable serializable = whoAsking;
        synchronized (serializable) {
            if (this.accessAllowedNow(addr, requestPath)) {
                return true;
            }
            askThread = (Thread)whoAsking.get(addr);
            if (askThread == null) {
                askThread = Thread.currentThread();
                whoAsking.put(addr, askThread);
            }
        }
        serializable = HttpServerSettings.class;
        synchronized (serializable) {
            if (askThread != Thread.currentThread()) {
                return this.accessAllowedNow(addr, requestPath);
            }
            try {
                if (!this.isShowGrantAccessDialog()) {
                    boolean bl = false;
                    return bl;
                }
                String msg = NbBundle.getMessage((Class)HttpServerSettings.class, (String)"MSG_AddAddress", (Object)addr.getHostAddress());
                GrantAccessPanel panel = new GrantAccessPanel(msg);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage((Class)HttpServerSettings.class, (String)"CTL_GrantAccessTitle"), true, 0, NotifyDescriptor.NO_OPTION, null);
                descriptor.setMessageType(3);
                Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
                d.setSize(580, 180);
                d.setVisible(true);
                this.setShowGrantAccessDialog(panel.getShowDialog());
                if (NotifyDescriptor.YES_OPTION.equals(descriptor.getValue())) {
                    this.appendAddressToGranted(addr.getHostAddress());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                whoAsking.remove(addr);
            }
        }
    }

    private boolean accessAllowedNow(InetAddress addr, String resource) {
        if (hostProperty.getHost().equals(ANYHOST)) {
            return true;
        }
        HashSet hs = this.getGrantedAddressesSet();
        if (hs.contains(addr.getHostAddress())) {
            return true;
        }
        return this.fireGrantAccessEvent(addr, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddressToGranted(String addr) {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String granted = hostProperty.getGrantedAddresses().trim();
            if (granted.length() > 0 && granted.charAt(granted.length() - 1) != ';' && granted.charAt(granted.length() - 1) != ',') {
                granted = granted + ',';
            }
            granted = granted + addr;
            hostProperty.setGrantedAddresses(granted);
        }
    }

    HashSet getGrantedAddressesSet() {
        HashSet<String> addr = new HashSet<String>();
        try {
            addr.add(InetAddress.getByName("localhost").getHostAddress());
            addr.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer(hostProperty.getGrantedAddresses(), ",;");
        while (st.hasMoreTokens()) {
            String ipa = st.nextToken();
            ipa = ipa.trim();
            try {
                addr.add(InetAddress.getByName(ipa).getHostAddress());
            }
            catch (UnknownHostException e) {}
        }
        return addr;
    }

    Properties getMappedServlets() {
        return mappedServlets;
    }

    static String mangle(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '.') {
                sb.append(name.charAt(i));
                continue;
            }
            String code = Integer.toHexString(name.charAt(i)).toUpperCase();
            if (code.length() < 2) {
                code = code.length() == 0 ? "00" : "0" + code;
            }
            sb.append("%").append(code.length() == 2 ? code : code.substring(code.length() - 2));
        }
        return sb.toString();
    }

    static String demangle(String name) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) != '%') {
                    sb.append(name.charAt(i));
                    continue;
                }
                sb.append((char)Integer.parseInt(name.substring(i + 1, i + 3), 16));
                i += 2;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return "";
        }
        return sb.toString();
    }

    public HostProperty getHostProperty() {
        return hostProperty;
    }

    public void setHostProperty(HostProperty hostProperty) {
        if (ANYHOST.equals(hostProperty.getHost()) || LOCALHOST.equals(hostProperty.getHost())) {
            HttpServerSettings.hostProperty.setHost(hostProperty.getHost());
            HttpServerSettings.hostProperty.setGrantedAddresses(hostProperty.getGrantedAddresses());
            this.firePropertyChange(PROP_HOST_PROPERTY, null, hostProperty);
        }
    }

    public boolean isShowGrantAccessDialog() {
        Boolean b = (Boolean)this.getProperty(PROP_SHOW_GRANT_ACCESS);
        if (b != null) {
            return b;
        }
        return true;
    }

    public void setShowGrantAccessDialog(boolean show) {
        this.putProperty(PROP_SHOW_GRANT_ACCESS, show ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public static class HostProperty
    implements Serializable {
        private String grantedAddresses;
        private String host;
        private static final long serialVersionUID = 1927848926692414249L;

        HostProperty(String grantedAddresses, String host) {
            this.grantedAddresses = grantedAddresses;
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getGrantedAddresses() {
            return this.grantedAddresses;
        }

        public void setGrantedAddresses(String grantedAddresses) {
            this.grantedAddresses = grantedAddresses;
        }
    }
}

