/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import java.lang.reflect.Method;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class SaveAction
extends CookieAction {
    private static Class dataObject;
    private static Method getNodeDelegate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SaveAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected Class[] cookieClasses() {
        return new Class[]{SaveCookie.class};
    }

    protected void performAction(Node[] activatedNodes) {
        SaveCookie sc = (SaveCookie)activatedNodes[0].getCookie(SaveCookie.class);
        if (!$assertionsDisabled && sc == null) {
            throw new AssertionError((Object)("SaveCookie must be present on " + activatedNodes[0] + ". " + "See http://www.netbeans.org/issues/show_bug.cgi?id=68285 for details on overriding " + activatedNodes[0].getClass().getName() + ".getCookie correctly."));
        }
        if (sc == null) {
            return;
        }
        try {
            sc.save();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)SaveAction.class, (String)"MSG_saved", (Object)this.getSaveMessage(activatedNodes[0])));
        }
        catch (IOException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, NbBundle.getMessage((Class)SaveAction.class, (String)"EXC_notsaved", (Object)this.getSaveMessage(activatedNodes[0])));
            err.notify((Throwable)e);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getSaveMessage(Node n) {
        Node.Cookie obj;
        if (dataObject == null) {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = ((Object)((Object)this)).getClass().getClassLoader();
            }
            try {
                dataObject = Class.forName("org.openide.loaders.DataObject", true, l);
                getNodeDelegate = dataObject.getMethod("getNodeDelegate", new Class[0]);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        if (getNodeDelegate != null && (obj = n.getCookie(dataObject)) != null) {
            try {
                n = (Node)getNodeDelegate.invoke((Object)obj, new Object[0]);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return n.getDisplayName();
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage((Class)SaveAction.class, (String)"Save");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.png";
    }

    static {
        $assertionsDisabled = !SaveAction.class.desiredAssertionStatus();
    }
}

