/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentFactory;
import org.netbeans.modules.j2ee.jboss4.config.CarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.EarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.EjbDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.ide.JBJ2eePlatformFactory;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;

public class JBDeploymentManager
implements DeploymentManager {
    private DeploymentManager dm;
    private String realUri;
    private Object rmiServer;
    private int debuggingPort = 8787;
    private InstanceProperties instanceProperties;
    private static Map propertiesToIsRunning = Collections.synchronizedMap(new WeakHashMap());
    private JBJ2eePlatformFactory.J2eePlatformImplImpl jbPlatform;

    public JBDeploymentManager(DeploymentManager dm, String uri, String username, String password) {
        this.realUri = uri;
        this.dm = dm;
        this.rmiServer = null;
    }

    public String getHost() {
        String host = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("host");
        return host;
    }

    public int getPort() {
        String port = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("port");
        return new Integer(port);
    }

    public int getDebuggingPort() {
        return this.debuggingPort;
    }

    public String getUrl() {
        return this.realUri;
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.realUri);
        }
        return this.instanceProperties;
    }

    public synchronized Object getRMIServer() {
        if (this.rmiServer == null) {
            try {
                InstanceProperties ip = this.getInstanceProperties();
                URLClassLoader loader = JBDeploymentFactory.getJBClassLoader(ip.getProperty("root-dir"));
                Thread.currentThread().setContextClassLoader(loader);
                Hashtable<String, Object> env = new Hashtable<String, Object>();
                env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                env.put("java.naming.provider.url", "jnp://localhost:" + JBPluginUtils.getJnpPort(ip.getProperty("server-dir")));
                env.put("java.naming.factory.object", "org.jboss.naming");
                env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                env.put("jnp.disableDiscovery", Boolean.TRUE);
                InitialContext ctx = new InitialContext(env);
                this.rmiServer = ctx.lookup("/jmx/invoker/RMIAdaptor");
            }
            catch (NameNotFoundException ex) {
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.rmiServer;
    }

    public synchronized Object refreshRMIServer() {
        this.rmiServer = null;
        return this.getRMIServer();
    }

    public static boolean isRunningLastCheck(InstanceProperties ip) {
        boolean isRunning = propertiesToIsRunning.containsKey(ip) && propertiesToIsRunning.get(ip).equals(Boolean.TRUE);
        return isRunning;
    }

    public static void setRunningLastCheck(InstanceProperties ip, Boolean isRunning) {
        assert (ip != null);
        propertiesToIsRunning.put(ip, isRunning);
    }

    public ProgressObject distribute(Target[] target, File file, File file2) throws IllegalStateException {
        return new JBDeployer(this.realUri, this).deploy(target, file, file2, this.getHost(), this.getPort());
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        ModuleType type = deployableObject.getType();
        if (type == ModuleType.WAR) {
            return new WarDeploymentConfiguration(deployableObject);
        }
        if (type == ModuleType.EAR) {
            return new EarDeploymentConfiguration(deployableObject);
        }
        if (type == ModuleType.EJB) {
            return new EjbDeploymentConfiguration(deployableObject);
        }
        if (type == ModuleType.CAR) {
            return new CarDeploymentConfiguration(deployableObject);
        }
        throw new InvalidModuleException("Unsupported module type: " + type.toString());
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        return this.dm.redeploy(targetModuleID, inputStream, inputStream2);
    }

    public ProgressObject distribute(Target[] target, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.dm.distribute(target, inputStream, inputStream2);
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleID) throws IllegalStateException {
        return this.dm.undeploy(targetModuleID);
    }

    public ProgressObject stop(TargetModuleID[] targetModuleID) throws IllegalStateException {
        return this.dm.stop(targetModuleID);
    }

    public ProgressObject start(TargetModuleID[] targetModuleID) throws IllegalStateException {
        return this.dm.start(targetModuleID);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.dm.setLocale(locale);
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.dm.isLocaleSupported(locale);
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        return this.dm.getRunningModules(moduleType, target);
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        return new JBDeployer(this.realUri, this).redeploy(targetModuleID, file, file2);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        this.dm.setDConfigBeanVersion(dConfigBeanVersionType);
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return this.dm.isDConfigBeanVersionSupported(dConfigBeanVersionType);
    }

    public void release() {
        if (this.dm != null) {
            this.dm.release();
        }
    }

    public boolean isRedeploySupported() {
        return this.dm.isRedeploySupported();
    }

    public Locale getCurrentLocale() {
        return this.dm.getCurrentLocale();
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.dm.getDConfigBeanVersion();
    }

    public Locale getDefaultLocale() {
        return this.dm.getDefaultLocale();
    }

    public Locale[] getSupportedLocales() {
        return this.dm.getSupportedLocales();
    }

    public Target[] getTargets() throws IllegalStateException {
        return this.dm.getTargets();
    }

    public JBJ2eePlatformFactory.J2eePlatformImplImpl getJBPlatform() {
        if (this.jbPlatform == null) {
            this.jbPlatform = (JBJ2eePlatformFactory.J2eePlatformImplImpl)new JBJ2eePlatformFactory().getJ2eePlatformImpl(this);
        }
        return this.jbPlatform;
    }

    public JBProperties getProperties() {
        return new JBProperties(this);
    }
}

