/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.web.Cache;
import org.netbeans.modules.j2ee.sun.dd.api.web.CacheHelper;
import org.netbeans.modules.j2ee.sun.dd.api.web.CacheMapping;
import org.netbeans.modules.j2ee.sun.dd.api.web.DefaultHelper;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.dd.api.web.WebProperty;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.ConfigFinder;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.Snippet;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.schema2beans.BaseBean;

public class WebAppCache {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.Bundle");
    private static final String SunWebFileName = "sun-web.xml";
    private WebAppRoot webAppRoot;
    private String cacheMaxEntries;
    private String timeoutInSeconds;
    private String cacheEnabled;
    private List properties;
    private DefaultHelper defaultHelper;
    private List cacheHelpers;
    private List cacheMappings;
    private Boolean isValid = null;
    protected List validationFieldList = new ArrayList();
    public static final String FIELD_CACHE_MAX_ENTRIES = ":max-entries";
    public static final String FIELD_CACHE_TIMEOUT = ":timeout";
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheHelper;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$sun$dd$api$web$WebProperty;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheMapping;

    protected void init(WebAppRoot parent) {
        this.webAppRoot = parent;
    }

    public Base getParent() {
        return this.webAppRoot;
    }

    protected void updateValidationFieldList() {
        this.validationFieldList.add(FIELD_CACHE_MAX_ENTRIES);
        this.validationFieldList.add(FIELD_CACHE_TIMEOUT);
    }

    public void validationStateChanged(Boolean newState) {
        this.isValid = newState;
    }

    public boolean isValid() {
        if (this.isValid == null) {
            boolean tempValid = this.validateFields(true);
            this.isValid = tempValid;
        }
        return this.isValid;
    }

    public boolean validateFields(boolean shortCircuit) {
        ErrorMessageDB messageDB = this.webAppRoot.getMessageDB();
        boolean result = true;
        messageDB.clearErrors();
        Iterator iter = this.validationFieldList.iterator();
        while (iter.hasNext() && (result || !shortCircuit)) {
            boolean fieldResult = this.validateField((String)iter.next());
            result = result && fieldResult;
        }
        return result;
    }

    public boolean validateField(String fieldId) {
        ValidationError error = null;
        if (fieldId.equals(FIELD_CACHE_MAX_ENTRIES)) {
            String absoluteFieldXpath = this.getAbsoluteXpath(fieldId);
            if (Utils.notEmpty(this.cacheMaxEntries)) {
                try {
                    int value = Integer.parseInt(this.cacheMaxEntries);
                    if (value < 0) {
                        Object[] args = new Object[]{this.cacheMaxEntries, "0"};
                        String message = MessageFormat.format(bundle.getString("ERR_NumberTooLow"), args);
                        error = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, absoluteFieldXpath, message);
                    }
                }
                catch (NumberFormatException ex) {
                    Object[] args = new Object[]{this.cacheMaxEntries};
                    String message = MessageFormat.format(bundle.getString("ERR_NumberInvalid"), args);
                    error = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, absoluteFieldXpath, message);
                }
            }
            if (error == null) {
                error = ValidationError.getValidationErrorMask(ValidationError.PARTITION_CACHE_GENERAL, absoluteFieldXpath);
            }
        } else if (fieldId.equals(FIELD_CACHE_TIMEOUT)) {
            String absoluteFieldXpath = this.getAbsoluteXpath(fieldId);
            if (Utils.notEmpty(this.timeoutInSeconds)) {
                try {
                    int value = Integer.parseInt(this.timeoutInSeconds);
                    if (value < -1) {
                        Object[] args = new Object[]{this.timeoutInSeconds, "-1"};
                        String message = MessageFormat.format(bundle.getString("ERR_NumberTooLow"), args);
                        error = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, absoluteFieldXpath, message);
                    }
                }
                catch (NumberFormatException ex) {
                    Object[] args = new Object[]{this.timeoutInSeconds};
                    String message = MessageFormat.format(bundle.getString("ERR_NumberInvalid"), args);
                    error = ValidationError.getValidationError(ValidationError.PARTITION_CACHE_GENERAL, absoluteFieldXpath, message);
                }
            }
            if (error == null) {
                error = ValidationError.getValidationErrorMask(ValidationError.PARTITION_CACHE_GENERAL, absoluteFieldXpath);
            }
        }
        if (error != null) {
            this.webAppRoot.getMessageDB().updateError(error);
        }
        return error == null || !Utils.notEmpty(error.getMessage());
    }

    protected String getAbsoluteXpath(String field) {
        StringBuffer buf = new StringBuffer(field.length() + 20);
        buf.append("/sun-web-app/cache/");
        buf.append(field);
        return buf.toString();
    }

    public String getCacheMaxEntries() {
        return this.cacheMaxEntries;
    }

    public void setCacheMaxEntries(String newCacheMaxEntries) throws PropertyVetoException {
        if (newCacheMaxEntries == null || newCacheMaxEntries.length() == 0) {
            newCacheMaxEntries = null;
        }
        String oldCacheMaxEntries = this.cacheMaxEntries;
        this.getVCS().fireVetoableChange("cacheMaxEntries", oldCacheMaxEntries, newCacheMaxEntries);
        this.cacheMaxEntries = newCacheMaxEntries;
        this.getPCS().firePropertyChange("cacheMaxEntries", oldCacheMaxEntries, this.cacheMaxEntries);
    }

    public String getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public void setTimeoutInSeconds(String newTimeoutInSeconds) throws PropertyVetoException {
        if (newTimeoutInSeconds == null || newTimeoutInSeconds.length() == 0) {
            newTimeoutInSeconds = null;
        }
        String oldTimeoutInSeconds = this.timeoutInSeconds;
        this.getVCS().fireVetoableChange("timeoutInSeconds", oldTimeoutInSeconds, newTimeoutInSeconds);
        this.timeoutInSeconds = newTimeoutInSeconds;
        this.getPCS().firePropertyChange("timeoutInSeconds", oldTimeoutInSeconds, this.timeoutInSeconds);
    }

    public String getCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(String newCacheEnabled) throws PropertyVetoException {
        String oldClassLoader = this.cacheEnabled;
        this.getVCS().fireVetoableChange("cacheEnabled", new Boolean(oldClassLoader), new Boolean(newCacheEnabled));
        this.cacheEnabled = newCacheEnabled;
        this.getPCS().firePropertyChange("cacheEnabled", new Boolean(oldClassLoader), new Boolean(this.cacheEnabled));
    }

    public List getProperties() {
        return this.properties;
    }

    public WebProperty getProperty(int index) {
        return (WebProperty)this.properties.get(index);
    }

    public void setProperties(List newProperties) throws PropertyVetoException {
        List oldProperties = this.properties;
        this.getVCS().fireVetoableChange("properties", oldProperties, newProperties);
        this.properties = newProperties;
        this.getPCS().firePropertyChange("properties", oldProperties, this.properties);
    }

    public void addProperty(WebProperty newProperty) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("property", null, newProperty);
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(newProperty);
        this.getPCS().firePropertyChange("property", null, newProperty);
    }

    public void removeProperty(WebProperty oldProperty) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("property", oldProperty, null);
        this.properties.remove(oldProperty);
        this.getPCS().firePropertyChange("property", oldProperty, null);
    }

    public DefaultHelper getDefaultHelper() {
        return this.defaultHelper;
    }

    public void setDefaultHelper(DefaultHelper newDefaultHelper) throws PropertyVetoException {
        if (newDefaultHelper == null) {
            newDefaultHelper = this.webAppRoot.getConfig().getStorageFactory().createDefaultHelper();
        }
        DefaultHelper oldDefaultHelper = this.defaultHelper;
        this.getVCS().fireVetoableChange("defaultHelper", oldDefaultHelper, newDefaultHelper);
        this.defaultHelper = newDefaultHelper;
        this.getPCS().firePropertyChange("defaultHelper", oldDefaultHelper, this.defaultHelper);
    }

    public List getCacheHelpers() {
        return this.cacheHelpers;
    }

    public CacheHelper getCacheHelper(int index) {
        return (CacheHelper)this.cacheHelpers.get(index);
    }

    public void setCacheHelpers(List newCacheHelpers) throws PropertyVetoException {
        List oldCacheHelpers = this.cacheHelpers;
        this.getVCS().fireVetoableChange("cacheHelpers", oldCacheHelpers, newCacheHelpers);
        this.cacheHelpers = newCacheHelpers;
        this.getPCS().firePropertyChange("cacheHelpers", oldCacheHelpers, this.cacheHelpers);
    }

    public void addProperty(CacheHelper newCacheHelper) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheHelper", null, newCacheHelper);
        if (this.cacheHelpers == null) {
            this.cacheHelpers = new ArrayList();
        }
        this.cacheHelpers.add(newCacheHelper);
        this.getPCS().firePropertyChange("cacheHelper", null, newCacheHelper);
    }

    public void removeProperty(CacheHelper oldCacheHelper) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheHelper", oldCacheHelper, null);
        this.cacheHelpers.remove(oldCacheHelper);
        this.getPCS().firePropertyChange("cacheHelper", oldCacheHelper, null);
    }

    public List getCacheMappings() {
        return this.cacheMappings;
    }

    public CacheMapping getCacheMapping(int index) {
        return (CacheMapping)this.cacheMappings.get(index);
    }

    public void setCacheMappings(List newCacheMappings) throws PropertyVetoException {
        List oldCacheMappings = this.cacheMappings;
        this.getVCS().fireVetoableChange("cacheMappings", oldCacheMappings, newCacheMappings);
        this.cacheMappings = newCacheMappings;
        this.getPCS().firePropertyChange("cacheMappings", oldCacheMappings, this.cacheMappings);
    }

    public void addCacheMapping(CacheMapping newCacheMapping) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheMapping", null, newCacheMapping);
        if (this.cacheMappings == null) {
            this.cacheMappings = new ArrayList();
        }
        this.cacheMappings.add(newCacheMapping);
        this.getPCS().firePropertyChange("cacheMapping", null, newCacheMapping);
    }

    public void removeCacheMapping(CacheMapping oldCacheMapping) throws PropertyVetoException {
        this.getVCS().fireVetoableChange("cacheMapping", oldCacheMapping, null);
        this.cacheMappings.remove(oldCacheMapping);
        this.getPCS().firePropertyChange("cacheMapping", oldCacheMapping, null);
    }

    Collection getSnippets() {
        ArrayList<1> snippets = new ArrayList<1>();
        Snippet snipOne = new Snippet(){

            public BaseBean getCmpDDSnippet() {
                return null;
            }

            public CommonDDBean getDDSnippet() {
                CacheMapping[] mappings;
                WebProperty[] webProps;
                DefaultHelper dh;
                CacheHelper[] helpers;
                Cache cache = WebAppCache.this.webAppRoot.getConfig().getStorageFactory().createCache_NoDefaults();
                String version = WebAppCache.this.webAppRoot.getAppServerVersion().getWebAppVersionAsString();
                if (WebAppCache.this.cacheMaxEntries != null) {
                    cache.setMaxEntries(WebAppCache.this.cacheMaxEntries);
                }
                if (WebAppCache.this.timeoutInSeconds != null) {
                    cache.setTimeoutInSeconds(WebAppCache.this.timeoutInSeconds);
                }
                if (WebAppCache.this.cacheEnabled != null) {
                    cache.setEnabled(WebAppCache.this.cacheEnabled);
                }
                if ((helpers = (CacheHelper[])Utils.listToArray(WebAppCache.this.getCacheHelpers(), class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheHelper == null ? (class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheHelper = WebAppCache.class$("org.netbeans.modules.j2ee.sun.dd.api.web.CacheHelper")) : class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheHelper, version)) != null) {
                    cache.setCacheHelper(helpers);
                }
                if ((dh = WebAppCache.this.getDefaultHelper()).sizeWebProperty() > 0) {
                    cache.setDefaultHelper((DefaultHelper)dh.cloneVersion(version));
                }
                if ((webProps = (WebProperty[])Utils.listToArray(WebAppCache.this.getProperties(), class$org$netbeans$modules$j2ee$sun$dd$api$web$WebProperty == null ? (class$org$netbeans$modules$j2ee$sun$dd$api$web$WebProperty = WebAppCache.class$("org.netbeans.modules.j2ee.sun.dd.api.web.WebProperty")) : class$org$netbeans$modules$j2ee$sun$dd$api$web$WebProperty, version)) != null) {
                    cache.setWebProperty(webProps);
                }
                if ((mappings = (CacheMapping[])Utils.listToArray(WebAppCache.this.getCacheMappings(), class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheMapping == null ? (class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheMapping = WebAppCache.class$("org.netbeans.modules.j2ee.sun.dd.api.web.CacheMapping")) : class$org$netbeans$modules$j2ee$sun$dd$api$web$CacheMapping, version)) != null) {
                    cache.setCacheMapping(mappings);
                }
                return cache;
            }

            public boolean hasDDSnippet() {
                if (WebAppCache.this.getCacheMaxEntries() != null) {
                    return true;
                }
                if (WebAppCache.this.getTimeoutInSeconds() != null) {
                    return true;
                }
                if (WebAppCache.this.getCacheEnabled() != null) {
                    return true;
                }
                List cacheHelpers = WebAppCache.this.getCacheHelpers();
                if (cacheHelpers != null && cacheHelpers.size() > 0) {
                    return true;
                }
                DefaultHelper dh = WebAppCache.this.getDefaultHelper();
                if (dh.sizeWebProperty() > 0) {
                    return true;
                }
                List properties = WebAppCache.this.getProperties();
                if (properties != null && properties.size() > 0) {
                    return true;
                }
                List cacheMappings = WebAppCache.this.getCacheMappings();
                return cacheMappings != null && cacheMappings.size() > 0;
            }

            public String getPropertyName() {
                return "Cache";
            }

            public String getFileName() {
                return WebAppCache.SunWebFileName;
            }

            public CommonDDBean mergeIntoRootDD(CommonDDBean ddRoot) {
                Cache cache = (Cache)this.getDDSnippet();
                if (ddRoot instanceof SunWebApp) {
                    SunWebApp swa = (SunWebApp)ddRoot;
                    swa.setCache(cache);
                }
                return cache;
            }

            public CommonDDBean mergeIntoRovingDD(CommonDDBean ddParent) {
                return this.mergeIntoRootDD(ddParent);
            }
        };
        snippets.add(snipOne);
        return snippets;
    }

    boolean loadFromPlanFile(SunONEDeploymentConfiguration config) {
        String uriText = this.webAppRoot.getUriText();
        Cache beanGraph = (Cache)config.getBeans(uriText, SunWebFileName, this.webAppRoot.getParser(), new CacheFinder());
        this.clearProperties();
        if (null != beanGraph) {
            this.cacheMaxEntries = beanGraph.getMaxEntries();
            this.timeoutInSeconds = beanGraph.getTimeoutInSeconds();
            this.cacheEnabled = beanGraph.getEnabled();
            this.cacheHelpers = Utils.arrayToList((CommonDDBean[])beanGraph.getCacheHelper());
            DefaultHelper dh = beanGraph.getDefaultHelper();
            if (dh != null && dh.sizeWebProperty() > 0) {
                this.defaultHelper = (DefaultHelper)dh.clone();
            }
            this.properties = Utils.arrayToList((CommonDDBean[])beanGraph.getWebProperty());
            this.cacheMappings = Utils.arrayToList((CommonDDBean[])beanGraph.getCacheMapping());
        } else {
            this.setDefaultProperties();
        }
        return beanGraph != null;
    }

    protected void clearProperties() {
        this.cacheMaxEntries = null;
        this.timeoutInSeconds = null;
        this.cacheEnabled = null;
        this.cacheHelpers = null;
        this.defaultHelper = this.webAppRoot.getConfig().getStorageFactory().createDefaultHelper();
        this.properties = null;
        this.cacheMappings = null;
    }

    protected void setDefaultProperties() {
    }

    protected PropertyChangeSupport getPCS() {
        return this.webAppRoot.getPCS();
    }

    protected VetoableChangeSupport getVCS() {
        return this.webAppRoot.getVCS();
    }

    private class CacheFinder
    implements ConfigFinder {
        private CacheFinder() {
        }

        public Object find(Object obj) {
            Cache result = null;
            if (obj instanceof SunWebApp) {
                SunWebApp swa = (SunWebApp)obj;
                result = swa.getCache();
            }
            return result;
        }
    }
}

