/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openide.util.Utilities;

public class ResultItemPaintComponent
extends JPanel {
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif";
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static String str;
    private static final String[] frequentWords;
    public static final Color KEYWORD_COLOR;
    public static final Color TYPE_COLOR;

    public ResultItemPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setString(String str) {
        ResultItemPaintComponent.str = str;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    protected Icon getIcon() {
        return null;
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    protected void draw(Graphics g) {
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics g, String s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, String s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, String s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, String s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics g, String s, Color c) {
        if (g == null) {
            this.drawString(g, "   ");
            this.drawString(g, s, c);
        } else {
            int spaceWidth;
            int w = this.getWidth() - this.getWidth(s) - this.drawX;
            if (w > (spaceWidth = this.getWidth(" ")) * 2) {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s);
            } else {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s) - this.getWidth("...   ");
                g.setColor(this.getBackground());
                g.fillRect(this.drawX, 0, this.getWidth() - this.drawX, this.getHeight());
                this.drawString(g, "...   ", c);
            }
            this.drawString(g, s, c);
        }
    }

    protected void drawStringToGraphics(Graphics g, String s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font, boolean strike) {
        if (g != null) {
            if (!strike) {
                g.drawString(s, this.drawX, this.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(s);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s) {
        Integer i = (Integer)this.widths.get(s);
        if (i != null) {
            return i;
        }
        if (s == null) {
            s = "";
        }
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    static {
        frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", THROWS};
        KEYWORD_COLOR = Color.darkGray;
        TYPE_COLOR = Color.black;
    }

    public static class ELFunctionPaintComponent
    extends ELPaintComponent {
        private String prefix = null;
        private String parameters = null;
        private static final Color PREFIX_COLOR = Color.blue.darker().darker();
        private static final Color FUNCTION_NAME_COLOR = Color.black;
        private static final Color PARAMETER_COLOR = Color.black;
        private static final String ICON_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/function_16.png";

        protected Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)ICON_PATH));
        }

        public Color getExpressionColor() {
            return FUNCTION_NAME_COLOR;
        }

        public void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.prefix, PREFIX_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            this.drawString(g, ":" + str, FUNCTION_NAME_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            this.drawParameters(g, this.parameters);
            if (this.getTypeName() != null) {
                this.drawTypeName(g, this.getTypeName(), this.getTypeColor());
            }
        }

        protected void drawParameters(Graphics g, String parList) {
            this.drawString(g, "(", PARAMETER_COLOR);
            if (this.parameters != null) {
                this.drawString(g, this.parameters, PARAMETER_COLOR);
            }
            this.drawString(g, ")", PARAMETER_COLOR);
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setParameters(String parameters) {
            this.parameters = parameters;
        }
    }

    public static class ELPropertyPaintComponent
    extends ELPaintComponent {
        public static final Color PROPERTY_NAME_COLOR = Color.blue.darker().darker();
        private static final String PROPERTY_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/property_16.png";

        protected Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)PROPERTY_PATH));
        }

        public Color getExpressionColor() {
            return PROPERTY_NAME_COLOR;
        }
    }

    public static class ELBeanPaintComponent
    extends ELPaintComponent {
        public static final Color BEAN_NAME_COLOR = Color.blue.darker().darker();
        private static final String BEAN_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/bean_16.png";

        protected Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)BEAN_PATH));
        }

        public Color getExpressionColor() {
            return BEAN_NAME_COLOR;
        }
    }

    public static class ELImplicitObjectPaintComponent
    extends ELPaintComponent {
        private int type = 0;
        private static final String OBJECT_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/class_16.png";
        private static final String MAP_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/map_16.png";

        protected Icon getIcon() {
            ImageIcon icon = null;
            switch (this.type) {
                case 0: {
                    icon = new ImageIcon(Utilities.loadImage((String)OBJECT_PATH));
                    break;
                }
                case 1: {
                    icon = new ImageIcon(Utilities.loadImage((String)MAP_PATH));
                }
            }
            return icon;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    public static class ELPaintComponent
    extends ResultItemPaintComponent {
        private String typeName = null;

        public void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, str, this.getExpressionColor(), new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            if (this.getTypeName() != null) {
                this.drawTypeName(g, this.getTypeName(), this.getTypeColor());
            }
        }

        public Color getExpressionColor() {
            return Color.blue;
        }

        public Color getTypeColor() {
            return Color.BLACK;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }
    }

    public static class AttributePaintComponent
    extends ResultItemPaintComponent {
        private boolean mandatory;

        public AttributePaintComponent(boolean mandatory) {
            this.mandatory = mandatory;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, str, this.mandatory ? Color.RED : Color.GREEN.darker());
        }
    }

    public static class JspDirectivePaintComponent
    extends ResultItemPaintComponent {
        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, "<%@");
            this.drawString(g, str, Color.BLUE, this.getDrawFont().deriveFont(1), false);
            this.drawString(g, " ... ", Color.GREEN.darker());
            this.drawString(g, "%>");
        }
    }

    public static class JspTagPaintComponent
    extends ResultItemPaintComponent {
        private boolean isEmpty;

        public JspTagPaintComponent(boolean isEmpty) {
            this.isEmpty = isEmpty;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, "<");
            this.drawString(g, str, Color.BLUE, this.getDrawFont().deriveFont(1), false);
            if (this.isEmpty) {
                this.drawString(g, "/>");
            } else {
                this.drawString(g, ">");
            }
        }
    }

    public static class AbbrevPaintComponent
    extends ResultItemPaintComponent {
        private String abbrev;

        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.abbrev, Color.BLUE, this.getDrawFont().deriveFont(1), false);
            this.drawString(g, " " + str, TYPE_COLOR);
        }

        public void setAbbrev(String abbrev) {
            this.abbrev = abbrev;
        }
    }

    public static class StringPaintComponent
    extends ResultItemPaintComponent {
        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, str, TYPE_COLOR);
        }
    }
}

