/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.FontAndColorsPanel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HighlightingPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JList lCategories = new JList();
    private ColorComboBox foregroundColorChooser = new ColorComboBox();
    private ColorComboBox backgroundColorChooser = new ColorComboBox();
    private ColorModel colorModel = null;
    private boolean listen = false;
    private String currentProfile;
    private Map profileToCategories = new HashMap();
    private Set toBeSaved = new HashSet();
    private boolean changed = false;
    private Map profileToDefaults = new HashMap();

    public HighlightingPanel(FontAndColorsPanel fontAndColorsPanel) {
        this.lCategories.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Categories"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Foreground_Chooser"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Foreground_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Background_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Background_Chooser"));
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!HighlightingPanel.this.listen) {
                    return;
                }
                HighlightingPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.foregroundColorChooser.addPropertyChangeListener(this);
        this.backgroundColorChooser.addPropertyChangeListener(this);
        JLabel lCategory = new JLabel();
        HighlightingPanel.loc(lCategory, "CTL_Category");
        lCategory.setLabelFor(this.lCategories);
        FormLayout layout = new FormLayout("p:g, 10dlu, p, 3dlu, p:g, 1dlu, p", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, p:g");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.add((Component)lCategory, lc.xy(1, 1));
        builder.add((Component)new JScrollPane(this.lCategories), cc.xywh(1, 3, 1, 8));
        builder.addLabel(HighlightingPanel.loc("CTL_Foreground_label"), lc.xy(3, 3), (Component)this.foregroundColorChooser, cc.xyw(5, 3, 3));
        builder.addLabel(HighlightingPanel.loc("CTL_Background_label"), lc.xy(3, 5), (Component)this.backgroundColorChooser, cc.xyw(5, 5, 3));
    }

    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getPropertyName() != "color") {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.listen = false;
        this.setCurrentProfile(this.currentProfile);
        this.lCategories.setListData(this.getCategories(this.currentProfile));
        this.lCategories.setSelectedIndex(0);
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    void cancel() {
        this.toBeSaved = new HashSet();
        this.profileToCategories = new HashMap();
        this.changed = false;
    }

    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator it = this.toBeSaved.iterator();
        while (it.hasNext()) {
            String profile = (String)it.next();
            this.colorModel.setHighlightings(profile, this.getCategories(profile));
        }
        this.toBeSaved = new HashSet();
        this.profileToCategories = new HashMap();
    }

    boolean isChanged() {
        return this.changed;
    }

    void setCurrentProfile(String currentProfile) {
        String oldScheme = this.currentProfile;
        this.currentProfile = currentProfile;
        if (!this.colorModel.getProfiles().contains(currentProfile)) {
            Vector categories = this.getCategories(oldScheme);
            this.profileToCategories.put(currentProfile, new Vector(categories));
            this.toBeSaved.add(currentProfile);
        }
        this.refreshUI();
    }

    void deleteProfile(String profile) {
        if (this.colorModel.isCustomProfile(profile)) {
            this.profileToCategories.put(profile, null);
        } else {
            this.profileToCategories.put(profile, this.getDefaults(profile));
            this.refreshUI();
        }
        this.toBeSaved.add(profile);
    }

    Collection getHighlightings() {
        return this.getCategories(this.currentProfile);
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)HighlightingPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)HighlightingPanel.loc(key));
        }
    }

    private void updateData() {
        if (this.lCategories.getSelectedIndex() < 0) {
            return;
        }
        Vector categories = this.getCategories(this.currentProfile);
        AttributeSet category = (AttributeSet)categories.get(this.lCategories.getSelectedIndex());
        Object underline = null;
        Object wave = null;
        Object strikethrough = null;
        SimpleAttributeSet c = new SimpleAttributeSet(category);
        if (this.backgroundColorChooser.getColor() != null) {
            c.addAttribute(StyleConstants.Background, this.backgroundColorChooser.getColor());
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        if (this.foregroundColorChooser.getColor() != null) {
            c.addAttribute(StyleConstants.Foreground, this.foregroundColorChooser.getColor());
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        if (underline != null) {
            c.addAttribute(StyleConstants.Underline, underline);
        } else {
            c.removeAttribute(StyleConstants.Underline);
        }
        if (strikethrough != null) {
            c.addAttribute(StyleConstants.StrikeThrough, strikethrough);
        } else {
            c.removeAttribute(StyleConstants.StrikeThrough);
        }
        if (wave != null) {
            c.addAttribute(EditorStyleConstants.WaveUnderlineColor, wave);
        } else {
            c.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        int i = this.lCategories.getSelectedIndex();
        categories.set(i, c);
        this.toBeSaved.add(this.currentProfile);
    }

    private void refreshUI() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.foregroundColorChooser.setEnabled(false);
            this.backgroundColorChooser.setEnabled(false);
            return;
        }
        this.foregroundColorChooser.setEnabled(true);
        this.backgroundColorChooser.setEnabled(true);
        Vector categories = this.getCategories(this.currentProfile);
        AttributeSet category = (AttributeSet)categories.get(index);
        this.listen = false;
        this.foregroundColorChooser.setColor((Color)category.getAttribute(StyleConstants.Foreground));
        this.backgroundColorChooser.setColor((Color)category.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private Vector getCategories(String profile) {
        if (this.colorModel == null) {
            return null;
        }
        if (!this.profileToCategories.containsKey(profile)) {
            Collection c = this.colorModel.getHighlightings(profile);
            ArrayList l = new ArrayList(c);
            Collections.sort(l, new CategoryComparator());
            this.profileToCategories.put(profile, new Vector(l));
        }
        return (Vector)this.profileToCategories.get(profile);
    }

    private Vector getDefaults(String profile) {
        if (!this.profileToDefaults.containsKey(profile)) {
            Collection c = this.colorModel.getHighlightingDefaults(profile);
            ArrayList l = new ArrayList(c);
            Collections.sort(l, new CategoryComparator());
            this.profileToDefaults.put(profile, new Vector(l));
        }
        return (Vector)this.profileToDefaults.get(profile);
    }
}

