/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.Format;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NbDdeBrowserImpl
extends ExtBrowserImpl {
    private static final String WWW_ACTIVATE = "WWW_Activate";
    private static final String WWW_OPEN_URL = "WWW_OpenURL";
    private static final String EXTBROWSER_DLL = "extbrowser";
    private static final String EXTBROWSER_DLL_64BIT = "extbrowser64";
    private static Thread nativeThread;
    private static URLDisplayer nativeRunnable;

    public NbDdeBrowserImpl(ExtWebBrowser extBrowserFactory) {
        this.extBrowserFactory = extBrowserFactory;
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl created with factory: " + extBrowserFactory);
        }
    }

    private native byte[] reqDdeMessage(String var1, String var2, String var3, int var4) throws NbBrowserException;

    public static native String getBrowserPath(String var0) throws NbBrowserException;

    public static native String getDefaultOpenCommand() throws NbBrowserException;

    public synchronized void setURL(URL url) {
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl.setUrl: " + url);
        }
        if (nativeThread == null) {
            nativeRunnable = new URLDisplayer();
            nativeThread = new Thread((Runnable)nativeRunnable, "URLdisplayer");
            nativeThread.start();
        }
        NbDdeBrowserImpl.nativeRunnable.postTask(new DisplayTask(url, this));
    }

    private String realDDEServer() {
        String srv;
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl.realDDEServer");
        }
        if ((srv = this.extBrowserFactory.getDDEServer()) != null) {
            return srv;
        }
        try {
            String cmd = NbDdeBrowserImpl.getDefaultOpenCommand();
            if (cmd != null) {
                if (cmd.toUpperCase().indexOf("IEXPLORE") >= 0) {
                    return "IEXPLORE";
                }
                if (cmd.toUpperCase().indexOf("NETSCP") >= 0) {
                    return "NETSCAPE6";
                }
                if (cmd.toUpperCase().indexOf("NETSCAPE") >= 0) {
                    return "NETSCAPE";
                }
                if (cmd.toUpperCase().indexOf("MOZILLA") >= 0) {
                    return "MOZILLA";
                }
                if (cmd.toUpperCase().indexOf("FIREFOX") >= 0) {
                    return "FIREFOX";
                }
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return "IEXPLORE";
    }

    public int getActivateTimeout() {
        return this.extBrowserFactory.getActivateTimeout();
    }

    public int getOpenUrlTimeout() {
        return this.extBrowserFactory.getOpenurlTimeout();
    }

    static {
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log(1, "" + System.currentTimeMillis() + "> NbDdeBrowser: static initializer: ");
        }
        try {
            if (Utilities.isWindows()) {
                String sunDataModel = System.getProperty("sun.arch.data.model");
                if (sunDataModel != null) {
                    if ("64".equals(sunDataModel)) {
                        System.loadLibrary(EXTBROWSER_DLL_64BIT);
                    } else {
                        System.loadLibrary(EXTBROWSER_DLL);
                    }
                } else {
                    String javaVMName = System.getProperty("java.vm.name");
                    if (javaVMName != null && javaVMName.indexOf("64") > -1) {
                        System.loadLibrary(EXTBROWSER_DLL_64BIT);
                    } else {
                        System.loadLibrary(EXTBROWSER_DLL);
                    }
                }
            }
        }
        catch (Exception e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)NbDdeBrowserImpl.class, (String)"ERR_cant_locate_dll"), 1));
        }
        nativeThread = null;
        nativeRunnable = null;
    }

    private static class DisplayTask {
        URL url;
        NbDdeBrowserImpl browser;

        DisplayTask(URL url, NbDdeBrowserImpl browser) {
            this.url = url;
            this.browser = browser;
        }
    }

    static class URLDisplayer
    implements Runnable {
        private static final int ADDITIONAL_WAIT_TIMEOUT = 6000;
        Vector tasks = new Vector();
        boolean doProcessing = true;
        boolean isDisplaying = false;

        private URLDisplayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postTask(DisplayTask task) {
            URLDisplayer uRLDisplayer = this;
            synchronized (uRLDisplayer) {
                boolean shouldNotify = this.tasks.isEmpty();
                this.tasks.add(task);
                if (shouldNotify) {
                    this.notifyAll();
                }
            }
        }

        private synchronized DisplayTask getNextTask() throws InterruptedException {
            while (this.tasks.isEmpty()) {
                this.wait();
            }
            return (DisplayTask)this.tasks.remove(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl.run");
            }
            while (this.doProcessing) {
                try {
                    DisplayTask task = this.getNextTask();
                    this.isDisplaying = true;
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        public void run() {
                            if (URLDisplayer.this.isDisplaying) {
                                nativeThread.interrupt();
                                if (ExtWebBrowser.getEM().isLoggable(1)) {
                                    ExtWebBrowser.getEM().log("interrupted in URLDisplayer.run.TimerTask.run()");
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_win_browser_invocation_failed"), 1));
                            }
                        }
                    }, 6000L);
                    this.dispatchURL(task);
                    timer.cancel();
                }
                catch (InterruptedException ex) {
                    ExtWebBrowser.getEM().log("interrupted in run(): " + ex);
                }
                finally {
                    this.isDisplaying = false;
                }
            }
        }

        public void dispatchURL(DisplayTask task) {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " NbDdeBrowserImpl.dispatchURL: " + task);
            }
            try {
                URL url = task.url;
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " URLDispatcher.url: " + url);
                }
                url = URLUtil.createExternalURL(url, URLUtil.browserHandlesJarURLs(task.browser.realDDEServer()));
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " url: " + url);
                }
                String urlStr = url.toString();
                boolean triedStart = false;
                int MAX_URL_LENGTH = 199;
                if (urlStr != null && urlStr.length() > 199) {
                    urlStr = this.getFileUrl(urlStr);
                }
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " urlstr: " + urlStr);
                }
                if (!this.win9xHack(task.browser.realDDEServer())) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_activatingBrowser"));
                    try {
                        task.browser.reqDdeMessage(task.browser.realDDEServer(), NbDdeBrowserImpl.WWW_ACTIVATE, "-1,0x0", task.browser.getActivateTimeout());
                    }
                    catch (NbBrowserException ex) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "Exception, gonna start browser: " + ex);
                        }
                        triedStart = true;
                        this.startBrowser(task.browser.extBrowserFactory.getBrowserExecutable(), urlStr);
                    }
                }
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " firstpart");
                }
                if (!triedStart) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_openingURLInBrowser", (Object)urlStr));
                    String args1 = "\"" + urlStr + "\",,-1,0x1,,,";
                    try {
                        Thread.sleep(500L);
                        task.browser.reqDdeMessage(task.browser.realDDEServer(), NbDdeBrowserImpl.WWW_OPEN_URL, args1, task.browser.getOpenUrlTimeout());
                    }
                    catch (NbBrowserException ex) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log("Restarting browser.");
                        }
                        this.startBrowser(task.browser.extBrowserFactory.getBrowserExecutable(), urlStr);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " secondpart");
                }
                URL oldUrl = task.browser.url;
                task.browser.url = url;
                task.browser.pcs.firePropertyChange("url", oldUrl, url);
            }
            catch (Exception ex) {
                final Exception ex1 = ex;
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " Interrupted in URLDisplayer.dispatchURL.end");
                }
                ErrorManager.getDefault().annotate((Throwable)ex1, NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_win_browser_invocation_failed"));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ErrorManager.getDefault().notify((Throwable)ex1);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getFileUrl(String url) {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "Gonna get redirect file for long url: " + url);
            }
            String newurl = null;
            OutputStreamWriter fw = null;
            File f = null;
            int retries = 10;
            while (f == null && retries > 0) {
                --retries;
                try {
                    f = File.createTempFile(NbDdeBrowserImpl.EXTBROWSER_DLL, ".html");
                    if (ExtWebBrowser.getEM().isLoggable(1)) {
                        ExtWebBrowser.getEM().log("file: " + f);
                    }
                    if (f == null) continue;
                    fw = new FileWriter(f);
                    if (f.canWrite()) {
                        String s1 = NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl") : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"TXT_RedirectURL1");
                        String s2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl") : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"TXT_RedirectURL2");
                        String s = s1.concat(url).concat(s2);
                        fw.write(s);
                        fw.flush();
                    }
                    newurl = "file:/" + f.getAbsolutePath();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, "" + System.currentTimeMillis() + ioe.toString());
                }
                finally {
                    if (fw == null) continue;
                    try {
                        fw.close();
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().log(1, "" + System.currentTimeMillis() + ioe.toString());
                    }
                }
            }
            if (newurl != null) {
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "New URL: " + newurl);
                }
                return newurl;
            }
            return url;
        }

        private boolean win9xHack(String browser) {
            return browser.equals("IEXPLORE") && (Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2);
        }

        private void startBrowser(NbProcessDescriptor cmd, String url) throws IOException {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_startingBrowser", (Object)url));
            cmd.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(url)));
        }
    }
}

