/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship;

import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.RelationshipState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingWizard;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.TableElement;
import org.openide.util.UserCancelException;

public class RelatedClassStep
extends RelationshipMappingStep {
    private static final String PAD = " ";
    private static final String classLauncherName = "com.sun.jdo.modules.persistence.mapping.core.ui.panels.PersistenceClassSelectorPanel";
    private static Method persistenceClassLauncher;
    private JTextPane relatedClassTextField;
    private JComboBox relatedPrimaryTableComboBox;
    private JRadioButton linkDirectlyRadioButton;
    private JTextField thisFieldTextField;
    private JButton relatedClassButton;
    private JRadioButton linkWithJoinRadioButton;
    private JTextField primaryTableTextField;
    private JComboBox relatedFieldComboBox;
    private JTextField thisClassTextField;
    private boolean _launchingSelectorPanel = false;
    private Boolean relatedPrimaryFlag;

    public RelatedClassStep(RelationshipMappingWizard wizard) {
        super(wizard);
        this.initComponents();
        this.initStyles();
        this.initAccessibility();
    }

    private void initStyles() {
        Font defaultFont = UIManager.getFont("Label.font");
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style iconStyle = this.relatedClassTextField.addStyle("icon", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, defaultFont.getFamily());
        StyleConstants.setFontSize(defaultStyle, defaultFont.getSize());
        StyleConstants.setIcon(iconStyle, Util.getIllegalIcon());
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getMappingContext().getString("RMW_Initial_Step_Text"));
    }

    private void initComponents() {
        MappingContext mappingContext = this.getMappingContext();
        JTextArea relatedClassPanelTextArea = new JTextArea();
        JPanel classFieldTablePanel = new JPanel();
        JLabel thisClassLabel = new JLabel();
        JLabel thisFieldLabel = new JLabel();
        this.thisClassTextField = new JTextField();
        JLabel primaryTableLabel = new JLabel();
        JLabel relatedClassLabel = new JLabel();
        JLabel relatedFieldLabel = new JLabel();
        JLabel relatedPrimaryTableLabel = new JLabel();
        this.thisFieldTextField = new JTextField();
        this.primaryTableTextField = new JTextField();
        this.relatedFieldComboBox = new JComboBox();
        this.relatedPrimaryTableComboBox = new JComboBox();
        this.relatedClassTextField = new JTextPane(){

            public boolean isManagingFocus() {
                return false;
            }
        };
        this.relatedClassButton = new JButton();
        JPanel linkPanel = new JPanel();
        this.linkDirectlyRadioButton = new JRadioButton();
        this.linkWithJoinRadioButton = new JRadioButton();
        JLabel linkDirectImage = new JLabel();
        JLabel linkWithJoinImage = new JLabel();
        JLabel linkLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(150, 25));
        this.setMinimumSize(new Dimension(150, 25));
        relatedClassPanelTextArea.setWrapStyleWord(true);
        relatedClassPanelTextArea.setLineWrap(true);
        relatedClassPanelTextArea.setEditable(false);
        relatedClassPanelTextArea.setColumns(70);
        relatedClassPanelTextArea.setRows(4);
        relatedClassPanelTextArea.setForeground((Color)UIManager.getDefaults().get("Label.foreground"));
        relatedClassPanelTextArea.setFont(UIManager.getFont("Label.font"));
        relatedClassPanelTextArea.setText(mappingContext.getString("RMW_Initial_Step_Text"));
        relatedClassPanelTextArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        relatedClassPanelTextArea.setDisabledTextColor((Color)UIManager.getDefaults().get("Label.foreground"));
        relatedClassPanelTextArea.setPreferredSize(new Dimension(840, 80));
        relatedClassPanelTextArea.setMaximumSize(new Dimension(460, 80));
        relatedClassPanelTextArea.setMinimumSize(new Dimension(460, 80));
        relatedClassPanelTextArea.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)relatedClassPanelTextArea, gridBagConstraints);
        classFieldTablePanel.setLayout(new GridBagLayout());
        thisClassLabel.setText(mappingContext.getString("RMW_This_Class"));
        thisClassLabel.setDisplayedMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_This_Class"));
        thisClassLabel.setLabelFor(this.thisClassTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        classFieldTablePanel.add((Component)thisClassLabel, gridBagConstraints);
        thisFieldLabel.setText(mappingContext.getString("RMW_This_Field"));
        thisFieldLabel.setDisplayedMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_This_Field"));
        thisFieldLabel.setLabelFor(this.thisFieldTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        classFieldTablePanel.add((Component)thisFieldLabel, gridBagConstraints);
        this.thisClassTextField.setEditable(false);
        this.thisClassTextField.setPreferredSize(new Dimension(200, 20));
        this.thisClassTextField.setMinimumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 5, 12);
        classFieldTablePanel.add((Component)this.thisClassTextField, gridBagConstraints);
        primaryTableLabel.setText(mappingContext.getString("LBL_Primary_Table"));
        primaryTableLabel.setDisplayedMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_Primary_Table"));
        primaryTableLabel.setLabelFor(this.primaryTableTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        classFieldTablePanel.add((Component)primaryTableLabel, gridBagConstraints);
        relatedClassLabel.setText(mappingContext.getString("LBL_Related_Class"));
        relatedClassLabel.setToolTipText(mappingContext.getString("HINT_elementClass"));
        relatedClassLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Related_Class"));
        relatedClassLabel.setLabelFor(this.relatedClassTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        classFieldTablePanel.add((Component)relatedClassLabel, gridBagConstraints);
        relatedFieldLabel.setText(mappingContext.getString("LBL_Related_Field"));
        relatedFieldLabel.setToolTipText(mappingContext.getString("HINT_relatedField"));
        relatedFieldLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Related_Field"));
        relatedFieldLabel.setLabelFor(this.relatedFieldComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        classFieldTablePanel.add((Component)relatedFieldLabel, gridBagConstraints);
        relatedPrimaryTableLabel.setText(mappingContext.getString("LBL_Primary_Table"));
        relatedPrimaryTableLabel.setToolTipText(mappingContext.getString("HINT_relatedPrimaryTable"));
        relatedPrimaryTableLabel.setDisplayedMnemonic(mappingContext.getMnemonic("LBL_Mnemonic_Primary_Table"));
        relatedPrimaryTableLabel.setLabelFor(this.relatedPrimaryTableComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        classFieldTablePanel.add((Component)relatedPrimaryTableLabel, gridBagConstraints);
        this.thisFieldTextField.setEditable(false);
        this.thisFieldTextField.setPreferredSize(new Dimension(200, 20));
        this.thisFieldTextField.setMinimumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 5, 12);
        classFieldTablePanel.add((Component)this.thisFieldTextField, gridBagConstraints);
        this.primaryTableTextField.setEditable(false);
        this.primaryTableTextField.setPreferredSize(new Dimension(200, 20));
        this.primaryTableTextField.setMinimumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 5, 12);
        classFieldTablePanel.add((Component)this.primaryTableTextField, gridBagConstraints);
        this.relatedFieldComboBox.setModel(new DefaultComboBoxModel());
        this.relatedFieldComboBox.setPreferredSize(new Dimension(200, 20));
        this.relatedFieldComboBox.setMinimumSize(new Dimension(200, 20));
        this.relatedFieldComboBox.setRenderer(new CustomListCellRenderer());
        SwingUtils.makeLightWeight(this.relatedFieldComboBox);
        this.relatedFieldComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RelatedClassStep.this.relatedFieldComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 5, 10);
        classFieldTablePanel.add((Component)this.relatedFieldComboBox, gridBagConstraints);
        this.relatedPrimaryTableComboBox.setModel(new DefaultComboBoxModel());
        this.relatedPrimaryTableComboBox.setPreferredSize(new Dimension(200, 20));
        this.relatedPrimaryTableComboBox.setMinimumSize(new Dimension(200, 20));
        this.relatedPrimaryTableComboBox.setRenderer(new CustomListCellRenderer());
        SwingUtils.makeLightWeight(this.relatedPrimaryTableComboBox);
        this.relatedPrimaryTableComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RelatedClassStep.this.relatedPrimaryTableComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 5, 10);
        classFieldTablePanel.add((Component)this.relatedPrimaryTableComboBox, gridBagConstraints);
        this.relatedClassTextField.setBorder(new LineBorder((Color)UIManager.getDefaults().get("TextField.inactiveForeground")));
        this.relatedClassTextField.setEditable(false);
        this.relatedClassTextField.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        this.relatedClassTextField.setPreferredSize(new Dimension(200, 21));
        this.relatedClassTextField.setMinimumSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 5, 0);
        classFieldTablePanel.add((Component)this.relatedClassTextField, gridBagConstraints);
        this.relatedClassButton.setText(mappingContext.getString("CTL_..."));
        this.relatedClassButton.setPreferredSize(new Dimension(20, 21));
        this.relatedClassButton.setMinimumSize(new Dimension(20, 21));
        this.relatedClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RelatedClassStep.this.relatedClassButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        classFieldTablePanel.add((Component)this.relatedClassButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)classFieldTablePanel, gridBagConstraints);
        linkPanel.setLayout(new GridBagLayout());
        this.linkDirectlyRadioButton.setMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_Link_Directly"));
        this.linkDirectlyRadioButton.setSelected(true);
        this.linkDirectlyRadioButton.setText(mappingContext.getString("RMW_Link_Directly"));
        this.linkDirectlyRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RelatedClassStep.this.linkDirectlyRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.85;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        linkPanel.add((Component)this.linkDirectlyRadioButton, gridBagConstraints);
        this.linkWithJoinRadioButton.setMnemonic(mappingContext.getMnemonic("RMW_Mnemonic_Link_Using_Join"));
        this.linkWithJoinRadioButton.setText(mappingContext.getString("RMW_Link_Using_Join"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.linkDirectlyRadioButton);
        buttonGroup.add(this.linkWithJoinRadioButton);
        this.linkWithJoinRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RelatedClassStep.this.linkWithJoinRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.85;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        linkPanel.add((Component)this.linkWithJoinRadioButton, gridBagConstraints);
        linkDirectImage.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/jdo/modules/persistence/mapping/core/resources/localForeign.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.15;
        linkPanel.add((Component)linkDirectImage, gridBagConstraints);
        linkWithJoinImage.setIcon(new ImageIcon(this.getClass().getResource("/com/sun/jdo/modules/persistence/mapping/core/resources/join.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.15;
        linkPanel.add((Component)linkWithJoinImage, gridBagConstraints);
        linkLabel.setText(mappingContext.getString("RMW_Relationship_Navigation_Text"));
        linkLabel.setLabelFor(linkPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        linkPanel.add((Component)linkLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(10, 0, 100, 0);
        this.add((Component)linkPanel, gridBagConstraints);
    }

    private void relatedPrimaryTableComboBoxItemStateChanged(ItemEvent evt) {
        boolean listenersEnabled;
        Object lElement = this.relatedPrimaryTableComboBox.getModel().getSelectedItem();
        boolean bl = listenersEnabled = !this.areListenersDisabled();
        if (lElement instanceof DBListElement) {
            TableState relatedTableState;
            FieldHolderState holder = this.getHolderState();
            RelationshipElement relationshipElement = this.getField();
            String relatedClass = holder.getCurrentRelatedClass(relationshipElement);
            TableElement primaryTable = lElement != null ? (TableElement)((DBListElement)lElement).getFirstElement() : null;
            TableState tableState = relatedTableState = this.getShortClassName().equals(this.getShortRelatedClassName()) ? holder.getTableState() : holder.getTableState(relatedClass);
            if (listenersEnabled || primaryTable != null || relatedTableState != null && relatedTableState.getCurrentPrimaryTable() == null) {
                holder.setTableState(relatedClass, primaryTable);
            }
        }
        if (listenersEnabled) {
            if (this.relatedPrimaryTableComboBox.getSelectedIndex() != 0 && this.relatedPrimaryTableComboBox.getItemAt(0) instanceof IconWrapper) {
                this.relatedPrimaryTableComboBox.removeItemAt(0);
            }
            this.setButtonStates();
            this.fireChange();
        }
    }

    private void relatedFieldComboBoxItemStateChanged(ItemEvent evt) {
        Object selected = this.relatedFieldComboBox.getModel().getSelectedItem();
        if (selected instanceof String) {
            boolean listenersEnabled;
            FieldHolderState holder = this.getHolderState();
            RelationshipElement relationshipElement = this.getField();
            RelationshipState oldState = holder.getCurrentStateForField(relationshipElement);
            String relatedClass = holder.getCurrentRelatedClass(relationshipElement);
            MappingContext context = this.getMappingContext();
            String inverse = (String)selected;
            RelationshipState inverseState = null;
            RelationshipElement relatedField = null;
            boolean bl = listenersEnabled = !this.areListenersDisabled();
            if (context.getString("VALUE_none").equals(inverse)) {
                inverse = null;
            }
            if (inverse != null && relatedClass != null) {
                PersistenceClassElement pClass = context.getModel().getPersistenceClass(relatedClass);
                RelationshipElement relationshipElement2 = relatedField = pClass != null ? pClass.getRelationship(inverse) : null;
            }
            if (listenersEnabled || inverse != null || holder.getCurrentRelatedField(relationshipElement) == null) {
                holder.setCurrentRelatedField(relationshipElement, relatedField);
            }
            RelationshipState relationshipState = inverseState = inverse != null ? RelationshipState.getInverseStateForField(holder, relationshipElement) : null;
            if ((oldState == null || !oldState.getColumnPairState().hasCompleteRows() || inverseState != null && inverseState.getColumnPairState().hasCompleteRows()) && listenersEnabled) {
                this.relatedStateChanged(true);
            }
            if (listenersEnabled && this.relatedFieldComboBox.getSelectedIndex() != 0 && this.relatedFieldComboBox.getItemAt(0) instanceof IconWrapper) {
                this.relatedFieldComboBox.removeItemAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relatedClassButtonActionPerformed(ActionEvent evt) {
        if (!this._launchingSelectorPanel) {
            this._launchingSelectorPanel = true;
            try {
                FieldHolderState holder = this.getHolderState();
                RelationshipElement relationshipElement = this.getField();
                String currentClass = holder.getCurrentRelatedClass(relationshipElement);
                PersistenceClassElement existingElement = currentClass != null ? this.getMappingContext().getModel().getPersistenceClass(currentClass) : null;
                PersistenceClassElement lValue = this.launchPersistenceClassSelector(existingElement, relationshipElement.getDeclaringClass().getName(), holder.getTableState().getCurrentSchemaName());
                if (lValue != null && !lValue.equals(existingElement)) {
                    String relatedClass = lValue != null ? lValue.getName() : null;
                    RelationshipState old = holder.getCurrentStateForField(relationshipElement);
                    String inverseName = holder.getCurrentRelatedFieldName(relationshipElement);
                    boolean hasMapping = old != null && old.getColumnPairState().hasCompleteRows();
                    boolean hasInverse = !StringHelper.isEmpty(inverseName);
                    boolean replace = true;
                    if (!hasMapping) {
                        if (hasInverse && this.isLegalInverse(relatedClass, inverseName)) {
                            replace = false;
                        }
                    } else if (currentClass != null && existingElement == null) {
                        boolean isLegalInverse;
                        boolean bl = isLegalInverse = !hasInverse || this.isLegalInverse(relatedClass, inverseName);
                        if (holder.isLegalMappingForRelatedClass(relationshipElement, relatedClass) && isLegalInverse) {
                            replace = false;
                        }
                    }
                    if (!replace) {
                        holder.replaceFieldState(relationshipElement, holder.getCurrentStateForField(relationshipElement));
                        if (hasInverse) {
                            holder.setCurrentRelatedField(relationshipElement, lValue.getRelationship(inverseName));
                        }
                    } else {
                        holder.setCurrentRelatedField(relationshipElement, null);
                    }
                    holder.setCurrentRelatedClass(relationshipElement, relatedClass);
                    this.relatedPrimaryFlag = null;
                    this.populateFromState(replace);
                    if (!this.areListenersDisabled()) {
                        this.setButtonStates(replace);
                        this.fireChange();
                    }
                }
            }
            catch (UserCancelException userCancelException) {
            }
            finally {
                this._launchingSelectorPanel = false;
            }
        }
    }

    private void linkWithJoinRadioButtonActionPerformed(ActionEvent evt) {
        ((RelationshipMappingWizard)this.wizard).setLinkWithJoin();
        this.fireChange();
    }

    private void linkDirectlyRadioButtonActionPerformed(ActionEvent evt) {
        ((RelationshipMappingWizard)this.wizard).setLinkDirectly();
        this.fireChange();
    }

    protected String getSubtitleKey() {
        return "RMW_Initial_Setup_Step";
    }

    private static synchronized Method getPersistenceClassLauncher(Logger logger) {
        if (persistenceClassLauncher == null) {
            try {
                Class<?> c = Class.forName(classLauncherName);
                persistenceClassLauncher = c.getMethod("launchWindow", String.class, PersistenceClassElement.class, String.class, String.class, MappingContext.class);
            }
            catch (ClassNotFoundException e) {
                logger.log(900, "mapping.module.loader.error_configuring_launcher", e);
            }
            catch (NoSuchMethodException e) {
                logger.log(900, "mapping.module.loader.error_configuring_launcher", e);
            }
            catch (SecurityException e) {
                logger.log(900, "mapping.module.loader.error_configuring_launcher", e);
            }
        }
        return persistenceClassLauncher;
    }

    private PersistenceClassElement launchPersistenceClassSelector(PersistenceClassElement existingElement, String relClassName, String schemaName) throws UserCancelException {
        MappingContext context = this.getMappingContext();
        Logger logger = context.getLogger();
        Method windowLauncher = RelatedClassStep.getPersistenceClassLauncher(logger);
        PersistenceClassElement persistenceClass = null;
        if (null != windowLauncher) {
            try {
                persistenceClass = (PersistenceClassElement)windowLauncher.invoke(null, context.getString("TITLE_Select_Persistence_Class"), existingElement, relClassName, schemaName, context);
            }
            catch (IllegalAccessException ex) {
                logger.log(900, "mapping.module.loader.error_executing_launcher", ex);
            }
            catch (IllegalArgumentException ex) {
                logger.log(900, "mapping.module.loader.error_executing_launcher", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof UserCancelException) {
                    throw (UserCancelException)targetException;
                }
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                logger.log(900, "mapping.module.loader.error_executing_launcher", ex);
            }
        }
        return persistenceClass;
    }

    private boolean isLegalInverse(String newClass, String currentInverseName) {
        FieldHolderState holder;
        FieldHolderState relatedState;
        RelationshipElement inverse;
        Model model = this.getMappingContext().getModel();
        RelationshipElement relationshipElement = inverse = currentInverseName != null ? model.getPersistenceClass(newClass).getRelationship(currentInverseName) : null;
        if (inverse != null && (relatedState = (holder = this.getHolderState()).getRelatedState(inverse)) != null) {
            RelationshipElement field;
            RelationshipElement inverseInverse = relatedState.getCurrentRelatedField(inverse);
            if (inverseInverse != (field = this.getField())) {
                boolean oldHasThisInverse;
                String inverseName = relatedState.getCurrentRelatedFieldName(inverse);
                String inverseClass = relatedState.getCurrentRelatedClass(inverse);
                String oldClass = holder.getCurrentRelatedClass(field);
                MappingClassElement oldElement = model.getMappingClass(oldClass);
                boolean bl = oldHasThisInverse = oldElement == null && inverseClass.equals(oldClass);
                if (inverseName == null || !inverseName.equals(field.getName()) || inverseClass == null || !oldHasThisInverse && !inverseClass.equals(newClass)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void populateFromState() {
        this.populateFromState(true);
    }

    protected void populateFromState(boolean replace) {
        FieldHolderState holder = this.getHolderState();
        RelationshipElement field = this.getField();
        RelationshipState relationshipState = this.getRelationshipState();
        String relatedClass = holder.getCurrentRelatedClass(field);
        MappingContext context = this.getMappingContext();
        Model model = context.getModel();
        boolean isCollection = model.isCollection(model.getFieldType(field.getDeclaringClass().getName(), field.getName()));
        boolean hasPrimary = this.hasPrimaryTableName();
        boolean hasRelatedClass = relatedClass != null;
        TableState relatedState = holder.getTableState(relatedClass);
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Document doc = this.relatedClassTextField.getDocument();
        PersistenceClassElement relatedClassElement = hasRelatedClass ? model.getPersistenceClass(relatedClass) : null;
        String shortRelatedClass = this.getShortRelatedClassName();
        this.thisClassTextField.setText(this.getShortClassName());
        this.thisFieldTextField.setText(field.toString());
        this.primaryTableTextField.setText(hasPrimary ? this.getPrimaryTableName() : context.getString("VALUE_unmapped"));
        this.loadRelatedFieldComboBox(holder.getCurrentRelatedFieldName(field));
        try {
            doc.remove(0, doc.getLength());
            if (relatedClassElement == null && !StringHelper.isEmpty(shortRelatedClass) && !shortRelatedClass.equals(context.getString("VALUE_related_class"))) {
                doc.insertString(doc.getLength(), PAD, this.relatedClassTextField.getStyle("icon"));
                doc.insertString(doc.getLength(), PAD, defaultStyle);
            }
            doc.insertString(doc.getLength(), shortRelatedClass, defaultStyle);
        }
        catch (BadLocationException e) {
            context.getLogger().log(800, "mapping.module.bad_location_exception", e);
            this.relatedClassTextField.setText(shortRelatedClass);
        }
        this.relatedClassButton.setEnabled(context.isJDOExposed() && hasPrimary && isCollection);
        this.loadPrimaryTableComboBox(hasRelatedClass ? relatedState.getCurrentPrimaryTableName() : null);
        if (relationshipState == null) {
            this.linkDirectlyRadioButton.setSelected(true);
        } else if (relationshipState.isJoinRelationship()) {
            this.linkWithJoinRadioButton.setSelected(true);
        } else {
            this.linkDirectlyRadioButton.setSelected(true);
        }
    }

    protected void setButtonStates() {
        this.setButtonStates(true);
    }

    private void setButtonStates(boolean replace) {
        String relatedClass = this.getHolderState().getCurrentRelatedClass(this.getField());
        MappingContext context = this.getMappingContext();
        PersistenceClassElement existingElement = relatedClass != null ? context.getModel().getPersistenceClass(relatedClass) : null;
        boolean hasRelatedClass = existingElement != null;
        this.relatedPrimaryTableComboBox.setEnabled(this.shouldEnableRelatedPrimaryTable(relatedClass, hasRelatedClass));
        this.relatedFieldComboBox.setEnabled(context.isJDOExposed() && this.hasPrimaryTableName() && hasRelatedClass);
        if (!this.areListenersDisabled()) {
            this.relatedStateChanged(replace);
        }
    }

    private boolean shouldEnableRelatedPrimaryTable(String relatedClass, boolean hasRelatedClass) {
        if (this.relatedPrimaryFlag == null) {
            FieldHolderState holder = this.getHolderState();
            TableState relatedState = holder.getTableState(relatedClass);
            boolean hasRelatedState = relatedState != null;
            String relatedPrimaryName = hasRelatedState ? relatedState.getMappedPrimaryTableName() : null;
            String currentRelatedPrimaryName = hasRelatedState ? relatedState.getCurrentPrimaryTableName() : null;
            this.relatedPrimaryFlag = JavaTypeHelper.valueOf(this.hasPrimaryTableName() && hasRelatedClass && relatedState != holder.getTableState() && (!hasRelatedState || StringHelper.isEmpty(relatedPrimaryName) || StringHelper.isEmpty(currentRelatedPrimaryName)));
        }
        return this.relatedPrimaryFlag;
    }

    private void loadRelatedFieldComboBox(String selection) {
        ArrayList<String> candidates = new ArrayList<String>(this.getHolderState().getSortedRelatedFieldCandidates(this.getField()));
        DefaultComboBoxModel lComboModel = (DefaultComboBoxModel)this.relatedFieldComboBox.getModel();
        candidates.add(0, this.getMappingContext().getString("VALUE_none"));
        SwingUtils.replaceItems(lComboModel, candidates);
        if (selection != null) {
            if (candidates.contains(selection)) {
                lComboModel.setSelectedItem(selection);
            } else if (selection.trim().length() > 0) {
                IconWrapper iconWrapper = new IconWrapper(selection, Util.getIllegalIcon());
                lComboModel.insertElementAt(iconWrapper, 0);
                lComboModel.setSelectedItem(iconWrapper);
            }
        }
    }

    private void loadPrimaryTableComboBox(String tableName) {
        String unmapped = this.getMappingContext().getString("VALUE_unmapped");
        TableState tableState = this.getHolderState().getTableState();
        DBListElement[] lTablelist = DBListElement.convertArray(TableState.getSortedPrimaryTableCandidates(tableState.getCurrentSchema()), unmapped, false);
        DefaultComboBoxModel lComboModel = (DefaultComboBoxModel)this.relatedPrimaryTableComboBox.getModel();
        TableElement selection = this.getTable(tableName);
        SwingUtils.replaceItems(lComboModel, Arrays.asList(lTablelist));
        if (selection != null) {
            lComboModel.setSelectedItem(new DBListElement((DBElement)selection, unmapped));
        } else if (!StringHelper.isEmpty(tableName)) {
            IconWrapper iconWrapper = new IconWrapper(tableName, Util.getIllegalIcon());
            lComboModel.insertElementAt(iconWrapper, 0);
            lComboModel.setSelectedItem(iconWrapper);
        }
    }

    private String getPrimaryTableName() {
        FieldHolderState holder = this.getHolderState();
        TableState tableState = holder != null ? holder.getTableState() : null;
        return tableState != null ? tableState.getCurrentPrimaryTableName() : null;
    }

    private boolean hasPrimaryTableName() {
        return !StringHelper.isEmpty(this.getPrimaryTableName());
    }

    public boolean isValid() {
        return this.hasPrimaryTableName() && this.getRelatedPrimaryTable() != null;
    }

    public boolean isLinkWithJoin() {
        return this.linkWithJoinRadioButton.isSelected();
    }

    public boolean isLinkDirectly() {
        return this.linkDirectlyRadioButton.isSelected();
    }

    protected void setLinkDirectly() {
        this.linkDirectlyRadioButton.setSelected(true);
    }

    protected void setLinkWithJoin() {
        this.linkWithJoinRadioButton.setSelected(true);
    }

    protected void initGUI() throws Exception {
    }

    private void relatedStateChanged(boolean replace) {
        FieldHolderState holder = this.getHolderState();
        if (replace) {
            ((RelationshipMappingWizard)this.wizard).replaceStateObject(false);
        } else {
            RelationshipElement field = this.getField();
            RelationshipState state = holder.getCurrentStateForField(field);
            if (!state.getColumnPairState().hasCompleteRows()) {
                RelationshipElement relatedField = holder.getCurrentRelatedField(field);
                holder.addDefaultStateForField(field, ((RelationshipMappingWizard)this.wizard).getJoinTable(), this.isLinkWithJoin(), false);
                holder.setCurrentRelatedField(field, relatedField);
            }
            this.setNeedsPopulate(true);
            ((RelationshipMappingWizard)this.wizard).replaceDataObject(holder.getCurrentStateForField(field));
        }
    }
}

