/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ejb.rules.method;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;

public class BMandRemoteExceptionWarning
extends AbstractRule {
    public JEEVerificationProblemMark.Severity getSeverity() {
        return JEEVerificationProblemMark.Severity.WARNING;
    }

    public String getId() {
        return "BMandRemoteExceptionWarning";
    }

    protected String getMessageKey() {
        return "MSG_BMandRemoteExceptionWarning";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        String remoteIF = "java.rmi.Remote";
        return (ctx.isLBI() || ctx.isRBI()) && !ProblemFindingUtils.isAssignableFrom("java.rmi.Remote", ctx.getMainJavaClass()) && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Method m = (Method)Method.class.cast(subject);
            for (JavaClass e : m.getExceptions()) {
                if (!"java.rmi.RemoteException".equals(e.getName())) continue;
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }
}

